#!/usr/bin/env bash



# set -e: exit on errors
# set -x: verbose logging

set -x



# Configure bash globbing for recursive cp command

shopt -s globstar



# Set variables

PORT="_build/Hypatia's Mario Craft 64 (Jabo)"

echo -n "Type dds if you converted the textures to that format, otherwise just press enter to use PNG (default): "
read VALUE

case "$VALUE" in

  dds)
    EXT=".dds"
    ;;

  *)
    EXT=".png"
    ;;
esac



# Remove and recreate work directories

rm -drf "$PORT"
rm -drf "_temp"

mkdir -p "$PORT"
mkdir -p "_temp"



# Copy textures to work directories

cp -r "Ports/Jabo/"* "$PORT"
cp **"/SUPER MARIO 64"*"$EXT" "_temp"



# Create directories

mkdir -p "$PORT/Areas/Big Boo's Haunt"
mkdir -p "$PORT/Areas/Bob-omb Battlefield"
mkdir -p "$PORT/Areas/Bowser in the Dark World/Boss"
mkdir -p "$PORT/Areas/Bowser in the Fire Sea"
mkdir -p "$PORT/Areas/Bowser in the Sky/Boss"
mkdir -p "$PORT/Areas/Castle Inside"
mkdir -p "$PORT/Areas/Castle Outside/Window"
mkdir -p "$PORT/Areas/Cavern of the Metal Cap"
mkdir -p "$PORT/Areas/Cool Cool Mountain/unused"
mkdir -p "$PORT/Areas/Dire Dire Docks/Ship Room"
mkdir -p "$PORT/Areas/Hazy Maze Cave/Maps"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Chest"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Crate"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Kelp"
mkdir -p "$PORT/Areas/Jolly Roger Bay/Ship"
mkdir -p "$PORT/Areas/Lethal Lava Land/Bowser"
mkdir -p "$PORT/Areas/Lethal Lava Land/unused"
mkdir -p "$PORT/Areas/Lethal Lava Land/Volcano"
mkdir -p "$PORT/Areas/Rainbow Ride"
mkdir -p "$PORT/Areas/Shifting Sand Land/Block"
mkdir -p "$PORT/Areas/Shifting Sand Land/Pyramid"
mkdir -p "$PORT/Areas/Shifting Sand Land/unused"
mkdir -p "$PORT/Areas/Snowman's Land"
mkdir -p "$PORT/Areas/Tall Tall Mountain/Slide"
mkdir -p "$PORT/Areas/Tall Tall Mountain/Slide Entrance"
mkdir -p "$PORT/Areas/The Princess's Secret Slide"
mkdir -p "$PORT/Areas/Tick Tock Clock"
mkdir -p "$PORT/Areas/Tiny-Huge Island/Wiggler's Cave"
mkdir -p "$PORT/Areas/Tower of the Wing Cap"
mkdir -p "$PORT/Areas/Vanish Cap Under the Moat"
mkdir -p "$PORT/Areas/Wet-Dry World"
mkdir -p "$PORT/Areas/Whomp's Fortress"
mkdir -p "$PORT/Areas/Wing Mario Over the Rainbow"
mkdir -p "$PORT/Boot/Logo"
mkdir -p "$PORT/Boot/File Select/Hand"
mkdir -p "$PORT/Boot/Press Start/Game Over"
mkdir -p "$PORT/Boot/Press Start/Game Over (iQue)"
mkdir -p "$PORT/Boot/Press Start/Grey Star"
mkdir -p "$PORT/Boot/Press Start/Hand"
mkdir -p "$PORT/Boot/Press Start/Red Star"
mkdir -p "$PORT/Boot/Press Start/Title"
mkdir -p "$PORT/Boot/Press Start/Title (iQue)"
mkdir -p "$PORT/Characters/Amp"
mkdir -p "$PORT/Characters/Bob-omb"
mkdir -p "$PORT/Characters/Boo"
mkdir -p "$PORT/Characters/Book"
mkdir -p "$PORT/Characters/Bowser"
mkdir -p "$PORT/Characters/Bubba"
mkdir -p "$PORT/Characters/Bullet Bill"
mkdir -p "$PORT/Characters/Bully"
mkdir -p "$PORT/Characters/Butterfly"
mkdir -p "$PORT/Characters/Chain Chomp"
mkdir -p "$PORT/Characters/Chilly Chief"
mkdir -p "$PORT/Characters/Chuckya"
mkdir -p "$PORT/Characters/Clam Shell"
mkdir -p "$PORT/Characters/Dorrie"
mkdir -p "$PORT/Characters/Eyerok"
mkdir -p "$PORT/Characters/Fish"
mkdir -p "$PORT/Characters/Flyguy"
mkdir -p "$PORT/Characters/Goomba"
mkdir -p "$PORT/Characters/Grindel"
mkdir -p "$PORT/Characters/Heave Ho"
mkdir -p "$PORT/Characters/Hoot"
mkdir -p "$PORT/Characters/Koopa"
mkdir -p "$PORT/Characters/King Bob-omb"
mkdir -p "$PORT/Characters/Klepto"
mkdir -p "$PORT/Characters/Lakitu/unused"
mkdir -p "$PORT/Characters/Mad Piano"
mkdir -p "$PORT/Characters/Manta Ray"
mkdir -p "$PORT/Characters/Mario/unused"
mkdir -p "$PORT/Characters/Mips"
mkdir -p "$PORT/Characters/Moneybag"
mkdir -p "$PORT/Characters/Monty Mole"
mkdir -p "$PORT/Characters/Mr. Blizzard"
mkdir -p "$PORT/Characters/Mr. I"
mkdir -p "$PORT/Characters/Peach/Letter"
mkdir -p "$PORT/Characters/Penguin/unused"
mkdir -p "$PORT/Characters/Piranha Plant"
mkdir -p "$PORT/Characters/Pokey"
mkdir -p "$PORT/Characters/Scuttlebug"
mkdir -p "$PORT/Characters/Skeeter"
mkdir -p "$PORT/Characters/Snufit"
mkdir -p "$PORT/Characters/Spindrift"
mkdir -p "$PORT/Characters/Sushi"
mkdir -p "$PORT/Characters/Swoop"
mkdir -p "$PORT/Characters/Thwomp"
mkdir -p "$PORT/Characters/Toad"
mkdir -p "$PORT/Characters/Ukiki"
mkdir -p "$PORT/Characters/Unagi"
mkdir -p "$PORT/Characters/Whomp"
mkdir -p "$PORT/Characters/Wiggler"
mkdir -p "$PORT/Characters/Yoshi"
mkdir -p "$PORT/Effects/Bubbles and Particles"
mkdir -p "$PORT/Effects/Burn Smoke"
mkdir -p "$PORT/Effects/Explosion"
mkdir -p "$PORT/Effects/Flame"
mkdir -p "$PORT/Effects/Flower (unused)"
mkdir -p "$PORT/Effects/Impact Ring"
mkdir -p "$PORT/Effects/Lava Bubble/unused"
mkdir -p "$PORT/Effects/Light/Big Boo's Haunt"
mkdir -p "$PORT/Effects/Metal"
mkdir -p "$PORT/Effects/Particles"
mkdir -p "$PORT/Effects/Pebble"
mkdir -p "$PORT/Effects/Run"
mkdir -p "$PORT/Effects/Shadow"
mkdir -p "$PORT/Effects/Sparkle/Animation"
mkdir -p "$PORT/Effects/Sparkle/Press Start/unused"
mkdir -p "$PORT/Effects/Stomp"
mkdir -p "$PORT/Effects/Swim"
mkdir -p "$PORT/Effects/Tornado"
mkdir -p "$PORT/Effects/Transitions"
mkdir -p "$PORT/Effects/Water Splash"
mkdir -p "$PORT/Effects/Bowser Explosion/00"
mkdir -p "$PORT/Effects/Bowser Explosion/01"
mkdir -p "$PORT/Effects/Bowser Explosion/02"
mkdir -p "$PORT/Effects/Bowser Explosion/03"
mkdir -p "$PORT/Effects/Bowser Explosion/04"
mkdir -p "$PORT/Effects/Bowser Explosion/05"
mkdir -p "$PORT/Effects/Bowser Explosion/06"
mkdir -p "$PORT/Effects/Bowser Explosion/07"
mkdir -p "$PORT/Effects/Bowser Explosion/08"
mkdir -p "$PORT/Effects/Bowser Explosion/09"
mkdir -p "$PORT/Effects/Bowser Explosion/10"
mkdir -p "$PORT/Effects/Bowser Explosion/11"
mkdir -p "$PORT/Effects/Bowser Explosion/12"
mkdir -p "$PORT/Effects/Bowser Explosion/13"
mkdir -p "$PORT/Ending/Europe/English"
mkdir -p "$PORT/Ending/Europe/French"
mkdir -p "$PORT/Ending/Europe/German"
mkdir -p "$PORT/Ending/iQue"
mkdir -p "$PORT/Hacks/Termina Invasion/Majora's Mask"
mkdir -p "$PORT/Hacks/Termina Invasion/Link/Cap"
mkdir -p "$PORT/Hacks/Termina Invasion/Link/Leftover"
mkdir -p "$PORT/Hacks/Termina Invasion/UI/Text"
mkdir -p "$PORT/Hacks/Termina Invasion/UI/File Select"
mkdir -p "$PORT/Hacks/Termina Invasion/UI/Clock"
mkdir -p "$PORT/Hacks/Termina Invasion/UI/Health"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Window"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Moon"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Mario"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Box"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Luigi"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Moon"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Swordsmith"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/Bottom"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/Painting"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Wario"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Moon"
mkdir -p "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue"
mkdir -p "$PORT/Hacks/Termina Invasion/Rupees"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Boot"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/HUD/Icons"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/HUD/Course"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Effects"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/02 - Whomp's Forest"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Star"
mkdir -p "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Coin"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Bowser"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Luigi"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Mario"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Peach"
mkdir -p "$PORT/Hacks/Low Poly Promo Models/Toad"
mkdir -p "$PORT/Hacks/Low Poly Render96/1-UP"
mkdir -p "$PORT/Hacks/Low Poly Render96/Boo"
mkdir -p "$PORT/Hacks/Low Poly Render96/Chain Chomp"
mkdir -p "$PORT/Hacks/Low Poly Render96/Coins"
mkdir -p "$PORT/Hacks/Low Poly Render96/Goomba"
mkdir -p "$PORT/Hacks/Low Poly Render96/Penguin"
mkdir -p "$PORT/Hacks/Low Poly Render96/Pokey"
mkdir -p "$PORT/Hacks/Italian/Boot"
mkdir -p "$PORT/Hacks/Italian/Game Over"
mkdir -p "$PORT/Hacks/Italian/Power Meter"
mkdir -p "$PORT/Hacks/Italian/Doors"
mkdir -p "$PORT/Hacks/Italian/Ending"
mkdir -p "$PORT/Hacks/Italian/File Select"
mkdir -p "$PORT/Hacks/Italian/Accents"
mkdir -p "$PORT/Hacks/Italian/Credits"
mkdir -p "$PORT/Hacks/Shindou Improvement"
mkdir -p "$PORT/Hacks/Multiplayer/Splitscreen"
mkdir -p "$PORT/Hacks/Multiplayer/v1.2"
mkdir -p "$PORT/Hacks/Multiplayer/v1.3"
mkdir -p "$PORT/Hacks/Multiplayer/v1.3.1"
mkdir -p "$PORT/HUD/Course"
mkdir -p "$PORT/HUD/Font"
mkdir -p "$PORT/HUD/Icons"
mkdir -p "$PORT/HUD/Power Meter/iQue"
mkdir -p "$PORT/HUD/Course/Europe/English"
mkdir -p "$PORT/HUD/Course/Europe/French"
mkdir -p "$PORT/HUD/Course/Europe/German"
mkdir -p "$PORT/HUD/Course/iQue"
mkdir -p "$PORT/HUD/Font/Japanese"
mkdir -p "$PORT/HUD/Font/Japanese (unused)"
mkdir -p "$PORT/Letters/16x8"
mkdir -p "$PORT/Letters/8x8"
mkdir -p "$PORT/Letters/Credits"
mkdir -p "$PORT/Letters/16x8/Buttons"
mkdir -p "$PORT/Letters/16x8/Capital"
mkdir -p "$PORT/Letters/16x8/Lowercase"
mkdir -p "$PORT/Letters/16x8/Numerals"
mkdir -p "$PORT/Letters/16x8/Punctuation"
mkdir -p "$PORT/Letters/16x8/Special"
mkdir -p "$PORT/Letters/16x8/Symbols"
mkdir -p "$PORT/Letters/16x8/Buttons/A"
mkdir -p "$PORT/Letters/16x8/Buttons/B"
mkdir -p "$PORT/Letters/16x8/Buttons/C"
mkdir -p "$PORT/Letters/16x8/Buttons/R"
mkdir -p "$PORT/Letters/16x8/Buttons/Z"
mkdir -p "$PORT/Letters/16x8/Capital/A"
mkdir -p "$PORT/Letters/16x8/Capital/B"
mkdir -p "$PORT/Letters/16x8/Capital/C"
mkdir -p "$PORT/Letters/16x8/Capital/D"
mkdir -p "$PORT/Letters/16x8/Capital/E"
mkdir -p "$PORT/Letters/16x8/Capital/F"
mkdir -p "$PORT/Letters/16x8/Capital/G"
mkdir -p "$PORT/Letters/16x8/Capital/H"
mkdir -p "$PORT/Letters/16x8/Capital/I"
mkdir -p "$PORT/Letters/16x8/Capital/J"
mkdir -p "$PORT/Letters/16x8/Capital/K"
mkdir -p "$PORT/Letters/16x8/Capital/L"
mkdir -p "$PORT/Letters/16x8/Capital/M"
mkdir -p "$PORT/Letters/16x8/Capital/N"
mkdir -p "$PORT/Letters/16x8/Capital/O"
mkdir -p "$PORT/Letters/16x8/Capital/P"
mkdir -p "$PORT/Letters/16x8/Capital/Q"
mkdir -p "$PORT/Letters/16x8/Capital/R"
mkdir -p "$PORT/Letters/16x8/Capital/S"
mkdir -p "$PORT/Letters/16x8/Capital/T"
mkdir -p "$PORT/Letters/16x8/Capital/U"
mkdir -p "$PORT/Letters/16x8/Capital/V"
mkdir -p "$PORT/Letters/16x8/Capital/W"
mkdir -p "$PORT/Letters/16x8/Capital/X"
mkdir -p "$PORT/Letters/16x8/Capital/Y"
mkdir -p "$PORT/Letters/16x8/Capital/Z"
mkdir -p "$PORT/Letters/16x8/Lowercase/a"
mkdir -p "$PORT/Letters/16x8/Lowercase/b"
mkdir -p "$PORT/Letters/16x8/Lowercase/c"
mkdir -p "$PORT/Letters/16x8/Lowercase/d"
mkdir -p "$PORT/Letters/16x8/Lowercase/e"
mkdir -p "$PORT/Letters/16x8/Lowercase/f"
mkdir -p "$PORT/Letters/16x8/Lowercase/g"
mkdir -p "$PORT/Letters/16x8/Lowercase/h"
mkdir -p "$PORT/Letters/16x8/Lowercase/i"
mkdir -p "$PORT/Letters/16x8/Lowercase/j"
mkdir -p "$PORT/Letters/16x8/Lowercase/k"
mkdir -p "$PORT/Letters/16x8/Lowercase/l"
mkdir -p "$PORT/Letters/16x8/Lowercase/m"
mkdir -p "$PORT/Letters/16x8/Lowercase/n"
mkdir -p "$PORT/Letters/16x8/Lowercase/o"
mkdir -p "$PORT/Letters/16x8/Lowercase/p"
mkdir -p "$PORT/Letters/16x8/Lowercase/q"
mkdir -p "$PORT/Letters/16x8/Lowercase/r"
mkdir -p "$PORT/Letters/16x8/Lowercase/s"
mkdir -p "$PORT/Letters/16x8/Lowercase/t"
mkdir -p "$PORT/Letters/16x8/Lowercase/u"
mkdir -p "$PORT/Letters/16x8/Lowercase/v"
mkdir -p "$PORT/Letters/16x8/Lowercase/w"
mkdir -p "$PORT/Letters/16x8/Lowercase/x"
mkdir -p "$PORT/Letters/16x8/Lowercase/y"
mkdir -p "$PORT/Letters/16x8/Lowercase/z"
mkdir -p "$PORT/Letters/16x8/Numerals/0"
mkdir -p "$PORT/Letters/16x8/Numerals/1"
mkdir -p "$PORT/Letters/16x8/Numerals/2"
mkdir -p "$PORT/Letters/16x8/Numerals/3"
mkdir -p "$PORT/Letters/16x8/Numerals/4"
mkdir -p "$PORT/Letters/16x8/Numerals/5"
mkdir -p "$PORT/Letters/16x8/Numerals/6"
mkdir -p "$PORT/Letters/16x8/Numerals/7"
mkdir -p "$PORT/Letters/16x8/Numerals/8"
mkdir -p "$PORT/Letters/16x8/Numerals/9"
mkdir -p "$PORT/Letters/8x8/Capital"
mkdir -p "$PORT/Letters/8x8/Numerals"
mkdir -p "$PORT/Letters/8x8/Punctuation"
mkdir -p "$PORT/Letters/8x8/Special"
mkdir -p "$PORT/Letters/8x8/Symbols"
mkdir -p "$PORT/Letters/8x8/Capital/A"
mkdir -p "$PORT/Letters/8x8/Capital/B"
mkdir -p "$PORT/Letters/8x8/Capital/C"
mkdir -p "$PORT/Letters/8x8/Capital/D (Europe)"
mkdir -p "$PORT/Letters/8x8/Capital/D (USA)"
mkdir -p "$PORT/Letters/8x8/Capital/E"
mkdir -p "$PORT/Letters/8x8/Capital/F"
mkdir -p "$PORT/Letters/8x8/Capital/G"
mkdir -p "$PORT/Letters/8x8/Capital/H"
mkdir -p "$PORT/Letters/8x8/Capital/I"
mkdir -p "$PORT/Letters/8x8/Capital/J"
mkdir -p "$PORT/Letters/8x8/Capital/K"
mkdir -p "$PORT/Letters/8x8/Capital/L"
mkdir -p "$PORT/Letters/8x8/Capital/M"
mkdir -p "$PORT/Letters/8x8/Capital/N"
mkdir -p "$PORT/Letters/8x8/Capital/O"
mkdir -p "$PORT/Letters/8x8/Capital/P"
mkdir -p "$PORT/Letters/8x8/Capital/Q"
mkdir -p "$PORT/Letters/8x8/Capital/R"
mkdir -p "$PORT/Letters/8x8/Capital/S"
mkdir -p "$PORT/Letters/8x8/Capital/T"
mkdir -p "$PORT/Letters/8x8/Capital/U"
mkdir -p "$PORT/Letters/8x8/Capital/V"
mkdir -p "$PORT/Letters/8x8/Capital/W"
mkdir -p "$PORT/Letters/8x8/Capital/X"
mkdir -p "$PORT/Letters/8x8/Capital/Y"
mkdir -p "$PORT/Letters/8x8/Capital/Z"
mkdir -p "$PORT/Letters/8x8/Numerals/0"
mkdir -p "$PORT/Letters/8x8/Numerals/1"
mkdir -p "$PORT/Letters/8x8/Numerals/2"
mkdir -p "$PORT/Letters/8x8/Numerals/3"
mkdir -p "$PORT/Letters/8x8/Numerals/4"
mkdir -p "$PORT/Letters/8x8/Numerals/5"
mkdir -p "$PORT/Letters/8x8/Numerals/6"
mkdir -p "$PORT/Letters/8x8/Numerals/7"
mkdir -p "$PORT/Letters/8x8/Numerals/8"
mkdir -p "$PORT/Letters/8x8/Numerals/9"
mkdir -p "$PORT/Letters/8x8/Punctuation/Europe"
mkdir -p "$PORT/Objects/1-UP"
mkdir -p "$PORT/Objects/Blue Coin Switch"
mkdir -p "$PORT/Objects/Bomb"
mkdir -p "$PORT/Objects/Boxes"
mkdir -p "$PORT/Objects/Breakable Box"
mkdir -p "$PORT/Objects/Cannon"
mkdir -p "$PORT/Objects/Cap Switch"
mkdir -p "$PORT/Objects/Chair/unused"
mkdir -p "$PORT/Objects/Checkerboard Platform"
mkdir -p "$PORT/Objects/Coin"
mkdir -p "$PORT/Objects/Doors"
mkdir -p "$PORT/Objects/Heart"
mkdir -p "$PORT/Objects/Lava"
mkdir -p "$PORT/Objects/Metal Box"
mkdir -p "$PORT/Objects/Pipe"
mkdir -p "$PORT/Objects/Poundable Pole"
mkdir -p "$PORT/Objects/Purple Switch"
mkdir -p "$PORT/Objects/Sign"
mkdir -p "$PORT/Objects/Star"
mkdir -p "$PORT/Objects/Trees"
mkdir -p "$PORT/Objects/Water"
mkdir -p "$PORT/Objects/Water Bubble"
mkdir -p "$PORT/Objects/Yellow Sphere"
mkdir -p "$PORT/Paintings/Bob-omb Battlefield"
mkdir -p "$PORT/Paintings/Bowser"
mkdir -p "$PORT/Paintings/Cool Cool Mountain"
mkdir -p "$PORT/Paintings/Dire Dire Docks"
mkdir -p "$PORT/Paintings/Jolly Roger Bay/Japan"
mkdir -p "$PORT/Paintings/Lethal Lava Land"
mkdir -p "$PORT/Paintings/Peach"
mkdir -p "$PORT/Paintings/Shifting Sand Land"
mkdir -p "$PORT/Paintings/Snowman's Land"
mkdir -p "$PORT/Paintings/Tall Tall Mountain"
mkdir -p "$PORT/Paintings/Tick Tock Clock"
mkdir -p "$PORT/Paintings/Tiny-Huge Island"
mkdir -p "$PORT/Paintings/Wet-Dry World"
mkdir -p "$PORT/Paintings/Whomp's Fortress"
mkdir -p "$PORT/Skybox/Big Boo's Haunt"
mkdir -p "$PORT/Skybox/Bowser in the Dark World"
mkdir -p "$PORT/Skybox/Bowser in the Fire Sea"
mkdir -p "$PORT/Skybox/Bowser in the Sky"
mkdir -p "$PORT/Skybox/Cloud Floor"
mkdir -p "$PORT/Skybox/Clouds"
mkdir -p "$PORT/Skybox/Cool Cool Mountain"
mkdir -p "$PORT/Skybox/Shifting Sand Land"
mkdir -p "$PORT/Skybox/Water"
mkdir -p "$PORT/Skybox/Wet-Dry World"



# Copy and rename textures

cp "_temp/SUPER MARIO 64#0AD7A8F7#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/C673D794FFF9F8AE0006DBF9FA79314E$EXT"
cp "_temp/SUPER MARIO 64#0C8C45BA#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/260BD51674D29F1E9C076D48B1A84C33$EXT"
cp "_temp/SUPER MARIO 64#1C62CC15#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/F88221FFD89C5579F7F66BB2D2A9F6DA$EXT"
cp "_temp/SUPER MARIO 64#4A4683BC#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/07FAB40C3A03E95AD65D9CB395838406$EXT"
cp "_temp/SUPER MARIO 64#15D30589#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/3E3FDA583D6E61ABA186C3DC7F27A33F$EXT"
cp "_temp/SUPER MARIO 64#042DEE1B#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/AC77B29CED84059EE1B36AE6B42BF0E0$EXT"
cp "_temp/SUPER MARIO 64#78AB0F9F#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/E22A4D62788E72FE5080979C9F9DA712$EXT"
cp "_temp/SUPER MARIO 64#381EA750#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/752952C60BEDD604518FE441E7D5BCBC$EXT"
cp "_temp/SUPER MARIO 64#3157CD18#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/380DA58E8B9F819693FB7BED2C0D69E7$EXT"
cp "_temp/SUPER MARIO 64#4443D529#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/885249976CFA925FF35FF6885955AC3D$EXT"
cp "_temp/SUPER MARIO 64#24767D89#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/55F6170705026A34F45EA8D28D9ECA9B$EXT"
cp "_temp/SUPER MARIO 64#222768FA#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/5BCB7D34E5E4A1398BCB73B36D614277$EXT"
cp "_temp/SUPER MARIO 64#8899587D#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/4376B70B4E66720F55FB414443F2F8B1$EXT"
cp "_temp/SUPER MARIO 64#17405808#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/C9D7C3AFD65034620D8B1B0311007191$EXT"
cp "_temp/SUPER MARIO 64#49313621#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/8A5EC7FC5851191686058066E71CC21C$EXT"
cp "_temp/SUPER MARIO 64#A4AF5230#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/1794A0E58A36EED1EC244FDCB6A8AE11$EXT"
cp "_temp/SUPER MARIO 64#B5B2C148#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/CB25761A6FEF65B17B3632B6D5D58AA4$EXT"
cp "_temp/SUPER MARIO 64#B8F6006F#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/E30C12D8E6E43E105E918E9B0C73AE24$EXT"
cp "_temp/SUPER MARIO 64#BD28248A#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/2E97C3B3EBD965A2E20FD86AF35FB5BB$EXT"
cp "_temp/SUPER MARIO 64#C9E2883E#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/84B6767C62D34C56A772788C20B54FA5$EXT"
cp "_temp/SUPER MARIO 64#C99707D9#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/6A108845864A881E31F4893B2B86ECF1$EXT"
cp "_temp/SUPER MARIO 64#D950DA92#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/6D36DB097D7A58DB9E980ED7CEBA32BA$EXT"
cp "_temp/SUPER MARIO 64#E559FC96#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/2257B87B3E3BC810B34F00E35EA35005$EXT"
cp "_temp/SUPER MARIO 64#EDA45656#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/48CDBD7F9AD5D257DCAEA046CED7EADA$EXT"
cp "_temp/SUPER MARIO 64#FFF8437E#0#2_all$EXT" "$PORT/Areas/Big Boo's Haunt/D01A999A9D41191E017645D33AAA3B19$EXT"

cp "_temp/SUPER MARIO 64#0DDBBC70#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/56D524D6FD9EE9087DE302C5F3F2345E$EXT"
cp "_temp/SUPER MARIO 64#4B070BC3#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/F1496DECEA47E5FEF37B1D29A79B1523$EXT"
cp "_temp/SUPER MARIO 64#4D03386E#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/9C0761DEDF0517A91E2F74E0763657AA$EXT"
cp "_temp/SUPER MARIO 64#061A6C74#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/7A0CDF77976F8C2A28715F79393CA626$EXT"
cp "_temp/SUPER MARIO 64#215CE254#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/FA6CCCFD2BD3A6BF51CC622B16F8B2D5$EXT"
cp "_temp/SUPER MARIO 64#245EA00F#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/8392FCE6BE94D28319B8922D3772DC66$EXT"
cp "_temp/SUPER MARIO 64#602EF33F#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/BD3DBB8AB995D8C47C1453040CBC100D$EXT"
cp "_temp/SUPER MARIO 64#1448C073#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/FD96F67937AA3F8B90A54381A8C8DC90$EXT"
cp "_temp/SUPER MARIO 64#9026CBA3#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/4F8B25CB9909B0E37F1B58D6F5AEEA6B$EXT"
cp "_temp/SUPER MARIO 64#A2D48F6C#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/3936EC871A00B1E64A9515D73E40616B$EXT"
cp "_temp/SUPER MARIO 64#AE019762#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/2370BC08093E2B451B3250C6273F1492$EXT"
cp "_temp/SUPER MARIO 64#AEC008C0#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/C695594A0EDC46135D4BB697E51C15E1$EXT"
cp "_temp/SUPER MARIO 64#AEF22277#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/6ACC6389CCC5A7E440AD5F6022B6316B$EXT"
cp "_temp/SUPER MARIO 64#B7B83492#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/965BF2F538E6FD85D9DDF3FD773A0B45$EXT"
cp "_temp/SUPER MARIO 64#CBE026C4#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/90A87DD9BBA67A9D877A37D3F5526CED$EXT"
cp "_temp/SUPER MARIO 64#DD78FBD8#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/F759AEAB9D90A80A6D93BEA2F4A99DF6$EXT"
cp "_temp/SUPER MARIO 64#FDBCE221#0#2_all$EXT" "$PORT/Areas/Bob-omb Battlefield/E1914F380E8201BFADC94FDF1C73B250$EXT"

cp "_temp/SUPER MARIO 64#60351310#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/Boss/D24AA616AED5C89B8F688AB0B613905D$EXT"
cp "_temp/SUPER MARIO 64#B017CFF7#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/Boss/4A3BDF9D9211BE2E6928E3F0B382F914$EXT"
cp "_temp/SUPER MARIO 64#CA7E41B1#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/Boss/D046633797E75CE5F423C3431B477F8E$EXT"
cp "_temp/SUPER MARIO 64#13132153#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/F05958F3ED189A142D86842099717240$EXT"
cp "_temp/SUPER MARIO 64#177D197C#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/94A660491CD16C123A95082A02832C5A$EXT"
cp "_temp/SUPER MARIO 64#50964858#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/687079BFA9BA94263997A75243201441$EXT"
cp "_temp/SUPER MARIO 64#54670BB6#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/0479C82977064BA27B3AD30B2CCF3784$EXT"
cp "_temp/SUPER MARIO 64#59C3CDD9#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/D1090309BDC02FD5463EA35C040C8FAC$EXT"
cp "_temp/SUPER MARIO 64#5D5BB4D6#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/C7A558F5479CC461F1F9D738997F5E62$EXT"
cp "_temp/SUPER MARIO 64#7A6AB5A7#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/445F0F10AE249C882DE0C1538C2891D0$EXT"
cp "_temp/SUPER MARIO 64#7E5C24F7#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/0F24CA90FDFF9ABB2FFC98E708ACCE56$EXT"
cp "_temp/SUPER MARIO 64#8FC7FAC2#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/025D6AE4C3B02C7D3FB131FFDF1E974A$EXT"
cp "_temp/SUPER MARIO 64#A11B5CF3#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/17004DEBEDEF68D5608E3270E26BCC97$EXT"
cp "_temp/SUPER MARIO 64#B114863B#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/9CD2ABD34CC28AE03528B471B88850A1$EXT"
cp "_temp/SUPER MARIO 64#B63A3055#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/F94A06F8C0112BD68CCC7B0BCB79EA86$EXT"
cp "_temp/SUPER MARIO 64#CD71304B#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/848997696DD219A4E85E75D267FD40C0$EXT"
cp "_temp/SUPER MARIO 64#CF717C3C#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/63323AEBA150DA63F6DD896BDA2C9E70$EXT"
cp "_temp/SUPER MARIO 64#D872790D#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/D8B7B3A0A3E8D49E4A5B9C05DBD632E0$EXT"
cp "_temp/SUPER MARIO 64#E0C22A3C#0#2_all$EXT" "$PORT/Areas/Bowser in the Dark World/99A0C44C285849E3404EDAF2D9C07A61$EXT"

cp "_temp/SUPER MARIO 64#6D8CFA2F#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/13F28F62933BF3D1A1E1A525F95BCD12$EXT"
cp "_temp/SUPER MARIO 64#8E28628B#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/20D9E011EC5F02210EBCD2ECBFB229CB$EXT"
cp "_temp/SUPER MARIO 64#91252367#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/4C7169FD1C61D977F744803B280115EF$EXT"
cp "_temp/SUPER MARIO 64#A7C43AFC#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/9978EF7F9DE9FCCE47B0034D9B424BF9$EXT"
cp "_temp/SUPER MARIO 64#FE7EC2B3#0#2_all$EXT" "$PORT/Areas/Bowser in the Fire Sea/E39D928E3B63C318855BBE6CE1B784D2$EXT"

cp "_temp/SUPER MARIO 64#204D81E4#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/Boss/3CD87EDEAA970B0B61D14D2A247136FB$EXT"
cp "_temp/SUPER MARIO 64#61C24B5E#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/Boss/37BF86D9BBAF27A9D2ECE7EEDB691FFD$EXT"
cp "_temp/SUPER MARIO 64#DF5317B2#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/Boss/BD6515D91A867FA3CEF92C6303052C73$EXT"
cp "_temp/SUPER MARIO 64#6069E288#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/5EB649EA2FE8F5194C049443685F4FF2$EXT"
cp "_temp/SUPER MARIO 64#A290798B#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/669827E5DBF800328C1883BE11E2C644$EXT"
cp "_temp/SUPER MARIO 64#B0CD69EF#0#2_all$EXT" "$PORT/Areas/Bowser in the Sky/FA47536F29531D9EB17791079F259964$EXT"

cp "_temp/SUPER MARIO 64#022F69E3#0#2_all$EXT" "$PORT/Areas/Castle Inside/492F29A625CFF15B955E6D9F27446116$EXT"
cp "_temp/SUPER MARIO 64#0303136F#0#2_all$EXT" "$PORT/Areas/Castle Inside/13BE02095F3B5FDDC73D701C8AB5D743$EXT"
cp "_temp/SUPER MARIO 64#0D487556#0#2_all$EXT" "$PORT/Areas/Castle Inside/C4658E3CA79B6E66C5CE7D1AEF65852C$EXT"
cp "_temp/SUPER MARIO 64#1E520811#0#2_all$EXT" "$PORT/Areas/Castle Inside/C54214B707C0EB0FF5F3ED1F6ACCCC83$EXT"
cp "_temp/SUPER MARIO 64#2DC59B5C#0#2_all$EXT" "$PORT/Areas/Castle Inside/DAC86886E3D97B8C82E322C877E3354A$EXT"
cp "_temp/SUPER MARIO 64#4EEEFE7D#0#2_all$EXT" "$PORT/Areas/Castle Inside/E8B631C103BA7697EB424BE9E5E6C308$EXT"
cp "_temp/SUPER MARIO 64#54F2C81A#0#2_all$EXT" "$PORT/Areas/Castle Inside/403792EB685590BBD59B4D91CE1DB9B5$EXT"
cp "_temp/SUPER MARIO 64#59D072F0#0#2_all$EXT" "$PORT/Areas/Castle Inside/1B7CA9CF338F60C1D4351C5EB12D9786$EXT"
cp "_temp/SUPER MARIO 64#6AA1BE26#0#2_all$EXT" "$PORT/Areas/Castle Inside/708146056E858E4B3C30972943BC122F$EXT"
cp "_temp/SUPER MARIO 64#6DA0B1B9#0#2_all$EXT" "$PORT/Areas/Castle Inside/3CB02ADCFC6AF91C84DC6717D2713266$EXT"
cp "_temp/SUPER MARIO 64#7134B6DD#0#2_all$EXT" "$PORT/Areas/Castle Inside/FF3CA04BD3CDD2CFA4F91FFA3AA125AC$EXT"
cp "_temp/SUPER MARIO 64#730DA5F2#0#2_all$EXT" "$PORT/Areas/Castle Inside/7AA9B91C64C45A2A3E42041FD093D661$EXT"
cp "_temp/SUPER MARIO 64#8EE5398C#0#2_all$EXT" "$PORT/Areas/Castle Inside/F8E5A24CE6F113F4E81CBC95860AEDED$EXT"
cp "_temp/SUPER MARIO 64#9BE30B6E#0#2_all$EXT" "$PORT/Areas/Castle Inside/3CC0BD6724E5E1530A3D53735740FDC2$EXT"
cp "_temp/SUPER MARIO 64#9FCDDCE1#0#2_all$EXT" "$PORT/Areas/Castle Inside/D769A53BC4643FE0D3070CE7F0713E5B$EXT"
cp "_temp/SUPER MARIO 64#A6463A8D#0#2_all$EXT" "$PORT/Areas/Castle Inside/C01D1356EE94410280D81807A80A19EA$EXT"
cp "_temp/SUPER MARIO 64#D10D7B85#0#2_all$EXT" "$PORT/Areas/Castle Inside/446E0F4C1CDB0F8132514B6705818B8D$EXT"
cp "_temp/SUPER MARIO 64#DBCA0482#0#2_all$EXT" "$PORT/Areas/Castle Inside/5C88BD2615414C3BFB7BC8B3724EA06E$EXT"
cp "_temp/SUPER MARIO 64#FDB50546#0#2_all$EXT" "$PORT/Areas/Castle Inside/E19FB990FCA048CEE711559713DBBA12$EXT"
cp "_temp/SUPER MARIO 64#0702FDE6#0#2_all$EXT" "$PORT/Areas/Castle Inside/BB0E229376850328276095ABC2D0D41D$EXT"

cp "_temp/SUPER MARIO 64#09820848#0#2_all$EXT" "$PORT/Areas/Castle Outside/2B8CB6EC26F96D2D15D63502F0C77438$EXT"
cp "_temp/SUPER MARIO 64#0C89D16B#0#2_all$EXT" "$PORT/Areas/Castle Outside/42944C9C8F1231AAB6335459652AE4D2$EXT"
cp "_temp/SUPER MARIO 64#146F813F#0#2_all$EXT" "$PORT/Areas/Castle Outside/16620B9D17B1FAE35918995A794C3FB1$EXT"
cp "_temp/SUPER MARIO 64#22F743BF#0#2_all$EXT" "$PORT/Areas/Castle Outside/79ECC8B47E45ACCF6A1962540E2CD97F$EXT"
cp "_temp/SUPER MARIO 64#27ECE31D#0#2_all$EXT" "$PORT/Areas/Castle Outside/54DA6A9B3BDC4A791344304A9C7757DA$EXT"
cp "_temp/SUPER MARIO 64#370FC06B#0#2_all$EXT" "$PORT/Areas/Castle Outside/33C7FA7E34AEEE55A23EFDCBD076D189$EXT"
cp "_temp/SUPER MARIO 64#4166F73D#0#2_all$EXT" "$PORT/Areas/Castle Outside/B8062B99F007F8E03C4FB42660DB6DEC$EXT"
cp "_temp/SUPER MARIO 64#5F328955#0#2_all$EXT" "$PORT/Areas/Castle Outside/675596DC83900190F819BD20A01D3EBE$EXT"
cp "_temp/SUPER MARIO 64#726D3EFE#0#2_all$EXT" "$PORT/Areas/Castle Outside/D1464A7FA9C171A06E31BE29D2481189$EXT"
cp "_temp/SUPER MARIO 64#8296D820#0#2_all$EXT" "$PORT/Areas/Castle Outside/83729F2B81F6FEA0A5323423C4E81F7D$EXT"
cp "_temp/SUPER MARIO 64#968FA8CE#0#2_all$EXT" "$PORT/Areas/Castle Outside/13C5BB0D8664FC2330ADA2E398DB67B4$EXT"
cp "_temp/SUPER MARIO 64#976DBC10#0#2_all$EXT" "$PORT/Areas/Castle Outside/FFBA6A6967223C06FECF78403B531FC1$EXT"
cp "_temp/SUPER MARIO 64#A2C3484F#0#2_all$EXT" "$PORT/Areas/Castle Outside/7EF0EBD99AEA5EE0C66D55B2F079B221$EXT"
cp "_temp/SUPER MARIO 64#A6E20840#0#2_all$EXT" "$PORT/Areas/Castle Outside/4062BD3FB22ED9FFC4446F1AA7886E40$EXT"
cp "_temp/SUPER MARIO 64#C55C829F#0#2_all$EXT" "$PORT/Areas/Castle Outside/A184078351A3469ADD17D2C518A10669$EXT"
cp "_temp/SUPER MARIO 64#CC25CE0F#0#2_all$EXT" "$PORT/Areas/Castle Outside/B32CC229AC1CBFAF2D799C33ABDD5391$EXT"
cp "_temp/SUPER MARIO 64#D5BD2CF3#0#2_all$EXT" "$PORT/Areas/Castle Outside/679CA1AA81B07D79F08CA10FE10E64F6$EXT"
cp "_temp/SUPER MARIO 64#D7D14C92#0#2_all$EXT" "$PORT/Areas/Castle Outside/A8B23D90AF8FD4ADD74558FB9E8683F3$EXT"
cp "_temp/SUPER MARIO 64#E22B8125#0#2_all$EXT" "$PORT/Areas/Castle Outside/3DEF4FB0605665422EBB493F64EC4FE0$EXT"
cp "_temp/SUPER MARIO 64#E361666A#0#2_all$EXT" "$PORT/Areas/Castle Outside/E63AD69D15B96BD9F9BC4DE16AD08140$EXT"
cp "_temp/SUPER MARIO 64#F8303731#0#2_all$EXT" "$PORT/Areas/Castle Outside/4F05F264868F64CFE5138D79F67FD882$EXT"
cp "_temp/SUPER MARIO 64#F92708AD#0#2_all$EXT" "$PORT/Areas/Castle Outside/768C44B21279B4E33912993FEC859412$EXT"
cp "_temp/SUPER MARIO 64#0D09F13E#0#2_all$EXT" "$PORT/Areas/Castle Outside/Window/8D6D46EC30539EDC01D2F2271BE3D8BB$EXT"
cp "_temp/SUPER MARIO 64#0FDD80CA#0#2_all$EXT" "$PORT/Areas/Castle Outside/Window/635C0EC0D269BF8762848274032C752B$EXT"

cp "_temp/SUPER MARIO 64#5AC90B8D#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/44CC8BA66FAAD380350DBA13B5D214AD$EXT"
cp "_temp/SUPER MARIO 64#A055E62E#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/F959471FFCF56E275DE208D30AEFEDCE$EXT"
cp "_temp/SUPER MARIO 64#A22A5A73#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/20649CE04CBE00857A839FD38D4EB866$EXT"
cp "_temp/SUPER MARIO 64#F22E4881#0#2_all$EXT" "$PORT/Areas/Cavern of the Metal Cap/C057CF0CC9D572E98A0A992512C84AAC$EXT"

cp "_temp/SUPER MARIO 64#FED5AB03#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/unused/E18F3676279079AA8161483CF4F98786$EXT"
cp "_temp/SUPER MARIO 64#038BE28F#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/97E556C94AF02D28A45498150510839C$EXT"
cp "_temp/SUPER MARIO 64#130CA9A8#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/FBCEC078422F8C5457450596CA9A3C36$EXT"
cp "_temp/SUPER MARIO 64#15686BED#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/20138E23EF1E8C3FC303100AE8B44EF2$EXT"
cp "_temp/SUPER MARIO 64#17EA3392#3#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/411451A4A61E24D2969FC4E9F8E05946$EXT"
cp "_temp/SUPER MARIO 64#252A4B98#3#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/6C74FF06A35257325E0922B81B8683F3$EXT"
cp "_temp/SUPER MARIO 64#266A1564#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/733D70FB242060A7BA74A5B9FEF33C15$EXT"
cp "_temp/SUPER MARIO 64#3909F67D#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/A19BA588E6083D5C8D5EBB224A509008$EXT"
cp "_temp/SUPER MARIO 64#3FF93DA3#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/71EBBAB30B9BAEA0DE9DD469CB319C0B$EXT"
cp "_temp/SUPER MARIO 64#4276DB5E#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/E10F926D60BF9B73A8DCF0B01DB48CBD$EXT"
cp "_temp/SUPER MARIO 64#56DA6B66#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/6BA4CB99C2821D26FCD16206F2346726$EXT"
cp "_temp/SUPER MARIO 64#611B82B3#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/3F46C48A59ECA35C9BAA4B64A016AD9F$EXT"
cp "_temp/SUPER MARIO 64#6543184D#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/8DF576E1624D620396DA5F4D1A3B9EEC$EXT"
cp "_temp/SUPER MARIO 64#744A7D8E#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/B98886314C4118D1D7DF6F79BD15F4A1$EXT"
cp "_temp/SUPER MARIO 64#8299C450#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/B049E3E59009B140662711006210DADF$EXT"
cp "_temp/SUPER MARIO 64#84FED0D8#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/4B61B59056801FA999370AFD457060A4$EXT"
cp "_temp/SUPER MARIO 64#8DB2E5CA#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/2ACBA9370F83E4FB81BD31622DCE78B2$EXT"
cp "_temp/SUPER MARIO 64#9678001C#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/0127E586FE9E9B1CE46E6EF8F73C20B6$EXT"
cp "_temp/SUPER MARIO 64#9B6B4DBC#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/A90C94D55E46217B661165D41FAFBCB9$EXT"
cp "_temp/SUPER MARIO 64#9CAB9C3A#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/C64020C5C3B42903F39CCD1EF20AE2E4$EXT"
cp "_temp/SUPER MARIO 64#B2718DB8#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/F31069EF0CB5BC7885D71F7EDAD037FC$EXT"
cp "_temp/SUPER MARIO 64#D83419B2#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/4AA4EAD89632A6C6C5E17825F45D1F80$EXT"
cp "_temp/SUPER MARIO 64#E1CA8B50#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/ACB72617339E1C095302AD5F731A812D$EXT"
cp "_temp/SUPER MARIO 64#E8E37186#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/4105B238FFA794419C6E91A84427BA1E$EXT"
cp "_temp/SUPER MARIO 64#E9E0C62A#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/D1F1A553371063D9C8AF66334875ED29$EXT"
cp "_temp/SUPER MARIO 64#F831589E#0#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/BDFBD95B0A04A508C15CB76D716FD665$EXT"
cp "_temp/SUPER MARIO 64#FE55B4F9#3#2_all$EXT" "$PORT/Areas/Cool Cool Mountain/126D26F153141DF15C9060AB0814C296$EXT"

cp "_temp/SUPER MARIO 64#164FBE11#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/59A128945C6FA25C3086B8F90F32CEB3$EXT"
cp "_temp/SUPER MARIO 64#1D6FCB73#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/289D0DF2D38DD9264C33AC7B1447B1AD$EXT"
cp "_temp/SUPER MARIO 64#7B8E447D#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/4651ECCDD6BDC1CAFCCAEAEC466FCA3E$EXT"
cp "_temp/SUPER MARIO 64#F6C53A3C#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/Ship Room/B558DFE98BA7CCAFC4F5081D01C78CF9$EXT"
cp "_temp/SUPER MARIO 64#1A808DA7#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/E96C18876F09DDF41A41C26AFBF73164$EXT"
cp "_temp/SUPER MARIO 64#53C1213E#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/9BA3B1EFB6D844A07C2100BD7F32A081$EXT"
cp "_temp/SUPER MARIO 64#9C0E821E#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/D6F7131912940BD181E9D268A174C938$EXT"
cp "_temp/SUPER MARIO 64#C3459917#0#2_all$EXT" "$PORT/Areas/Dire Dire Docks/2084C47A61AB7BD89195CEBD74664B26$EXT"

cp "_temp/SUPER MARIO 64#65BFA19A#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/Maps/8A301C47AA7044DDB8E86919DD2A02EE$EXT"
cp "_temp/SUPER MARIO 64#829B7107#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/Maps/65D8F98B6C81F132171C9F97A8E54AD5$EXT"
cp "_temp/SUPER MARIO 64#FE1AB8D0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/Maps/A6F604F7210AABE4E9F6E5BCDA10F08F$EXT"
cp "_temp/SUPER MARIO 64#06682E2E#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/8A2F160FDED4471693647E7F4DF230A9$EXT"
cp "_temp/SUPER MARIO 64#304306E0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/99BDBE942027EC27BE4829DA0D15FB6C$EXT"
cp "_temp/SUPER MARIO 64#33C58D86#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/945C348187FB2E7D140243FEFD845EA2$EXT"
cp "_temp/SUPER MARIO 64#36F00556#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/A429FFD0162CB9FE147512A99D01ED20$EXT"
cp "_temp/SUPER MARIO 64#3E40E693#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/621436BF6C6CC00F0943D1C1B201EE6C$EXT"
cp "_temp/SUPER MARIO 64#40FA0DCA#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/B471340E8C2DE086E204E1995ECC1576$EXT"
cp "_temp/SUPER MARIO 64#4E6ECA8D#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/0BB467F834ED5FAC75185DF04BCB94AA$EXT"
cp "_temp/SUPER MARIO 64#4ED23BE0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/9F40E6DEE594F69D98E46BA89CBB9996$EXT"
cp "_temp/SUPER MARIO 64#6A925357#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/0A3E61D86F63818412C5036A1B3EDFBA$EXT"
cp "_temp/SUPER MARIO 64#6BEFEDB8#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/7E943DDC5890283A8DF8B35DE781C172$EXT"
cp "_temp/SUPER MARIO 64#7F9CCD83#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/66A6E9D20497919D099F77EAD22DA943$EXT"
cp "_temp/SUPER MARIO 64#8D2F37B0#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/E9EF0D1A6F9E2979E636C5AE22D984BF$EXT"
cp "_temp/SUPER MARIO 64#92F79940#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/8CB5810BAEB8FF226915147E3D3C7970$EXT"
cp "_temp/SUPER MARIO 64#97E53259#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/B8E4D06FCB60E460C501D3E94B2F58CC$EXT"
cp "_temp/SUPER MARIO 64#9B4BEFB8#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/F6B9714679DB47E8284EE4992982EED5$EXT"
cp "_temp/SUPER MARIO 64#BE04CE2E#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/86A5261FEEFF182CDAFFB2E336DD6711$EXT"
cp "_temp/SUPER MARIO 64#C199118A#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/1CE485312F4F65E345426A457FEAA48E$EXT"
cp "_temp/SUPER MARIO 64#D951B3DA#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/8F28E29F3F583982D65BA0ADAF54C2B6$EXT"
cp "_temp/SUPER MARIO 64#E56F0BBF#0#2_all$EXT" "$PORT/Areas/Hazy Maze Cave/BD5D290A119ECB723EC915130D2C779C$EXT"

cp "_temp/SUPER MARIO 64#1B6ACD5E#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/8285317CF0E8EF18517244E76755940E$EXT"
cp "_temp/SUPER MARIO 64#87D447AF#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/77ACEC3F69BC82F69F197F88D2537AD6$EXT"
cp "_temp/SUPER MARIO 64#8F698CC1#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/FC38B69AD5D2302338E7DE4572D9AD5E$EXT"
cp "_temp/SUPER MARIO 64#E60FFD91#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Chest/F0AFFF0617FCED6ACB9C447F44F0D466$EXT"
cp "_temp/SUPER MARIO 64#4010BAE8#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Crate/6301D3F4CE0F34BEE6F7E68ED0577689$EXT"
cp "_temp/SUPER MARIO 64#49997119#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Crate/DD3239CA599B25D9729AD34D63ABC1CB$EXT"
cp "_temp/SUPER MARIO 64#20E1EA4D#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/226A627CDEC30CC370BE0EBEABC0F056$EXT"
cp "_temp/SUPER MARIO 64#513BD6B7#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/528533A1D263F3134CF1E11E09CB3EBA$EXT"
cp "_temp/SUPER MARIO 64#C989266F#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/EF1ACD636EE2A493AA25AE110A132FB9$EXT"
cp "_temp/SUPER MARIO 64#D53A754E#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Kelp/432F450CDB5E29ECE953C58381BAA680$EXT"
cp "_temp/SUPER MARIO 64#428BEF9C#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/E00EB356F7377CF50126B245DA6989D1$EXT"
cp "_temp/SUPER MARIO 64#579C53ED#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/0C545EC0922B57905CF3B08F25D5A1D6$EXT"
cp "_temp/SUPER MARIO 64#6108550A#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/94B81B4FB8FE1F6BBD0B5A736BE10565$EXT"
cp "_temp/SUPER MARIO 64#6879F1F6#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/120CC2338D474E31A64AC0EA6799D120$EXT"
cp "_temp/SUPER MARIO 64#B5135C61#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/Ship/518E1F1F1776AFF7AD23EAE7EF7CDFD6$EXT"
cp "_temp/SUPER MARIO 64#2B644522#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/9F16E795E33D41722D81B7BEAD7E72E2$EXT"
cp "_temp/SUPER MARIO 64#4A0AF053#3#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/BECE1F48CB87B874F118F4F695BDE306$EXT"
cp "_temp/SUPER MARIO 64#5C403031#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/2F930E9CF91DC94137810FD81A61C781$EXT"
cp "_temp/SUPER MARIO 64#775A5057#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/D01DAEA4CA5160DE780E29E5AC84F94C$EXT"
cp "_temp/SUPER MARIO 64#7E28666B#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/A65B1B2B8ECCA2D1E2000108F66FC750$EXT"
cp "_temp/SUPER MARIO 64#A1AE1A01#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/6D6392557B6FC697A8961E0F0F982ECE$EXT"
cp "_temp/SUPER MARIO 64#C5E87355#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/146623E68795DBD57A61656ED5B508D8$EXT"
cp "_temp/SUPER MARIO 64#E3C3F224#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/72D40B774DD6AC8D044770A5EAF24F0C$EXT"
cp "_temp/SUPER MARIO 64#FEBEDAE8#0#2_all$EXT" "$PORT/Areas/Jolly Roger Bay/2885C48AAF7D4DB3480C736A08EFAC3A$EXT"

cp "_temp/SUPER MARIO 64#36FC4C04#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/0347D109BB228FE923CB5B45F7AFA2D6$EXT"
cp "_temp/SUPER MARIO 64#46A556F1#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/3ACA4571AB6D8B885E9572FE640BA30E$EXT"
cp "_temp/SUPER MARIO 64#4A750285#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/E4694FAD8FA1D674CDC9F184513CF581$EXT"
cp "_temp/SUPER MARIO 64#4E0A3338#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/7161A8D9BF4B45B51D5BADEC7D0435D4$EXT"
cp "_temp/SUPER MARIO 64#6541DD48#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/561CA3690627B6DE77DFA225C23E7271$EXT"
cp "_temp/SUPER MARIO 64#7323E612#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/747DDEB3C5D7ED4862185281652E4AC4$EXT"
cp "_temp/SUPER MARIO 64#A804C734#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/00C757A688FA52A22AA296D7292C576E$EXT"
cp "_temp/SUPER MARIO 64#BBCA6538#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/E9FC3DA816832A4957EC92D15AB925EC$EXT"
cp "_temp/SUPER MARIO 64#C64AD046#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/B605B3680612579EF691351612DBCD95$EXT"
cp "_temp/SUPER MARIO 64#CCFDAE7D#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/2FF19988B812244592955B2E4FE4C20C$EXT"
cp "_temp/SUPER MARIO 64#D9E8F2F0#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/5BBB95CFF54163C8E696257FED062EEB$EXT"
cp "_temp/SUPER MARIO 64#EA11FB10#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/C194612432201A686BC5606CD019DEED$EXT"
cp "_temp/SUPER MARIO 64#F6AFFEC8#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/E3AD9413A0E3ECF175927C15E6860613$EXT"
cp "_temp/SUPER MARIO 64#F71BCBCA#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Bowser/A4088B5884B3B3297A9DFAACF761B325$EXT"
cp "_temp/SUPER MARIO 64#E3F0759B#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/unused/B9F90715C32D0F68E7A771F4D319CC44$EXT"
cp "_temp/SUPER MARIO 64#144C8CF3#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/918CA2FA779DCDF2FACEE1C93E9AF2C6$EXT"
cp "_temp/SUPER MARIO 64#1541A06E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/51F39AE8230541B6138C67244C99284B$EXT"
cp "_temp/SUPER MARIO 64#63F6E568#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/EED23BE631D45053ECF19FCC26FF9625$EXT"
cp "_temp/SUPER MARIO 64#6A748651#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/E9449217C9F6A117CC9C3B77E2CE2BE0$EXT"
cp "_temp/SUPER MARIO 64#7AE8E843#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/38F533DF7F4183396BBA92851305C358$EXT"
cp "_temp/SUPER MARIO 64#7CFB23B0#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/9B637B095D0B8BB2CC6CE37E76DCEEDC$EXT"
cp "_temp/SUPER MARIO 64#8F25C650#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/Volcano/C8F489D32EE6F099CB16ABE582025FDB$EXT"
cp "_temp/SUPER MARIO 64#0B962372#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/09C5017DB3A9A5D36C153D0A9345041B$EXT"
cp "_temp/SUPER MARIO 64#10675A01#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/A7068E2B7D4E96626AE85AD69A0E5C05$EXT"
cp "_temp/SUPER MARIO 64#10E452C9#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/A4EE55BCB369AE6EDE522F347D132BE1$EXT"
cp "_temp/SUPER MARIO 64#1ECB06AF#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/B6C0589E5B631EAD29A62E02A0DDF0A5$EXT"
cp "_temp/SUPER MARIO 64#2A83D55A#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/6C0ED1FC7A4C2FF5F886BC46CC535EF5$EXT"
cp "_temp/SUPER MARIO 64#2EA7C781#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/75683223EF10C43C5D08FA397D6BB1DF$EXT"
cp "_temp/SUPER MARIO 64#3A9A3561#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/4926651FC532DB1514D9A470B2066F34$EXT"
cp "_temp/SUPER MARIO 64#40568542#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/9982AF687A01693E2469FC1544D91342$EXT"
cp "_temp/SUPER MARIO 64#508E888F#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/0D82D2BF486141A12FCB32C4CF41A01D$EXT"
cp "_temp/SUPER MARIO 64#52BC0E5E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/95C57381B659377D828A0AE9A938C325$EXT"
cp "_temp/SUPER MARIO 64#5996660E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/7CF871BEE3CC650545EC7B7F671D0250$EXT"
cp "_temp/SUPER MARIO 64#5D3DF26F#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/72E246B9D32AE73724D846D012DD0B2C$EXT"
cp "_temp/SUPER MARIO 64#6626C09A#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/BFC86C99B0A3B1AA81413F5C9084E1CE$EXT"
cp "_temp/SUPER MARIO 64#6FA30457#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/F6B653FA88F5188862B2255E36A3A078$EXT"
cp "_temp/SUPER MARIO 64#746A5D31#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/C4310C37B69D4A07977D82CFEE7D7C9D$EXT"
cp "_temp/SUPER MARIO 64#7ECF9E44#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/86A372739C02D4F9FEC85FF127E5D26D$EXT"
cp "_temp/SUPER MARIO 64#810A6136#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/F3CEF9F2E6787A968281850A31DEC53C$EXT"
cp "_temp/SUPER MARIO 64#82B146CD#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/9883BFC21F1E0BD3C35286E020CE2532$EXT"
cp "_temp/SUPER MARIO 64#945943B1#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/0A812CE09AB9594D53B75B714BB78EC3$EXT"
cp "_temp/SUPER MARIO 64#9A729C51#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/06E41D99EA6F40EDF5356D0C85710BB0$EXT"
cp "_temp/SUPER MARIO 64#A808D20A#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/C2224C37A27F6C14196E01DC9242CB8D$EXT"
cp "_temp/SUPER MARIO 64#B1386A2E#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/190315DAF00C21C5CE5EFCE71B4CB872$EXT"
cp "_temp/SUPER MARIO 64#B50DE959#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/DC583DED78388D1539E07BB3485ED80F$EXT"
cp "_temp/SUPER MARIO 64#BA6D7331#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/EF3F71C28D4076B8E74CF15C3398A4F2$EXT"
cp "_temp/SUPER MARIO 64#C0BCCCF4#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/ADAA49EAC0A4302EF5F64E935F1E8A3D$EXT"
cp "_temp/SUPER MARIO 64#C518BF93#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/936D73608D7B8559EFC5C10109991F13$EXT"
cp "_temp/SUPER MARIO 64#C6B026AA#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/28B27B09F112EF488A1AFF144FDE9699$EXT"
cp "_temp/SUPER MARIO 64#D494EB3B#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/3739FF205BFD723124877BDC8B099D05$EXT"
cp "_temp/SUPER MARIO 64#E2E864A2#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/7821A159D9FECE3FF9E90265F5357745$EXT"
cp "_temp/SUPER MARIO 64#E42D6AA8#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/AEBF2FB42798215E89B368AA11E0E1E8$EXT"
cp "_temp/SUPER MARIO 64#E49DCFB8#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/A60720E3F5567231D557DE565B67E867$EXT"
cp "_temp/SUPER MARIO 64#F4D429FD#0#2_all$EXT" "$PORT/Areas/Lethal Lava Land/2FBFFF04F6A2D154A6E08B6FA8287602$EXT"

cp "_temp/SUPER MARIO 64#32169E73#0#2_all$EXT" "$PORT/Areas/Rainbow Ride/CF10DF6C7C2D8EC47825A1309413FBF5$EXT"
cp "_temp/SUPER MARIO 64#4676F47D#0#2_all$EXT" "$PORT/Areas/Rainbow Ride/46D3481D4EFD51A23DE9259290B4F6EE$EXT"
cp "_temp/SUPER MARIO 64#83101FA2#0#2_all$EXT" "$PORT/Areas/Rainbow Ride/9EA57A2B073ED75DF050189E8F8BEC60$EXT"

cp "_temp/SUPER MARIO 64#1CB6E388#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/AD2C81D335CDFE33EB5DAA3D6059605A$EXT"
cp "_temp/SUPER MARIO 64#325A3830#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/B8CB6641C6E53A8768A3E24FF2C2D315$EXT"
cp "_temp/SUPER MARIO 64#D5B932A2#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/A7F0DCB4E52DD0FD7FE78E8C1290C19F$EXT"
cp "_temp/SUPER MARIO 64#ECE06C79#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Block/BD373C01F7AB1FE1F46A68FFFAC8990F$EXT"
cp "_temp/SUPER MARIO 64#5AF9DFDE#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Pyramid/A3A0CA34EA125D557C7DA034E12BBC3C$EXT"
cp "_temp/SUPER MARIO 64#85204772#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Pyramid/7E8DAD8C2E3F4343E94F1F08D844B35F$EXT"
cp "_temp/SUPER MARIO 64#F3CC9E98#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/Pyramid/107B52AF89D2A8403352E43B04A46B35$EXT"
cp "_temp/SUPER MARIO 64#3ECBD5D1#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/unused/41B8620B995164C173FC571FA2B4D78E$EXT"
cp "_temp/SUPER MARIO 64#B99A9F71#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/unused/F29364881BB8D185EE7E61E5E767740D$EXT"
cp "_temp/SUPER MARIO 64#04A35759#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/CBE74EF2F00DE20FD6BF56A9B9603EB8$EXT"
cp "_temp/SUPER MARIO 64#09208466#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/5A53F40492F26A4E7A131564E962786E$EXT"
cp "_temp/SUPER MARIO 64#1F6DA0F2#3#2_all$EXT" "$PORT/Areas/Shifting Sand Land/90AD269B9AAA7F6E1921EDC0C3273979$EXT"
cp "_temp/SUPER MARIO 64#60AA80AA#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/A913A80D44A643C6C68F931D8A805C1B$EXT"
cp "_temp/SUPER MARIO 64#6DCA9CD5#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/C2FD7C56569C2B321D95A8DC39A1C3A5$EXT"
cp "_temp/SUPER MARIO 64#7F832C86#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/0CDCE035596DEAB6370C5D2E2C948D8B$EXT"
cp "_temp/SUPER MARIO 64#8B50E442#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/FEA803DAA4689AB6DBC49186BA3C710D$EXT"
cp "_temp/SUPER MARIO 64#A3DA7F18#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/7A08BEB34F8119F976F74A77A3543F15$EXT"
cp "_temp/SUPER MARIO 64#C6028757#0#2_all$EXT" "$PORT/Areas/Shifting Sand Land/8525DB4610F18341E663569FFB201D07$EXT"

cp "_temp/SUPER MARIO 64#1FC70576#0#2_all$EXT" "$PORT/Areas/Snowman's Land/C3B9B38741D6BF0B709DD482111F1EE8$EXT"
cp "_temp/SUPER MARIO 64#6CF04010#0#2_all$EXT" "$PORT/Areas/Snowman's Land/126F54C6E03C52B3364F9CA47C54B678$EXT"
cp "_temp/SUPER MARIO 64#783B816B#0#2_all$EXT" "$PORT/Areas/Snowman's Land/3006177F0A51C241CBD967ED6C57C512$EXT"
cp "_temp/SUPER MARIO 64#DA375BA5#0#2_all$EXT" "$PORT/Areas/Snowman's Land/85A46A92B7FECF4232C1C1F3A3962230$EXT"

cp "_temp/SUPER MARIO 64#07CF15A6#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/439F7A17D884AFE21EF3A81541136762$EXT"
cp "_temp/SUPER MARIO 64#27B29129#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/8DCD67CB4F36DCEB8EB95DDFC67B6F1E$EXT"
cp "_temp/SUPER MARIO 64#5CFEB1DB#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/DD6781C74EBB983A328B921432024BD6$EXT"
cp "_temp/SUPER MARIO 64#76E8D87C#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/20CF70B95334E21384784B756544864B$EXT"
cp "_temp/SUPER MARIO 64#8F523EF1#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/C265C1854F183E7E2459A145C9831FDD$EXT"
cp "_temp/SUPER MARIO 64#D1C5DE12#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/1D530924F4E95842F98EA23DA42225B2$EXT"
cp "_temp/SUPER MARIO 64#D4E4F405#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/6BD411DEDBE1E0BF3F6EEAA8FFFD9D68$EXT"
cp "_temp/SUPER MARIO 64#E383FD85#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/6049B4BE88C2E42D099F1721E5D85771$EXT"
cp "_temp/SUPER MARIO 64#B4CAD4F7#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide/B0D5DFCE27FF123AEA77D564E1876C83$EXT"
cp "_temp/SUPER MARIO 64#167CAC52#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide Entrance/CB14AE1D8CE6B146C39871976096B591$EXT"
cp "_temp/SUPER MARIO 64#69553F79#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/Slide Entrance/E66F354FA3A71697EC43E0A45CACDF52$EXT"
cp "_temp/SUPER MARIO 64#08758CDE#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/498126B632CA505B1E37E74755648172$EXT"
cp "_temp/SUPER MARIO 64#13E4332A#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/BC65C6F04A21B06F6526158D5039D3B7$EXT"
cp "_temp/SUPER MARIO 64#1660C971#3#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/C06644564FDEEF919279D28EC05310A4$EXT"
cp "_temp/SUPER MARIO 64#1F3B7ABC#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/ECE9E9D29041AC28127691029A79F13E$EXT"
cp "_temp/SUPER MARIO 64#28061018#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/741F3025DD4CCF377A4620F1775A2707$EXT"
cp "_temp/SUPER MARIO 64#51762E4C#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/58C4D217FCE6095B2BF7441B0719F35D$EXT"
cp "_temp/SUPER MARIO 64#B401E19F#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/90D7CFA949771609D4A3960AB877F5E7$EXT"
cp "_temp/SUPER MARIO 64#B59D468A#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/66B0F0D549A05AE935042C3D74B3800E$EXT"
cp "_temp/SUPER MARIO 64#C072C80F#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/241A6E4B6964E92ED1CA519D92B698CA$EXT"
cp "_temp/SUPER MARIO 64#D41593D8#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/75072C7A66A1846BAAEA70FFAD3F5ABF$EXT"
cp "_temp/SUPER MARIO 64#DD432C19#3#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/222D3817CF2200CD15DA503298A4718A$EXT"
cp "_temp/SUPER MARIO 64#F8D78296#0#2_all$EXT" "$PORT/Areas/Tall Tall Mountain/41ED67B0708E8D1C38CB24EB542B1245$EXT"

cp "_temp/SUPER MARIO 64#403C6122#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/C271DFCA8808D0CC2EF1F5F45E669FFC$EXT"
cp "_temp/SUPER MARIO 64#4C001AD4#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/C355C63210545ED57A675541EA1F18D0$EXT"
cp "_temp/SUPER MARIO 64#7A1B62B1#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/6E52F383AAC87291EFF87BCAEE4ADCF6$EXT"
cp "_temp/SUPER MARIO 64#9FA96B1F#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/B155BA75D14930479F556E57747F757E$EXT"
cp "_temp/SUPER MARIO 64#D0AB7F94#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/2DBFF2CE1FEC4D202C5874071A04AFB3$EXT"
cp "_temp/SUPER MARIO 64#D1F883F5#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/349634D8604239561FA11A95D31CA906$EXT"
cp "_temp/SUPER MARIO 64#D795FE9F#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/3D1B4F85729E4A46023D54A96D380D5A$EXT"
cp "_temp/SUPER MARIO 64#F902B80B#0#2_all$EXT" "$PORT/Areas/The Princess's Secret Slide/0B80A052283A6FE6DC0FD387FFEFCA60$EXT"

cp "_temp/SUPER MARIO 64#0110314C#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/2FD4FADFFDBC8EF86E11A57E6DA6C1F5$EXT"
cp "_temp/SUPER MARIO 64#19BB64C1#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/24A82041139CBCECE15478C015ED0728$EXT"
cp "_temp/SUPER MARIO 64#1C3B41CF#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/54242C46B7FD0C052C6FBDC85C44CB14$EXT"
cp "_temp/SUPER MARIO 64#1F5B1636#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/D34201297F18D85DBBEE33A95C555F26$EXT"
cp "_temp/SUPER MARIO 64#39E470DD#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/FDBE33FF41448715808E249A023A6FFB$EXT"
cp "_temp/SUPER MARIO 64#41304ACC#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/356BA227F3C4C186CEE7F247FF893161$EXT"
cp "_temp/SUPER MARIO 64#48B717EE#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/A912D910C0EE41B32BC56469DCF781DB$EXT"
cp "_temp/SUPER MARIO 64#4C26A305#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/A9D733C3D78DBAC274F121E8CA187C53$EXT"
cp "_temp/SUPER MARIO 64#52F9E748#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/916B7DDC7377B4062255439B321472EC$EXT"
cp "_temp/SUPER MARIO 64#57C29C7D#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/27BB9A0CAE2978E1851968E78404D661$EXT"
cp "_temp/SUPER MARIO 64#6E3243F8#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/674F43E03FD11BCEA8F6DBF246D7997C$EXT"
cp "_temp/SUPER MARIO 64#79D25AFB#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/AB6F71A9D5BC69CD63D940A109D86C6F$EXT"
cp "_temp/SUPER MARIO 64#83D5BA14#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/2C535A6BBBB443903103FC9B46C57820$EXT"
cp "_temp/SUPER MARIO 64#86FB0C9F#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/1EAAE4424A210169086648FA48CC6BAE$EXT"
cp "_temp/SUPER MARIO 64#88654139#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/9F12E2C3A2F9E8919422D9EBDD91D958$EXT"
cp "_temp/SUPER MARIO 64#933C8F9C#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/9299AD9E12307D90B65B7B377B2E45B5$EXT"
cp "_temp/SUPER MARIO 64#C9524EEE#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/24CEDCDA1A15AFE10E6D1582BB96D95F$EXT"
cp "_temp/SUPER MARIO 64#D872CF6B#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/8F9035631B6D384267DFE6DAEB8B0A44$EXT"
cp "_temp/SUPER MARIO 64#FF00D1BF#0#2_all$EXT" "$PORT/Areas/Tick Tock Clock/F7046192FF14FE581CF89D19C72AA226$EXT"

cp "_temp/SUPER MARIO 64#5C3873C6#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/2A31F6D1306A96E046AB1C4D81A261BE$EXT"
cp "_temp/SUPER MARIO 64#60DD36F6#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/5F138C22FDA2BD1D7AC9B5EC29E3E9C5$EXT"
cp "_temp/SUPER MARIO 64#6F5155BA#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/Wiggler's Cave/3F322F19FA27DC1CF7F3E2502CB51DF3$EXT"
cp "_temp/SUPER MARIO 64#6F5155BA#3#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/A14175776FC4594371640F1AD43744B5$EXT"
cp "_temp/SUPER MARIO 64#CF52A490#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/D32B2C7577C0592AD0556B4E07FCC902$EXT"
cp "_temp/SUPER MARIO 64#D91DA963#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/CDDA7F00652E9FA14FBE1E5F485FBD40$EXT"
cp "_temp/SUPER MARIO 64#EB37A9B8#0#2_all$EXT" "$PORT/Areas/Tiny-Huge Island/FCFDC6880934ED07567733DE79CE0582$EXT"

cp "_temp/SUPER MARIO 64#20167DE7#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/A2B4E6C156C7E5ACC1FAD6848BAF30BC$EXT"
cp "_temp/SUPER MARIO 64#2B08F032#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/D4CFC604509EF6C17F9863AD58F7E22A$EXT"
cp "_temp/SUPER MARIO 64#3163AA92#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/198F2217A3AEFFB7787BBA85805038FB$EXT"
cp "_temp/SUPER MARIO 64#A7C0A6EB#3#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/2F039B1BE5386F10B2EBC1203D7E5AEB$EXT"
cp "_temp/SUPER MARIO 64#E473FB5D#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/B0E905FFB7E888EE70798C9932B644D3$EXT"
cp "_temp/SUPER MARIO 64#EC819D1B#0#2_all$EXT" "$PORT/Areas/Tower of the Wing Cap/ADD6C94AB560718097A16C992E916732$EXT"

cp "_temp/SUPER MARIO 64#094B9235#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/52B8A84D11ECD6EFD9F169015E8B597B$EXT"
cp "_temp/SUPER MARIO 64#7E7433A6#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/7DDB3CA2DEC81AA0D0BC056CFF3A9410$EXT"
cp "_temp/SUPER MARIO 64#9066E92B#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/082EC986527EF1A19831AAD3CF0C91F1$EXT"
cp "_temp/SUPER MARIO 64#A2F695A8#0#2_all$EXT" "$PORT/Areas/Vanish Cap Under the Moat/834850129FDBE55CDA41CCCBAE34BAA5$EXT"

cp "_temp/SUPER MARIO 64#73505869#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/EEBBFEFC58BC6F80EF679E6629780901$EXT"
cp "_temp/SUPER MARIO 64#74141022#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/DFF8D7440F347957A7D50EC93D85C1D1$EXT"
cp "_temp/SUPER MARIO 64#9DF06E15#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/EBE8EEB8343AE73F5E23FDD854C72EEB$EXT"
cp "_temp/SUPER MARIO 64#AF89C8F8#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/9DD88784F5D73674CAA57359DE8DB18D$EXT"
cp "_temp/SUPER MARIO 64#CC57ADE9#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/A92D914BC07A3FBF4AE74C23B2D63C64$EXT"
cp "_temp/SUPER MARIO 64#DCF4DE07#0#2_all$EXT" "$PORT/Areas/Wet-Dry World/A952717AB85426DAFAC1AF2481D6C686$EXT"

cp "_temp/SUPER MARIO 64#01755B95#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/90704784F8D411C638601AA4A5A15D41$EXT"
cp "_temp/SUPER MARIO 64#13C541EA#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/8A55CAE45D6E49823E614ED3F633A054$EXT"
cp "_temp/SUPER MARIO 64#1EFFD4E0#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/E74383B0328951CC4FC60CB7C6514DFE$EXT"
cp "_temp/SUPER MARIO 64#2BC420F5#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/03B3F3557EF2157FDE9AF40094DE969C$EXT"
cp "_temp/SUPER MARIO 64#49A3631E#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/87CAA847A46625F3D6FA18118DF829F2$EXT"
cp "_temp/SUPER MARIO 64#4F265622#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/75B2ED386E1E04C6EF17B506FF3CAB2B$EXT"
cp "_temp/SUPER MARIO 64#53405A73#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/24861756F87BB280CC5BB862AF2EA8C2$EXT"
cp "_temp/SUPER MARIO 64#742FD706#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/E265805F93665C69C387E2E164FB8A18$EXT"
cp "_temp/SUPER MARIO 64#79D8C749#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/2E7E56F920676FE512DAC92794833AB2$EXT"
cp "_temp/SUPER MARIO 64#81F9D9F5#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/2197528FE2126650EB0966292C105978$EXT"
cp "_temp/SUPER MARIO 64#861DC3CF#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/2EC971B8F1B8939FEE8B5330384E2579$EXT"
cp "_temp/SUPER MARIO 64#93AE5517#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/38A6D40D36E9B60D8F144BB32B359314$EXT"
cp "_temp/SUPER MARIO 64#9B61A230#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/4FB4F8658175703D2D4C1025F42842F3$EXT"
cp "_temp/SUPER MARIO 64#B1F1CC42#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/BEEC4D3B30FCE61E59E113CFEC17A6FE$EXT"
cp "_temp/SUPER MARIO 64#BD423336#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/313E3F0C5D4B9359C5BFA078E0E82CBA$EXT"
cp "_temp/SUPER MARIO 64#D4291CF0#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/93702CDFBD39FD8CC3A15361D841057E$EXT"
cp "_temp/SUPER MARIO 64#DC7BDE10#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/6CA4B090608E7A78AD7097DC0EEB0675$EXT"
cp "_temp/SUPER MARIO 64#E61E849B#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/EDE125A1D8551114B2981A45D1300947$EXT"
cp "_temp/SUPER MARIO 64#E944A81B#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/7D50B3EA6E99A20DB9F07765668884DB$EXT"
cp "_temp/SUPER MARIO 64#F3B23497#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/947298DF39950D4D3B9E0BAEE3FA2790$EXT"
cp "_temp/SUPER MARIO 64#F5A3113C#0#2_all$EXT" "$PORT/Areas/Whomp's Fortress/7F7931938C34F5EAFB51E3834CDF6442$EXT"

cp "_temp/SUPER MARIO 64#04F846F7#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/B46AA9BA2B7ADE27E560E44AF9E016BD$EXT"
cp "_temp/SUPER MARIO 64#2CDB87DE#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/9C4FCAC66C37401CF0A367D705CEAA38$EXT"
cp "_temp/SUPER MARIO 64#33B314AF#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/7B8022A78FAE7DF8C222ED0D325CBD15$EXT"
cp "_temp/SUPER MARIO 64#51D4DA7F#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/517B7FE7AA1879FBE3E9D30BBF1A97C5$EXT"
cp "_temp/SUPER MARIO 64#BD4BA854#0#2_all$EXT" "$PORT/Areas/Wing Mario Over the Rainbow/130B2C2A9909421CF1A65B8482F863AF$EXT"

cp "_temp/SUPER MARIO 64#1056B1F2#0#2_all$EXT" "$PORT/Boot/File Select/Hand/86DF5C77D2B493998C8A00131335A033$EXT"
cp "_temp/SUPER MARIO 64#66799DCC#0#2_all$EXT" "$PORT/Boot/File Select/Hand/ADF5F0C02404F028FC8339A024476D3C$EXT"
cp "_temp/SUPER MARIO 64#3C99819F#0#2_all$EXT" "$PORT/Boot/File Select/08EFA480CD893DA527CF3D8ADBFCB880$EXT"
cp "_temp/SUPER MARIO 64#431E1944#0#2_all$EXT" "$PORT/Boot/File Select/516CE4817E60C6DA07E66CF098526FF8$EXT"
cp "_temp/SUPER MARIO 64#474F8A1B#0#2_all$EXT" "$PORT/Boot/File Select/2262676E66CDD672C8EE11011BF81791$EXT"
cp "_temp/SUPER MARIO 64#72CB8C7F#0#2_all$EXT" "$PORT/Boot/File Select/AEE5131C160DFD15FD51843E24C34B30$EXT"
cp "_temp/SUPER MARIO 64#A34F223C#0#2_all$EXT" "$PORT/Boot/File Select/197736B039E3A2453FDF1BFF1F3B29E0$EXT"
cp "_temp/SUPER MARIO 64#E5D87CD6#0#2_all$EXT" "$PORT/Boot/File Select/E6C5AF57298EA2E99D0444E8C711D9B9$EXT"
cp "_temp/SUPER MARIO 64#EC60ED0C#0#2_all$EXT" "$PORT/Boot/File Select/CE685004685346A4B126ABC6CBB3C75D$EXT"
cp "_temp/SUPER MARIO 64#FAE4A688#0#2_all$EXT" "$PORT/Boot/File Select/93EBFB0BA7A50D66B7E97A373A6E3B89$EXT"
cp "_temp/SUPER MARIO 64#FBCB7598#0#2_all$EXT" "$PORT/Boot/File Select/DE3A19129F46507C21F1F0011BE36AAE$EXT"

cp "_temp/SUPER MARIO 64#1298CA11#0#2_all$EXT" "$PORT/Boot/Logo/2D84A52362AA7324319FDDF5AEF2ED7E$EXT"
cp "_temp/SUPER MARIO 64#3BA40EE9#0#2_all$EXT" "$PORT/Boot/Logo/B397A5C4FAFEEE24FB3C899A498DE095$EXT"
cp "_temp/SUPER MARIO 64#3D51E423#0#2_all$EXT" "$PORT/Boot/Logo/57A8E4FEC5ACC8EBE7D27AD7C4C0C426$EXT"
cp "_temp/SUPER MARIO 64#610B81D3#0#2_all$EXT" "$PORT/Boot/Logo/33E8371AC320FE21AE72075002E40AD5$EXT"
cp "_temp/SUPER MARIO 64#B1A11E42#0#2_all$EXT" "$PORT/Boot/Logo/6C9B35C973E85234EDA0B902D989857F$EXT"
cp "_temp/SUPER MARIO 64#B2E16417#0#2_all$EXT" "$PORT/Boot/Logo/D290043B1B65AE78FC9EDC2C784C967F$EXT"
cp "_temp/SUPER MARIO 64#0855931E#0#2_all$EXT" "$PORT/Boot/Logo/9D1608ADF3F26CE487C975961CE2B6EF$EXT"
cp "_temp/SUPER MARIO 64#AE87D925#0#2_all$EXT" "$PORT/Boot/Logo/1EE0425BE681ABA5949CAC75AF11E302$EXT"
cp "_temp/SUPER MARIO 64#B7C38322#0#2_all$EXT" "$PORT/Boot/Logo/D16191DE617AE6DB77F764BB9F52A8AA$EXT"

cp "_temp/SUPER MARIO 64#563280BD#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/5A00D296C43094CA7B42E324C6D94869$EXT"
cp "_temp/SUPER MARIO 64#75701F22#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/F3498E23CD4B98D459BAD1A9AFA243BC$EXT"
cp "_temp/SUPER MARIO 64#8ECFFABB#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/D55A6045140F3C2DBABCCF918FDFBF08$EXT"
cp "_temp/SUPER MARIO 64#BB980031#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over/3BEC210BA8A163F57EBD34D7587606B3$EXT"
cp "_temp/SUPER MARIO 64#53F6CD7D#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over (iQue)/880C478C5BBA5C11098719A50B6ABC0C$EXT"
cp "_temp/SUPER MARIO 64#62A06EEF#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over (iQue)/4BC1AF202376457095435699921EFB64$EXT"
cp "_temp/SUPER MARIO 64#8354C629#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over (iQue)/0E35689C50FA787F3E6AE586AEDC1C6B$EXT"
cp "_temp/SUPER MARIO 64#E110CE4F#0#2_all$EXT" "$PORT/Boot/Press Start/Game Over (iQue)/844CF3A7C4F32319EC96AA7DE5E64FFA$EXT"
cp "_temp/SUPER MARIO 64#087F8F7B#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/26140243D78748B86105FB5314F8E57D$EXT"
cp "_temp/SUPER MARIO 64#188B6465#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/4A52C880019B97D8621AB55066B76317$EXT"
cp "_temp/SUPER MARIO 64#A15FB7B8#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/0A400A875EF8EEDC839068CDBE562211$EXT"
cp "_temp/SUPER MARIO 64#D816C431#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/ADE9D8B9C38A39C8B5B6B86626BC2789$EXT"
cp "_temp/SUPER MARIO 64#DEE37E88#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/723EF243C194A02F808414353496020B$EXT"
cp "_temp/SUPER MARIO 64#DF22EBFF#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/D870F30C34DCDEF26F1F273E25A75B2C$EXT"
cp "_temp/SUPER MARIO 64#DFF2A421#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/38E26D41716711017202B380BFF86550$EXT"
cp "_temp/SUPER MARIO 64#E7F503AC#0#2_all$EXT" "$PORT/Boot/Press Start/Grey Star/461EA464B7EECA6279A622FF8F3D028E$EXT"
cp "_temp/SUPER MARIO 64#0D821DF9#0#2_all$EXT" "$PORT/Boot/Press Start/Hand/5C5DDD5E9C39A9168CB9BEF0BA9D9025$EXT"
cp "_temp/SUPER MARIO 64#C61400EB#0#2_all$EXT" "$PORT/Boot/Press Start/Hand/CB436C9F0445715AC4B604956470065A$EXT"
cp "_temp/SUPER MARIO 64#01BF1983#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/744B005B661ABD17E6A4708BD10D85F2$EXT"
cp "_temp/SUPER MARIO 64#02040B88#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/13A420FA19CDEDE0EFDE80EDD148833E$EXT"
cp "_temp/SUPER MARIO 64#1F31633F#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/3A5DDFF742B9ACEB1DD9E2584A1C6998$EXT"
cp "_temp/SUPER MARIO 64#531BEBD4#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/7BAE90C9C50E9F6D8B540425FC5A8C39$EXT"
cp "_temp/SUPER MARIO 64#686C2F97#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/7DA0BD9EB7E9EB520EBB4C382F3CA7E8$EXT"
cp "_temp/SUPER MARIO 64#934DC3B3#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/91A7821BEFBAEE37E6650B85BA19B02C$EXT"
cp "_temp/SUPER MARIO 64#D04A00D5#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/6DAC47E0EA9CCD597C09E66F7FEAFF0B$EXT"
cp "_temp/SUPER MARIO 64#D314E722#0#2_all$EXT" "$PORT/Boot/Press Start/Red Star/D68E2BDF98F443BF091C4DF9E611AD44$EXT"
cp "_temp/SUPER MARIO 64#17EB8CF3#0#2_all$EXT" "$PORT/Boot/Press Start/Title/8D24C7FB8733864F2988B5F529536C6C$EXT"
cp "_temp/SUPER MARIO 64#530A2CF4#0#2_all$EXT" "$PORT/Boot/Press Start/Title/C721DA20DD5260BD1E4272229F4398EB$EXT"
cp "_temp/SUPER MARIO 64#57A58C22#0#2_all$EXT" "$PORT/Boot/Press Start/Title/F1CF50404C552ABA558456035713D42A$EXT"
cp "_temp/SUPER MARIO 64#8B826DF7#0#2_all$EXT" "$PORT/Boot/Press Start/Title/DD4DEA5B29A39A94C2E963DAA2959488$EXT"
cp "_temp/SUPER MARIO 64#7D0AED5E#0#2_all$EXT" "$PORT/Boot/Press Start/Title (iQue)/81C4D6FF90899BFA4E641B23D1819139$EXT"
cp "_temp/SUPER MARIO 64#69DA4B2D#0#2_all$EXT" "$PORT/Boot/Press Start/Title (iQue)/BD83897DEABF4D1FAF43824BE1A66080$EXT"
cp "_temp/SUPER MARIO 64#624F4862#0#2_all$EXT" "$PORT/Boot/Press Start/Title (iQue)/BCA0FBD100F2C9A250D35BBDF3D9E3A5$EXT"
cp "_temp/SUPER MARIO 64#A918230E#0#2_all$EXT" "$PORT/Boot/Press Start/Title (iQue)/EBED446B135840B2E50A1862B41E7966$EXT"
cp "_temp/SUPER MARIO 64#16CE5DC5#3#1_all$EXT" "$PORT/Boot/Press Start/39DD097B42DC1960BFF31BB3DD5CA19B$EXT"
cp "_temp/SUPER MARIO 64#D1500155#0#2_all$EXT" "$PORT/Boot/Press Start/5F3752D39C3074F8A0D5F53E4AC80EEF$EXT"

cp "_temp/SUPER MARIO 64#31764A00#0#2_all$EXT" "$PORT/Characters/Amp/1A6E7630EB91E58973E4DD29C25E99B1$EXT"
cp "_temp/SUPER MARIO 64#6F7DF292#0#2_all$EXT" "$PORT/Characters/Amp/F5E32ABF0B9934A821A865E8841803FD$EXT"
cp "_temp/SUPER MARIO 64#86712A04#0#2_all$EXT" "$PORT/Characters/Amp/C24D76EB2EBB4B1BAB82936C548E8996$EXT"
cp "_temp/SUPER MARIO 64#88DC2D34#0#2_all$EXT" "$PORT/Characters/Amp/AA7BDEE77C671CA2C53322AE4864621E$EXT"

cp "_temp/SUPER MARIO 64#292E5FD8#0#2_all$EXT" "$PORT/Characters/Bob-omb/D7A84DDC9D8DF8DC6C1D5B55313EDCCD$EXT"
cp "_temp/SUPER MARIO 64#2ED4BA24#0#2_all$EXT" "$PORT/Characters/Bob-omb/3F70BBC1D3FCA1DFD6CABE11CDB1AD4B$EXT"
cp "_temp/SUPER MARIO 64#35456B51#0#2_all$EXT" "$PORT/Characters/Bob-omb/F21ED876E19B7D906881D64DA0B095A6$EXT"
cp "_temp/SUPER MARIO 64#38894888#0#2_all$EXT" "$PORT/Characters/Bob-omb/F28873A9F9965A25990D377B899E7999$EXT"
cp "_temp/SUPER MARIO 64#585285D7#0#2_all$EXT" "$PORT/Characters/Bob-omb/1230ED70B899B92E61510EEB7297DA62$EXT"
cp "_temp/SUPER MARIO 64#A71D06B9#0#2_all$EXT" "$PORT/Characters/Bob-omb/D39CD23169C30A90D4F50216D6B18892$EXT"

cp "_temp/SUPER MARIO 64#070E836F#0#2_all$EXT" "$PORT/Characters/Boo/2413A328CAF84EE27E2BA3437C180663$EXT"
cp "_temp/SUPER MARIO 64#B11FDC36#0#2_all$EXT" "$PORT/Characters/Boo/E0DA07080C5DEEEEA425BC043241261D$EXT"

cp "_temp/SUPER MARIO 64#37F10A8C#0#2_all$EXT" "$PORT/Characters/Book/9E8A9FA5B298FDD3E17D6095C6D67445$EXT"
cp "_temp/SUPER MARIO 64#3E5AF02C#0#2_all$EXT" "$PORT/Characters/Book/6452640AEA88E42999CB82FAE1350BC1$EXT"
cp "_temp/SUPER MARIO 64#6D083A48#0#2_all$EXT" "$PORT/Characters/Book/995B65353FECA951EDA61070E9728166$EXT"
cp "_temp/SUPER MARIO 64#8073DE72#0#2_all$EXT" "$PORT/Characters/Book/A1344EA35DE2A22D9EDCC9AEDCD69240$EXT"
cp "_temp/SUPER MARIO 64#F6BEEB24#0#2_all$EXT" "$PORT/Characters/Book/AB1532262D5B472BF7C1B43276B92E71$EXT"

cp "_temp/SUPER MARIO 64#2E0C1E02#0#2_all$EXT" "$PORT/Characters/Bowser/D045EDEBC730FE573EC7E9EEFC85F36C$EXT"
cp "_temp/SUPER MARIO 64#374E253A#0#2_all$EXT" "$PORT/Characters/Bowser/8995D280065A50D7E1A9A313EEC0B57D$EXT"
cp "_temp/SUPER MARIO 64#386A9785#0#2_all$EXT" "$PORT/Characters/Bowser/6762C48891818FB1FCF9DD229CA36151$EXT"
cp "_temp/SUPER MARIO 64#39CC9592#0#2_all$EXT" "$PORT/Characters/Bowser/EF9CFE44012FC2BF431F593D9A491F5F$EXT"
cp "_temp/SUPER MARIO 64#514A29BC#0#2_all$EXT" "$PORT/Characters/Bowser/F4E845881A7E381CC6875CA04B7EFDE8$EXT"
cp "_temp/SUPER MARIO 64#55620576#0#2_all$EXT" "$PORT/Characters/Bowser/001137D8667F8FF1D1B5BF4FE54307D8$EXT"
cp "_temp/SUPER MARIO 64#61AFCDD5#0#2_all$EXT" "$PORT/Characters/Bowser/B23EBE1FD25A0B6085F18D67443B1DA6$EXT"
cp "_temp/SUPER MARIO 64#6AF6B17F#0#2_all$EXT" "$PORT/Characters/Bowser/A697531EC7AE80FCFAC8FF71965559E3$EXT"
cp "_temp/SUPER MARIO 64#6B3A40A5#0#2_all$EXT" "$PORT/Characters/Bowser/6E0A0C4444593A9C01476DD031AF5E60$EXT"
cp "_temp/SUPER MARIO 64#6E6A49EF#0#2_all$EXT" "$PORT/Characters/Bowser/6EB2C11BA832EE8325E0F74BCFC07B22$EXT"
cp "_temp/SUPER MARIO 64#7B84A495#0#2_all$EXT" "$PORT/Characters/Bowser/6BAB6CE83BEB2DE8B2F61C0AA62626C7$EXT"
cp "_temp/SUPER MARIO 64#7EB3FE85#0#2_all$EXT" "$PORT/Characters/Bowser/313176BC124C4C1E78EF5911AB411111$EXT"
cp "_temp/SUPER MARIO 64#8D6B1DF6#0#2_all$EXT" "$PORT/Characters/Bowser/9E920E0677C2CABA70F1B2EFE8E8052D$EXT"
cp "_temp/SUPER MARIO 64#9759DCD0#0#2_all$EXT" "$PORT/Characters/Bowser/F5B2FAF8B4D6D6A1F2022743EE78D6E7$EXT"
cp "_temp/SUPER MARIO 64#A0869522#0#2_all$EXT" "$PORT/Characters/Bowser/0DAC93F94AA5C8203C32130C6A6BF326$EXT"
cp "_temp/SUPER MARIO 64#D405BFC1#0#2_all$EXT" "$PORT/Characters/Bowser/6199D1B7F9D8344522BF0D7E4A7AA161$EXT"
cp "_temp/SUPER MARIO 64#D813A5E5#0#2_all$EXT" "$PORT/Characters/Bowser/E76CE4C5001FB9478E3AE67CE85768F0$EXT"
cp "_temp/SUPER MARIO 64#DAD0C429#0#2_all$EXT" "$PORT/Characters/Bowser/2108A08E41A08CFF73DABEA56E1D5C39$EXT"
cp "_temp/SUPER MARIO 64#E351CFF2#0#2_all$EXT" "$PORT/Characters/Bowser/18A678786B602855B682B004B648867A$EXT"
cp "_temp/SUPER MARIO 64#F148AE1E#0#2_all$EXT" "$PORT/Characters/Bowser/0E061C084F12632FBED244758B665AF7$EXT"

cp "_temp/SUPER MARIO 64#2DEC812E#0#2_all$EXT" "$PORT/Characters/Bubba/149CAA8CAFC9CBEA07E59F8E1F5C79B5$EXT"
cp "_temp/SUPER MARIO 64#761B53E2#0#2_all$EXT" "$PORT/Characters/Bubba/816DEAB86C15B1A575A789E9E9C8B9D9$EXT"
cp "_temp/SUPER MARIO 64#A11454A9#0#2_all$EXT" "$PORT/Characters/Bubba/379AA7C1E52776D6D8ED7BE8BFB97198$EXT"
cp "_temp/SUPER MARIO 64#BF952514#0#2_all$EXT" "$PORT/Characters/Bubba/51F483B2A6626AB71996B0A88AAE2262$EXT"
cp "_temp/SUPER MARIO 64#FC53C33B#0#2_all$EXT" "$PORT/Characters/Bubba/5F6B35234161ED05DFF14A471C0D571E$EXT"

cp "_temp/SUPER MARIO 64#03298536#0#2_all$EXT" "$PORT/Characters/Bullet Bill/10DDCC5A5F3EFED69013CB0CAA03FB2A$EXT"
cp "_temp/SUPER MARIO 64#35BBD200#0#2_all$EXT" "$PORT/Characters/Bullet Bill/DBE75E1C12D2789AD13AAA1713004160$EXT"

cp "_temp/SUPER MARIO 64#09CABB08#0#2_all$EXT" "$PORT/Characters/Bully/5907B4C31859388384E9B0C4F7BFEC75$EXT"
cp "_temp/SUPER MARIO 64#21247806#0#2_all$EXT" "$PORT/Characters/Bully/BAB5EB20DB2E42461BC3A7A369CEFB19$EXT"
cp "_temp/SUPER MARIO 64#36D9C81E#0#2_all$EXT" "$PORT/Characters/Bully/AE62D4D146BE26EB4EE09038A0D374DC$EXT"
cp "_temp/SUPER MARIO 64#D35575D6#0#2_all$EXT" "$PORT/Characters/Bully/058815D408135BCE3C60378681B7A764$EXT"

cp "_temp/SUPER MARIO 64#26DFC97D#0#2_all$EXT" "$PORT/Characters/Butterfly/13801E3A6E56328811DED48252A5D285$EXT"

cp "_temp/SUPER MARIO 64#01A60CCD#0#2_all$EXT" "$PORT/Characters/Chain Chomp/4A576A93C1E44F1AA0FAA6F812BDE2D6$EXT"
cp "_temp/SUPER MARIO 64#09740389#0#2_all$EXT" "$PORT/Characters/Chain Chomp/70376B4CFACDE59DA5D6CB32A513472A$EXT"
cp "_temp/SUPER MARIO 64#354089BB#0#2_all$EXT" "$PORT/Characters/Chain Chomp/1DA378378D7E0624AE46462428119DD9$EXT"
cp "_temp/SUPER MARIO 64#8AC74230#0#2_all$EXT" "$PORT/Characters/Chain Chomp/A900DB66EF33B12B86B3E282E986060E$EXT"
cp "_temp/SUPER MARIO 64#B267FDF0#0#2_all$EXT" "$PORT/Characters/Chain Chomp/B8DD224CF78BAA9B674A0FB1869E1D85$EXT"
cp "_temp/SUPER MARIO 64#CB4982B2#0#2_all$EXT" "$PORT/Characters/Chain Chomp/FD972B1875B8BC4E272A24B772812928$EXT"

cp "_temp/SUPER MARIO 64#00866B3F#0#2_all$EXT" "$PORT/Characters/Chilly Chief/B5CD8B07C3B5C6482E412405B683E2E9$EXT"
cp "_temp/SUPER MARIO 64#B4AA0E1C#0#2_all$EXT" "$PORT/Characters/Chilly Chief/6C609C31A8D5632A065D5889081801A1$EXT"

cp "_temp/SUPER MARIO 64#1501AD26#0#2_all$EXT" "$PORT/Characters/Chuckya/E751CE392E96695004522C2CD8C1A243$EXT"
cp "_temp/SUPER MARIO 64#33EA5D90#0#2_all$EXT" "$PORT/Characters/Chuckya/E4B14782E5582BAD4808CD1EDB259F3B$EXT"
cp "_temp/SUPER MARIO 64#7B7A6AD1#0#2_all$EXT" "$PORT/Characters/Chuckya/DB2B2D8314317EEE35B050284588ABC0$EXT"

cp "_temp/SUPER MARIO 64#679A4C71#0#2_all$EXT" "$PORT/Characters/Clam Shell/C7C405B83F376B84AA8FB2B0A70A4E0D$EXT"
cp "_temp/SUPER MARIO 64#F97DC072#0#2_all$EXT" "$PORT/Characters/Clam Shell/0D7560F4470E8AD670182CB626712C45$EXT"

cp "_temp/SUPER MARIO 64#6C902269#0#2_all$EXT" "$PORT/Characters/Dorrie/FD153F4980C841688295E4813E7B065E$EXT"
cp "_temp/SUPER MARIO 64#FD57EA27#0#2_all$EXT" "$PORT/Characters/Dorrie/7E365A3FC27EA82E54E2E08C0D677146$EXT"

cp "_temp/SUPER MARIO 64#2C14636C#0#2_all$EXT" "$PORT/Characters/Eyerok/7CDF5E414A3CCACCD1CB7D4A3B3A30F7$EXT"
cp "_temp/SUPER MARIO 64#761E51A0#0#2_all$EXT" "$PORT/Characters/Eyerok/2E619771378F45DED89941EF531ADFA0$EXT"
cp "_temp/SUPER MARIO 64#93944D54#0#2_all$EXT" "$PORT/Characters/Eyerok/72DFCD5B669AD7A71BFC8D65D08D52D4$EXT"
cp "_temp/SUPER MARIO 64#B9299E61#0#2_all$EXT" "$PORT/Characters/Eyerok/F63BFF0CC5145E2BA86671523B7D65DB$EXT"

cp "_temp/SUPER MARIO 64#2563BF4C#0#2_all$EXT" "$PORT/Characters/Fish/61FDC0C643A8BAF78AA44F4ED84D9136$EXT"
cp "_temp/SUPER MARIO 64#FD9AA14E#0#2_all$EXT" "$PORT/Characters/Fish/6850F7879B7A3790903552B0B544AD85$EXT"

cp "_temp/SUPER MARIO 64#20725250#3#2_all$EXT" "$PORT/Characters/Flyguy/0698CEB1F11D1B242A5206992AF05948$EXT"
cp "_temp/SUPER MARIO 64#923C687E#0#2_all$EXT" "$PORT/Characters/Flyguy/323FE6A36ADC30A83694CD69E2F41614$EXT"
cp "_temp/SUPER MARIO 64#C833EF43#0#2_all$EXT" "$PORT/Characters/Flyguy/305670A14B0C58BBD7ACA00263F936FA$EXT"

cp "_temp/SUPER MARIO 64#384E2A31#0#2_all$EXT" "$PORT/Characters/Goomba/8C7F33B03FB95577ED73BCFE937D6F9E$EXT"
cp "_temp/SUPER MARIO 64#C6A1C158#0#2_all$EXT" "$PORT/Characters/Goomba/EAEDE827A69757200F4FE19EB4CBDF53$EXT"
cp "_temp/SUPER MARIO 64#FD83B121#0#2_all$EXT" "$PORT/Characters/Goomba/9DA640F466CBBD0FCBD83032F791C14E$EXT"

cp "_temp/SUPER MARIO 64#2E1EB8AA#0#2_all$EXT" "$PORT/Characters/Grindel/1683D4388FE063ED0C19D21D1C13EFE3$EXT"
cp "_temp/SUPER MARIO 64#38AFCCEE#0#2_all$EXT" "$PORT/Characters/Grindel/5858E8C9815E1482FA6EE65F9EC678D9$EXT"

cp "_temp/SUPER MARIO 64#0E40FA10#0#2_all$EXT" "$PORT/Characters/Heave Ho/3B32629AE33EF5A4E442141A4BC8EF89$EXT"
cp "_temp/SUPER MARIO 64#3B111D77#0#2_all$EXT" "$PORT/Characters/Heave Ho/09EF53793FDA4B4857704E2B0AF55ED5$EXT"
cp "_temp/SUPER MARIO 64#6C5CC56F#0#2_all$EXT" "$PORT/Characters/Heave Ho/4923E9F0542F2D653954CEAE7AE0C4A5$EXT"
cp "_temp/SUPER MARIO 64#6E489603#0#2_all$EXT" "$PORT/Characters/Heave Ho/C8B42EFAA57E2CE2FD4596323E13F3EB$EXT"
cp "_temp/SUPER MARIO 64#890B9632#0#2_all$EXT" "$PORT/Characters/Heave Ho/3F47610F8D325DF3E2E7A9F05EB8D9A4$EXT"
cp "_temp/SUPER MARIO 64#9B650ED0#0#2_all$EXT" "$PORT/Characters/Heave Ho/F20898F0DF03E630F6919FB7A475AA4E$EXT"

cp "_temp/SUPER MARIO 64#0CE27CD0#0#2_all$EXT" "$PORT/Characters/Hoot/20AA3A3680D93DAA9E5304C27AB14140$EXT"
cp "_temp/SUPER MARIO 64#1F8B71CA#0#2_all$EXT" "$PORT/Characters/Hoot/034D4FC735EE7E47D1615267B39FE2A5$EXT"
cp "_temp/SUPER MARIO 64#9DF33CC7#0#2_all$EXT" "$PORT/Characters/Hoot/6E5CBF175B542B8AEEBDA5636CED64A3$EXT"

cp "_temp/SUPER MARIO 64#2996CA88#0#2_all$EXT" "$PORT/Characters/King Bob-omb/6EC8E59AB98D2EF55199736F8BD26CEA$EXT"
cp "_temp/SUPER MARIO 64#808C10C2#0#2_all$EXT" "$PORT/Characters/King Bob-omb/A9E0D56F5B86DCAA8D4CF00439EA8438$EXT"
cp "_temp/SUPER MARIO 64#886B2FF9#0#2_all$EXT" "$PORT/Characters/King Bob-omb/90C9B6E8B8309F661CE135D47B7D58ED$EXT"
cp "_temp/SUPER MARIO 64#F7844A94#0#2_all$EXT" "$PORT/Characters/King Bob-omb/92F707797DA4555D34145C9F63EC30F2$EXT"

cp "_temp/SUPER MARIO 64#0E7107E3#0#2_all$EXT" "$PORT/Characters/Klepto/DCA90FD9AC9A285820310CFE87E9A2B4$EXT"
cp "_temp/SUPER MARIO 64#6ABEBFF0#0#2_all$EXT" "$PORT/Characters/Klepto/F613D75990588A99C622CCB54A3C3FF9$EXT"
cp "_temp/SUPER MARIO 64#89B90233#0#2_all$EXT" "$PORT/Characters/Klepto/C52E959C8861F074585BA5BF1EA9C5C0$EXT"
cp "_temp/SUPER MARIO 64#90581231#0#2_all$EXT" "$PORT/Characters/Klepto/DDC0F0BB9342B185C59806211D9A145C$EXT"
cp "_temp/SUPER MARIO 64#C3F5C275#0#2_all$EXT" "$PORT/Characters/Klepto/52ACEC5197F5AD36A286BFD808DA647B$EXT"

cp "_temp/SUPER MARIO 64#0D9FD7E4#0#2_all$EXT" "$PORT/Characters/Koopa/486E5D46D651335D9DD6472825F47917$EXT"
cp "_temp/SUPER MARIO 64#29C0C7D2#0#2_all$EXT" "$PORT/Characters/Koopa/D6F938DF9DCB6562D9AB9A77ACFE0AE0$EXT"
cp "_temp/SUPER MARIO 64#3B0D1E46#0#2_all$EXT" "$PORT/Characters/Koopa/6933CC0476A3CA7364AA682E76807713$EXT"
cp "_temp/SUPER MARIO 64#5F035EC5#0#2_all$EXT" "$PORT/Characters/Koopa/72609E868761338E96A88E3D4E0F072D$EXT"
cp "_temp/SUPER MARIO 64#62C94802#0#2_all$EXT" "$PORT/Characters/Koopa/A586186E4F71B0F8724CD054FC4DB462$EXT"
cp "_temp/SUPER MARIO 64#852361B6#0#2_all$EXT" "$PORT/Characters/Koopa/3971E67C3822AC4765B5D80C008AB3E4$EXT"
cp "_temp/SUPER MARIO 64#86FB2F22#0#2_all$EXT" "$PORT/Characters/Koopa/44CF06D700AD5986588AE1914F0B6109$EXT"
cp "_temp/SUPER MARIO 64#CBBC8294#0#2_all$EXT" "$PORT/Characters/Koopa/BA38025ACC1BBE8B56C1B1E25E2130CF$EXT"
cp "_temp/SUPER MARIO 64#D8903B0B#0#2_all$EXT" "$PORT/Characters/Koopa/BEDFE47E8DDDBAE3F5EA2F32ECE04764$EXT"

cp "_temp/SUPER MARIO 64#85C9CDA3#0#2_all$EXT" "$PORT/Characters/Lakitu/unused/A55DFBF8C7E4126F94D229C917A93573$EXT"
cp "_temp/SUPER MARIO 64#0993E63E#0#2_all$EXT" "$PORT/Characters/Lakitu/F464D69DB718E21C10CAA91525CFC5E4$EXT"
cp "_temp/SUPER MARIO 64#5D617EA0#0#2_all$EXT" "$PORT/Characters/Lakitu/D736CFC6CBAE86256D80E79638B61B09$EXT"
cp "_temp/SUPER MARIO 64#77290EB2#0#2_all$EXT" "$PORT/Characters/Lakitu/7E070DC9BC8883415AEDEC7AC867D728$EXT"
cp "_temp/SUPER MARIO 64#7CE8869D#3#2_all$EXT" "$PORT/Characters/Lakitu/E5FC91D2CCB13FAAEC8B65E1F6144152$EXT"
cp "_temp/SUPER MARIO 64#DB6C3044#0#2_all$EXT" "$PORT/Characters/Lakitu/BCD6966EAB9E22C91AD8947E662F51C0$EXT"
cp "_temp/SUPER MARIO 64#EAA27132#0#2_all$EXT" "$PORT/Characters/Lakitu/FEEF35E84447DEE9ECE63106449BA1E2$EXT"

cp "_temp/SUPER MARIO 64#8213677C#0#2_all$EXT" "$PORT/Characters/Mad Piano/9F316AFE97A5384252F95C87A6A40B55$EXT"
cp "_temp/SUPER MARIO 64#A3C0D76F#0#2_all$EXT" "$PORT/Characters/Mad Piano/D8154733D1DDCD863E5A904F1D4CC59E$EXT"
cp "_temp/SUPER MARIO 64#C9A1F57E#0#2_all$EXT" "$PORT/Characters/Mad Piano/761C0906B0B4004C3ADFF2E00AE6AB4E$EXT"
cp "_temp/SUPER MARIO 64#FB38796A#0#2_all$EXT" "$PORT/Characters/Mad Piano/72EE60C24A4459177A16EAAE1C59277E$EXT"
cp "_temp/SUPER MARIO 64#FD6AF08F#0#2_all$EXT" "$PORT/Characters/Mad Piano/7EC3464E4D4FDBC71C20328CBE418513$EXT"

cp "_temp/SUPER MARIO 64#1203BAA7#0#2_all$EXT" "$PORT/Characters/Manta Ray/B90129BFF58881DFFC7EAFCD6DA8652B$EXT"
cp "_temp/SUPER MARIO 64#8C1EBB7F#0#2_all$EXT" "$PORT/Characters/Manta Ray/EECB46A7915D765996B5CBE71D5057A8$EXT"
cp "_temp/SUPER MARIO 64#9B42ABEA#0#2_all$EXT" "$PORT/Characters/Manta Ray/C06A57E77EC626916003CA37F071CD51$EXT"
cp "_temp/SUPER MARIO 64#D2EBC589#0#2_all$EXT" "$PORT/Characters/Manta Ray/160F6B490C7B90572C629C7424E0776C$EXT"

cp "_temp/SUPER MARIO 64#BFA0470C#0#2_all$EXT" "$PORT/Characters/Mario/unused/F44327905C7D7250DB3BF415E9CD44A8$EXT"
cp "_temp/SUPER MARIO 64#5F995294#0#2_all$EXT" "$PORT/Characters/Mario/unused/9E937CEC65F0DDD47B4D214C81BF658C$EXT"
cp "_temp/SUPER MARIO 64#17C50CF2#0#2_all$EXT" "$PORT/Characters/Mario/0A4DF8E183933189EE2A9E959DE003C5$EXT"
cp "_temp/SUPER MARIO 64#19442FC9#0#2_all$EXT" "$PORT/Characters/Mario/C9308BE6241F29DF98AA7506733DD19E$EXT"
cp "_temp/SUPER MARIO 64#28964B59#0#2_all$EXT" "$PORT/Characters/Mario/AC34F92E6122EDF74A5AD9FD162A1353$EXT"
cp "_temp/SUPER MARIO 64#2BEA0A29#0#2_all$EXT" "$PORT/Characters/Mario/B7F3C3854385862FB4FE5F4F666BF710$EXT"
cp "_temp/SUPER MARIO 64#387D6D33#0#2_all$EXT" "$PORT/Characters/Mario/3E5A5849DF361A35CCD5D20FF5C85BC3$EXT"
cp "_temp/SUPER MARIO 64#5D6B0678#0#2_all$EXT" "$PORT/Characters/Mario/BC64A1744FF5AFAAF3A4EDFD75138131$EXT"
cp "_temp/SUPER MARIO 64#6B8D43C4#0#2_all$EXT" "$PORT/Characters/Mario/D00F2C0F7DD3D0C2CB88F9BCA54ACFBB$EXT"
cp "_temp/SUPER MARIO 64#905D3214#0#2_all$EXT" "$PORT/Characters/Mario/2BF8629E4F893B9F2C5E2237A273F076$EXT"
cp "_temp/SUPER MARIO 64#9FBECEF9#0#2_all$EXT" "$PORT/Characters/Mario/823605D8D2651E20BAD3D55975F1E0AD$EXT"
cp "_temp/SUPER MARIO 64#E9FCBF74#0#2_all$EXT" "$PORT/Characters/Mario/C11ABD52FD83AB20B47E43BB28AD97A7$EXT"

cp "_temp/SUPER MARIO 64#4944D2C9#0#2_all$EXT" "$PORT/Characters/Mips/9D179A637ED5C982EC2A4011ED99F142$EXT"

cp "_temp/SUPER MARIO 64#968EC1C4#0#2_all$EXT" "$PORT/Characters/Moneybag/640778B7B06D70E78346FFBF96586519$EXT"
cp "_temp/SUPER MARIO 64#E3548182#0#2_all$EXT" "$PORT/Characters/Moneybag/92EE9711B874A414C4D23C772A87D871$EXT"

cp "_temp/SUPER MARIO 64#04A6FFC8#0#2_all$EXT" "$PORT/Characters/Monty Mole/FC699F986FE14B5AC55DFA9ADCE362BA$EXT"
cp "_temp/SUPER MARIO 64#06343AFC#0#2_all$EXT" "$PORT/Characters/Monty Mole/4681454950FB36FDD438009B15DB3BE8$EXT"
cp "_temp/SUPER MARIO 64#21F3A705#0#2_all$EXT" "$PORT/Characters/Monty Mole/3C3233E01ACE456B07BF4CF7F5076AE2$EXT"
cp "_temp/SUPER MARIO 64#3902D1B8#0#2_all$EXT" "$PORT/Characters/Monty Mole/371D8F89385A26CABD6E23F44B7E7217$EXT"
cp "_temp/SUPER MARIO 64#81B554A7#3#2_all$EXT" "$PORT/Characters/Monty Mole/A0C18C79F995F40923512352232B8CCF$EXT"
cp "_temp/SUPER MARIO 64#D6096833#0#2_all$EXT" "$PORT/Characters/Monty Mole/D6B4D788808D3D6E44E76A12D3DDFD92$EXT"

cp "_temp/SUPER MARIO 64#2395DA7B#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/EA9B080F084DEC300C67EE8D8E3EDF7C$EXT"
cp "_temp/SUPER MARIO 64#5B8676CF#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/871FB7766D09DDF7627D421BCDAD27EB$EXT"
cp "_temp/SUPER MARIO 64#6A4BEF91#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/2FFB53B2A8122082897C1AE6897C6323$EXT"
cp "_temp/SUPER MARIO 64#88C0CCF9#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/314D582C80ECD71DBBD1D52E6570E504$EXT"
cp "_temp/SUPER MARIO 64#9D15E307#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/6EF14FC6A39CC8AA6BCB52CD7F0B6088$EXT"
cp "_temp/SUPER MARIO 64#E48F835F#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/6DCC9A98B79357F544DD77701FFD6A25$EXT"
cp "_temp/SUPER MARIO 64#E52EE127#0#2_all$EXT" "$PORT/Characters/Mr. Blizzard/0D855427488B9A84C86C9528CACDD162$EXT"

cp "_temp/SUPER MARIO 64#02CFD740#0#2_all$EXT" "$PORT/Characters/Mr. I/9AAB68FF20196DDC2C6C4A2392FA90B6$EXT"
cp "_temp/SUPER MARIO 64#2A93AFC0#0#2_all$EXT" "$PORT/Characters/Mr. I/56255DF7094C25E74D5A027D9E77A248$EXT"
cp "_temp/SUPER MARIO 64#5CC4BED3#0#2_all$EXT" "$PORT/Characters/Mr. I/D4D66C045688B01EF300518E2C54913F$EXT"
cp "_temp/SUPER MARIO 64#5DFA73AC#0#2_all$EXT" "$PORT/Characters/Mr. I/981A8FFCB661F795360E7FA65C925E20$EXT"
cp "_temp/SUPER MARIO 64#78A6DB75#0#2_all$EXT" "$PORT/Characters/Mr. I/83B0F2561AFB735342AB6C2A540278FF$EXT"
cp "_temp/SUPER MARIO 64#87786913#0#2_all$EXT" "$PORT/Characters/Mr. I/1C6141F8EE68698BE4430B98483F9643$EXT"
cp "_temp/SUPER MARIO 64#A833E954#0#2_all$EXT" "$PORT/Characters/Mr. I/D8DF68730881B656D6864E8765AAFFEC$EXT"

cp "_temp/SUPER MARIO 64#064B5C5F#0#2_all$EXT" "$PORT/Characters/Peach/Letter/AB1BBFA6E6E212222D91B2FD30915FFA$EXT"
cp "_temp/SUPER MARIO 64#AC05A9FF#3#1_all$EXT" "$PORT/Characters/Peach/Letter/27882FA1E6E8219A5C333A53FED43ABA$EXT"
cp "_temp/SUPER MARIO 64#C4845A3E#0#2_all$EXT" "$PORT/Characters/Peach/Letter/43A65160A6309421FE93364CB008C7AE$EXT"
cp "_temp/SUPER MARIO 64#03DAF3D5#0#2_all$EXT" "$PORT/Characters/Peach/E15C61B2C7C1FCC1D59A2C9027B07868$EXT"
cp "_temp/SUPER MARIO 64#4FE1A0ED#0#2_all$EXT" "$PORT/Characters/Peach/D474013E91A8AA1FCA349AFB699D94EB$EXT"
cp "_temp/SUPER MARIO 64#723EDCD4#0#2_all$EXT" "$PORT/Characters/Peach/9BFF7D6D8EFE43C005C78755B1986C51$EXT"
cp "_temp/SUPER MARIO 64#7B8E4AC2#0#2_all$EXT" "$PORT/Characters/Peach/D3243D853E28320F594AA62086E851A7$EXT"
cp "_temp/SUPER MARIO 64#7E216E16#0#2_all$EXT" "$PORT/Characters/Peach/6464CC17D7138255AA9BB3D7E9E814C8$EXT"
cp "_temp/SUPER MARIO 64#B7C60055#0#2_all$EXT" "$PORT/Characters/Peach/669F89A434B461FF75A8C0266834133B$EXT"
cp "_temp/SUPER MARIO 64#CC4FE796#0#2_all$EXT" "$PORT/Characters/Peach/B82A2133D6E2FB61E4C04A13B8307479$EXT"
cp "_temp/SUPER MARIO 64#DBF4274C#0#2_all$EXT" "$PORT/Characters/Peach/D7145856A690AFE087E45E2D4DBD35B4$EXT"
cp "_temp/SUPER MARIO 64#ECACF737#0#2_all$EXT" "$PORT/Characters/Peach/A8B7FA1DD00FCD1FB4FD6E160A39C1F6$EXT"
cp "_temp/SUPER MARIO 64#F8775564#0#2_all$EXT" "$PORT/Characters/Peach/6B860A6B4EDE119C2430F1823529CC33$EXT"

cp "_temp/SUPER MARIO 64#6D8F004D#0#2_all$EXT" "$PORT/Characters/Penguin/unused/CD8732F27264D2D4E6E13B8CFDBCDB4C$EXT"
cp "_temp/SUPER MARIO 64#180BDE92#0#2_all$EXT" "$PORT/Characters/Penguin/4015D1C51B9BBBB23C820B67E9C17002$EXT"
cp "_temp/SUPER MARIO 64#578AA0E9#0#2_all$EXT" "$PORT/Characters/Penguin/4CC3E47AA26E3ACC1275464943A418B7$EXT"
cp "_temp/SUPER MARIO 64#6C131FEF#0#2_all$EXT" "$PORT/Characters/Penguin/D503DF90374D1ACC9AE8E6F94922FB51$EXT"
cp "_temp/SUPER MARIO 64#78B59E82#0#2_all$EXT" "$PORT/Characters/Penguin/896340072CD0EB6BF5F51C1B1EEA27E3$EXT"
cp "_temp/SUPER MARIO 64#B2DBCCAE#0#2_all$EXT" "$PORT/Characters/Penguin/0F89F833448DD71AA0A18F866F5F529C$EXT"

cp "_temp/SUPER MARIO 64#29F15A68#0#2_all$EXT" "$PORT/Characters/Piranha Plant/A05DE2CE05AAFC53572FD9F7B8F0C47E$EXT"
cp "_temp/SUPER MARIO 64#373DF028#0#2_all$EXT" "$PORT/Characters/Piranha Plant/3814B6C167405FCE59C74F09CB907C79$EXT"
cp "_temp/SUPER MARIO 64#5AEA7079#0#2_all$EXT" "$PORT/Characters/Piranha Plant/8EB105777886CD09E384DDDF30539A07$EXT"
cp "_temp/SUPER MARIO 64#5BC5CA75#0#2_all$EXT" "$PORT/Characters/Piranha Plant/165933DE51BDBD5A718FB106BBCAE0EB$EXT"
cp "_temp/SUPER MARIO 64#85887EE4#0#2_all$EXT" "$PORT/Characters/Piranha Plant/C0B6FCE6E5D7FF158D26F1F8DF22A311$EXT"
cp "_temp/SUPER MARIO 64#C20FC383#0#2_all$EXT" "$PORT/Characters/Piranha Plant/0B7F18961C5875FD5764E4C4E92ACFC1$EXT"
cp "_temp/SUPER MARIO 64#F66CA88B#0#2_all$EXT" "$PORT/Characters/Piranha Plant/6A0B81E6BF838AF5076DBD411941D649$EXT"

cp "_temp/SUPER MARIO 64#2F25120F#0#2_all$EXT" "$PORT/Characters/Pokey/7A3B8CA4C67F91A71171303173C4F635$EXT"
cp "_temp/SUPER MARIO 64#36B1482F#0#2_all$EXT" "$PORT/Characters/Pokey/93F12AB9E834136F63FEA84F9621088B$EXT"
cp "_temp/SUPER MARIO 64#B8A77D4D#0#2_all$EXT" "$PORT/Characters/Pokey/163920373EC0D705ED62E96E8D3330B0$EXT"

cp "_temp/SUPER MARIO 64#349B3BBD#0#2_all$EXT" "$PORT/Characters/Scuttlebug/8AE70EFC6382CC29BA6C6B76BE723FB3$EXT"
cp "_temp/SUPER MARIO 64#55DA5D92#0#2_all$EXT" "$PORT/Characters/Scuttlebug/DB240F435F9F32C3971EE85E2BD46BCD$EXT"
cp "_temp/SUPER MARIO 64#822FF6DF#0#2_all$EXT" "$PORT/Characters/Scuttlebug/46D89D19DD0D53A898F87FDC37C31247$EXT"
cp "_temp/SUPER MARIO 64#C540C44C#0#2_all$EXT" "$PORT/Characters/Scuttlebug/062BD809D20519E0F1425F5B6947A286$EXT"
cp "_temp/SUPER MARIO 64#E6919896#0#2_all$EXT" "$PORT/Characters/Scuttlebug/AC9CCC7426F6DD2CBB68DBA4757F5DA6$EXT"

cp "_temp/SUPER MARIO 64#6AC8D5D1#0#2_all$EXT" "$PORT/Characters/Skeeter/358E65395430391CE67EDCE1690F781E$EXT"
cp "_temp/SUPER MARIO 64#A6469110#0#2_all$EXT" "$PORT/Characters/Skeeter/8BB980C13909FAE15977F4ADCC449ADB$EXT"

cp "_temp/SUPER MARIO 64#1F4CDAB4#0#2_all$EXT" "$PORT/Characters/Snufit/5B4EB67BC129006D6282FAAB19127BFB$EXT"
cp "_temp/SUPER MARIO 64#458C0935#0#2_all$EXT" "$PORT/Characters/Snufit/FD07296FA9E5FA834E7E645CFE49AFCF$EXT"
cp "_temp/SUPER MARIO 64#6BCC2E51#0#2_all$EXT" "$PORT/Characters/Snufit/D9011AC9F56611DCF050F10DC9E2158B$EXT"
cp "_temp/SUPER MARIO 64#FACEA23F#0#2_all$EXT" "$PORT/Characters/Snufit/3327DBEEDC6D8F6FE5D5D0BA160EE6D6$EXT"

cp "_temp/SUPER MARIO 64#0F8EBA38#0#2_all$EXT" "$PORT/Characters/Spindrift/4C703E945565AF6EABDA474006B1D961$EXT"
cp "_temp/SUPER MARIO 64#13207BBB#0#2_all$EXT" "$PORT/Characters/Spindrift/45F857F2513173435C90C0DEE625C4C0$EXT"
cp "_temp/SUPER MARIO 64#9DC7C1E8#0#2_all$EXT" "$PORT/Characters/Spindrift/12443B63374DB9C0F0560D553FBACD8D$EXT"
cp "_temp/SUPER MARIO 64#DCD89861#0#2_all$EXT" "$PORT/Characters/Spindrift/578AA3572EDC670A42433E757BC7D3F9$EXT"

cp "_temp/SUPER MARIO 64#0010FDC4#0#2_all$EXT" "$PORT/Characters/Sushi/520AB15CEBD476C17B2A011661865D87$EXT"
cp "_temp/SUPER MARIO 64#D4178125#0#2_all$EXT" "$PORT/Characters/Sushi/F6BE00131E50DCA0C3D3E3CADB5E48D0$EXT"
cp "_temp/SUPER MARIO 64#E127CEDD#0#2_all$EXT" "$PORT/Characters/Sushi/FADF1D31FA7078986D6BA89DA5A45C7D$EXT"

cp "_temp/SUPER MARIO 64#629A458D#0#2_all$EXT" "$PORT/Characters/Swoop/C985210D47385DD7F0A81FFB807714C2$EXT"
cp "_temp/SUPER MARIO 64#D220AA57#0#2_all$EXT" "$PORT/Characters/Swoop/38875C78557AF1F5C165C3E8A8615DD6$EXT"
cp "_temp/SUPER MARIO 64#DF2A6551#0#2_all$EXT" "$PORT/Characters/Swoop/90FD3A8714365835F80DBC62A91A2FC3$EXT"
cp "_temp/SUPER MARIO 64#F399A4E9#0#2_all$EXT" "$PORT/Characters/Swoop/B0A474810E8D4CF27226361C6532B0B6$EXT"

cp "_temp/SUPER MARIO 64#17CDE57D#0#2_all$EXT" "$PORT/Characters/Thwomp/490684226340F46C05924006087EA273$EXT"
cp "_temp/SUPER MARIO 64#39D86D67#0#2_all$EXT" "$PORT/Characters/Thwomp/3A4B16DB2FCAD789F04FCF4B11E49EFB$EXT"

cp "_temp/SUPER MARIO 64#383BBD9B#0#2_all$EXT" "$PORT/Characters/Toad/DB6460C10037C73F67407EBEC67D4C68$EXT"
cp "_temp/SUPER MARIO 64#39F5A629#0#2_all$EXT" "$PORT/Characters/Toad/4B51AF4B7EA121F103971626D6E67309$EXT"

cp "_temp/SUPER MARIO 64#31C66E6F#0#2_all$EXT" "$PORT/Characters/Ukiki/50A8E280F9E95AC3F584980AE9DF3C85$EXT"
cp "_temp/SUPER MARIO 64#49F74EB1#0#2_all$EXT" "$PORT/Characters/Ukiki/944933C16ECD73BD1790A7D847889A23$EXT"
cp "_temp/SUPER MARIO 64#EA6F033E#0#2_all$EXT" "$PORT/Characters/Ukiki/025A59DE9219B9D243FF56426ABB9001$EXT"

cp "_temp/SUPER MARIO 64#59BBF047#0#2_all$EXT" "$PORT/Characters/Unagi/AF21655FBF189E532DDF18933972ED86$EXT"
cp "_temp/SUPER MARIO 64#6D6C38E3#0#2_all$EXT" "$PORT/Characters/Unagi/6E05A8C289EA21D190BE96D4D4F89A85$EXT"
cp "_temp/SUPER MARIO 64#AD35A744#0#2_all$EXT" "$PORT/Characters/Unagi/01C20D8C4B08271FB594E2D983024068$EXT"
cp "_temp/SUPER MARIO 64#DB1CF863#0#2_all$EXT" "$PORT/Characters/Unagi/61E17CF69A1BADEED25AD88BB70BD036$EXT"
cp "_temp/SUPER MARIO 64#EDBBE3D1#0#2_all$EXT" "$PORT/Characters/Unagi/6A4CD0AC376247733E770B304366B27B$EXT"
cp "_temp/SUPER MARIO 64#F0729E14#0#2_all$EXT" "$PORT/Characters/Unagi/537FECE749F8C04B2499115C6101E163$EXT"

cp "_temp/SUPER MARIO 64#4DEDBC41#0#2_all$EXT" "$PORT/Characters/Whomp/BC591FD9CD3398EB4A8BF06FE14A0C69$EXT"
cp "_temp/SUPER MARIO 64#6695E997#0#2_all$EXT" "$PORT/Characters/Whomp/56CA8BA82D59B3CE4027388B534CDB64$EXT"
cp "_temp/SUPER MARIO 64#8464CC0C#0#2_all$EXT" "$PORT/Characters/Whomp/AB108BBA59E83E6727DECFAAB107C8E2$EXT"
cp "_temp/SUPER MARIO 64#D42E66E7#0#2_all$EXT" "$PORT/Characters/Whomp/D729408FB7175E499F398AB5FE633447$EXT"

cp "_temp/SUPER MARIO 64#0E9C4E15#0#2_all$EXT" "$PORT/Characters/Wiggler/03A9013118709E4057AFE3FB4E90C465$EXT"
cp "_temp/SUPER MARIO 64#3411743E#0#2_all$EXT" "$PORT/Characters/Wiggler/0161BD8121044F809734FEA4FF44A5DD$EXT"
cp "_temp/SUPER MARIO 64#3867CBEE#0#2_all$EXT" "$PORT/Characters/Wiggler/B2429D401B292033DB83E9B615A533BD$EXT"
cp "_temp/SUPER MARIO 64#4E43931B#0#2_all$EXT" "$PORT/Characters/Wiggler/7B6BA37A81BDE34DBEB2F8132A305E15$EXT"
cp "_temp/SUPER MARIO 64#52FEDEB7#0#2_all$EXT" "$PORT/Characters/Wiggler/B6A09B56236ED75B44FC58EBE9F01507$EXT"
cp "_temp/SUPER MARIO 64#A2F30414#0#2_all$EXT" "$PORT/Characters/Wiggler/CDFF4A01BF944EA8DBB6962B0842ABBE$EXT"

cp "_temp/SUPER MARIO 64#0AB43F69#0#2_all$EXT" "$PORT/Characters/Yoshi/5854CF2FA3214F0465CE0E8C81482E54$EXT"
cp "_temp/SUPER MARIO 64#17060726#0#2_all$EXT" "$PORT/Characters/Yoshi/52D87DB40207F18094DB438832F71659$EXT"
cp "_temp/SUPER MARIO 64#506D1A26#0#2_all$EXT" "$PORT/Characters/Yoshi/84DD58E10517B047C3606A1FF669DB28$EXT"

cp "_temp/SUPER MARIO 64#41FDBC76#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/00/620F0B67A91F7F74151BC5BE745B7110$EXT"
cp "_temp/SUPER MARIO 64#6ED6659F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/00/E24D195A2EE77CDB7FFDB900FCF30D3D$EXT"
cp "_temp/SUPER MARIO 64#D12D02E4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/01/C6376710F1A0DC51E631FA7A5ECC2370$EXT"
cp "_temp/SUPER MARIO 64#DB8655FD#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/01/7C73407581B7C87AAAAA1AB141415E58$EXT"
cp "_temp/SUPER MARIO 64#5D54105C#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/02/266185B776B335AD3E69F344F6829FB9$EXT"
cp "_temp/SUPER MARIO 64#F5D23B55#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/02/591D01FB363ECD8525519E11D7130DED$EXT"
cp "_temp/SUPER MARIO 64#838795F8#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/03/1F6E974C415034AF2739394D155F75E1$EXT"
cp "_temp/SUPER MARIO 64#B8B08A8F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/03/6511095919D90D940137A5246EF7551B$EXT"
cp "_temp/SUPER MARIO 64#29636778#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/04/3B14F10C4AFAD29B962D34085B5EBD87$EXT"
cp "_temp/SUPER MARIO 64#E280555D#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/04/D7BC7495BF4ABFFCCC38EF15C4FB7F8B$EXT"
cp "_temp/SUPER MARIO 64#4A7E7508#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/05/E615BBAA932F2316CB5070F0CF125F9B$EXT"
cp "_temp/SUPER MARIO 64#B534B831#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/05/A46BC6A8F2F5F8252F4E7DFC8F15C916$EXT"
cp "_temp/SUPER MARIO 64#523F2F3F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/06/5A2B629D5014AD552B35FD28F7E45822$EXT"
cp "_temp/SUPER MARIO 64#897D9B14#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/06/E3A886F856ACBA0D0B78ADCE449C36EA$EXT"
cp "_temp/SUPER MARIO 64#03249A62#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/07/C28DFB31F394D9A835E7ECC1012A3E95$EXT"
cp "_temp/SUPER MARIO 64#61EC3940#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/07/507E3DE0AC8EBDC9E111D17A6FABDC05$EXT"
cp "_temp/SUPER MARIO 64#871045E4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/08/62C0553AF520CBCFD4EAC61BFE02FBC5$EXT"
cp "_temp/SUPER MARIO 64#0ED8D758#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/08/5E1DF112931412E90059648104DD79B2$EXT"
cp "_temp/SUPER MARIO 64#5FD6CCEC#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/09/3FA8FE9B9A94D6CADB7A8FD7BD641684$EXT"
cp "_temp/SUPER MARIO 64#A46186FA#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/09/CFEBFB2F971CA33713031BBD01F344D0$EXT"
cp "_temp/SUPER MARIO 64#63F46B6E#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/10/ED99B207092608A196A0EA905938F637$EXT"
cp "_temp/SUPER MARIO 64#FD1AA928#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/10/2086ABD77F54BFF769B5CDD80EE2B88B$EXT"
cp "_temp/SUPER MARIO 64#095FC27A#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/11/A9029141488E3ADDEF4B80FFFA4F59AC$EXT"
cp "_temp/SUPER MARIO 64#54E749EC#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/11/D4BA0E6F7D2B26DB4D9E157258420CF1$EXT"
cp "_temp/SUPER MARIO 64#7473E7A4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/12/7ECC2DDD6AC19EC96EF337FA8277E91E$EXT"
cp "_temp/SUPER MARIO 64#B853043B#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/12/9F2C2A91506BBB7EA1389DA9E05396BF$EXT"
cp "_temp/SUPER MARIO 64#5E9F5DF4#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/13/88367756BD5BCA938FE0347F2B898A5A$EXT"
cp "_temp/SUPER MARIO 64#A4F69A2F#0#2_all$EXT" "$PORT/Effects/Bowser Explosion/13/C07023BBE3FA41F35E7836E716E10481$EXT"
cp "_temp/SUPER MARIO 64#1E263631#3#2_all$EXT" "$PORT/Effects/Bowser Explosion/6DFB8E3834A3C66F12841AFB998B7BDC$EXT"
cp "_temp/SUPER MARIO 64#D333CC90#3#2_all$EXT" "$PORT/Effects/Bowser Explosion/F5C83726EDA3CE3ECC41B7C8838BAA51$EXT"

cp "_temp/SUPER MARIO 64#4A5830AD#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/1315138A9AE1545CA93886E3F271E850$EXT"
cp "_temp/SUPER MARIO 64#54FAC607#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/F3CFC85E94041C49D337613F97F57C9A$EXT"
cp "_temp/SUPER MARIO 64#6A32A053#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/C6BED96FC58836ABCC9CC2EDE929A520$EXT"
cp "_temp/SUPER MARIO 64#CB509D6A#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/E2D488F6C1C3F29CC50E6FFB65D7084D$EXT"
cp "_temp/SUPER MARIO 64#DCC12774#0#2_all$EXT" "$PORT/Effects/Bubbles and Particles/1A1608394F8680BA9CA7A704B3C21E12$EXT"

cp "_temp/SUPER MARIO 64#D3A287BB#0#2_all$EXT" "$PORT/Effects/Burn Smoke/4F8CD13AABEE51E0F39F4A53A486DD42$EXT"

cp "_temp/SUPER MARIO 64#0B6D2926#0#2_all$EXT" "$PORT/Effects/Explosion/78BD95B86FA66895340CE2570F6154D7$EXT"
cp "_temp/SUPER MARIO 64#166DD880#0#2_all$EXT" "$PORT/Effects/Explosion/69B7548DD90226965706806B86646A2B$EXT"
cp "_temp/SUPER MARIO 64#1872FA6C#0#2_all$EXT" "$PORT/Effects/Explosion/70BBE31D07373CEED695F72E77B6D930$EXT"
cp "_temp/SUPER MARIO 64#1E834EB0#0#2_all$EXT" "$PORT/Effects/Explosion/3B1212D793EAE0856D167813FCC019DD$EXT"
cp "_temp/SUPER MARIO 64#42A20F7E#0#2_all$EXT" "$PORT/Effects/Explosion/5B97D24E4031E88CE39E1609EB1AD143$EXT"
cp "_temp/SUPER MARIO 64#B596CB90#0#2_all$EXT" "$PORT/Effects/Explosion/5C31C26E9502CF1F24F9C320BEF868C8$EXT"
cp "_temp/SUPER MARIO 64#FA421C73#0#2_all$EXT" "$PORT/Effects/Explosion/7B2B8F09D9B04EFED6CFA626F188751D$EXT"

cp "_temp/SUPER MARIO 64#1AE70860#3#2_all$EXT" "$PORT/Effects/Flame/03223E1044B90BFB3046C44EEA6D37EE$EXT"
cp "_temp/SUPER MARIO 64#28DF6C96#3#2_all$EXT" "$PORT/Effects/Flame/08E92EA4F9C6416B68A29AA6A8639415$EXT"
cp "_temp/SUPER MARIO 64#4C6EDE9F#3#2_all$EXT" "$PORT/Effects/Flame/C72DC0AEDC8C7DA1B30634F4BE71F32B$EXT"
cp "_temp/SUPER MARIO 64#617BFB7B#3#2_all$EXT" "$PORT/Effects/Flame/C5CC58EAB04E5257D87B5B8D271FBD92$EXT"
cp "_temp/SUPER MARIO 64#67AD777B#3#2_all$EXT" "$PORT/Effects/Flame/9C93EFA730E67ED68DBDF516019A0F33$EXT"
cp "_temp/SUPER MARIO 64#A4841A07#3#2_all$EXT" "$PORT/Effects/Flame/FDF0975AFC63F2C76125F4A95A8808BA$EXT"
cp "_temp/SUPER MARIO 64#DB4164D7#3#2_all$EXT" "$PORT/Effects/Flame/389955496722ECA31623EF4D37AF294A$EXT"
cp "_temp/SUPER MARIO 64#F0B319A6#3#2_all$EXT" "$PORT/Effects/Flame/B186F0943A22F84F937FB4E036AFA33B$EXT"

cp "_temp/SUPER MARIO 64#5D987F11#0#2_all$EXT" "$PORT/Effects/Flower (unused)/7292D0F1C490EA116A4CD404190B98DE$EXT"
cp "_temp/SUPER MARIO 64#7B2F0CE2#0#2_all$EXT" "$PORT/Effects/Flower (unused)/38F478C2943B20B8EC0577D7F3AE2D0C$EXT"
cp "_temp/SUPER MARIO 64#77C14ADF#0#2_all$EXT" "$PORT/Effects/Flower (unused)/E390C4A0BB4B27F5DFBE46D15820CD42$EXT"
cp "_temp/SUPER MARIO 64#8A94A19F#0#2_all$EXT" "$PORT/Effects/Flower (unused)/18EFC90F9340970BE9FF3ABC8FEB6458$EXT"

cp "_temp/SUPER MARIO 64#20655B3C#3#2_all$EXT" "$PORT/Effects/Impact Ring/1D936F37BE3C8CEDB5D71127C1836846$EXT"
cp "_temp/SUPER MARIO 64#3CF309E4#3#2_all$EXT" "$PORT/Effects/Impact Ring/0DF9DAADB8AE96FD994208C8423489CE$EXT"

cp "_temp/SUPER MARIO 64#85AEF726#0#2_all$EXT" "$PORT/Effects/Lava Bubble/unused/A35D1D89FADAD9039AD613620C0E06F5$EXT"
cp "_temp/SUPER MARIO 64#044F24EF#0#2_all$EXT" "$PORT/Effects/Lava Bubble/C965AD66ABDA2D9DD5319222DF2BD7D2$EXT"
cp "_temp/SUPER MARIO 64#55E07C1C#0#2_all$EXT" "$PORT/Effects/Lava Bubble/9757307705DDEEA6854E19CB06992198$EXT"
cp "_temp/SUPER MARIO 64#7378A96F#0#2_all$EXT" "$PORT/Effects/Lava Bubble/12650C0BB4C14967B01B29ED0C6C9537$EXT"
cp "_temp/SUPER MARIO 64#D2A5D574#0#2_all$EXT" "$PORT/Effects/Lava Bubble/F5D1F5506F841BB855639E3DDF97A1B6$EXT"
cp "_temp/SUPER MARIO 64#DDE47B60#0#2_all$EXT" "$PORT/Effects/Lava Bubble/31656C2959320B8879C1B20C5CC91282$EXT"
cp "_temp/SUPER MARIO 64#F91048ED#0#2_all$EXT" "$PORT/Effects/Lava Bubble/F5DA607125CE6695140F0562CC09CA7C$EXT"
cp "_temp/SUPER MARIO 64#FF50BD43#0#2_all$EXT" "$PORT/Effects/Lava Bubble/01351B4C7BAAFA8481D4612F56BF100D$EXT"

cp "_temp/SUPER MARIO 64#F0A134BD#3#2_all$EXT" "$PORT/Effects/Light/Big Boo's Haunt/39E1CAA78AB7601ABD4A46C8C0DD10BF$EXT"
cp "_temp/SUPER MARIO 64#19E8F076#3#2_all$EXT" "$PORT/Effects/Light/428E59A70CD9A18E1FF13BE0DEFDBDAC$EXT"
cp "_temp/SUPER MARIO 64#2EB2480C#3#2_all$EXT" "$PORT/Effects/Light/F6DC0DB81A2BFC0A22DD871B00EFF21F$EXT"
cp "_temp/SUPER MARIO 64#3BAC2B9A#3#2_all$EXT" "$PORT/Effects/Light/507CCB7202178AC7F866C6A97244A25A$EXT"
cp "_temp/SUPER MARIO 64#65542036#3#2_all$EXT" "$PORT/Effects/Light/85D1A4544EAC3BE3B9AC7011B0BE3A71$EXT"
cp "_temp/SUPER MARIO 64#6C3CE89F#3#2_all$EXT" "$PORT/Effects/Light/B1A384676EA14DE31AAE10E4BADDEFAF$EXT"

cp "_temp/SUPER MARIO 64#184368CA#0#2_all$EXT" "$PORT/Effects/Metal/6FFBE5EC4841E921FB688C0F26FED48C$EXT"
cp "_temp/SUPER MARIO 64#432D56BE#0#2_all$EXT" "$PORT/Effects/Metal/455F45F507F4CF8F67162FF400DD0490$EXT"

cp "_temp/SUPER MARIO 64#CD2A5787#0#2_all$EXT" "$PORT/Effects/Particles/1A17E68AF5FDB51E45AA8CA2F4BF9D9D$EXT"
cp "_temp/SUPER MARIO 64#F21F608E#0#2_all$EXT" "$PORT/Effects/Particles/C3101F03C948A8C7EB5D2388C344923F$EXT"

cp "_temp/SUPER MARIO 64#5535F203#0#2_all$EXT" "$PORT/Effects/Pebble/7BA36891B4F0D89420D1E36113977D31$EXT"

cp "_temp/SUPER MARIO 64#1A43DF6A#3#2_all$EXT" "$PORT/Effects/Run/47B2CE833CA5501F9F6B4CCB52E970D4$EXT"
cp "_temp/SUPER MARIO 64#3CB6F1A9#3#2_all$EXT" "$PORT/Effects/Run/C4610F05D181F2D8DDE3FAC829764F15$EXT"
cp "_temp/SUPER MARIO 64#84836B2D#3#2_all$EXT" "$PORT/Effects/Run/0FC8A9C37B636EA672BC659AE4A7110D$EXT"
cp "_temp/SUPER MARIO 64#8A94D5A3#3#2_all$EXT" "$PORT/Effects/Run/8F92485B91D9B00AA9BFCAFDA4482376$EXT"
cp "_temp/SUPER MARIO 64#92828A2B#3#2_all$EXT" "$PORT/Effects/Run/ADB90575217D9185CDCC06A39D1AA1C0$EXT"
cp "_temp/SUPER MARIO 64#9C50AF6D#3#2_all$EXT" "$PORT/Effects/Run/9EC11791692CB3EC6AF14554E670C58F$EXT"
cp "_temp/SUPER MARIO 64#BBD69D4A#3#2_all$EXT" "$PORT/Effects/Run/684CF39114371EACBBA982B67FDC84D5$EXT"

cp "_temp/SUPER MARIO 64#9CFE9F81#3#2_all$EXT" "$PORT/Effects/Shadow/5CFA9B89775176343CFB2454C74E5F29$EXT"

cp "_temp/SUPER MARIO 64#064F172D#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/AD9F8F47060FF3C854EF6192A291E9BF$EXT"
cp "_temp/SUPER MARIO 64#2465B806#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/746E2C9638FF83FD64A38EA2A104A7DB$EXT"
cp "_temp/SUPER MARIO 64#2A283A6A#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/CC63FE8B7FBE3535C7880BD1110DE017$EXT"
cp "_temp/SUPER MARIO 64#87805A7C#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/CF4281C25991927D1CCF5C2BDA19EF46$EXT"
cp "_temp/SUPER MARIO 64#EED115D8#3#2_all$EXT" "$PORT/Effects/Sparkle/Animation/C688B3C92501FF3F6BB602DFBF2A4A55$EXT"
cp "_temp/SUPER MARIO 64#7F6733C7#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/unused/545EAC6D118DDFE36E6742C39A6829E5$EXT"
cp "_temp/SUPER MARIO 64#44AE3D51#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/D71C3FBDBAA51E3218623DE8B2CD646F$EXT"
cp "_temp/SUPER MARIO 64#4EE94F84#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/F3866A42B355BE8B10D87DD02B354E77$EXT"
cp "_temp/SUPER MARIO 64#6BF1D4EA#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/4B50C54886409C71188DA0786BB338E8$EXT"
cp "_temp/SUPER MARIO 64#CCEB38F6#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/9D3739BDED4F87C84E06D94422B33760$EXT"
cp "_temp/SUPER MARIO 64#F476B374#0#2_all$EXT" "$PORT/Effects/Sparkle/Press Start/13045FB1954F0BE92ACAE49B37E89BBA$EXT"
cp "_temp/SUPER MARIO 64#57F55B58#0#2_all$EXT" "$PORT/Effects/Sparkle/37C382E38B51AD40306D232F5D9FFCA1$EXT"
cp "_temp/SUPER MARIO 64#8188E2DD#0#2_all$EXT" "$PORT/Effects/Sparkle/AF6C8568484363C095D2BEC84CA864BC$EXT"
cp "_temp/SUPER MARIO 64#906FF62E#0#2_all$EXT" "$PORT/Effects/Sparkle/84A58939BE4FF3D18E859F4D3C27A80E$EXT"
cp "_temp/SUPER MARIO 64#B9C749B9#0#2_all$EXT" "$PORT/Effects/Sparkle/C23295B7EDCEC813822FECD4ED187185$EXT"
cp "_temp/SUPER MARIO 64#F11E411F#0#2_all$EXT" "$PORT/Effects/Sparkle/8F6AD2DAD411730E79969CF8C3D99025$EXT"
cp "_temp/SUPER MARIO 64#F4FAB5F3#0#2_all$EXT" "$PORT/Effects/Sparkle/EAF1D2AD36961EAA1CBF47970DDF8959$EXT"

cp "_temp/SUPER MARIO 64#4446F65D#3#2_all$EXT" "$PORT/Effects/Stomp/4DD39000CCD2CD5433C4FDC785E3B83A$EXT"
cp "_temp/SUPER MARIO 64#9374994C#3#2_all$EXT" "$PORT/Effects/Stomp/67C5570DAC097A60704870FD923C38CB$EXT"
cp "_temp/SUPER MARIO 64#A6411501#3#2_all$EXT" "$PORT/Effects/Stomp/6024D19B5A6D88AC364513A7924ED8B8$EXT"
cp "_temp/SUPER MARIO 64#BB48F1BC#3#2_all$EXT" "$PORT/Effects/Stomp/66966932FAB4F4E8E4C3FEC64CFF60BA$EXT"
cp "_temp/SUPER MARIO 64#C7B5DBC9#3#2_all$EXT" "$PORT/Effects/Stomp/E7DE06FF6F7C085753675507CB4C723F$EXT"
cp "_temp/SUPER MARIO 64#D8504EE4#3#2_all$EXT" "$PORT/Effects/Stomp/7D564737D57918BBE5E88D91BAAC34F3$EXT"

cp "_temp/SUPER MARIO 64#4B0C0C56#3#2_all$EXT" "$PORT/Effects/Swim/31A573B76FE207DF3544F88D17F97F5E$EXT"
cp "_temp/SUPER MARIO 64#5FF8D3EF#3#2_all$EXT" "$PORT/Effects/Swim/9465498E705CF289FBF335C45E3DAF57$EXT"
cp "_temp/SUPER MARIO 64#67D8B446#3#2_all$EXT" "$PORT/Effects/Swim/C7AD74A347D817344957689834ADEC7A$EXT"
cp "_temp/SUPER MARIO 64#FBA28E17#3#2_all$EXT" "$PORT/Effects/Swim/CC4B23CCE17618036C8C99BB8066EE85$EXT"

cp "_temp/SUPER MARIO 64#A7BDD88F#3#2_all$EXT" "$PORT/Effects/Tornado/A0C44C0A219B87F0F3E5F5E427A5AB8E$EXT"

cp "_temp/SUPER MARIO 64#2D0C2E11#3#1_all$EXT" "$PORT/Effects/Transitions/D7AB0191E050558536700E0F3726C584$EXT"
cp "_temp/SUPER MARIO 64#7749B0D9#3#1_all$EXT" "$PORT/Effects/Transitions/10F7B0922846C9D92C40C964090AD2B1$EXT"
cp "_temp/SUPER MARIO 64#98347689#3#1_all$EXT" "$PORT/Effects/Transitions/B357D8C43E21153CD1A0252D647755AD$EXT"
cp "_temp/SUPER MARIO 64#CB57B47B#3#1_all$EXT" "$PORT/Effects/Transitions/F036ADE2811F39FEBCF8536E40EC85E8$EXT"

cp "_temp/SUPER MARIO 64#0F5D756E#0#2_all$EXT" "$PORT/Effects/Water Splash/AFB7CF1BEECAACF627737059F5A7C2F0$EXT"
cp "_temp/SUPER MARIO 64#444B37F6#0#2_all$EXT" "$PORT/Effects/Water Splash/C36B9B4FDA6A3815AFF1242AD8A24E5B$EXT"
cp "_temp/SUPER MARIO 64#4844CCB0#0#2_all$EXT" "$PORT/Effects/Water Splash/298493E492DD8D75E5A2BEF65A96930F$EXT"
cp "_temp/SUPER MARIO 64#674FA5C8#0#2_all$EXT" "$PORT/Effects/Water Splash/873765A58249FE2FFBEB571DC3104A02$EXT"
cp "_temp/SUPER MARIO 64#928D4E78#0#2_all$EXT" "$PORT/Effects/Water Splash/C30D280273ADFCF154F5EC59692F90F1$EXT"
cp "_temp/SUPER MARIO 64#B54D1A02#0#2_all$EXT" "$PORT/Effects/Water Splash/4D18566A87808EE0B803BD8CDB0799C8$EXT"
cp "_temp/SUPER MARIO 64#E04DCB5D#0#2_all$EXT" "$PORT/Effects/Water Splash/2036A9375234D3687596A824D890C409$EXT"
cp "_temp/SUPER MARIO 64#FA11921A#0#2_all$EXT" "$PORT/Effects/Water Splash/12A82C697E93B6BDCD0127026DEC1524$EXT"

cp "_temp/SUPER MARIO 64#931AB56D#3#1_all$EXT" "$PORT/Effects/BB44068BCB3DE8F81BD044E1E7367434$EXT"
cp "_temp/SUPER MARIO 64#A44DF3E3#3#1_all$EXT" "$PORT/Effects/ACFA0D5D39BFB914A59B1484F4DF695E$EXT"

cp "_temp/SUPER MARIO 64#0FB7A538#0#2_all$EXT" "$PORT/Ending/iQue/D2E3F3815D158C9CC1B0678ABEBB3FE6$EXT"
cp "_temp/SUPER MARIO 64#2E2B191D#0#2_all$EXT" "$PORT/Ending/iQue/1A6D3A790814A7D751390BF966903654$EXT"
cp "_temp/SUPER MARIO 64#5C47FE38#0#2_all$EXT" "$PORT/Ending/iQue/5CE85856CC0429E954F7F472856CC23C$EXT"
cp "_temp/SUPER MARIO 64#07E88217#0#2_all$EXT" "$PORT/Ending/iQue/5A7D4E6721051136F0440D1AD2D02720$EXT"
cp "_temp/SUPER MARIO 64#605B6197#0#2_all$EXT" "$PORT/Ending/iQue/46094C949113680A9A30F4309F6E6745$EXT"
cp "_temp/SUPER MARIO 64#CE836E55#0#2_all$EXT" "$PORT/Ending/iQue/5ADE8B946129B88988253BE59C165B31$EXT"
cp "_temp/SUPER MARIO 64#DBAF6936#0#2_all$EXT" "$PORT/Ending/iQue/A8164D31323ACB11176B23F577BB9772$EXT"
cp "_temp/SUPER MARIO 64#E535A40E#0#2_all$EXT" "$PORT/Ending/iQue/57C7143771DBDC972EFCFC223E1028EC$EXT"
cp "_temp/SUPER MARIO 64#C136BC10#0#2_all$EXT" "$PORT/Ending/06FB1A9BF9220B2A9C40E6C14854D677$EXT"
cp "_temp/SUPER MARIO 64#8A4DF121#0#2_all$EXT" "$PORT/Ending/8745FDDD471E8DA9E8B79EE7CD7E6827$EXT"
cp "_temp/SUPER MARIO 64#77C0FF44#0#2_all$EXT" "$PORT/Ending/1CDC60B555AB2EE62F88395A84EA5249$EXT"
cp "_temp/SUPER MARIO 64#F8B79A21#0#2_all$EXT" "$PORT/Ending/132B799A2F8C630C83182B8FCFD683DC$EXT"
cp "_temp/SUPER MARIO 64#F8D3168E#0#2_all$EXT" "$PORT/Ending/C6451F7BC1CF38B2BCEED23CD77E3D14$EXT"
cp "_temp/SUPER MARIO 64#40AA862F#0#2_all$EXT" "$PORT/Ending/AF365168CB26A81644A864F6748B5B95$EXT"
cp "_temp/SUPER MARIO 64#60BCEF6E#0#2_all$EXT" "$PORT/Ending/A13EC43E2F8DA66F8C0EF9C93B5B6B8F$EXT"
cp "_temp/SUPER MARIO 64#FBEC7687#0#2_all$EXT" "$PORT/Ending/459363575C5E492B73D47C2B6A119F34$EXT"
cp "_temp/SUPER MARIO 64#D3D78F68#0#2_all$EXT" "$PORT/Ending/7A1C262A7ECA10041AA1BB799041AAC3$EXT"
cp "_temp/SUPER MARIO 64#9C8D6967#0#2_all$EXT" "$PORT/Ending/723B4AFF1E7616ADDE0ADA61A7C6E036$EXT"
cp "_temp/SUPER MARIO 64#80443EAE#0#2_all$EXT" "$PORT/Ending/DD8865B229F1EFAA80F545D0762787A6$EXT"
cp "_temp/SUPER MARIO 64#FA825D44#0#2_all$EXT" "$PORT/Ending/AAA23040C87CFAD9490A77FA80FAF160$EXT"
cp "_temp/SUPER MARIO 64#292C40A1#0#2_all$EXT" "$PORT/Ending/DCAF2A2BB8022175AD74B8D668042861$EXT"
cp "_temp/SUPER MARIO 64#39A50598#0#2_all$EXT" "$PORT/Ending/75054207520ADF5ED52A7AF14405631B$EXT"
cp "_temp/SUPER MARIO 64#FA49A60A#0#2_all$EXT" "$PORT/Ending/EE8EDC21BA3E2F70D39F01E905C30452$EXT"
cp "_temp/SUPER MARIO 64#BF00C323#0#2_all$EXT" "$PORT/Ending/5E2F752ACAFD1502FB06753117C3B99D$EXT"
cp "_temp/SUPER MARIO 64#5663D126#0#2_all$EXT" "$PORT/Ending/5B621967C0A497C4D43CFAABFD0F48FC$EXT"
cp "_temp/SUPER MARIO 64#9BD37209#0#2_all$EXT" "$PORT/Ending/FCA9ACE32E70ECC0E0D57936E8F0B54C$EXT"
cp "_temp/SUPER MARIO 64#A58A82F8#0#2_all$EXT" "$PORT/Ending/33E810FF871BAFBBE95C8A64820344D6$EXT"
cp "_temp/SUPER MARIO 64#07C7C401#0#2_all$EXT" "$PORT/Ending/9A91C9124821E1529E6483BF88BDF7F6$EXT"
cp "_temp/SUPER MARIO 64#8202BE27#0#2_all$EXT" "$PORT/Ending/433703378554F6330BE3D32ABF85A98F$EXT"
cp "_temp/SUPER MARIO 64#6C706165#0#2_all$EXT" "$PORT/Ending/FBA202CAC77C4762CAE03B2D9F568FB2$EXT"
cp "_temp/SUPER MARIO 64#10C87D57#0#2_all$EXT" "$PORT/Ending/2A8A67181EA6E928AE00B260406AC780$EXT"
cp "_temp/SUPER MARIO 64#BA568BD1#0#2_all$EXT" "$PORT/Ending/796AE5DDF1D09916FFB156E04E226FE6$EXT"
cp "_temp/SUPER MARIO 64#0430DE55#0#2_all$EXT" "$PORT/Ending/251D6A6A95BAE0F030315F9EDA9F6057$EXT"
cp "_temp/SUPER MARIO 64#F3247D8B#0#2_all$EXT" "$PORT/Ending/D75A7D0B927E01A3F1729395DA56A8A8$EXT"
cp "_temp/SUPER MARIO 64#6926316A#0#2_all$EXT" "$PORT/Ending/BE290980B55EC261619F81F2536E217A$EXT"
cp "_temp/SUPER MARIO 64#163F6E7C#0#2_all$EXT" "$PORT/Ending/982340A4EC7AB39946CBE951010459DC$EXT"
cp "_temp/SUPER MARIO 64#C8782E13#0#2_all$EXT" "$PORT/Ending/0CA1B4E7C573E14F3622C396AC58119A$EXT"
cp "_temp/SUPER MARIO 64#086772E7#0#2_all$EXT" "$PORT/Ending/7C5064D94B47D3C9EB801AD7818A40CB$EXT"
cp "_temp/SUPER MARIO 64#59C798D4#0#2_all$EXT" "$PORT/Ending/286E072D4B2550095CE740B730E9E8C0$EXT"
cp "_temp/SUPER MARIO 64#992737D1#0#2_all$EXT" "$PORT/Ending/C27B7B9C87BAC127F51836FF8017B5AB$EXT"
cp "_temp/SUPER MARIO 64#2677A2A0#0#2_all$EXT" "$PORT/Ending/F5AB71146C957D4CDD6F4F7745828EC5$EXT"
cp "_temp/SUPER MARIO 64#1A6F8A0E#0#2_all$EXT" "$PORT/Ending/2A29382D5CF1EB567F77ECD11348A940$EXT"
cp "_temp/SUPER MARIO 64#EC390C33#0#2_all$EXT" "$PORT/Ending/49077E4631DA750057F34990316316D9$EXT"
cp "_temp/SUPER MARIO 64#72A1D4B8#0#2_all$EXT" "$PORT/Ending/535FFA97139752ED03223C863C65D2E0$EXT"
cp "_temp/SUPER MARIO 64#537D0A34#0#2_all$EXT" "$PORT/Ending/00B4BEEC463282A79DD80166BA242811$EXT"
cp "_temp/SUPER MARIO 64#16DB7146#0#2_all$EXT" "$PORT/Ending/696848F7FAED3DF9D87E834D692A8395$EXT"
cp "_temp/SUPER MARIO 64#21A99BEF#0#2_all$EXT" "$PORT/Ending/3ABF42798500A48C1D2786B4819B71A4$EXT"
cp "_temp/SUPER MARIO 64#6A799547#0#2_all$EXT" "$PORT/Ending/270C84D21A6548FC198F1439B5CDB4B5$EXT"
cp "_temp/SUPER MARIO 64#8D5F88C4#0#2_all$EXT" "$PORT/Ending/1EACAE2B1922708B5930180BB4C18A1C$EXT"
cp "_temp/SUPER MARIO 64#F66738C7#0#2_all$EXT" "$PORT/Ending/AA86BEA9CF41709013C10A19864003B5$EXT"
cp "_temp/SUPER MARIO 64#108D6CAE#0#2_all$EXT" "$PORT/Ending/C02E9A624F71BB4CB6C6E471E470B22D$EXT"
cp "_temp/SUPER MARIO 64#E3A23A76#0#2_all$EXT" "$PORT/Ending/4D71C6220CD9E3B7094ABB733C4A518E$EXT"
cp "_temp/SUPER MARIO 64#2282C30A#0#2_all$EXT" "$PORT/Ending/C1212C6A30D41303ECC77A212FE131B5$EXT"
cp "_temp/SUPER MARIO 64#6BC84AF5#0#2_all$EXT" "$PORT/Ending/9EF15C43E9D005A2F87794A6E3463890$EXT"

cp "_temp/SUPER MARIO 64#18EC36FD#0#2_all$EXT" "$PORT/Ending/Europe/English/E04D0A4E4D0C335DA70DC7970014FD8C$EXT"
cp "_temp/SUPER MARIO 64#31A51D72#0#2_all$EXT" "$PORT/Ending/Europe/English/06DEAAA6340CB69F28F2EF8BC2EA8952$EXT"
cp "_temp/SUPER MARIO 64#290FFE53#0#2_all$EXT" "$PORT/Ending/Europe/French/E370B3DABED4D0CC2FE47E66AC639F6D$EXT"
cp "_temp/SUPER MARIO 64#500B0DEA#0#2_all$EXT" "$PORT/Ending/Europe/French/7BE169D8056674BB3CB20441E9EA001F$EXT"
cp "_temp/SUPER MARIO 64#0C111216#0#2_all$EXT" "$PORT/Ending/Europe/German/48CF79800F71EFAED0AA81F96DC73B5F$EXT"
cp "_temp/SUPER MARIO 64#4381E7ED#0#2_all$EXT" "$PORT/Ending/Europe/German/08F5540E5DDFB4D27CE4AEA2FA56534B$EXT"
cp "_temp/SUPER MARIO 64#0C106657#0#2_all$EXT" "$PORT/Ending/Europe/210ABD73874967985BBAFC1175FB10FB$EXT"
cp "_temp/SUPER MARIO 64#10F7ABF3#0#2_all$EXT" "$PORT/Ending/Europe/17E78A4EFF93B3F8401EF673B468934C$EXT"
cp "_temp/SUPER MARIO 64#27FDB2DC#0#2_all$EXT" "$PORT/Ending/Europe/AA774B95F6D2AE3B47C01739EB3B846B$EXT"
cp "_temp/SUPER MARIO 64#28F7B042#0#2_all$EXT" "$PORT/Ending/Europe/52CD31EF50539B5E55BD2F58071987CC$EXT"
cp "_temp/SUPER MARIO 64#2A46C0DF#0#2_all$EXT" "$PORT/Ending/Europe/4C43DEC9F502A2D995AC3030844288C8$EXT"
cp "_temp/SUPER MARIO 64#308E2468#0#2_all$EXT" "$PORT/Ending/Europe/42409F8FB98BC07122AD9289AFBD4FFA$EXT"
cp "_temp/SUPER MARIO 64#3F7232A7#0#2_all$EXT" "$PORT/Ending/Europe/7FB34EC7CDF8F0D1E26F3BC26236BFC0$EXT"
cp "_temp/SUPER MARIO 64#4AD973E2#0#2_all$EXT" "$PORT/Ending/Europe/07B35ECD83173331DEDC1EBFC2D75572$EXT"
cp "_temp/SUPER MARIO 64#532ECD87#0#2_all$EXT" "$PORT/Ending/Europe/71D73A1F822686AEB3CAFD02D3837DCA$EXT"
cp "_temp/SUPER MARIO 64#5657416D#0#2_all$EXT" "$PORT/Ending/Europe/F6881E6F05548FC1A04BA54C95948FB1$EXT"
cp "_temp/SUPER MARIO 64#5677A141#0#2_all$EXT" "$PORT/Ending/Europe/7AE662801CAE4A5E75B5B432992A9E12$EXT"
cp "_temp/SUPER MARIO 64#5AB4CEF4#0#2_all$EXT" "$PORT/Ending/Europe/307204741470F968D9753AC0A0EBFFC1$EXT"
cp "_temp/SUPER MARIO 64#63AECD87#0#2_all$EXT" "$PORT/Ending/Europe/ADC5EF7A8D652F5EC684B5989D70C1D9$EXT"
cp "_temp/SUPER MARIO 64#6D62A6A6#0#2_all$EXT" "$PORT/Ending/Europe/B677850636897FF28F305C1B6D271CE5$EXT"
cp "_temp/SUPER MARIO 64#74A85A68#0#2_all$EXT" "$PORT/Ending/Europe/BD595C44025396CC681688534600FE45$EXT"
cp "_temp/SUPER MARIO 64#763590BE#0#2_all$EXT" "$PORT/Ending/Europe/CBAFAFE13DEF74E27D46D7173274C5C8$EXT"
cp "_temp/SUPER MARIO 64#81874B75#0#2_all$EXT" "$PORT/Ending/Europe/27DA661F8512B5AAB85AFACD071B4A2B$EXT"
cp "_temp/SUPER MARIO 64#83AB57C6#0#2_all$EXT" "$PORT/Ending/Europe/897F174208673F93D23336A477410D84$EXT"
cp "_temp/SUPER MARIO 64#85C02640#0#2_all$EXT" "$PORT/Ending/Europe/71412F92F52C82A95F1C4263A17536A2$EXT"
cp "_temp/SUPER MARIO 64#89464744#0#2_all$EXT" "$PORT/Ending/Europe/3C5BA70D67851B6C408F49205FB82F3D$EXT"
cp "_temp/SUPER MARIO 64#978D2257#0#2_all$EXT" "$PORT/Ending/Europe/9227F4A5FB1011F7608D9EE8028D99D3$EXT"
cp "_temp/SUPER MARIO 64#A5CFD43A#0#2_all$EXT" "$PORT/Ending/Europe/CB8B61689818DDEB66051EF2097D6F11$EXT"
cp "_temp/SUPER MARIO 64#B2743C1B#0#2_all$EXT" "$PORT/Ending/Europe/B5E5782ED0A91122B9F9FE9173E102E9$EXT"
cp "_temp/SUPER MARIO 64#B4D53E4A#0#2_all$EXT" "$PORT/Ending/Europe/1EEF54308E631C8E73255C3E2CFF926D$EXT"
cp "_temp/SUPER MARIO 64#C041FCD7#0#2_all$EXT" "$PORT/Ending/Europe/10EA48CAF312406A63199C8D5B86D2CE$EXT"
cp "_temp/SUPER MARIO 64#D31DAE4D#0#2_all$EXT" "$PORT/Ending/Europe/316C788C14E4B01B9AD571C8868D0FD6$EXT"
cp "_temp/SUPER MARIO 64#D6570E85#0#2_all$EXT" "$PORT/Ending/Europe/B57EFC3D729798E3F55677982175D823$EXT"
cp "_temp/SUPER MARIO 64#E3F75852#0#2_all$EXT" "$PORT/Ending/Europe/B37BD3954D8AB61565CC42C4D3100A16$EXT"
cp "_temp/SUPER MARIO 64#E97DEC1C#0#2_all$EXT" "$PORT/Ending/Europe/A786E3EBAAF50E75D7FBE4D406E89118$EXT"
cp "_temp/SUPER MARIO 64#EA9EFBD7#0#2_all$EXT" "$PORT/Ending/Europe/23760A8B03B148C613B5513BD7F89DF4$EXT"
cp "_temp/SUPER MARIO 64#EDF99175#0#2_all$EXT" "$PORT/Ending/Europe/BCB485C7502740FBE95CDC53D0A8492D$EXT"
cp "_temp/SUPER MARIO 64#EDFDEEE8#0#2_all$EXT" "$PORT/Ending/Europe/1F531C3961B16DEB91713B5C23F4C6A4$EXT"

cp "_temp/SUPER MARIO 64#0B2390F1#0#2_all$EXT" "$PORT/Hacks/Italian/88E577C6C708BBB7595FD5430AC8A0E0$EXT"
cp "_temp/SUPER MARIO 64#9D0D539A#0#2_all$EXT" "$PORT/Hacks/Italian/EAF3B1EC5C358026F090FC88A9BBCD4C$EXT"

cp "_temp/SUPER MARIO 64#7F99C256#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/EABADC56FDEDEDD4C2C2E82A2F3420C5$EXT"
cp "_temp/SUPER MARIO 64#8BB18968#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/9588E471E90FC764023C70574C978317$EXT"
cp "_temp/SUPER MARIO 64#8CA25891#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/59DE92992B88A29707D52E357C23744D$EXT"
cp "_temp/SUPER MARIO 64#70A7D167#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/C78A203B3E960EADEB4F99505BC72334$EXT"
cp "_temp/SUPER MARIO 64#787AC0A1#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/6D641A7DDB661E38868683C413F6F731$EXT"
cp "_temp/SUPER MARIO 64#AEA7B185#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/21F4FD8F980D53A11D196A402D037436$EXT"
cp "_temp/SUPER MARIO 64#BEA8A184#3#0_all$EXT" "$PORT/Hacks/Italian/Accents/CE8385BAE6D1205063D0C5497F7E5B83$EXT"

cp "_temp/SUPER MARIO 64#6FAA2E94#0#2_all$EXT" "$PORT/Hacks/Italian/Boot/D544AD14A7FC0584228AC1B28FCCF4F1$EXT"
cp "_temp/SUPER MARIO 64#E1C887F7#0#2_all$EXT" "$PORT/Hacks/Italian/Boot/16216E74D15AF197B402E8516198B657$EXT"
cp "_temp/SUPER MARIO 64#E519CA39#0#2_all$EXT" "$PORT/Hacks/Italian/Boot/B1FE2ED591C05B17C46446570B68234C$EXT"

cp "_temp/SUPER MARIO 64#0DF2EE56#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/D09CDD3EE46EACC4688E2B00D3FBFA8D$EXT"
cp "_temp/SUPER MARIO 64#03615A50#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/CF3D2F3E779D0BFAADE06C5D0654884A$EXT"
cp "_temp/SUPER MARIO 64#05E4C3CE#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/AFA0F9FBA55BDB72321594203653D8A6$EXT"
cp "_temp/SUPER MARIO 64#2FFB1C1E#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/C58EC2CA19019DBB302A2C0CBB46F7C0$EXT"
cp "_temp/SUPER MARIO 64#3BCA4663#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/5616D85537A1CA1C5132039A4CB2A72C$EXT"
cp "_temp/SUPER MARIO 64#4AFB88E5#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/225B3198E4810EFFF3F0931740F127AD$EXT"
cp "_temp/SUPER MARIO 64#7E19E019#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/302F24402EDCD6ECAEFB5E859E23AB47$EXT"
cp "_temp/SUPER MARIO 64#8B3C07F3#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/DC778713A874B057DF7B759244E7903A$EXT"
cp "_temp/SUPER MARIO 64#17EF85F7#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/3B322F815F6A4C4337D24A3569CD216B$EXT"
cp "_temp/SUPER MARIO 64#25B219C7#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/D99A69CE06A68AD5ABC4681AE4B56903$EXT"
cp "_temp/SUPER MARIO 64#66D3249E#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/76AD169307783D2DE9FAB5D719EBA029$EXT"
cp "_temp/SUPER MARIO 64#68CC2DCF#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/78D8BF9DD8B6CE8073C4FF1C6A07DD4D$EXT"
cp "_temp/SUPER MARIO 64#74B2E682#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/F79B3D316DECE98E20E19E4CBC8BE961$EXT"
cp "_temp/SUPER MARIO 64#76A30F4E#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/49934299D70FEE60F1362B5948FC2110$EXT"
cp "_temp/SUPER MARIO 64#97BE3437#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/7E409204AE340D7C432C3701FD4D4DB8$EXT"
cp "_temp/SUPER MARIO 64#284FF556#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/5EEDB386C9EF825A9FC52AEA637B7018$EXT"
cp "_temp/SUPER MARIO 64#522CE9C5#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/B12D0F729C40DAA522D86EB76661D9D9$EXT"
cp "_temp/SUPER MARIO 64#690ACA1A#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/99194A66361546AC3C2DC99020FD0577$EXT"
cp "_temp/SUPER MARIO 64#916ADF8D#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/D95DB73A4ADF08CF7E6B59D0D8D66969$EXT"
cp "_temp/SUPER MARIO 64#89840F12#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/7D5A0F2C1E5A9A729DEAE2A542CF5D20$EXT"
cp "_temp/SUPER MARIO 64#96184D64#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/5F5E2199A54901C94F00D55E6DE7CF1F$EXT"
cp "_temp/SUPER MARIO 64#381969FB#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/9DD26706330A45A69571C11DBACCDDC9$EXT"
cp "_temp/SUPER MARIO 64#A8A99A1B#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/4BB06ED7F17AF8BBD52897A6AB40D640$EXT"
cp "_temp/SUPER MARIO 64#A24313CF#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/AFA21AF82F144E00936FD77C7DFD1101$EXT"
cp "_temp/SUPER MARIO 64#E192BD52#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/14CB910471329C5C83046882244EC6C3$EXT"
cp "_temp/SUPER MARIO 64#EDC820A0#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/581686ABFD59CACF814E735959C15981$EXT"
cp "_temp/SUPER MARIO 64#EF597575#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/642F9E0025AB57A5FD50FC00DAF69A47$EXT"
cp "_temp/SUPER MARIO 64#EFC4F8C1#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/E9AF19EBC97B29F5750631CA3795AA20$EXT"
cp "_temp/SUPER MARIO 64#F09319B6#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/47E6862E8EF77608AAB4290270A9D89D$EXT"
cp "_temp/SUPER MARIO 64#F9693BD4#0#2_all$EXT" "$PORT/Hacks/Italian/Credits/A953F5B53545B4F94493B11C4314FAC5$EXT"

cp "_temp/SUPER MARIO 64#379ABEE0#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/1F97DB7F6B515007FF21E71B2919E431$EXT"
cp "_temp/SUPER MARIO 64#C48EA6DD#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/6E6423B76BBDD4EAB28E67EB23272ED8$EXT"
cp "_temp/SUPER MARIO 64#E6170513#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/D4700FBC475381F8840FD32D1E5CB96A$EXT"
cp "_temp/SUPER MARIO 64#F4F57CAE#0#2_all$EXT" "$PORT/Hacks/Italian/Doors/A1B4DF1DBF11D19E107C0824384426FC$EXT"

cp "_temp/SUPER MARIO 64#08731842#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/3200AEFB4F87A268A3B1CA697C191181$EXT"
cp "_temp/SUPER MARIO 64#8E673CBA#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/39AEB21B31C67EECA33E987F7CF77405$EXT"
cp "_temp/SUPER MARIO 64#44A3D447#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/906AE0C74F88015A1E0456F37091BD4D$EXT"
cp "_temp/SUPER MARIO 64#90105191#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/C0E2E6C88C885A5D11092B392CB25F91$EXT"
cp "_temp/SUPER MARIO 64#A8EF6703#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/CCFA312DF01EB9299C9727ADBAF3CDF5$EXT"
cp "_temp/SUPER MARIO 64#BCD252AA#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/CD6FADCB5AD370089823697175AFA2A1$EXT"
cp "_temp/SUPER MARIO 64#C3D06562#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/469DDAAFB0CA2DB496804392C33C232A$EXT"
cp "_temp/SUPER MARIO 64#FBAC0AC1#0#2_all$EXT" "$PORT/Hacks/Italian/Ending/6B7FAC075692C4D0EC59D5CA1E9D10C1$EXT"

cp "_temp/SUPER MARIO 64#2C614658#0#2_all$EXT" "$PORT/Hacks/Italian/File Select/1DD133AAFB67356674CF762A07942DD5$EXT"
cp "_temp/SUPER MARIO 64#832377DF#0#2_all$EXT" "$PORT/Hacks/Italian/File Select/C560D27FDBF659FD539F34FF70D625DD$EXT"
cp "_temp/SUPER MARIO 64#DDDEB631#0#2_all$EXT" "$PORT/Hacks/Italian/File Select/DBE26B2527BF5F89FA35C99D5B988BC8$EXT"

cp "_temp/SUPER MARIO 64#1D183FBC#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/4772C8831B69F1E7766B53733FE56A00$EXT"
cp "_temp/SUPER MARIO 64#9B6614EA#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/38E97A7E3726E7161E7B2D1A13DD5EDF$EXT"
cp "_temp/SUPER MARIO 64#B994341B#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/2B09F919072C7D4BABC59F3C6F41AAAC$EXT"
cp "_temp/SUPER MARIO 64#DE288E3D#0#2_all$EXT" "$PORT/Hacks/Italian/Game Over/BBF478D4291E18C7EED7EE65F987F34F$EXT"

cp "_temp/SUPER MARIO 64#28C6D988#0#2_all$EXT" "$PORT/Hacks/Italian/Power Meter/D1085C0D029495604D204C8750A06A36$EXT"
cp "_temp/SUPER MARIO 64#DA943EC7#0#2_all$EXT" "$PORT/Hacks/Italian/Power Meter/E02A3A037C4C20589428CABC73981284$EXT"

cp "_temp/SUPER MARIO 64#8E553E08#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/A43B9FB0D3A15696E40AE9522BBEC5F7$EXT"
cp "_temp/SUPER MARIO 64#9FB22F58#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/0953B959B4F23818073CC02D56E48BFF$EXT"
cp "_temp/SUPER MARIO 64#89A3BC6D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/BDE9CF842605DD246293C6715E348D74$EXT"
cp "_temp/SUPER MARIO 64#461CAD5E#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/E645324C8655046D7903CB0AB367CD02$EXT"
cp "_temp/SUPER MARIO 64#4167F9D9#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/44B95F50C0BF1CF2C85AF496137BEEB7$EXT"
cp "_temp/SUPER MARIO 64#28306D49#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/394CBF83602E6B57DA747DB2EC09279E$EXT"
cp "_temp/SUPER MARIO 64#51464DCC#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/988CFB9DD9E027685BBF6AFB2B76DCBE$EXT"
cp "_temp/SUPER MARIO 64#22922890#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/654C21A0E40350DC7437D31B045BBBBF$EXT"
cp "_temp/SUPER MARIO 64#AB5321E2#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/AD1440BC4686703E80209E5EBE55C32A$EXT"
cp "_temp/SUPER MARIO 64#B75E03A9#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/629D327DE3772DACD8A3B3E9224A08DD$EXT"
cp "_temp/SUPER MARIO 64#B994AC9B#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/6C3E7D28ED1034D045747797CADD49A1$EXT"
cp "_temp/SUPER MARIO 64#D03DC784#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/C6B1051E6D571F96BE05C5563A9824F6$EXT"
cp "_temp/SUPER MARIO 64#E6FC50A9#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Bowser/6676A85DA101D2FBD74B0A6BFC360472$EXT"

cp "_temp/SUPER MARIO 64#5CB45199#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/29EAFB7611A05370C484529929912C4E$EXT"
cp "_temp/SUPER MARIO 64#44A70AFD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/8DB2A2148885BA3C72444963F0823F30$EXT"
cp "_temp/SUPER MARIO 64#169F1F02#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/972DEF237105B0C37BDBA64D90009219$EXT"
cp "_temp/SUPER MARIO 64#799CA729#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/73F4B0836F4978F2DC2752E9A6E140D3$EXT"
cp "_temp/SUPER MARIO 64#5844A956#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/85B753573696EA1A9CBD08A8FFA46164$EXT"
cp "_temp/SUPER MARIO 64#D0381C0B#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/8BCC92165D4D1987303F68E5F4339321$EXT"
cp "_temp/SUPER MARIO 64#F23F46C3#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Luigi/3E8C525B55E5B0C50C5B303C9246E50F$EXT"

cp "_temp/SUPER MARIO 64#0A9E2B96#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/80E9E04D364207652F7FC5E48E9F034D$EXT"
cp "_temp/SUPER MARIO 64#0DB99B2E#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/A547383DA903387790E7D232BF85C0D1$EXT"
cp "_temp/SUPER MARIO 64#3DC483C5#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/D2BB5416B4115B2930C52B74ED7B4C98$EXT"
cp "_temp/SUPER MARIO 64#5F864F5D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/1197EF6D0C507E374CCB83AD8312C3BC$EXT"
cp "_temp/SUPER MARIO 64#47CF2FCB#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/47437B8CEC4D9A06AD27DE2F97D502CE$EXT"
cp "_temp/SUPER MARIO 64#847028E0#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/76AE9E59003B628D6EA07CFE7228B553$EXT"
cp "_temp/SUPER MARIO 64#CCC551FE#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/6A81319BE8E363A9DB3E0C8EACF1A6B1$EXT"
cp "_temp/SUPER MARIO 64#D9F6CF53#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/C4FCD6763335D2D25B70565AA07919A3$EXT"
cp "_temp/SUPER MARIO 64#E972AC97#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/024206BDD2E5FA1885161CBF70EB094A$EXT"
cp "_temp/SUPER MARIO 64#EB3842BD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/3A69891AD9354E4682CF6602D3D9E65E$EXT"
cp "_temp/SUPER MARIO 64#F309ED8E#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/05E710A33CAB88EDBFF4EEC32D9E9F9E$EXT"
cp "_temp/SUPER MARIO 64#FBE45EEE#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/5E73B55362E1313E1B2B273044445B95$EXT"
cp "_temp/SUPER MARIO 64#FE3E61A2#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Mario/99BC3AC610B7B8E7ECB606EDBD8CAF8A$EXT"

cp "_temp/SUPER MARIO 64#00D84C67#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/00BF600DA5462322433EF88E81DD5F80$EXT"
cp "_temp/SUPER MARIO 64#2BDECACD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/02C362D6EF7CAC4D568585750CB52103$EXT"
cp "_temp/SUPER MARIO 64#4EDD979D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/8D5402C4A89428C28E289149C4AACB0B$EXT"
cp "_temp/SUPER MARIO 64#5B8168E1#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/2F0142D49B75E4CD4E2530A5B0E73694$EXT"
cp "_temp/SUPER MARIO 64#9C85EB43#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/B8D85B38DA618FC776EF4D24CCA6B54B$EXT"
cp "_temp/SUPER MARIO 64#60F3F3DD#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/BFFB98F6A0A1028A2D434F5A2E2CF933$EXT"
cp "_temp/SUPER MARIO 64#74EDA125#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/CE93075A25965DCA0EE6CCE02281458C$EXT"
cp "_temp/SUPER MARIO 64#861FB80F#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/DB5471739F60C0F1652D03833BF177A1$EXT"
cp "_temp/SUPER MARIO 64#B5FDC516#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/9559BF7D00CAF5D9A21D92D946CA40BD$EXT"
cp "_temp/SUPER MARIO 64#B8F1BFA4#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/EE8ABC62D13EA853BEEEBA4835B25561$EXT"
cp "_temp/SUPER MARIO 64#BD013EA0#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/72C29F1A6B72C363068FFD0CF1F549B5$EXT"
cp "_temp/SUPER MARIO 64#C60DF6D6#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Peach/314722F2C6FBE2A3D82DB73E7CBD4829$EXT"

cp "_temp/SUPER MARIO 64#6D7C572B#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/47B8248C32356DDE4A3E3BCD07BD879F$EXT"
cp "_temp/SUPER MARIO 64#575F3D32#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/07BCEE686B0E159CD890758745532359$EXT"
cp "_temp/SUPER MARIO 64#3645BC2D#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/E34ADCC73C28EC606AA381D7CBAC3766$EXT"
cp "_temp/SUPER MARIO 64#D5229F79#0#2_all$EXT" "$PORT/Hacks/Low Poly Promo Models/Toad/2D5DE28172A8DE18D2BE2B0083F20ADF$EXT"

cp "_temp/SUPER MARIO 64#9142C20C#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/6F187E5526192F641A90307626835794$EXT"
cp "_temp/SUPER MARIO 64#BDC17977#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/BBF96E726DFE497E1EBFAB4974B39830$EXT"
cp "_temp/SUPER MARIO 64#C26F9CCA#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/30AE59EA9E72053119FA7F7A727CD411$EXT"
cp "_temp/SUPER MARIO 64#D130AC90#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/AF6EE51ADD3E3BB7BF2EF33D7185F0A8$EXT"

cp "_temp/SUPER MARIO 64#5E56F570#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/1-UP/DC6AA2B6BABC015564CB68728E8E6229$EXT"
cp "_temp/SUPER MARIO 64#943356A3#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/1-UP/860E88B31C4D408A2D96F4868302AB58$EXT"

cp "_temp/SUPER MARIO 64#A64FDFB1#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Boo/65F719BFCC88107E3A92A3AFB949E938$EXT"
cp "_temp/SUPER MARIO 64#B68D854B#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Boo/4B7A926AD63F24306BB58998A336F0D2$EXT"

cp "_temp/SUPER MARIO 64#757A34CD#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Chain Chomp/8624AF44760355C27F35D31C50E1D4FA$EXT"
cp "_temp/SUPER MARIO 64#EE40B829#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Chain Chomp/0BBD483FEE28F73DA2D4BA9D6582E521$EXT"

cp "_temp/SUPER MARIO 64#534B7FC7#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Coins/AC6EAA7D2CFA862598D61E6C2C3E93CA$EXT"
cp "_temp/SUPER MARIO 64#B38FA4F7#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Coins/7513CC0AB20FDDF37DDA904A2E08438E$EXT"
cp "_temp/SUPER MARIO 64#C6CA2FCC#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Coins/0531D6A5F914DF059BBAF02B04DD9829$EXT"

cp "_temp/SUPER MARIO 64#AD1EAD6A#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Goomba/D68E261ECC8E4BF564B6A2116E2526AE$EXT"
cp "_temp/SUPER MARIO 64#B188E9BC#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Goomba/28FE06EA342513DF5DAC7B22717455DF$EXT"

cp "_temp/SUPER MARIO 64#013BC394#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Penguin/6C7CBC96B88FCA1FD9197D3B25EE911A$EXT"
cp "_temp/SUPER MARIO 64#6D2A2012#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Penguin/6E79479F9685A49BFA728C6868F69559$EXT"
cp "_temp/SUPER MARIO 64#853666DF#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Penguin/120395A08BB5DD38ADCEF964410BD43A$EXT"
cp "_temp/SUPER MARIO 64#AC74FF49#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Penguin/4B4330DD4E51BE209D04C0FF0AB0F7E9$EXT"
cp "_temp/SUPER MARIO 64#BE85D13F#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Penguin/523A41F7A96212862F4799751B9C9D4D$EXT"
cp "_temp/SUPER MARIO 64#F96362D4#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Penguin/D66E8CCC29EA33B10885D6DF587BAFED$EXT"

cp "_temp/SUPER MARIO 64#63E2DB78#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Pokey/EB6A77514A1BC51B3CDB2F26C66E20FD$EXT"
cp "_temp/SUPER MARIO 64#A85EAEE6#0#2_all$EXT" "$PORT/Hacks/Low Poly Render96/Pokey/21D7D0243C4CCE1B6BC9D83BF841E61D$EXT"

cp "_temp/SUPER MARIO 64#1CEC76B5#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/D6738092EE16C460DD8CC89BCE179E7D$EXT"
cp "_temp/SUPER MARIO 64#6B3E53CC#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/E66F2475625F483FD74139961ADC9D65$EXT"
cp "_temp/SUPER MARIO 64#9E1746CF#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/5A44A1223BD271C048959B8CB44F9E0F$EXT"
cp "_temp/SUPER MARIO 64#78C860CC#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/5AFAA6AA4534A1AB33B8F534DE3C8DEA$EXT"
cp "_temp/SUPER MARIO 64#7713BB0B#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/F618974A0416758F157C53D49F39CC32$EXT"
cp "_temp/SUPER MARIO 64#EB68F705#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/EE498D18BEC58E164A154C2486EC811D$EXT"
cp "_temp/SUPER MARIO 64#FD4ED4E4#0#2_all$EXT" "$PORT/Hacks/Multiplayer/Splitscreen/CE19FD2427AAF3DFA544CEA3AD6B6AFF$EXT"

cp "_temp/SUPER MARIO 64#3CF17015#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/146B6E4C1E832943265CF5C716DB4D44$EXT"
cp "_temp/SUPER MARIO 64#36D4EF3E#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/A33F562984D3FE55A54BB1D545E2E633$EXT"
cp "_temp/SUPER MARIO 64#244E5B3E#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/BDBA34E6A254997EEF254F878C4D49A7$EXT"
cp "_temp/SUPER MARIO 64#CAF05DAA#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.2/5570ADA6F4A0B67ADB2E7D8119170F9D$EXT"

cp "_temp/SUPER MARIO 64#87E934DB#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3/CF48E05AA1704F6FF82337C2B7DC4713$EXT"
cp "_temp/SUPER MARIO 64#CB30FEE4#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3/4CD60C1742CB44093F31FA436C863644$EXT"
cp "_temp/SUPER MARIO 64#CFB0A1D9#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3/F1EC26E6DB59E1A8CEE85C602D8D91FC$EXT"

cp "_temp/SUPER MARIO 64#670C1829#0#2_all$EXT" "$PORT/Hacks/Multiplayer/v1.3.1/02696E8C392BFDEAA56E46776E88F979$EXT"

cp "_temp/SUPER MARIO 64#D3A287BB#3#2_all$EXT" "$PORT/Hacks/Shindou Improvement/461B376EADE708165A9C3B2D95479D8F$EXT"
cp "_temp/SUPER MARIO 64#AFE7D9AE#0#2_all$EXT" "$PORT/Hacks/Shindou Improvement/C029D50D5B2F471F701ED04865731FBA$EXT"

cp "_temp/SUPER MARIO 64#02A9F308#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/EA1148543D89B368E9115271DC7DD824$EXT"
cp "_temp/SUPER MARIO 64#07E3D1E9#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/83B9785DFFEB274B12287B16A985EA3F$EXT"
cp "_temp/SUPER MARIO 64#1B1D8D53#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/EBB93A2138AFB465BC30DBEB0CB8932E$EXT"
cp "_temp/SUPER MARIO 64#9A8A844C#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/4DA7C7EF59054E2B11B79D9A640E0465$EXT"
cp "_temp/SUPER MARIO 64#34B17C10#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/069265364FD4BA4F2107E351C7215F35$EXT"
cp "_temp/SUPER MARIO 64#78AB4347#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/C6049230BFB6198C6D0350A53A94CA36$EXT"
cp "_temp/SUPER MARIO 64#54536290#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/0E0B2F2C2275DE5CD0C6902C557FF736$EXT"
cp "_temp/SUPER MARIO 64#A2C8DEBE#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/01 - Bob-omb Plains/91D3A1B59C5D0663631C5BC517D14E73$EXT"

cp "_temp/SUPER MARIO 64#6B5D1BAD#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/02 - Whomp's Forest/C0827A11F1CE8F40F6DD7CC779E783CE$EXT"
cp "_temp/SUPER MARIO 64#46EA5098#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/02 - Whomp's Forest/8448A8B91947DE56946603768B16E3BA$EXT"
cp "_temp/SUPER MARIO 64#69DEC8DC#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/02 - Whomp's Forest/36936BCE786413E4D94614DC8EEA2415$EXT"
cp "_temp/SUPER MARIO 64#4982B613#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/02 - Whomp's Forest/0D7CD7D2B4139BE9D71A1607F9AA6619$EXT"
cp "_temp/SUPER MARIO 64#6556B510#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/02 - Whomp's Forest/174C88EDBA1689DCC3000601E6F12714$EXT"

cp "_temp/SUPER MARIO 64#4BC0C7C1#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/D2DE6A3E0C4577C54D5EFBB579C826FF$EXT"
cp "_temp/SUPER MARIO 64#7A0E79DB#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/F33DE0B40065D0547BBDAB11CB7AA54B$EXT"
cp "_temp/SUPER MARIO 64#34D28AE4#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/23DCFA198E332737C790AC87EAD92BB2$EXT"
cp "_temp/SUPER MARIO 64#37E7B948#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/B35AAEFA2F65950C64BBEF599ADDE13B$EXT"
cp "_temp/SUPER MARIO 64#71C3372A#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/9F495F89C090C532D254EBBDDB80B432$EXT"
cp "_temp/SUPER MARIO 64#9953C617#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/C5EC04E9568C9BDB49536EA54D4ECF80$EXT"
cp "_temp/SUPER MARIO 64#31926763#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/2566A2F999BCAB035063F68B334085B0$EXT"
cp "_temp/SUPER MARIO 64#B991602F#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/2ABBC0B163AA8118B67F2137E29DA858$EXT"
cp "_temp/SUPER MARIO 64#BB31212B#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/E673BEE250C706A1E4ED34EB61392EA1$EXT"
cp "_temp/SUPER MARIO 64#F2FFFC1D#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/A7E9EB697C717BFF6A72EE3BA14D6015$EXT"
cp "_temp/SUPER MARIO 64#4DCC2191#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Areas/Hub/2CD9C0599A01231A2C12810A885258D4$EXT"

cp "_temp/SUPER MARIO 64#A05E4FA9#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Boot/ACD652956E1C49293919EA3E552AE749$EXT"

cp "_temp/SUPER MARIO 64#6AA5A9EE#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Effects/4590E2F0D2D42C9851E0D501E3841E40$EXT"
cp "_temp/SUPER MARIO 64#1352BD73#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Effects/A3C5E6665DD3B306D8E358E398B6E4E9$EXT"

cp "_temp/SUPER MARIO 64#25D2ED99#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/HUD/Course/B369A25F7F81D023CEBC111DAE1282F4$EXT"
cp "_temp/SUPER MARIO 64#986B6437#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/HUD/Course/457B2DA91FC70FC11DE0169DA471F0CD$EXT"

cp "_temp/SUPER MARIO 64#198613E8#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/HUD/Icons/776AE717A13AE77CA2853ACA18CEB000$EXT"

cp "_temp/SUPER MARIO 64#1CB85A3E#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Coin/727B84D2A83ECA8A050D5A1BD7641A87$EXT"
cp "_temp/SUPER MARIO 64#6CE79452#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Coin/E5407A1330589822B2314E482D4241F7$EXT"
cp "_temp/SUPER MARIO 64#6D70C3A3#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Coin/B60024AB6F0BFCE2DC92A45F8336DF53$EXT"
cp "_temp/SUPER MARIO 64#A34144C1#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Coin/D442D788FC601502F6306E49394BBAF4$EXT"
cp "_temp/SUPER MARIO 64#B9DE5FEB#3#1_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Coin/64E4B144FED3C21F30C8FB6ADE5673AE$EXT"

cp "_temp/SUPER MARIO 64#7C3DADD8#0#2_all$EXT" "$PORT/Hacks/SM64 The Green Stars (v3.4)/Objects/Star/668E72130308A03C6549DE370BECA039$EXT"

cp "_temp/SUPER MARIO 64#03BFF3E4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/E4A9B0A14FB9B6AFB527DE961CB3183F$EXT"
cp "_temp/SUPER MARIO 64#0813EA8C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/2B3AE6981DDFA1C99EF9DA589DC66094$EXT"
cp "_temp/SUPER MARIO 64#08744925#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/1CA94E08187E68CB78871B7EC9BD0D78$EXT"
cp "_temp/SUPER MARIO 64#2E895D49#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/74CD23B80CAE7D8C30CB1136288A93D0$EXT"
cp "_temp/SUPER MARIO 64#3C3D0839#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/DCE33205BCD3AC0D5D0F0F3491BF8DA4$EXT"
cp "_temp/SUPER MARIO 64#7DE9FE14#2#0#4F73E9A8_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/EF4A270EBB9322F6FD7B08ECE43B8F01$EXT"
cp "_temp/SUPER MARIO 64#8CBF05C5#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/387FB6DC16493421010A0B7B61784B10$EXT"
cp "_temp/SUPER MARIO 64#741C6CB6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/9BE46BD64F2025BD285BB4C8DEE44A56$EXT"
cp "_temp/SUPER MARIO 64#6911B708#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/2736CE309606FB944EF850EAE361E42E$EXT"
cp "_temp/SUPER MARIO 64#2034795B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/D298B2D8CBE18C4BED4C5E312550FD95$EXT"
cp "_temp/SUPER MARIO 64#63824560#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/22C0F886C3A543F9BDAA9F97302F4F4A$EXT"
cp "_temp/SUPER MARIO 64#A5A22813#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/726262DCBD9EEF6EF1411BA693836D6C$EXT"
cp "_temp/SUPER MARIO 64#A39842DD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/C8934841CA02E84185ADEAB7B8AB5D08$EXT"
cp "_temp/SUPER MARIO 64#C0F40731#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/F22395086D52849363446CD923E6B04B$EXT"
cp "_temp/SUPER MARIO 64#C089B08A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/B164C08C521048D5AD517C07612D424F$EXT"
cp "_temp/SUPER MARIO 64#D3DC02F8#2#0#C3F75878_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/C3893536B44746FCCB94A850C0A08C88$EXT"
cp "_temp/SUPER MARIO 64#DDBF1630#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/F6858B3CAF4E165F90C077EB9E9C505D$EXT"
cp "_temp/SUPER MARIO 64#E0C1A278#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/8AC240D53C410393063B2C275F341118$EXT"
cp "_temp/SUPER MARIO 64#EDB6F794#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Clock Tower/BDA818FF14C98A0E90EE26205D789E73$EXT"

cp "_temp/SUPER MARIO 64#2C99C4F7#2#1#3591A1A9_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Moon/8A3F966E3A778BCCD5F6184EB647309C$EXT"
cp "_temp/SUPER MARIO 64#14E19062#2#0#BE95D06E_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Moon/1442382AC5D27C15C843A7DB7EDB4A20$EXT"
cp "_temp/SUPER MARIO 64#636C3653#2#0#5F4E923D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Moon/AF6E13CCC6C181DD8A68B26EFAA76585$EXT"
cp "_temp/SUPER MARIO 64#B5F341EB#2#1#FD16535A_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Moon/56EE93505F9BBA37089166FC07556EC8$EXT"

cp "_temp/SUPER MARIO 64#6B706C8B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Window/D9CA88296BB569EA3A010B2E979A4E19$EXT"
cp "_temp/SUPER MARIO 64#53C0EFCC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/Window/FB8F46A74FD7B51A09F81D5AE0D27C06$EXT"

cp "_temp/SUPER MARIO 64#0B73F9A3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/253F34A3236502A31AF13D91664B66E3$EXT"
cp "_temp/SUPER MARIO 64#7A608357#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/BFEFF7995CD87DAF674827E4216B66E6$EXT"
cp "_temp/SUPER MARIO 64#8A331BC4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/BEF08873BD4E85571EAD01A8B1B45F81$EXT"
cp "_temp/SUPER MARIO 64#53ECF35E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/2B604E6B9A5A28EDC65019AC43816F7F$EXT"
cp "_temp/SUPER MARIO 64#80FC8AA8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/897962CA86B958430339E656FBFE9C3B$EXT"
cp "_temp/SUPER MARIO 64#629DA783#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/0D6366C376F4026AC2AFE2B057F82FBB$EXT"
cp "_temp/SUPER MARIO 64#851C4A25#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/18E2FF59A4241490FF4CEB528E437BCC$EXT"
cp "_temp/SUPER MARIO 64#78974486#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/6E0A8C37EAA4813D2A4F6122D27D406F$EXT"
cp "_temp/SUPER MARIO 64#83406550#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/E001F6FB8CF6D9086FB83205C73177AD$EXT"
cp "_temp/SUPER MARIO 64#A1F01C30#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/4BAA9EAD39159D6A92FA71299A78EE76$EXT"
cp "_temp/SUPER MARIO 64#A79B3B4B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/DDF9D494ECDF2C9C9C11CAD47A4F8A89$EXT"
cp "_temp/SUPER MARIO 64#BC914340#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/005FEBD6B8C0E196457AE3EB58849424$EXT"
cp "_temp/SUPER MARIO 64#BECCF3BF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/108E266A30B34143300F004CB0DC2208$EXT"
cp "_temp/SUPER MARIO 64#C49AA634#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/24A8B039AFE26B3B6D05FCF1E8AECC1A$EXT"
cp "_temp/SUPER MARIO 64#E0319CE8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/7229AE5122F6109CA10B5C50026B45D6$EXT"
cp "_temp/SUPER MARIO 64#E6CE8CC2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/85F62A370B3FEA5CCDD3F8ACBC1F9CF6$EXT"
cp "_temp/SUPER MARIO 64#E98E04AD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/EC5E7F86E134CE8FD852BAB7E1B581EE$EXT"
cp "_temp/SUPER MARIO 64#F04282FD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/01 - Castle Outside/9CB5B5247F2C6D81AB2D085618ACD583$EXT"

cp "_temp/SUPER MARIO 64#C7963CE2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/Painting/5D195B28B06D3D69A8F5B21EC222282F$EXT"
cp "_temp/SUPER MARIO 64#C6348997#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/Painting/56B0B953AFB200E818F9B5B5F7E491C2$EXT"
cp "_temp/SUPER MARIO 64#04ACE579#2#0#C71C3FB0_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/2006D508B4897A2474DEE57201E14A41$EXT"
cp "_temp/SUPER MARIO 64#06FF13AD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/8DBED7DDE3A66FFE466670427CD506D8$EXT"
cp "_temp/SUPER MARIO 64#5DC3A38D#2#0#89D4ABD7_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/FE10BB8148BF4C83612A79EEFF9904DA$EXT"
cp "_temp/SUPER MARIO 64#6F92BBF3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/A12F9F3643B846D07C0770E6C8BF5A52$EXT"
cp "_temp/SUPER MARIO 64#8DCE102C#2#0#51BB7975_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/FDEAB0478C0919E12636EAA62318E438$EXT"
cp "_temp/SUPER MARIO 64#9BB9E993#2#1#92F8F839_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/3AD5675606B393787B3D5AE7B7B246D1$EXT"
cp "_temp/SUPER MARIO 64#59E2EA54#2#0#B81742E0_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/8137D83EF6AB0ED9FC61A8C57B0925E7$EXT"
cp "_temp/SUPER MARIO 64#92A8882C#2#0#C91A7A22_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/1F07014E9A7B8E8512DD403B078EDB17$EXT"
cp "_temp/SUPER MARIO 64#311B4D1D#2#1#8BC520FB_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/134F9518B337841BA8247A5522F1EF99$EXT"
cp "_temp/SUPER MARIO 64#26041B9F#2#0#A2EF2F38_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/B66A6004EE8EC06EE59794B22748CED3$EXT"
cp "_temp/SUPER MARIO 64#815167A4#2#1#0E6E9CFF_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/39D04F49A7CCD314A5A2BBB24FD7338F$EXT"
cp "_temp/SUPER MARIO 64#C342A566#2#1#D618D3A5_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/B4F524ADCB622C4780BC22A83A03D8F4$EXT"
cp "_temp/SUPER MARIO 64#D56BE229#2#0#9B062622_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/3E7F06604C2A7CE3A5746C0180A946A5$EXT"
cp "_temp/SUPER MARIO 64#E58BECB8#2#1#31F54CF2_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/4B8C0BB83B06077D67C37315545EF213$EXT"
cp "_temp/SUPER MARIO 64#EF05EE0C#2#0#3B4ACD8D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/C51066A36130129FB4373A677F6FC3F7$EXT"
cp "_temp/SUPER MARIO 64#F55C3ECF#2#1#AAC9A568_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/02 - Castle Inside/816DFFDA0904213FB44EE110F4F80499$EXT"

cp "_temp/SUPER MARIO 64#1A62F332#2#0#B56624E6_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/7CD721AAEE87CCD14A30A2F784E9C7FD$EXT"
cp "_temp/SUPER MARIO 64#3C65ABFE#2#0#15D75BD5_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/6AD1A2C07DE800C64509524BDC8754F3$EXT"
cp "_temp/SUPER MARIO 64#3C70A8C5#2#1#4B2C8244_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/FFFF9C824574557616FBF43E762DA5AD$EXT"
cp "_temp/SUPER MARIO 64#3F689B3F#2#1#132C1922_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/D8855B19CA8596C2A850F66469EDEBA9$EXT"
cp "_temp/SUPER MARIO 64#7CCDA8DE#2#1#22658933_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/791811DF2678005E84BCC3E4C3E931D6$EXT"
cp "_temp/SUPER MARIO 64#9A688960#2#1#00007636_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/DC18F0FD0773490400FA3B6C3C9BE5FA$EXT"
cp "_temp/SUPER MARIO 64#33AAF7F0#2#1#FA40718B_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/3BEB4B9DF50F2C6C380194FF4A25F78F$EXT"
cp "_temp/SUPER MARIO 64#66C713AE#2#1#4702C77B_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/750EE9654CFDB26A861B466E5CD35F6B$EXT"
cp "_temp/SUPER MARIO 64#66D791D5#2#1#93F6E353_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/5B7277E37B4C43D50073D5DF2B4A6E91$EXT"
cp "_temp/SUPER MARIO 64#70C33E7F#2#0#AA187864_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/2422E3ED9B83542E87058D038A187279$EXT"
cp "_temp/SUPER MARIO 64#950F2575#2#1#3EC72DB6_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/F328F7672F853D5A8CEF519EDA2B7102$EXT"
cp "_temp/SUPER MARIO 64#3138DCCF#2#1#7809493B_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/5E7AA46450C7F88A9CB9716A50E65FF3$EXT"
cp "_temp/SUPER MARIO 64#4864DD68#2#1#2C6D94F4_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/C5AD3A0237283799AE8301A71FE5A803$EXT"
cp "_temp/SUPER MARIO 64#5291E049#2#1#BDA04531_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/A06C60DF4CF91EC3EC59C2CEFE2093B3$EXT"
cp "_temp/SUPER MARIO 64#5489CD16#2#1#5386DC0F_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/3D7062B72AAFB884A1C182EFA7E2B042$EXT"
cp "_temp/SUPER MARIO 64#493229EF#2#0#321F3856_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/B5FB42850469DEC1CF532EC13F9FCC73$EXT"
cp "_temp/SUPER MARIO 64#873944BC#2#1#39F494EB_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/AF45C7B9F8F429F52789205E9E15B32B$EXT"
cp "_temp/SUPER MARIO 64#A0B5BD4E#2#1#F161E63A_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/95AA84F88A1CE118A260247B69C0260D$EXT"
cp "_temp/SUPER MARIO 64#A4FE9CF7#2#0#9641D724_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/CB763BFF43B75BC6F26C5E7FBB4DBD7A$EXT"
cp "_temp/SUPER MARIO 64#A5F6F1D3#2#1#D6C830EA_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/EEBC2149B2D890116C37A313F52DE80B$EXT"
cp "_temp/SUPER MARIO 64#A77B61C7#2#1#C2F71BE5_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/BD7A435876FC744D9C10D3AD288EEF69$EXT"
cp "_temp/SUPER MARIO 64#B4FB8523#2#1#650866C5_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/37861818FA86A506FCA1426F973E7665$EXT"
cp "_temp/SUPER MARIO 64#D05E9698#2#0#66626A78_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/D60F88B783A8CC8D0825099EBF2EDD45$EXT"
cp "_temp/SUPER MARIO 64#D4B7CE79#2#1#2F2CE9FC_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/4AB59EADA3122E3FC6BCB5CC5F455276$EXT"
cp "_temp/SUPER MARIO 64#F4DCAA4B#2#0#A324B186_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/88FDE242D940C63ABD294CEA92BB1897$EXT"
cp "_temp/SUPER MARIO 64#F2773486#2#1#B7C95E72_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/C0EF337D0070AB671FC8336BC7D03F08$EXT"
cp "_temp/SUPER MARIO 64#FFE51399#2#1#F9A79EEE_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/1D1CCC504DE26B2251FF4A1762F2C838$EXT"

cp "_temp/SUPER MARIO 64#03D161D3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/416EE9A58D5A9EE3B1A2C4BAD4E0C84A$EXT"
cp "_temp/SUPER MARIO 64#1C08570A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/C48C37D37044CDB61505D75333DEE07C$EXT"
cp "_temp/SUPER MARIO 64#1FD5472A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/82BC060AC672CE0965134E3BFC08696C$EXT"
cp "_temp/SUPER MARIO 64#4B88CF3A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/DD777E3E2F9E9067133F29B31A536FAB$EXT"
cp "_temp/SUPER MARIO 64#4D33D303#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/92EF83150978EF41A0C14108D7DCEC13$EXT"
cp "_temp/SUPER MARIO 64#4FB80A30#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/21A593CD81CF1D30AFFC2F270C06DB37$EXT"
cp "_temp/SUPER MARIO 64#4FD26C4E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/4819AD5A9E91724E19BB6FDD81165E13$EXT"
cp "_temp/SUPER MARIO 64#7C4D59D8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/F7972DA23CC595873AEADCCC3463F01D$EXT"
cp "_temp/SUPER MARIO 64#7DF2679A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/C3ABE71A2FACC4D8AA7E2277E95743CA$EXT"
cp "_temp/SUPER MARIO 64#8B0019CF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/B1C7BF50966CCCB51AB840A6E22AC80B$EXT"
cp "_temp/SUPER MARIO 64#22C8C164#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/54BD387846234F51D5FA51978A2971E1$EXT"
cp "_temp/SUPER MARIO 64#36EFF375#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/DDBB477B7E23FC6CA70D60D971D74CFE$EXT"
cp "_temp/SUPER MARIO 64#44EA1CA6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/0DB6C255CDE2D39377B9DF84213ECBBC$EXT"
cp "_temp/SUPER MARIO 64#46E4A09F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/6138F698D3221AD5F0E4AAF8C02F277F$EXT"
cp "_temp/SUPER MARIO 64#49FBAE0D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/BB80DF90C0AC891A807DC1D52E5619C9$EXT"
cp "_temp/SUPER MARIO 64#58DE2F73#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/89BC2EEBD3331F9AD260A3D26AC16DFF$EXT"
cp "_temp/SUPER MARIO 64#97F012F2#4#0_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/6943D4C14929FE5DBEB740B2939B2F9B$EXT"
cp "_temp/SUPER MARIO 64#100A7117#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/FD2877339C04459D9564C61259695374$EXT"
cp "_temp/SUPER MARIO 64#106A5E4F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/ECD025FDD843765C21E6CEA103E8213B$EXT"
cp "_temp/SUPER MARIO 64#629E6B5D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/8CA94DAA609E9343DDDEBA336EE46A7A$EXT"
cp "_temp/SUPER MARIO 64#1616FBDF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/4EE9503844C5B63E78CCBC40BF95F58E$EXT"
cp "_temp/SUPER MARIO 64#5689EF6D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/D3FD1EC90D376738CCD69D139C1E6866$EXT"
cp "_temp/SUPER MARIO 64#7332F86F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/73705B44D475E5BAB30B78F65887BCE5$EXT"
cp "_temp/SUPER MARIO 64#15458B2D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/A8CCB822F7A07BFF8674A1496DF11ABE$EXT"
cp "_temp/SUPER MARIO 64#39914F8E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/746F4B9C06F28A0A6E63A9B7EFA0F2F6$EXT"
cp "_temp/SUPER MARIO 64#54648A7F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/79C8F1B6759A45CD7653F3D44C60DFC8$EXT"
cp "_temp/SUPER MARIO 64#480100F9#2#0#16DE91DA_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/6F4C84F9DA4FC9908EF8D29BD3FB1884$EXT"
cp "_temp/SUPER MARIO 64#4761737D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/A04810C81858F6903CD39D1B56D59012$EXT"
cp "_temp/SUPER MARIO 64#96516422#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/933224DF91D1FBE33F6BC278D63036A4$EXT"
cp "_temp/SUPER MARIO 64#AC0B00E8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/E834F697FD4A33EF4F495ED57E0AFD1B$EXT"
cp "_temp/SUPER MARIO 64#AFA65EA9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/F046733695AC5AAABBC9F122E243F5E9$EXT"
cp "_temp/SUPER MARIO 64#BEE0C6E7#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/12167A5B36C9323E15A781AAC23994F1$EXT"
cp "_temp/SUPER MARIO 64#C1187DA8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/28FFF4BFBA556C16324A0F9C8349C99F$EXT"
cp "_temp/SUPER MARIO 64#E3F5911C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/405FFE73094B932F7CE18BD3DD6652FD$EXT"
cp "_temp/SUPER MARIO 64#EB8391D1#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/689BB0A6420F54513C7EB245BB4F9595$EXT"
cp "_temp/SUPER MARIO 64#FD449308#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Swordsmith/4C6417B76BD33608951D7C21AF320C69$EXT"

cp "_temp/SUPER MARIO 64#2E286DED#2#0#8175CB5D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Wario/0DE50D53401483846B7DE0EAB2D905D2$EXT"
cp "_temp/SUPER MARIO 64#C8A84EDD#2#0#93774494_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/01 - Mountain Village/Wario/980C7ED8816A6F2E92F8E11F9F8026EB$EXT"

cp "_temp/SUPER MARIO 64#5F63C926#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/7CE5B8F77CAA42D580D1523B9E4F746D$EXT"
cp "_temp/SUPER MARIO 64#7CC2DD04#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/08D97DB6690C14931129DD5E6E6CF82E$EXT"
cp "_temp/SUPER MARIO 64#8BFFA79D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/0801DE7AF8928AFCFC61A42098705655$EXT"
cp "_temp/SUPER MARIO 64#8804BE16#2#0#EDC213B0_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/E20E9CD427C52F80DE072DFA07733216$EXT"
cp "_temp/SUPER MARIO 64#B2E5EFDD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/8158DA748CA4185C66D067D0B012E47B$EXT"
cp "_temp/SUPER MARIO 64#D1756FD8#2#0#73CCF7BD_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/D132BD2BBB20267A76B1C99AB6C6EB3C$EXT"
cp "_temp/SUPER MARIO 64#ED4140AA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/02 - Fairy Fountain/DAC6D8D63AA8F2D0B3697212A1992EA8$EXT"

cp "_temp/SUPER MARIO 64#01C3F931#2#0#A5B1BDCA_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Moon/ACDFF1A16A07A74C539B76E4A46D8855$EXT"
cp "_temp/SUPER MARIO 64#30D98CDC#2#0#8172A68A_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Moon/FF4402D88F0874AB26F1E5187B15C34E$EXT"

cp "_temp/SUPER MARIO 64#7B833F2C#2#1#EFCE8BEB_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/FE0262B57419E6C07F5908F0E7B33531$EXT"
cp "_temp/SUPER MARIO 64#7FC2AC31#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/748B687DA28A5F31F9F29C9917B86D7C$EXT"
cp "_temp/SUPER MARIO 64#37B0E48C#2#1#E768AF94_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/2081FE4C06E8F5B6FF1DB258C269BC38$EXT"
cp "_temp/SUPER MARIO 64#56ECB8C5#2#1#E1909438_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/96F41470EB027CD155EF2B041D5D2064$EXT"
cp "_temp/SUPER MARIO 64#98862EA1#2#1#367EECB9_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/94ECC7B190BC11E7C49D278D3049EAFB$EXT"
cp "_temp/SUPER MARIO 64#A010B97C#2#1#8520E45B_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/F81587B594B7DA4164D8C74BDDBBFBE2$EXT"
cp "_temp/SUPER MARIO 64#A88B4709#2#1#8A499473_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/0E6C29B6D8C76FC98FCCF1FDDB72079B$EXT"
cp "_temp/SUPER MARIO 64#B2FB02EA#2#1#5E8DF983_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/5C6F0102423321337DB9E9791D7547C2$EXT"
cp "_temp/SUPER MARIO 64#D6154A94#2#1#307C40A3_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/Owl Statue/A03F3F0B59AE5A0FA779E8EE0791E132$EXT"

cp "_temp/SUPER MARIO 64#00DBC934#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/F80111936005FFDA59879EE4E52D5D23$EXT"
cp "_temp/SUPER MARIO 64#03D9A011#2#1#86E54F8C_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/69661722E030858085F661CEBFB4CBBC$EXT"
cp "_temp/SUPER MARIO 64#6F3C9983#2#0#B35D6CEF_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/C9BBD25252A15E0879BBF4BE09FC24BA$EXT"
cp "_temp/SUPER MARIO 64#7D02FD0D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/FD8886CA9A2CA724BD1F0930CD61AE8A$EXT"
cp "_temp/SUPER MARIO 64#56D29FA9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/05F619C756661EC4A8D306A8ABC5F24A$EXT"
cp "_temp/SUPER MARIO 64#87A3C113#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/7B5061EFBA5DFE7FD4638224F9957A78$EXT"
cp "_temp/SUPER MARIO 64#138BDC57#2#1#998EA410_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/D7B1D819B65C86FC6551B547793E2C5D$EXT"
cp "_temp/SUPER MARIO 64#234F1DE9#2#1#8455215A_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/76916CCE7E4A2D1A2139D33EF84C48CA$EXT"
cp "_temp/SUPER MARIO 64#780F45D7#2#1#D68DC9BA_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/B525A29ADBA82EA4157EA7946075E9C4$EXT"
cp "_temp/SUPER MARIO 64#2056E1F3#2#0#B9C8A9DD_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/6EB268D8FD7CB1064325F104178A532F$EXT"
cp "_temp/SUPER MARIO 64#8287F1D9#2#0#49B40384_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/BC06EC0B9A505C4B409CAD46BB2D810E$EXT"
cp "_temp/SUPER MARIO 64#665338E3#2#0#EF81B827_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/F72C1940DA5FEA268C1B01D4C7EA1F9F$EXT"
cp "_temp/SUPER MARIO 64#BF12165A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/2BD7A3418216ABF81EB0951444486A71$EXT"
cp "_temp/SUPER MARIO 64#E3AD8C9E#2#0#493F29A6_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/CBDE687AE0A2340DC0B5F12419DD2607$EXT"
cp "_temp/SUPER MARIO 64#FA228E5B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/03 - Snowhead/BB0DC7A584386B5F5814E103894B9E74$EXT"

cp "_temp/SUPER MARIO 64#01C6F8EC#2#1#6614209B_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/7477A111C5AA6B79C7AC5CF9F2C7621E$EXT"
cp "_temp/SUPER MARIO 64#084C51AC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/A96FE17E5BF5F99D451CBC958537274D$EXT"
cp "_temp/SUPER MARIO 64#2DD689B4#2#1#7BAA27F6_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/240DDACED99B15902F17B7068838CD9C$EXT"
cp "_temp/SUPER MARIO 64#3C952A35#2#1#BB6C26D0_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/4FEBDDE836BF4AD6666D050AE2D07AD7$EXT"
cp "_temp/SUPER MARIO 64#3D30E92A#2#1#A3E1CF2D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/939558B7C215E118FC923335647D90F1$EXT"
cp "_temp/SUPER MARIO 64#4A2735DB#2#0#27049F14_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/0512E3F9428E2CD45B4131DF42E9EB90$EXT"
cp "_temp/SUPER MARIO 64#6A9B9F1B#2#1#84035AA7_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/2513318C6BC66DF7346827BB73B0C786$EXT"
cp "_temp/SUPER MARIO 64#6D11CE46#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/65F559557EB1FA293453839B5FB7022D$EXT"
cp "_temp/SUPER MARIO 64#40BE3FB9#2#1#8F2039BF_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/5714B5D968AB29C55C6ABE490D417F32$EXT"
cp "_temp/SUPER MARIO 64#45BEEC60#2#1#1DB4A17D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/8659EE1AADAAD0ACA0F6D1EEBACA4001$EXT"
cp "_temp/SUPER MARIO 64#94CDD2F6#2#0#53A2063D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/2C44A500D426CC93B5B2E07C1718AF0F$EXT"
cp "_temp/SUPER MARIO 64#187DA85E#2#1#78A75C57_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/CDB7194CE6158CD31CCB6A12077AE190$EXT"
cp "_temp/SUPER MARIO 64#661D9F61#2#1#BF564677_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/705AFFAAC82158F2F4BF3B8121BE4C98$EXT"
cp "_temp/SUPER MARIO 64#783BC965#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/872C2157694776516A8A0B25E7D0A640$EXT"
cp "_temp/SUPER MARIO 64#803DCBC2#2#1#8895432C_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/9A7409FAFFAA4EBC1C25DD2F300F45F9$EXT"
cp "_temp/SUPER MARIO 64#812FA3DF#2#0#4EA170D0_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/F6F49D021449FDE3A404892EE93328F0$EXT"
cp "_temp/SUPER MARIO 64#6214F622#2#1#B1D77346_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/FEAF0881F5E95E6D2D7F3499069C19CC$EXT"
cp "_temp/SUPER MARIO 64#53668AD1#2#1#E8BFD1CA_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/2E0F236B1EFCE5026A968A012FFDB725$EXT"
cp "_temp/SUPER MARIO 64#227303EC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/0733E1BA7C77644B892875D8E44F5FC6$EXT"
cp "_temp/SUPER MARIO 64#961146E0#2#1#2FEBEE4E_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/E4E0CAB5CB80FBA215AF24DFDCE5CB03$EXT"
cp "_temp/SUPER MARIO 64#30183141#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/E1A400937A48C109FD83E46D8471EBF9$EXT"
cp "_temp/SUPER MARIO 64#60580222#2#1#09E7D155_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/60252CACBA874C5B195AEC4DCF76D3A4$EXT"
cp "_temp/SUPER MARIO 64#94141540#2#0#9CEA853A_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/8E63CFEE7ED44E7824B847E79E3ECA18$EXT"
cp "_temp/SUPER MARIO 64#A13D9F26#2#0#55369A63_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/F89658A78CA9E5BFFAA8CA1604EDBF1F$EXT"
cp "_temp/SUPER MARIO 64#AD30FF2B#2#1#3E45A608_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/EE4305C8CF1FB1ECA5F0D867E771CB27$EXT"
cp "_temp/SUPER MARIO 64#ADF5927D#2#1#9D1C2316_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/FDA8030AC490430357A7D5A2DF8B9658$EXT"
cp "_temp/SUPER MARIO 64#B0618895#2#1#CE9C5222_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/05A7F7E4AFEC1CFCA6C66CA190CA39BE$EXT"
cp "_temp/SUPER MARIO 64#C6BA170A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/2AD31CFB5DA56CD3608F77F9FE52C34D$EXT"
cp "_temp/SUPER MARIO 64#D99724CD#2#1#FEBFEAC0_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/8939752AB63B713A677AEBB212CCFF2D$EXT"
cp "_temp/SUPER MARIO 64#E2DC76D7#2#1#6604AF79_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/DFD632805FE3676730FA401BAB50F48D$EXT"
cp "_temp/SUPER MARIO 64#E2F43A60#2#1#E6A568CC_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/F5487C0B7813186BC66325E303BA6FD8$EXT"
cp "_temp/SUPER MARIO 64#F75FC8CA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/04 - Stone Tower/65B728860878BFDDDCF5FD9B7B4AB7BF$EXT"

cp "_temp/SUPER MARIO 64#014DB024#3#1_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/999D9049C4488B13069B1A73ED39CA30$EXT"
cp "_temp/SUPER MARIO 64#9C7557BF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/BADCA7497B36A1617986130396CB7610$EXT"
cp "_temp/SUPER MARIO 64#A2E62A21#3#1_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/4BEEA22DB413B4BFD407680F57DA6E6F$EXT"

cp "_temp/SUPER MARIO 64#B326E47C#2#0#23612BA4_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/05E1C79BE3AD544D159B5363C87DAA47$EXT"
cp "_temp/SUPER MARIO 64#EE15813C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/D8D8CCDBF91131929206965B497F255C$EXT"
cp "_temp/SUPER MARIO 64#F7E36749#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/FF25D32751C9BD06EA52B4FC3C5C44F4$EXT"
cp "_temp/SUPER MARIO 64#1D44F820#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/44CEE5447FB0380EEB48887363AFFBA9$EXT"
cp "_temp/SUPER MARIO 64#3D3B45FC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/4C332B722A21F9D2F4ADB85F9C817950$EXT"
cp "_temp/SUPER MARIO 64#319FFE63#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/31B2FFF22CE1A9F335B7D85BB96B3D24$EXT"

cp "_temp/SUPER MARIO 64#3161F766#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/ABBB8ADB6C1A3AC02641CC32FF86F030$EXT"
cp "_temp/SUPER MARIO 64#4EF37CB8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/7C3BCA8C82EC959F8D7D480BD0106F96$EXT"
cp "_temp/SUPER MARIO 64#50C13917#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/6C0054E5E798D43FDD7A9FE6CA025E2F$EXT"
cp "_temp/SUPER MARIO 64#5E0D1145#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/2CEE60ADC490CFE22B2FB30C17199BCA$EXT"
cp "_temp/SUPER MARIO 64#76725F1E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/6133FF92CF63A49A831C68355C60FD14$EXT"
cp "_temp/SUPER MARIO 64#78D54BB8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/B327AD759BC5F3F06812D0A2960F550C$EXT"
cp "_temp/SUPER MARIO 64#819E99CB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/E5DF348A11CE41782B21E03E05BEA9E7$EXT"
cp "_temp/SUPER MARIO 64#8F14F703#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/13716A665D52B46E32F7C2F016205370$EXT"
cp "_temp/SUPER MARIO 64#BD0A1949#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/61D0CE283872B0F3A6A4304D0BB072D5$EXT"
cp "_temp/SUPER MARIO 64#D60AAE22#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/95ACD6E7D81FD39E0EBE193C455F85CE$EXT"
cp "_temp/SUPER MARIO 64#F6D91CF3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/BB49F8AB141E5C4B31C332BE27E7DA23$EXT"
cp "_temp/SUPER MARIO 64#FAF33CDB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Astral Observatory/C750E299FE3BB053A916A92C38FC82BF$EXT"

cp "_temp/SUPER MARIO 64#1A5BBA1B#2#0#49EC4FC3_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Box/DEAD673CF84348AD4493695EB527BA60$EXT"
cp "_temp/SUPER MARIO 64#7FFC1DD5#2#0#D352C69B_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Box/6E37B1C4B76BE44FB32515B50B28CC0A$EXT"
cp "_temp/SUPER MARIO 64#8B390D7A#2#0#33114AC7_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Box/16435ED2C8A72CABCCBE05E8C5A71CBF$EXT"
cp "_temp/SUPER MARIO 64#47772DE2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Box/164668EC2C865BBAD4256BF65BFD82CA$EXT"
cp "_temp/SUPER MARIO 64#DD71DA68#2#0#C56A3D4D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Box/FCEE5A5E286C204FE7735A5B160899FF$EXT"

cp "_temp/SUPER MARIO 64#014E3099#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/6B68CD4666B92390CD9B71ECD1D6ED47$EXT"
cp "_temp/SUPER MARIO 64#A724A9EF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/A531108A69A4406F3C381483BC741AE3$EXT"
cp "_temp/SUPER MARIO 64#CF9A56FF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/CE7E788D394E0F0B0966F0431E2BC8D1$EXT"
cp "_temp/SUPER MARIO 64#DD6BC07B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/A82D7C66DC0AC8625BC83DA73FC16081$EXT"
cp "_temp/SUPER MARIO 64#E384C7C0#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/5D7C2312A4FFEA9542C0677B4F96C4DC$EXT"
cp "_temp/SUPER MARIO 64#F15D25A7#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/3AE64D9417128D4D575206C3B020166A$EXT"
cp "_temp/SUPER MARIO 64#FECC55D2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Doggo/F104F414DFC3AEB61741B50C6D50363D$EXT"

cp "_temp/SUPER MARIO 64#029BB7DE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/BE8811064D95EAF9C58B2D203416079C$EXT"
cp "_temp/SUPER MARIO 64#2C974E90#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/993EA4F687A5FE201638E1596F7FBD4A$EXT"
cp "_temp/SUPER MARIO 64#2E659D7E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/E3CAD28227D98EEB5107CE9046C70463$EXT"
cp "_temp/SUPER MARIO 64#3DE9A2AD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/9EF49488CFB4AAAF094DD4CC958B3508$EXT"
cp "_temp/SUPER MARIO 64#4D69F881#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/029D117C0924233E9244A490DBA37606$EXT"
cp "_temp/SUPER MARIO 64#4E43BA34#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/366FA0E433DB0B2BFF8B05D964AB9C07$EXT"
cp "_temp/SUPER MARIO 64#5F6EE7E7#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/C2674BE20C027EBAD923072715C053A9$EXT"
cp "_temp/SUPER MARIO 64#6EA8E329#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/488BBEB5B64079921C553B8DDEB1D977$EXT"
cp "_temp/SUPER MARIO 64#7C656200#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/AE79E689F5AA8AF6B21A61360B30511A$EXT"
cp "_temp/SUPER MARIO 64#9CEE610A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/0A10D47C2C9421962E3DF0BAB038EACC$EXT"
cp "_temp/SUPER MARIO 64#23E8BE33#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/0BAAC2567764B3995EA5B15599B636BF$EXT"
cp "_temp/SUPER MARIO 64#66CC89DB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/74DCD4FB93FFEC778D843E62FA101904$EXT"
cp "_temp/SUPER MARIO 64#86A3E54F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/C64CA38459F94F7C7E0980DC209FE381$EXT"
cp "_temp/SUPER MARIO 64#995CB203#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/A318D47E3C3A156B7B9D3F89488DC4B2$EXT"
cp "_temp/SUPER MARIO 64#7384B0C6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/90ABB6664BCB941793D32F9DFDA5FC56$EXT"
cp "_temp/SUPER MARIO 64#10521ADC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/8C2CC8DA9C46E66DC9484FF4D78908B5$EXT"
cp "_temp/SUPER MARIO 64#5239918F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/8B02CAACF7164C976882D37AAF84E1D0$EXT"
cp "_temp/SUPER MARIO 64#A2E7FA7A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/11E3A25BED8D59245B5C9D0A4296A0B8$EXT"
cp "_temp/SUPER MARIO 64#AD4E1E62#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/AE03FDD367510887C7A18254674980D9$EXT"
cp "_temp/SUPER MARIO 64#B6E49B8A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/DFC4A385653DBFD9B201E8A8EAFF00A2$EXT"
cp "_temp/SUPER MARIO 64#C1C9356F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/81CF331836113B6CA35B5CAD48E52E9C$EXT"
cp "_temp/SUPER MARIO 64#C336FA3F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/AA89BF93CFA70197A4979E5B2527DC6C$EXT"
cp "_temp/SUPER MARIO 64#C644E81D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/936AC21E62DFB2DFB0633424F575A0CD$EXT"
cp "_temp/SUPER MARIO 64#D7BCAEB2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/4215F6F63D75E5D8515DC9B66C112A9D$EXT"
cp "_temp/SUPER MARIO 64#D127C2D2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/F7480286D9CA2656ACF557BC1FEF1B83$EXT"
cp "_temp/SUPER MARIO 64#DA03462A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/35A585A11F6BC6A7AD880F02214892B1$EXT"
cp "_temp/SUPER MARIO 64#DD250357#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/659A43F63E403F32C70276946DF8D2A9$EXT"
cp "_temp/SUPER MARIO 64#F7C87063#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/C4BBB611738CEB7F4BC4F50CBD7BE78E$EXT"
cp "_temp/SUPER MARIO 64#FC605025#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Link/AADC83842D959B405A8C63E1697FC779$EXT"

cp "_temp/SUPER MARIO 64#85700842#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Luigi/E6709E99646DC507646C75FDFA436BAC$EXT"
cp "_temp/SUPER MARIO 64#B35D56A5#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Luigi/E0F1E892E659E2640CAEBF0E52AFC940$EXT"

cp "_temp/SUPER MARIO 64#A06259F9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Mario/87B0B9E8E3824CD0330BB4A3258DD51A$EXT"
cp "_temp/SUPER MARIO 64#C4DA8474#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Mario/E8BFBC5BDF4B13954779018C3B276918$EXT"
cp "_temp/SUPER MARIO 64#E6E92538#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Mario/D02A8BD3C58B7C07EFEF08EB03176979$EXT"
cp "_temp/SUPER MARIO 64#E95D3BCA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Mario/6750B9C0A6413C239418F42754026AF6$EXT"
cp "_temp/SUPER MARIO 64#EFC3E0C3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Mario/E5CF73A4B7753A6E26FF11FC68972B99$EXT"

cp "_temp/SUPER MARIO 64#6556690B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Moon/1A9FD0AA221E16168915FC6DB76A112A$EXT"
cp "_temp/SUPER MARIO 64#D3362970#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Moon/CF6CCB48A14E039B821C7E22E05BC138$EXT"

cp "_temp/SUPER MARIO 64#2F02016B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/CC78633B06213BAA40B036538B1E95FD$EXT"
cp "_temp/SUPER MARIO 64#2F630D34#2#0#CBFCD5BA_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/91946D25717ECA219345ADE2CF40A737$EXT"
cp "_temp/SUPER MARIO 64#99B2711D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/0B03B00A8C82D46A698122D690D7F9FC$EXT"
cp "_temp/SUPER MARIO 64#651B552E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/CA3E3D97E52811E93306A69716FF5E9B$EXT"
cp "_temp/SUPER MARIO 64#4964EBC8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/040F84EA4084F6DA50546CB2D89B706C$EXT"
cp "_temp/SUPER MARIO 64#9012E358#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/58BDD8FF2E8C56DB5F835AF93289B7B4$EXT"
cp "_temp/SUPER MARIO 64#39358D61#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/68BD0E21BBC5756577D946F17BAA56E8$EXT"
cp "_temp/SUPER MARIO 64#281483D8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/96B22A56A8A3267919B5EA9246E79355$EXT"
cp "_temp/SUPER MARIO 64#B172CDE2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Research Lab/4B17B61AC815CE728B69E51915FBE66F$EXT"

cp "_temp/SUPER MARIO 64#045E7D13#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/4C5E0919B81782D585F39969EDEDFBFA$EXT"
cp "_temp/SUPER MARIO 64#0C3123BA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7DF03D8D41C13922D78E3F54D7EE1119$EXT"
cp "_temp/SUPER MARIO 64#0C4725EC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/0ACBBBD978428844BF424BD661DD8183$EXT"
cp "_temp/SUPER MARIO 64#14F74247#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/119EBA460D85739E0F64D66016BADE5F$EXT"
cp "_temp/SUPER MARIO 64#1715DDF9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/1FF23DDC8F142C2027EE75B2B7710BE0$EXT"
cp "_temp/SUPER MARIO 64#179A9928#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7035BC9AC0174B6133A0F5E3E8DC4615$EXT"
cp "_temp/SUPER MARIO 64#1A5D9C8E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/BF8FD2B9C1F10CAAB3BBE8CB17EF71AB$EXT"
cp "_temp/SUPER MARIO 64#1B6947B3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/6E53437971155CB9BB74FBD25A5C0DD6$EXT"
cp "_temp/SUPER MARIO 64#2B801D0F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/175B21DAF04FC22D397845834408035D$EXT"
cp "_temp/SUPER MARIO 64#2E14BDEA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/C1E4AE1579314F059AAE2339ADF27630$EXT"
cp "_temp/SUPER MARIO 64#2F957982#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/4CBF047766AA8C0C46DE3C5C38828A52$EXT"
cp "_temp/SUPER MARIO 64#32E331D6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/40E4CF3FB3D9961EBE57ACEEB85D1A0E$EXT"
cp "_temp/SUPER MARIO 64#359CCC89#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7359D5B58363D0DAD0879F3DD2FD4224$EXT"
cp "_temp/SUPER MARIO 64#3D77CBCF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/AD6290F5914F4C9E92F6E7A2E7C9B1C1$EXT"
cp "_temp/SUPER MARIO 64#43089C31#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/AA31AD80D309CD7333F64B4C4F1FF205$EXT"
cp "_temp/SUPER MARIO 64#4B857609#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/C12B1BB08F3FAA62A2DDDB12F7A35F69$EXT"
cp "_temp/SUPER MARIO 64#4F36B3DE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/0E72550CD89ACEDE4CFA4DBD09C8A880$EXT"
cp "_temp/SUPER MARIO 64#5170A341#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/1B287B5DA558184C0A4554EF2331846E$EXT"
cp "_temp/SUPER MARIO 64#58C530EF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/2831FB2ED33ADBDAB88D11B21B54F5AE$EXT"
cp "_temp/SUPER MARIO 64#5DBCCF46#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/357F01B15594F956DF648D27BE8E6B53$EXT"
cp "_temp/SUPER MARIO 64#60D13D2D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/126618EC69E08B2C9032BF0D52E890F3$EXT"
cp "_temp/SUPER MARIO 64#6301EB17#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/0661B5035C47B21E8E3A3600FAEC70F5$EXT"
cp "_temp/SUPER MARIO 64#6391D9B9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/A992A56B11B204F3BD30AA98B580DA81$EXT"
cp "_temp/SUPER MARIO 64#667B2C18#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/4B776E25B4B0267BC80B1F3A8D9908A9$EXT"
cp "_temp/SUPER MARIO 64#6CA75508#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/24952438B7C6D678578AEDBE37FA19B3$EXT"
cp "_temp/SUPER MARIO 64#776421EE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/92BBED721CF9E52A165F14B838673669$EXT"
cp "_temp/SUPER MARIO 64#79FF7E0C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/6A3FC1205A07335ECCE391A1CB7C9C40$EXT"
cp "_temp/SUPER MARIO 64#7AAA1CEA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/946423427CBCEF9475DE29DA505C9E9B$EXT"
cp "_temp/SUPER MARIO 64#7F8599D6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/F8FA451026686E09F9BB7D00D9FE1A68$EXT"
cp "_temp/SUPER MARIO 64#830803A6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/BC692AAC59F336392C97D824217E8408$EXT"
cp "_temp/SUPER MARIO 64#83A574FB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/8EDD93EB02E39886577C654BA5013F8D$EXT"
cp "_temp/SUPER MARIO 64#8A08CCB8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/8C25AAC758B0DDED041F14645314385A$EXT"
cp "_temp/SUPER MARIO 64#8D0A4ABF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/EA2ACB3573AFCEEB466EAD582BBDF5FC$EXT"
cp "_temp/SUPER MARIO 64#8EAFAA6B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7C371D98DBBC088FBAE2AAC23989AAF0$EXT"
cp "_temp/SUPER MARIO 64#A0C62F15#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/32E64C0F7D5807EE24188CBE4B75C87D$EXT"
cp "_temp/SUPER MARIO 64#A10B47E9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/19AE018CBD72611CF627027A0B65E746$EXT"
cp "_temp/SUPER MARIO 64#A3C2A7AD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7E3E37AE61AA4DFCD4A1A26CCEE9DB45$EXT"
cp "_temp/SUPER MARIO 64#A4D2404C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/5A5CEB4BF38AC0581F83AB123FFC8969$EXT"
cp "_temp/SUPER MARIO 64#A68890F4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/615C2EA47B7EA138D830F00DCA202813$EXT"
cp "_temp/SUPER MARIO 64#A952B36C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/9771408207C1C5D2168E10E68EB0410F$EXT"
cp "_temp/SUPER MARIO 64#ACA6A6F3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/39183244E9FC599880145CDD32A4B15C$EXT"
cp "_temp/SUPER MARIO 64#AD36D1F2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/D24A7228ECF7B3C3FFA6E5D023063A1E$EXT"
cp "_temp/SUPER MARIO 64#B0AECAA8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/BA06C4AE17FB793D135AD5004D7007AF$EXT"
cp "_temp/SUPER MARIO 64#B4A1BBD8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/25860874195D1D9B906A1C696F2B6CED$EXT"
cp "_temp/SUPER MARIO 64#BAA90BC5#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/083DEC9D60FEADDEB0AC99C41EE5DCB2$EXT"
cp "_temp/SUPER MARIO 64#BBB99C35#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/26767963AB0E8055B47298D7C7E967C9$EXT"
cp "_temp/SUPER MARIO 64#C367F0EB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/268B38643BCDFF318126E43010F35B61$EXT"
cp "_temp/SUPER MARIO 64#C3CEFF00#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/55787D8769837F383EF0747D560FB532$EXT"
cp "_temp/SUPER MARIO 64#CB53DBEF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/465B3CED755A84BE189E08C88E1B9AA9$EXT"
cp "_temp/SUPER MARIO 64#CE0068D5#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/ACE93AD427B606D352ED30F26E43C2FA$EXT"
cp "_temp/SUPER MARIO 64#D06A3E69#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/93410F44FC50934F34CDAB7D5EFA29DC$EXT"
cp "_temp/SUPER MARIO 64#D7766ECF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/69FB77D0C98D87D77400DEB10426BE94$EXT"
cp "_temp/SUPER MARIO 64#D8002E1A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7A548CDF3E02860A50B5784EF9DF4292$EXT"
cp "_temp/SUPER MARIO 64#DCDC19E6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/B1CDA15F1D20617C45DEF346F6082514$EXT"
cp "_temp/SUPER MARIO 64#E2C2911E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/F1272E590D2AB1267C7A2DB9E791FE4A$EXT"
cp "_temp/SUPER MARIO 64#E45792BF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/7890C1F089612F6D3EFE33CAFF2C143C$EXT"
cp "_temp/SUPER MARIO 64#EB99B586#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/60A7E624EAA129D820779631B1D75E71$EXT"
cp "_temp/SUPER MARIO 64#EE27BA72#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/DE97215DAED934430CBC4067CDE2717C$EXT"
cp "_temp/SUPER MARIO 64#EF1B2509#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/D6BB38329A904484738F0D171A2E4DA4$EXT"
cp "_temp/SUPER MARIO 64#EFD33C28#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/470945A0720B60AAE3587682C980C761$EXT"
cp "_temp/SUPER MARIO 64#F1BEB5C6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/0E00DD041B52A3696F2DBFF09C079861$EXT"
cp "_temp/SUPER MARIO 64#F32A50D0#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/072D81823A17AF634ECC8C2EA80A6992$EXT"
cp "_temp/SUPER MARIO 64#F9803304#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/FEC80EEB565BD287B554CDFFE91136A0$EXT"
cp "_temp/SUPER MARIO 64#FD63FB81#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Skybox/AE4D7DA81018FA280D5725963C0D4184$EXT"

cp "_temp/SUPER MARIO 64#04687CB4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/326C67BAD6D2E584C8E45B79F245C575$EXT"
cp "_temp/SUPER MARIO 64#05A114F8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/3568F575E635AECE2E3B139C89F57B02$EXT"
cp "_temp/SUPER MARIO 64#3A2487BF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/F24C59546B83A510C1A0158BDB91CEE4$EXT"
cp "_temp/SUPER MARIO 64#6A01A3CF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/CECC01CDAF071BACEB4A1B4634817FD8$EXT"
cp "_temp/SUPER MARIO 64#71B85162#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/DFD76D7E5263B3AEF095BF0D942FAD9E$EXT"
cp "_temp/SUPER MARIO 64#145B3047#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/3DD7D88D29FBE3D5B8BCB3F128601277$EXT"
cp "_temp/SUPER MARIO 64#603C7590#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/9A04E608F667F95C4290C7F5F0B33D9C$EXT"
cp "_temp/SUPER MARIO 64#8239C457#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/27507EE9DD9C95A29F752CB1FC52750B$EXT"
cp "_temp/SUPER MARIO 64#95780508#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/79F5BFB07093C638FA36555A52ECC970$EXT"
cp "_temp/SUPER MARIO 64#A2E3A293#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/703B262D51F071842B6A42D6D650A40A$EXT"
cp "_temp/SUPER MARIO 64#BFB735FA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/43BBA17CE7A359B055FE81D5237926D8$EXT"
cp "_temp/SUPER MARIO 64#DFBD048B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/2D1E46614F81CBE1CB2EFB43FCCFC98E$EXT"
cp "_temp/SUPER MARIO 64#E1F583B4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/A86FEB19BBA7CB33F3292596D3A845A3$EXT"
cp "_temp/SUPER MARIO 64#EC9D08E7#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/8D29C9F2AA50E0B0B5553A43031375F2$EXT"
cp "_temp/SUPER MARIO 64#FC375A0A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/SM64 Textures/0257FF9E5745D705B2961C5BDB46B1A8$EXT"

cp "_temp/SUPER MARIO 64#4AD2E560#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/A840A23294CCF3EB8B50B4F1974C2FC1$EXT"
cp "_temp/SUPER MARIO 64#CA97EE00#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/CE21E6DDA2E6049913EC665E761CFA6B$EXT"
cp "_temp/SUPER MARIO 64#CE11B23A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/3EDE4D3940E9224217A62D608C34E16D$EXT"

cp "_temp/SUPER MARIO 64#0D567458#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Swordsmith/EAC4925CC8FF94CBA83F0C9F88B643F9$EXT"
cp "_temp/SUPER MARIO 64#698B4673#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Swordsmith/F8303524525FD8980AE9223FC717F10E$EXT"
cp "_temp/SUPER MARIO 64#BF54AF2D#2#0#958B48F7_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/01 - Space/Swordsmith/C0ACDB96B5ACE0C629777DC783CA27AC$EXT"

cp "_temp/SUPER MARIO 64#0B486B6B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/355287C232B49813F355E6965361CD57$EXT"
cp "_temp/SUPER MARIO 64#05C6B872#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/12ADBF744B0236EE3FEBEDECBB9382CF$EXT"
cp "_temp/SUPER MARIO 64#3FDB5854#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/FEA8BF575A92525327442348509F2420$EXT"
cp "_temp/SUPER MARIO 64#5C1EF5FF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/8D1CE03CDC1C8BCE22798F02F0376A67$EXT"
cp "_temp/SUPER MARIO 64#64A7178C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/CE5CB8892DB28A8FBA7EEB1AADFC30A2$EXT"
cp "_temp/SUPER MARIO 64#6119C6B4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/10D6D2416A8213E6BF2EEE5F610D8000$EXT"
cp "_temp/SUPER MARIO 64#205804F2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/4028CBDF51FF82A6FA2B47DBBC4EFE3F$EXT"
cp "_temp/SUPER MARIO 64#AAFDF3C6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/FF1FD8CCF4DA305FBD5BDD552CAA4497$EXT"
cp "_temp/SUPER MARIO 64#B78C4B5D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/624D94FBA9F7E2B0A76CFA2DF7AB3DDC$EXT"
cp "_temp/SUPER MARIO 64#F63BA958#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/2AF695405569FD7E56148EF4CC6E3158$EXT"
cp "_temp/SUPER MARIO 64#F860B95C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/02 - Termina-Te Bowser/9204EBFC56AF01A1ABA577EE156C652B$EXT"

cp "_temp/SUPER MARIO 64#0D113677#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/Bottom/E0E5A01D30E6B352B22ECFAB36DAA30A$EXT"
cp "_temp/SUPER MARIO 64#3D4E303C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/Bottom/C168003EF7B2DF77EAED36CA854DBEA8$EXT"
cp "_temp/SUPER MARIO 64#30D255DE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/Bottom/D2C572CC16F3AEC05B34C2A9F35A2DAF$EXT"
cp "_temp/SUPER MARIO 64#F1699FCE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/Bottom/0239856DC538253A4129B757D8850737$EXT"
cp "_temp/SUPER MARIO 64#F4745FCA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/Bottom/33DAF28A0779E373669FE9FE41C3E498$EXT"
cp "_temp/SUPER MARIO 64#0C3B68EB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/7427E62A45942BCDF773629832B3AB6F$EXT"
cp "_temp/SUPER MARIO 64#118F7410#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/5C3C04BA4CD6B6560700F0630C4A27F1$EXT"
cp "_temp/SUPER MARIO 64#14E628A6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/BE48D347E654BE198A3A341B37C579C2$EXT"
cp "_temp/SUPER MARIO 64#1AE8F329#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/59EF8450BD7E2A2CA61C8F6D950EFC7E$EXT"
cp "_temp/SUPER MARIO 64#22116910#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/9E991F95449DAA15285D5653B6C7FA38$EXT"
cp "_temp/SUPER MARIO 64#26249F56#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/789FB0FFDA6A7E8D0E899C09C16178C3$EXT"
cp "_temp/SUPER MARIO 64#267D48E2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/65D447E6E6104F0C1F58FC7F122B79AC$EXT"
cp "_temp/SUPER MARIO 64#2BDD169D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/B584F4C093D4341B01E1822C72E07796$EXT"
cp "_temp/SUPER MARIO 64#385AE6CA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/B5E1185EF1FABA333F1DA3DC64796F2C$EXT"
cp "_temp/SUPER MARIO 64#473762FC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/DB885FDE93B13F4B7030C8E66D6611EE$EXT"
cp "_temp/SUPER MARIO 64#492BD806#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/0BA11AA7C7E3FC5E373A23723B0B496E$EXT"
cp "_temp/SUPER MARIO 64#58FA58C1#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/D7C20A03755EA3B0BB39F02B77516759$EXT"
cp "_temp/SUPER MARIO 64#5A157E18#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/66F035E010DB6F777C76DC6E7F1DEFC1$EXT"
cp "_temp/SUPER MARIO 64#5B1DA179#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/0E0E9E2136A4D7524A22CFF0887C394A$EXT"
cp "_temp/SUPER MARIO 64#643D25A0#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/F9A186CF84236A19977920BAED4C268F$EXT"
cp "_temp/SUPER MARIO 64#6BBA9D29#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/9A09D0FC83FC0E04FA45E8F1A3A81C07$EXT"
cp "_temp/SUPER MARIO 64#6D33B365#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/40A7E1937AF72238C9D125E460F276D8$EXT"
cp "_temp/SUPER MARIO 64#7529DB46#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/965DB32F7B20D1ACBAFB2A74AC1F9438$EXT"
cp "_temp/SUPER MARIO 64#83277146#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/FC2D131BB326B75ABFA5F5EAFAC5E46E$EXT"
cp "_temp/SUPER MARIO 64#842A7F4A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/B5D522719B83FFF354CBB2C3478C91EB$EXT"
cp "_temp/SUPER MARIO 64#89548F9B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/DC86C0D080E64F8C2E6FF22D9856D68B$EXT"
cp "_temp/SUPER MARIO 64#8C3C5873#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/5D53B1996234F3384880F7436120B170$EXT"
cp "_temp/SUPER MARIO 64#8DFD9E5C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/DAC274FE37F1848CFC2BB1A9C0C13471$EXT"
cp "_temp/SUPER MARIO 64#98907A3F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/D0084DFB4F17557A3DC2733911389F23$EXT"
cp "_temp/SUPER MARIO 64#9D512F1E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/0F0F1E1339AC6E4769CFDC95EF32871F$EXT"
cp "_temp/SUPER MARIO 64#A06FB45A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/7FA7B11CF7A1F014B5F629C211EED91C$EXT"
cp "_temp/SUPER MARIO 64#A4112B8B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/FAEDC9351BC95E3268B3EAB811170B5D$EXT"
cp "_temp/SUPER MARIO 64#AA7F580A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/DE2049DA8FFEDAE9400A0C3EBB546ED4$EXT"
cp "_temp/SUPER MARIO 64#AF25FA1B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/3C941D0CB981C233696A7D1A4447F480$EXT"
cp "_temp/SUPER MARIO 64#D7FF1826#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/A937115BA0035F6634D79D5EAEFFEFCF$EXT"
cp "_temp/SUPER MARIO 64#DE257325#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/5B87031619027BF49AAFA31AAC6CAEF9$EXT"
cp "_temp/SUPER MARIO 64#E6C80BBC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/F22756CB81CF08570C40E7EC18263DEE$EXT"
cp "_temp/SUPER MARIO 64#EBC102DC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/D2E489DDDA4C8C6E89061714165052F1$EXT"
cp "_temp/SUPER MARIO 64#F423FDD4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/3774A2FB64008D88A9FC86C51959BA17$EXT"
cp "_temp/SUPER MARIO 64#F7909C39#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/Ending/0C9111D1EB15404899225F6923410372$EXT"

cp "_temp/SUPER MARIO 64#46F7B9AE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/247DF6E55D2506455E6A391832081E2D$EXT"
cp "_temp/SUPER MARIO 64#58F636DA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/C8B348F793007846B6286AC8A3790B9B$EXT"
cp "_temp/SUPER MARIO 64#399EC3C2#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/2371C223D1DC06D4E6ACCFEFE37A57E9$EXT"
cp "_temp/SUPER MARIO 64#8463BC54#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/7D727D89EBF0C301C60546C957ABABF8$EXT"
cp "_temp/SUPER MARIO 64#A2D391A8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/23BE6FE716CB7FB02F3075F3D3A48856$EXT"
cp "_temp/SUPER MARIO 64#A72D1AEB#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/996DCA79D6B8793E57B05ABEA2ED30FE$EXT"
cp "_temp/SUPER MARIO 64#C02419D0#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Areas/05 - Final/03 - Epilogue/77E388D56470C251AD27D5DAC1221CEC$EXT"

cp "_temp/SUPER MARIO 64#80572E54#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Link/Cap/C31EC25B41228E20BA5A0B37D78702FF$EXT"
cp "_temp/SUPER MARIO 64#99784F90#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Link/Cap/51AC3E69F188807B7807071C7E04B4D8$EXT"
cp "_temp/SUPER MARIO 64#A00FC477#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Link/Cap/29722F4F7492CF288ACEAD1F002AF5FA$EXT"
cp "_temp/SUPER MARIO 64#4CE53111#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Link/Leftover/ACA1CF04D361E351510EC78DAB5C2A25$EXT"
cp "_temp/SUPER MARIO 64#B098CEB9#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Link/Leftover/7C9269FA3F18E82587123D37393DE88C$EXT"
cp "_temp/SUPER MARIO 64#03CB8D31#2#1#0A17C735_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Link/7AD524C441A37A26AA79B5FCCB4C3F07$EXT"
cp "_temp/SUPER MARIO 64#6E2E99E7#2#1#9CFEF9FF_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Link/02D20C6E4AFE374EB79389C1A162D95D$EXT"
cp "_temp/SUPER MARIO 64#F0291EB6#2#1#D60F7F1D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Link/95012944C4B44DAEEEFD3E6B69971104$EXT"
cp "_temp/SUPER MARIO 64#FCDAA0E1#2#1#C093935D_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Link/D1EB5FEE7E3A638A25DB68F7E3F62DC2$EXT"

cp "_temp/SUPER MARIO 64#6C475B5D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Majora's Mask/0D15F6E0BBFD834B2F50461613E3C782$EXT"
cp "_temp/SUPER MARIO 64#A52E629C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Majora's Mask/08848FFB67097B7DE497643538A78DA5$EXT"
cp "_temp/SUPER MARIO 64#A401012E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Majora's Mask/8480C590DB3DB7162087EE26D3AD8A90$EXT"
cp "_temp/SUPER MARIO 64#B0DBD832#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Majora's Mask/F90CB8B76929F7984C24C5C7B60A4EF6$EXT"
cp "_temp/SUPER MARIO 64#B1B3BA64#2#0#B66CFCA6_ciByRGBA$EXT" "$PORT/Hacks/Termina Invasion/Majora's Mask/DD7BEEC8258CE56622AB4D88845543C5$EXT"
cp "_temp/SUPER MARIO 64#F6450A0E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/Majora's Mask/07B90921CA84797774A9E72DD3E14203$EXT"

cp "_temp/SUPER MARIO 64#713C1243#3#2_all$EXT" "$PORT/Hacks/Termina Invasion/Rupees/B0C553DB465205606B29F147C7A529F3$EXT"
cp "_temp/SUPER MARIO 64#B5E54C21#3#2_all$EXT" "$PORT/Hacks/Termina Invasion/Rupees/FB837746267D9FAD74B4C3F24F6E6EC8$EXT"
cp "_temp/SUPER MARIO 64#D31AA916#3#2_all$EXT" "$PORT/Hacks/Termina Invasion/Rupees/EF1A9C849DC3C5634B9DB47BEE11C7ED$EXT"
cp "_temp/SUPER MARIO 64#E7C471FC#3#2_all$EXT" "$PORT/Hacks/Termina Invasion/Rupees/5F09FB056DD749CC00F3C258007482E9$EXT"

cp "_temp/SUPER MARIO 64#07B7AFF6#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/D4F4FF277E69D6778D672DE41169D870$EXT"
cp "_temp/SUPER MARIO 64#316917DD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/30DE9E3BE42C838F5C37C0502CEFFE71$EXT"
cp "_temp/SUPER MARIO 64#A8210CE4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/C27BCD98ABDD7D60CB4896E74A3B81BB$EXT"
cp "_temp/SUPER MARIO 64#F0381B0F#3#1_all$EXT" "$PORT/Hacks/Termina Invasion/UI/6CFA3A831A92EC27988F5BBD1BF61B14$EXT"

cp "_temp/SUPER MARIO 64#4D628A64#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Clock/39460FC1E2CDF5EAD7EF49C098E9B1EC$EXT"
cp "_temp/SUPER MARIO 64#FF9CC7F3#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Clock/957070C7DD3C111511723BD834F89B82$EXT"

cp "_temp/SUPER MARIO 64#05430D1D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/8180E41F1E53D4424B00D80E835D42CF$EXT"
cp "_temp/SUPER MARIO 64#056CC37C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/8F1FEA43C714B0388749D7A1DD67390F$EXT"
cp "_temp/SUPER MARIO 64#059BDDC8#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/4564152226E1F364AD5B0AF02F220149$EXT"
cp "_temp/SUPER MARIO 64#5A9F8838#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/1C21A997148AE5F62840A47E0E90B1FF$EXT"
cp "_temp/SUPER MARIO 64#9D3176AD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/09833AD88E2F6DDA94EDCD89F2732964$EXT"
cp "_temp/SUPER MARIO 64#63B04AD7#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/B92F417F3F0BE8D36A282D0D25C847C5$EXT"
cp "_temp/SUPER MARIO 64#70CE1EFE#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/C6BD9CE785E2F4201FDA4092A294A20B$EXT"
cp "_temp/SUPER MARIO 64#61255948#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/4BB61D0F1F9051F709B69CEEF43CED9D$EXT"
cp "_temp/SUPER MARIO 64#C4D9432A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/File Select/AFEE4AE0533D3315C0E8BACBD4110352$EXT"

cp "_temp/SUPER MARIO 64#4D7AC0C5#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Health/DA8060943EBA4A835C089226C94058B6$EXT"
cp "_temp/SUPER MARIO 64#48F418AA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Health/BF219B0DADA7E14E716072C57D073401$EXT"

cp "_temp/SUPER MARIO 64#0502F12B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/D6948F8397D78A23A8F85B2DA43BE8CD$EXT"
cp "_temp/SUPER MARIO 64#2F785224#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/869317CECD0CF92828684A2F9E887A71$EXT"
cp "_temp/SUPER MARIO 64#3C55003C#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/B28345F2A5A2B8A64E8E21F97423F1FB$EXT"
cp "_temp/SUPER MARIO 64#3D8C1592#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/0149CC5B8AD33D8D50C6D9D4FACB27EC$EXT"
cp "_temp/SUPER MARIO 64#4B564151#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/69EA18F93BC702022D2590CA40BF1E98$EXT"
cp "_temp/SUPER MARIO 64#7F720C4B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/7573033A68CF3380F3CB920DE7C7A3AC$EXT"
cp "_temp/SUPER MARIO 64#8B79624F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/B2A61F136430D96C9C481ECC1D1FBCE6$EXT"
cp "_temp/SUPER MARIO 64#8BD37D7A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/9D42CB1FC3A47DBB5ABB1A96C65E2C95$EXT"
cp "_temp/SUPER MARIO 64#8D608AEA#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/79C3A6555FFCFC3F4DB70B4E8E84F0FF$EXT"
cp "_temp/SUPER MARIO 64#26DAF951#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/4FD7A2611867FC15D4F8217098581A5B$EXT"
cp "_temp/SUPER MARIO 64#41B80100#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/E5DB0B28A99E74F89DD3690CDA3E6BC8$EXT"
cp "_temp/SUPER MARIO 64#49F864CF#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/1E4DA1577DD023D9440812EBBDFFA475$EXT"
cp "_temp/SUPER MARIO 64#50C42869#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/89AA139AC1ECD9ED4C704993BFC789A6$EXT"
cp "_temp/SUPER MARIO 64#51C82B5E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/11EB5E412EC462CFC645C3562651DDBC$EXT"
cp "_temp/SUPER MARIO 64#51D63B4D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/0FF6882726883E71E3D5605D2A2A11E2$EXT"
cp "_temp/SUPER MARIO 64#60CC08B0#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/606642CB39940C7054C2FFC57411EFD5$EXT"
cp "_temp/SUPER MARIO 64#80D42FBD#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/6EA37F9F5218D18FE1562ABF7E294F77$EXT"
cp "_temp/SUPER MARIO 64#94C6917D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/E4CFC7416C8B1ADB2E61ACE77CA765B5$EXT"
cp "_temp/SUPER MARIO 64#99A28B2D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/69C3E4DC6AB9A4FDFBA432B821E3F386$EXT"
cp "_temp/SUPER MARIO 64#99E91E6F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/6EA09B96FAF9D8D1382961546AFCF00E$EXT"
cp "_temp/SUPER MARIO 64#751B66C4#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/750607EFCAA5ECD14C0C25CE02C516E6$EXT"
cp "_temp/SUPER MARIO 64#861AE249#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/2032B92F52298368483A833A1A384E5E$EXT"
cp "_temp/SUPER MARIO 64#895C7E35#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/CD45A618C42104020D20EE0A33B73352$EXT"
cp "_temp/SUPER MARIO 64#8407FE4D#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/EB21D4E69253E09E90BB7892EBB41400$EXT"
cp "_temp/SUPER MARIO 64#16290B6E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/DF6CCCBBBE132BC5BBC48AAA823BE0EB$EXT"
cp "_temp/SUPER MARIO 64#39123B9F#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/D30DF94072E5E621C35AAEB395295F83$EXT"
cp "_temp/SUPER MARIO 64#93638A3E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/EBE4340DCDE64EC07C2A5497A4621E77$EXT"
cp "_temp/SUPER MARIO 64#960410CC#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/D602E070B49817494BF94ADF6B8DCDBE$EXT"
cp "_temp/SUPER MARIO 64#4309083E#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/2944AEB8CFC12DDDD865BD819E7157B3$EXT"
cp "_temp/SUPER MARIO 64#B52C7594#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/030136D957BB46EE0CEE015DD39544C4$EXT"
cp "_temp/SUPER MARIO 64#E02BC31A#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/476A03616187E958060D0AAEF33E4FCD$EXT"
cp "_temp/SUPER MARIO 64#E1D17E44#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/10767FA5C0E7CF59BB141837B02B8E2D$EXT"
cp "_temp/SUPER MARIO 64#E57BCF4B#0#2_all$EXT" "$PORT/Hacks/Termina Invasion/UI/Text/37759915417D133D327A6230AE35B887$EXT"

cp "_temp/SUPER MARIO 64#72BFE459#0#2_all$EXT" "$PORT/HUD/Course/Europe/English/82CB23EF261CC1511B1A15D165653615$EXT"
cp "_temp/SUPER MARIO 64#0B32979B#0#2_all$EXT" "$PORT/HUD/Course/Europe/French/AD51BF1C93C5A0A6C0CAFD54086F13B8$EXT"
cp "_temp/SUPER MARIO 64#FA7285DE#0#2_all$EXT" "$PORT/HUD/Course/Europe/German/3CD5091A9AD869981972110EB2140B74$EXT"
cp "_temp/SUPER MARIO 64#56DB5E1C#0#2_all$EXT" "$PORT/HUD/Course/Europe/5350F38EB95C6D14FC6DAC8C69B47C1B$EXT"
cp "_temp/SUPER MARIO 64#CBC66B93#0#2_all$EXT" "$PORT/HUD/Course/iQue/87FAB2A6D2674C18FE522786AB0BFB61$EXT"
cp "_temp/SUPER MARIO 64#F73E23B8#0#2_all$EXT" "$PORT/HUD/Course/iQue/30A1E960616FCC011B5C9AECDE7B440E$EXT"
cp "_temp/SUPER MARIO 64#D135687E#0#2_all$EXT" "$PORT/HUD/Course/0FD5633E41627EDD1112547BDC565448$EXT"
cp "_temp/SUPER MARIO 64#FAD8C6E1#0#2_all$EXT" "$PORT/HUD/Course/65FC3770A55DA5870D1F1CB7EC262D7F$EXT"

cp "_temp/SUPER MARIO 64#0075DA18#0#2_all$EXT" "$PORT/HUD/Font/Japanese/ED33B5953B88248506D6638FEFA4CC12$EXT"
cp "_temp/SUPER MARIO 64#127B0F41#0#2_all$EXT" "$PORT/HUD/Font/Japanese/C3934302FCDD1256B1D7809C163306E1$EXT"
cp "_temp/SUPER MARIO 64#1CD30ACE#0#2_all$EXT" "$PORT/HUD/Font/Japanese/0FCA34F482CE967E60BD33929A70631A$EXT"
cp "_temp/SUPER MARIO 64#1CDCC29C#0#2_all$EXT" "$PORT/HUD/Font/Japanese/5A4A56C0173763AE7D23F35F8AB5687B$EXT"
cp "_temp/SUPER MARIO 64#27AE0809#0#2_all$EXT" "$PORT/HUD/Font/Japanese/7DEC50BC4C5F767B01773F54D7748CD8$EXT"
cp "_temp/SUPER MARIO 64#3711D2C0#0#2_all$EXT" "$PORT/HUD/Font/Japanese/09662EA923863D9126D7EC17406C8B76$EXT"
cp "_temp/SUPER MARIO 64#448CB3E7#0#2_all$EXT" "$PORT/HUD/Font/Japanese/E0500052F4E966A748471B4CB424B9DB$EXT"
cp "_temp/SUPER MARIO 64#48FC50A9#0#2_all$EXT" "$PORT/HUD/Font/Japanese/D895E70B61542A3ADEC8AE85569B7FDC$EXT"
cp "_temp/SUPER MARIO 64#4DA5EB87#0#2_all$EXT" "$PORT/HUD/Font/Japanese/2E4F5430FA523D256E898B3FBEB627FA$EXT"
cp "_temp/SUPER MARIO 64#52797C8E#0#2_all$EXT" "$PORT/HUD/Font/Japanese/88E07518CE46AC21BC9AB72A265AE09D$EXT"
cp "_temp/SUPER MARIO 64#5F21CD0B#0#2_all$EXT" "$PORT/HUD/Font/Japanese/CA02ED10FF28A3E75E4CB448784722D5$EXT"
cp "_temp/SUPER MARIO 64#6379BE10#0#2_all$EXT" "$PORT/HUD/Font/Japanese/2415CF34A2754EB67B042651CBC4D402$EXT"
cp "_temp/SUPER MARIO 64#6A94B667#0#2_all$EXT" "$PORT/HUD/Font/Japanese/A071ECDAF63F9D1776F0FD246744BBA7$EXT"
cp "_temp/SUPER MARIO 64#72C132CB#0#2_all$EXT" "$PORT/HUD/Font/Japanese/A23A6229BF1343C50C4F118FD6DBAE46$EXT"
cp "_temp/SUPER MARIO 64#73017371#0#2_all$EXT" "$PORT/HUD/Font/Japanese/E4C9D1389BB7B8595C7C0D48DD6DCBC8$EXT"
cp "_temp/SUPER MARIO 64#83CB5976#0#2_all$EXT" "$PORT/HUD/Font/Japanese/D84159204AAE3B89A9725A259C27221E$EXT"
cp "_temp/SUPER MARIO 64#9255AA67#0#2_all$EXT" "$PORT/HUD/Font/Japanese/EFF0C42D2CF068BEF969AF59D8B4C934$EXT"
cp "_temp/SUPER MARIO 64#93E5A95E#0#2_all$EXT" "$PORT/HUD/Font/Japanese/7DE3A0B9A33E248244F7CFA77411A42B$EXT"
cp "_temp/SUPER MARIO 64#9B6626FE#0#2_all$EXT" "$PORT/HUD/Font/Japanese/326C520C655CC698AD24787D7ADE6DA5$EXT"
cp "_temp/SUPER MARIO 64#BE7558ED#0#2_all$EXT" "$PORT/HUD/Font/Japanese/D55863ECF0EC7A09AA2DA94FDA826BB0$EXT"
cp "_temp/SUPER MARIO 64#DDAFBC28#0#2_all$EXT" "$PORT/HUD/Font/Japanese/9D1F538BF8F4D05C10703985CF348DE6$EXT"
cp "_temp/SUPER MARIO 64#EBE128AA#0#2_all$EXT" "$PORT/HUD/Font/Japanese/97BC6C21637B086FD253B016B2C61D61$EXT"
cp "_temp/SUPER MARIO 64#F30400D5#0#2_all$EXT" "$PORT/HUD/Font/Japanese/1F785F11ED641B2B63A15313A073C8DC$EXT"
cp "_temp/SUPER MARIO 64#F7DE7C20#0#2_all$EXT" "$PORT/HUD/Font/Japanese/7E3B18D1702BE6EE51FB3A0E00564ABD$EXT"

cp "_temp/SUPER MARIO 64#0AB6E7BF#0#2_all$EXT" "$PORT/HUD/Font/Japanese (unused)/FFA180638664233153D88D949DB391BA$EXT"
cp "_temp/SUPER MARIO 64#CDA7F3BF#0#2_all$EXT" "$PORT/HUD/Font/Japanese (unused)/F3110B6C8F5E1C1E5F8548BA7A8F558C$EXT"
cp "_temp/SUPER MARIO 64#F7348D7B#0#2_all$EXT" "$PORT/HUD/Font/Japanese (unused)/7CB88FCE45AE7F672D302AB2185FED40$EXT"

cp "_temp/SUPER MARIO 64#0659AB56#0#2_all$EXT" "$PORT/HUD/Font/2E99D062B69C294D0B01572DCA736754$EXT"
cp "_temp/SUPER MARIO 64#08C865BC#0#2_all$EXT" "$PORT/HUD/Font/24C4DDF300762F39CDD363AD677C5923$EXT"
cp "_temp/SUPER MARIO 64#095CCD5F#0#2_all$EXT" "$PORT/HUD/Font/EFF90D59F2E92F964F5F4AF95CA60962$EXT"
cp "_temp/SUPER MARIO 64#0F53E6DA#0#2_all$EXT" "$PORT/HUD/Font/A181D3E2CE6CA2347BD1DC8F488B32E6$EXT"
cp "_temp/SUPER MARIO 64#134A35B3#0#2_all$EXT" "$PORT/HUD/Font/CD061E1F4DCEBBC20386B39659225D81$EXT"
cp "_temp/SUPER MARIO 64#202D35BE#0#2_all$EXT" "$PORT/HUD/Font/95F3FFFF9F6FD6D46395F17E305922A2$EXT"
cp "_temp/SUPER MARIO 64#28A7F52B#0#2_all$EXT" "$PORT/HUD/Font/67090CDDDB34BEA4B516810799A9B795$EXT"
cp "_temp/SUPER MARIO 64#2A359204#0#2_all$EXT" "$PORT/HUD/Font/847AB6226297D32FA25F0219A9E2EC7E$EXT"
cp "_temp/SUPER MARIO 64#2B851F69#0#2_all$EXT" "$PORT/HUD/Font/E4F674ED29ECAC0B31A2E13A918C7068$EXT"
cp "_temp/SUPER MARIO 64#336D534A#0#2_all$EXT" "$PORT/HUD/Font/2A8E910DD80E3379A05F63F4E579D54E$EXT"
cp "_temp/SUPER MARIO 64#414026B4#0#2_all$EXT" "$PORT/HUD/Font/1AC3EA0D9736AEF0C359D3D9BDABD034$EXT"
cp "_temp/SUPER MARIO 64#468BC569#0#2_all$EXT" "$PORT/HUD/Font/4F130AFC0D5D396897DFC78685FE6999$EXT"
cp "_temp/SUPER MARIO 64#4E4571C1#0#2_all$EXT" "$PORT/HUD/Font/9CFDA86CF723C40A06E1F61B5357C37A$EXT"
cp "_temp/SUPER MARIO 64#51BDAFFF#0#2_all$EXT" "$PORT/HUD/Font/C6D4C10362E282F1133A7868B67551A3$EXT"
cp "_temp/SUPER MARIO 64#52A84252#0#2_all$EXT" "$PORT/HUD/Font/11D4903001A11106838E2B89F0BE9A7E$EXT"
cp "_temp/SUPER MARIO 64#5EF65DD9#0#2_all$EXT" "$PORT/HUD/Font/A2D7A916694F43A6146CBA843082B955$EXT"
cp "_temp/SUPER MARIO 64#6B1FC91A#0#2_all$EXT" "$PORT/HUD/Font/5656B0BDC7A7B10BDC76461AF61E8D41$EXT"
cp "_temp/SUPER MARIO 64#6BC75681#0#2_all$EXT" "$PORT/HUD/Font/3D0D2A92A23B2B6F5DCE72D389FC24C1$EXT"
cp "_temp/SUPER MARIO 64#6C64EB0B#0#2_all$EXT" "$PORT/HUD/Font/9B36FE504C721F742807F4C922D410D6$EXT"
cp "_temp/SUPER MARIO 64#78CE86A9#0#2_all$EXT" "$PORT/HUD/Font/F845A5B8C26522E21A9BEFDACB597998$EXT"
cp "_temp/SUPER MARIO 64#7AB277B8#0#2_all$EXT" "$PORT/HUD/Font/9590C1B69B0E8DC34B30A0C0DC5231E0$EXT"
cp "_temp/SUPER MARIO 64#7C2D13C9#0#2_all$EXT" "$PORT/HUD/Font/B4A58202805F15DA9FB54D1477193F5C$EXT"
cp "_temp/SUPER MARIO 64#7CC51E15#0#2_all$EXT" "$PORT/HUD/Font/6487B2E93359BC933D3B3FBC91382483$EXT"
cp "_temp/SUPER MARIO 64#81BB18E0#0#2_all$EXT" "$PORT/HUD/Font/D2E0455EC1A6C4E2DCE3AEE1EAAEFA46$EXT"
cp "_temp/SUPER MARIO 64#86B7D553#0#2_all$EXT" "$PORT/HUD/Font/6371374CFAA316D45208DEDBF5C1D9BC$EXT"
cp "_temp/SUPER MARIO 64#92AD1EEF#0#2_all$EXT" "$PORT/HUD/Font/0B7A2E75997AD93B7E08C4DE492963DB$EXT"
cp "_temp/SUPER MARIO 64#9513887C#0#2_all$EXT" "$PORT/HUD/Font/504DFDFC5F19A998F97A198C9B19A45E$EXT"
cp "_temp/SUPER MARIO 64#A0974D75#0#2_all$EXT" "$PORT/HUD/Font/0BCF12CE45638FC19E8FA35F040EAC22$EXT"
cp "_temp/SUPER MARIO 64#A2013A12#0#2_all$EXT" "$PORT/HUD/Font/6C17ED6DE8245D810124F7D4D5AA29A1$EXT"
cp "_temp/SUPER MARIO 64#D89B4538#0#2_all$EXT" "$PORT/HUD/Font/8088515CC9518524362502B3AFA6CA35$EXT"
cp "_temp/SUPER MARIO 64#DB3C7C79#0#2_all$EXT" "$PORT/HUD/Font/872E61D2FDD4AB2656C5D12F4F834BA7$EXT"
cp "_temp/SUPER MARIO 64#E2DE3E2B#0#2_all$EXT" "$PORT/HUD/Font/D413859F51728F7036F1117636D3ACD9$EXT"
cp "_temp/SUPER MARIO 64#E4BD5580#0#2_all$EXT" "$PORT/HUD/Font/AB39D0E6E60C3A41A65097AB62739176$EXT"
cp "_temp/SUPER MARIO 64#F5974867#0#2_all$EXT" "$PORT/HUD/Font/C98C9D60A0F88A7CF074620E05488FF3$EXT"
cp "_temp/SUPER MARIO 64#FC10A1B3#0#2_all$EXT" "$PORT/HUD/Font/07F5965F78D85AA648F1820105F620DA$EXT"
cp "_temp/SUPER MARIO 64#FE3D6481#0#2_all$EXT" "$PORT/HUD/Font/7E2525E3596BE5B451E8153746FE545C$EXT"
cp "_temp/SUPER MARIO 64#FFEA1FFE#0#2_all$EXT" "$PORT/HUD/Font/CFA2BED11C6F01F1982B57CF4EDAC1EE$EXT"

cp "_temp/SUPER MARIO 64#362E3E52#0#2_all$EXT" "$PORT/HUD/Icons/40C9CE7827A1FB3D2376F4FACB97977D$EXT"
cp "_temp/SUPER MARIO 64#438CC5BE#0#2_all$EXT" "$PORT/HUD/Icons/25243CA14AC8F155502325E38F94A22A$EXT"
cp "_temp/SUPER MARIO 64#580E00A9#0#2_all$EXT" "$PORT/HUD/Icons/1885CB187A029FF180497A4B731429E0$EXT"
cp "_temp/SUPER MARIO 64#676B6CF3#0#2_all$EXT" "$PORT/HUD/Icons/32A0BDBF043A317BDD06A5DB600B4F7F$EXT"
cp "_temp/SUPER MARIO 64#6F32A4FB#0#2_all$EXT" "$PORT/HUD/Icons/1C896BBD9101591DC1D13F5574C11195$EXT"
cp "_temp/SUPER MARIO 64#88703C55#0#2_all$EXT" "$PORT/HUD/Icons/B2E85BD3DCED8D6B6AD0D20C522997F7$EXT"
cp "_temp/SUPER MARIO 64#A7398F08#0#2_all$EXT" "$PORT/HUD/Icons/C7008CE65F35217868476ECB13ADF8C2$EXT"
cp "_temp/SUPER MARIO 64#EC24C279#0#2_all$EXT" "$PORT/HUD/Icons/D35503FF003EEE3B706EDEBF324F97F9$EXT"

cp "_temp/SUPER MARIO 64#8C52B115#0#2_all$EXT" "$PORT/HUD/Power Meter/iQue/AEBCB01855B28375A2D30A500265F9F3$EXT"
cp "_temp/SUPER MARIO 64#567A4E13#0#2_all$EXT" "$PORT/HUD/Power Meter/iQue/017C732B7AF34B37221A3743BC701B5D$EXT"
cp "_temp/SUPER MARIO 64#076B5C8F#0#2_all$EXT" "$PORT/HUD/Power Meter/FFADAB745B6D29AE0E20ED2B73D196DA$EXT"
cp "_temp/SUPER MARIO 64#10F30B26#0#2_all$EXT" "$PORT/HUD/Power Meter/651A1D482C5F6469ABFFA481E5054AD4$EXT"
cp "_temp/SUPER MARIO 64#268B611D#0#2_all$EXT" "$PORT/HUD/Power Meter/FA56005D79F64C5EA7376EC3E1868719$EXT"
cp "_temp/SUPER MARIO 64#2B846815#0#2_all$EXT" "$PORT/HUD/Power Meter/77CDD7BD6A3D256E86037315C9062FC4$EXT"
cp "_temp/SUPER MARIO 64#4DC0BBDF#0#2_all$EXT" "$PORT/HUD/Power Meter/E38C5ADEEDA87123A88FBC7812A68A04$EXT"
cp "_temp/SUPER MARIO 64#6CA78364#0#2_all$EXT" "$PORT/HUD/Power Meter/F45B5540971D608B38BB02E8A30C6C57$EXT"
cp "_temp/SUPER MARIO 64#9F02A40F#0#2_all$EXT" "$PORT/HUD/Power Meter/A804E0146B26A8CA044D8A4A3BFB0693$EXT"
cp "_temp/SUPER MARIO 64#BCBD0842#0#2_all$EXT" "$PORT/HUD/Power Meter/25EE5DFAB652210E962584943FF73F68$EXT"
cp "_temp/SUPER MARIO 64#F1C23131#0#2_all$EXT" "$PORT/HUD/Power Meter/E034A64EBDC025C251D55910E813F10B$EXT"
cp "_temp/SUPER MARIO 64#FD569CD5#0#2_all$EXT" "$PORT/HUD/Power Meter/39BDB5B765577FF1355EEDBEDC10A3CB$EXT"

cp "_temp/SUPER MARIO 64#D1D18587#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/A/F2CAEF7033191F571BB6BEF75AAF905A$EXT"
cp "_temp/SUPER MARIO 64#9AC5A4A5#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/B/967C36BA95CCD3248CFA11AA8FDA23A4$EXT"
cp "_temp/SUPER MARIO 64#B97C9FAD#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/C/113D8486DDA5705F95DEBA361DCC6449$EXT"
cp "_temp/SUPER MARIO 64#B1C091A7#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/R/CBFB0F125BE73FF972EEF891D11E98AE$EXT"
cp "_temp/SUPER MARIO 64#0ECC73B4#3#0_all$EXT" "$PORT/Letters/16x8/Buttons/Z/AB4651B4FB7371833A552111B6B41983$EXT"
cp "_temp/SUPER MARIO 64#6CAB6E7C#3#0_all$EXT" "$PORT/Letters/16x8/Capital/A/5E77EDC31635E21CE87F4BB552309723$EXT"
cp "_temp/SUPER MARIO 64#AEB2B780#3#0_all$EXT" "$PORT/Letters/16x8/Capital/B/69C7C37EFA8DE5432D2AB90297BC3F67$EXT"
cp "_temp/SUPER MARIO 64#897AB77F#3#0_all$EXT" "$PORT/Letters/16x8/Capital/C/ECD299A024155F9F5CC7ACC54314A32F$EXT"
cp "_temp/SUPER MARIO 64#86A979A6#3#0_all$EXT" "$PORT/Letters/16x8/Capital/D/F8056B8CD01629E444C6F6CB71523527$EXT"
cp "_temp/SUPER MARIO 64#8798CFBF#3#0_all$EXT" "$PORT/Letters/16x8/Capital/E/3CB21F3135174230553DB71AA7AF8A6A$EXT"
cp "_temp/SUPER MARIO 64#69B6B1A1#3#0_all$EXT" "$PORT/Letters/16x8/Capital/F/E2EBBCB3BE35C0BAACDC1515B098CFE9$EXT"
cp "_temp/SUPER MARIO 64#8894B7A4#3#0_all$EXT" "$PORT/Letters/16x8/Capital/G/E81092644EDCF702D1C9D6DDCFC209B9$EXT"
cp "_temp/SUPER MARIO 64#78A6E268#3#0_all$EXT" "$PORT/Letters/16x8/Capital/H/CC404A0D83CB26F2EE90398376094BA3$EXT"
cp "_temp/SUPER MARIO 64#B9A790A1#3#0_all$EXT" "$PORT/Letters/16x8/Capital/I/8729D185D0A935DBD2C64A61D1125063$EXT"
cp "_temp/SUPER MARIO 64#9F8995A3#3#0_all$EXT" "$PORT/Letters/16x8/Capital/J/BF0165265701E528389947268D8FB308$EXT"
cp "_temp/SUPER MARIO 64#A8DF6863#3#0_all$EXT" "$PORT/Letters/16x8/Capital/K/09439FBB46C232EA50C46BAD07233BC6$EXT"
cp "_temp/SUPER MARIO 64#988AA5AE#3#0_all$EXT" "$PORT/Letters/16x8/Capital/L/37EBCB15FA61EC9E3DF185662EDFEA39$EXT"
cp "_temp/SUPER MARIO 64#AFB97693#3#0_all$EXT" "$PORT/Letters/16x8/Capital/M/2D9CC606A54518905A0A7D8EA60B998A$EXT"
cp "_temp/SUPER MARIO 64#B0AB7771#3#0_all$EXT" "$PORT/Letters/16x8/Capital/N/8771D59A253CA510A9679CB4806DBBA0$EXT"
cp "_temp/SUPER MARIO 64#887AB795#3#0_all$EXT" "$PORT/Letters/16x8/Capital/O/A3CA708F5CD4549A5968AAD411B3846D$EXT"
cp "_temp/SUPER MARIO 64#69B2B1A2#3#0_all$EXT" "$PORT/Letters/16x8/Capital/P/804C0B1EF3C1C0C4B45BB52C7D3B51CD$EXT"
cp "_temp/SUPER MARIO 64#A698B795#3#0_all$EXT" "$PORT/Letters/16x8/Capital/Q/2B9EA7D78577AD489198B8FABD4545C6$EXT"
cp "_temp/SUPER MARIO 64#6BB0B3A0#3#0_all$EXT" "$PORT/Letters/16x8/Capital/R/B672FDC37AFB8E16846F5D5D87D92874$EXT"
cp "_temp/SUPER MARIO 64#C1799951#3#0_all$EXT" "$PORT/Letters/16x8/Capital/S/B4B6058407B59BA450ABFA68041FCE88$EXT"
cp "_temp/SUPER MARIO 64#B9A79083#3#0_all$EXT" "$PORT/Letters/16x8/Capital/T/24659B428639CF9293047F8602418C7D$EXT"
cp "_temp/SUPER MARIO 64#9789A886#3#0_all$EXT" "$PORT/Letters/16x8/Capital/U/C5C56EA84647E51E0B6450DCA50B0030$EXT"
cp "_temp/SUPER MARIO 64#8D8F8692#3#0_all$EXT" "$PORT/Letters/16x8/Capital/V/C834C3779E122EDA2D47B02B4212835C$EXT"
cp "_temp/SUPER MARIO 64#7D8D66C4#3#0_all$EXT" "$PORT/Letters/16x8/Capital/W/DD3A76EF2BD08027472CBE41AC957243$EXT"
cp "_temp/SUPER MARIO 64#BDF14875#3#0_all$EXT" "$PORT/Letters/16x8/Capital/X/CBDE495BE03695E6F6017AD8EAB142EE$EXT"
cp "_temp/SUPER MARIO 64#AC848284#3#0_all$EXT" "$PORT/Letters/16x8/Capital/Y/BF55C39EBB0FF7A64448DC2A8BE73FFF$EXT"
cp "_temp/SUPER MARIO 64#B97D6191#3#0_all$EXT" "$PORT/Letters/16x8/Capital/Z/2B2B38776A125E48E0904C45CB8863FB$EXT"
cp "_temp/SUPER MARIO 64#80A7C266#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/a/1277375160171407D75111D83F284BB5$EXT"
cp "_temp/SUPER MARIO 64#6089A2C3#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/b/92D51D0A1ED32C865238B83F7F9AEF98$EXT"
cp "_temp/SUPER MARIO 64#C089A462#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/c/804C27BD7AFB77BE901A47A24C868D37$EXT"
cp "_temp/SUPER MARIO 64#8187C266#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/d/BC33C47C414D64A6132FF18123F18AC0$EXT"
cp "_temp/SUPER MARIO 64#BEA7A284#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/e/BA9D005EAE7DCD94F6E06BC5E7501C96$EXT"
cp "_temp/SUPER MARIO 64#AA77A182#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/f/2115AEDA47E7B5C30160B20C0F60C111$EXT"
cp "_temp/SUPER MARIO 64#8D8682B6#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/g/EF19B359E7EC2A793B39A6564D985CDF$EXT"
cp "_temp/SUPER MARIO 64#62A7C2A1#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/h/A005922B4B5A2237FD1522D53C06D93F$EXT"
cp "_temp/SUPER MARIO 64#788AA257#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/i/03BFF4422599ACE4921C07C27D973F47$EXT"
cp "_temp/SUPER MARIO 64#81697994#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/j/B5F0FC59EFCF0F2BCF7367A513A40524$EXT"
cp "_temp/SUPER MARIO 64#49E284A3#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/k/0ACF70129F4096BB4283CFD4671CBA8B$EXT"
cp "_temp/SUPER MARIO 64#6AA886A1#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/l/ED41A9AC67DD06F64DDDD942087EE41F$EXT"
cp "_temp/SUPER MARIO 64#64C774D2#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/m/31132E34BDEC73C2E5F0ED96A42902A6$EXT"
cp "_temp/SUPER MARIO 64#62A980C3#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/n/27ABBCE1CB33D0F1CAEE1A5FAC05EB6E$EXT"
cp "_temp/SUPER MARIO 64#8089A286#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/o/FC623D6C6C35EFF1DB03744F97FE2EAA$EXT"
cp "_temp/SUPER MARIO 64#A087A286#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/p/72201128C4785452DAB0CAD3EE449E48$EXT"
cp "_temp/SUPER MARIO 64#8187C284#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/q/CD1A0BE142477B9D7A95EB3890ABF526$EXT"
cp "_temp/SUPER MARIO 64#A2C46681#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/r/4F7866BA27554A910B8E8E1A7495019F$EXT"
cp "_temp/SUPER MARIO 64#C5C3A662#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/s/5886E680F7F1679EEC0C3E1E944E7FFA$EXT"
cp "_temp/SUPER MARIO 64#8C87859E#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/t/1A79877E51F42BAC514214A3AC69FFC9$EXT"
cp "_temp/SUPER MARIO 64#7F8AC166#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/u/69E7A30918990DEFB68E926CB3C1B2C5$EXT"
cp "_temp/SUPER MARIO 64#C3688681#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/v/4691FDC5172173140C6A24ADFBF871F0$EXT"
cp "_temp/SUPER MARIO 64#9FA8C268#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/w/667380214C501FACAB7FD2FF64AC5F58$EXT"
cp "_temp/SUPER MARIO 64#A2C49F94#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/x/21AA0B495E5D136FBDFD73C3A7168D40$EXT"
cp "_temp/SUPER MARIO 64#BD8C84AF#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/y/1220E124A2945C87EFB181A2D35C77B1$EXT"
cp "_temp/SUPER MARIO 64#C2A56782#3#0_all$EXT" "$PORT/Letters/16x8/Lowercase/z/C79184294DC3F0EB9585C2C4739B52C2$EXT"
cp "_temp/SUPER MARIO 64#98BB898E#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/0/FF023C44916F7EF086005DF104853F3B$EXT"
cp "_temp/SUPER MARIO 64#D057B494#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/1/905A78584109CD9F9397B7A87B35BF60$EXT"
cp "_temp/SUPER MARIO 64#B0F373B0#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/2/368D5D194D0E7D5671F6DE822D2DD79C$EXT"
cp "_temp/SUPER MARIO 64#87BA54C8#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/3/FB1A2ECA4A5E7E3582EB9665094F6ECD$EXT"
cp "_temp/SUPER MARIO 64#60D4A5C2#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/4/CE46C5BD338469ED8C7413B02C8D3AD6$EXT"
cp "_temp/SUPER MARIO 64#B6BA71D3#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/5/5C4516677F1B988671445E1165F89A4C$EXT"
cp "_temp/SUPER MARIO 64#97BAA58E#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/6/DBAA834D7BEAA5BF796AD7949DFD9934$EXT"
cp "_temp/SUPER MARIO 64#68F155A5#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/7/3C1637C1B1B070614256E2085D9843FD$EXT"
cp "_temp/SUPER MARIO 64#87BA9198#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/8/30D98852D9FA2BAA271EAA2D77EAFDBC$EXT"
cp "_temp/SUPER MARIO 64#B0D568A0#3#0_all$EXT" "$PORT/Letters/16x8/Numerals/9/D1A29CF3BFCFDADDA791EE85356FF0D5$EXT"
cp "_temp/SUPER MARIO 64#5297B884#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/86151D1F06E45A868671D15507D5C439$EXT"
cp "_temp/SUPER MARIO 64#637878B3#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/3505EE7BD69EC80605F0B2AA6EB83B3E$EXT"
cp "_temp/SUPER MARIO 64#6C6A6686#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/2F75DAED5F9DE2B79CFCAC219407BCE7$EXT"
cp "_temp/SUPER MARIO 64#8A4886A6#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/44FF9E6C61E690925173BE13AC8C153F$EXT"
cp "_temp/SUPER MARIO 64#8A687694#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/DAFFDE15E7BC1A030AB257925BA61747$EXT"
cp "_temp/SUPER MARIO 64#8A688695#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/62351D8F6C739D933A95948D07525314$EXT"
cp "_temp/SUPER MARIO 64#8A6886A4#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/7A18DF9A6FD0C8C81966D63697426ECF$EXT"
cp "_temp/SUPER MARIO 64#8C7275A4#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/C41EFAD2976481C53BE3550FDC537A32$EXT"
cp "_temp/SUPER MARIO 64#9A887684#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/FEEC25566DF7F528567F13BB62C42AE1$EXT"
cp "_temp/SUPER MARIO 64#9B877585#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/D8B5D5056E540EC29B4A7788A29E27CF$EXT"
cp "_temp/SUPER MARIO 64#A77A8863#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/C2405773C7B0D6038BA8CC51B757FCF1$EXT"
cp "_temp/SUPER MARIO 64#B35BE951#3#0_all$EXT" "$PORT/Letters/16x8/Punctuation/F5F1B542AB675F7F8C12ED63D8A401B0$EXT"
cp "_temp/SUPER MARIO 64#7A89B25A#3#0_all$EXT" "$PORT/Letters/16x8/Special/1AFBA36E8DCEF4BE89A4E3F277EB1CBE$EXT"
cp "_temp/SUPER MARIO 64#888AA166#3#0_all$EXT" "$PORT/Letters/16x8/Special/B8FA15960255EF7143923000770D9DFA$EXT"
cp "_temp/SUPER MARIO 64#897AF57D#3#0_all$EXT" "$PORT/Letters/16x8/Special/3831C58EA4B92B10B0E563C908BB2BD2$EXT"
cp "_temp/SUPER MARIO 64#8A898584#3#0_all$EXT" "$PORT/Letters/16x8/Special/52FEFDA3490F8BC1E96BF0048881BF26$EXT"
cp "_temp/SUPER MARIO 64#8A978693#3#0_all$EXT" "$PORT/Letters/16x8/Special/A452EE8A5248A774241ADC6A42F0F643$EXT"
cp "_temp/SUPER MARIO 64#8A978774#3#0_all$EXT" "$PORT/Letters/16x8/Special/ACFD7C26F0A7E6C1018F3026C2AC2782$EXT"
cp "_temp/SUPER MARIO 64#8A978783#3#0_all$EXT" "$PORT/Letters/16x8/Special/24E5EF42BFD4957F062809A65B560C49$EXT"
cp "_temp/SUPER MARIO 64#C089E260#3#0_all$EXT" "$PORT/Letters/16x8/Special/251CB5CBFF20462DC009F2AFBA47B1C3$EXT"
cp "_temp/SUPER MARIO 64#7771686E#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/8AFBAC06FA130E11D97753973C70DD44$EXT"
cp "_temp/SUPER MARIO 64#8394A58A#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/D12BB40E4EC87F2480691F18C8C06D10$EXT"
cp "_temp/SUPER MARIO 64#92819878#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/3CC63238E805F586EDC991B423D83CE3$EXT"
cp "_temp/SUPER MARIO 64#92A5A679#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/1D1B1B15BCE8724914EB4CB0630ACC90$EXT"
cp "_temp/SUPER MARIO 64#9C937792#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/E8D21B33D3044EDC0596E4E79B322922$EXT"
cp "_temp/SUPER MARIO 64#A48A62B0#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/D87197270629EB096A634DB80A0A4864$EXT"
cp "_temp/SUPER MARIO 64#A88FC5A2#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/2B7FAEA61A7140D0043280AE743474AB$EXT"
cp "_temp/SUPER MARIO 64#B0C2949A#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/45D36919DFAE4A3B19CA20C8677DAD8A$EXT"
cp "_temp/SUPER MARIO 64#D4A575A8#3#0_all$EXT" "$PORT/Letters/16x8/Symbols/93B5154BE796000503AB9AD584C338F4$EXT"

cp "_temp/SUPER MARIO 64#5A807466#3#1_all$EXT" "$PORT/Letters/8x8/Capital/A/0FB6310B2EE202889F81ED93020B7CF1$EXT"
cp "_temp/SUPER MARIO 64#767C6068#3#1_all$EXT" "$PORT/Letters/8x8/Capital/B/A4B64AEAD5783164A09E4401CA1914AC$EXT"
cp "_temp/SUPER MARIO 64#78986182#3#1_all$EXT" "$PORT/Letters/8x8/Capital/C/DD9E82544CC02FEB51BD6AB7DD2AEC79$EXT"
cp "_temp/SUPER MARIO 64#7C697070#3#1_all$EXT" "$PORT/Letters/8x8/Capital/D (Europe)/55065B2B3736E59F1AB5438674C3274F$EXT"
cp "_temp/SUPER MARIO 64#786B7070#3#1_all$EXT" "$PORT/Letters/8x8/Capital/D (USA)/97A1D4180390B6ABBC7874C9B63633BB$EXT"
cp "_temp/SUPER MARIO 64#88788776#3#1_all$EXT" "$PORT/Letters/8x8/Capital/E/93E6CCE585095C92D1F9F779776C0ABF$EXT"
cp "_temp/SUPER MARIO 64#84788778#3#1_all$EXT" "$PORT/Letters/8x8/Capital/F/3DECEB80E3379658ABA083BC462AD028$EXT"
cp "_temp/SUPER MARIO 64#68886576#3#1_all$EXT" "$PORT/Letters/8x8/Capital/G/3FDC35B2138C6E43FF145F2776E22F18$EXT"
cp "_temp/SUPER MARIO 64#846A6656#3#1_all$EXT" "$PORT/Letters/8x8/Capital/H/F8628F0E347F0E60CF3B61713695869F$EXT"
cp "_temp/SUPER MARIO 64#788C8286#3#1_all$EXT" "$PORT/Letters/8x8/Capital/I/E7940C042542466B1231FF51D37641BA$EXT"
cp "_temp/SUPER MARIO 64#80707E74#3#1_all$EXT" "$PORT/Letters/8x8/Capital/J/04E6E9A5FC24CD6875393A413C7E7CD7$EXT"
cp "_temp/SUPER MARIO 64#84806080#3#1_all$EXT" "$PORT/Letters/8x8/Capital/K/15B50BC286FF3050D5CA0F66C944977E$EXT"
cp "_temp/SUPER MARIO 64#8886887E#3#1_all$EXT" "$PORT/Letters/8x8/Capital/L/BEA6FEC1F448DE583177ADA0E83BF1C5$EXT"
cp "_temp/SUPER MARIO 64#A65A6E86#3#1_all$EXT" "$PORT/Letters/8x8/Capital/M/8D0C9AC2734314581239D2FBB9D44DE7$EXT"
cp "_temp/SUPER MARIO 64#964A7E66#3#1_all$EXT" "$PORT/Letters/8x8/Capital/N/5EA550EE013182CD4EFFCA7D394A2CF3$EXT"
cp "_temp/SUPER MARIO 64#68886272#3#1_all$EXT" "$PORT/Letters/8x8/Capital/O/29C72440AD1DA6F010DB711ED0889A20$EXT"
cp "_temp/SUPER MARIO 64#5A967A74#3#1_all$EXT" "$PORT/Letters/8x8/Capital/P/E5DABA151B805BA15085D95F59B293D8$EXT"
cp "_temp/SUPER MARIO 64#56886274#3#1_all$EXT" "$PORT/Letters/8x8/Capital/Q/BC5A932E91222A4A9CD009593CCC5918$EXT"
cp "_temp/SUPER MARIO 64#4C947C72#3#1_all$EXT" "$PORT/Letters/8x8/Capital/R/A25AEF3654EC790C9F4201653F6F9860$EXT"
cp "_temp/SUPER MARIO 64#729C6184#3#1_all$EXT" "$PORT/Letters/8x8/Capital/S/138D48E8CC0226C2278AF0ED68FEA91E$EXT"
cp "_temp/SUPER MARIO 64#8C748686#3#1_all$EXT" "$PORT/Letters/8x8/Capital/T/4C3BC91234AF664C2365D1921A7A0DFF$EXT"
cp "_temp/SUPER MARIO 64#8A6A5E6E#3#1_all$EXT" "$PORT/Letters/8x8/Capital/U/B36CA12E39B8A43064FA07C7B2C9E1B8$EXT"
cp "_temp/SUPER MARIO 64#92766B78#3#1_all$EXT" "$PORT/Letters/8x8/Capital/V/6C80D28849366B17D81D6FB611D5012B$EXT"
cp "_temp/SUPER MARIO 64#945C9872#3#1_all$EXT" "$PORT/Letters/8x8/Capital/W/5C39FFEA85D0461DF4DEFD76A81A71C3$EXT"
cp "_temp/SUPER MARIO 64#646A9C64#3#1_all$EXT" "$PORT/Letters/8x8/Capital/X/2485A85119CEB9A64CE64C921B6C670A$EXT"
cp "_temp/SUPER MARIO 64#9A6D7782#3#1_all$EXT" "$PORT/Letters/8x8/Capital/Y/ADEBF23A53F0D722E6D048467B4E81D4$EXT"
cp "_temp/SUPER MARIO 64#7C9E686E#3#1_all$EXT" "$PORT/Letters/8x8/Capital/Z/542293224A23CC154A9DBCD656E00618$EXT"
cp "_temp/SUPER MARIO 64#8A748466#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/0/9A7F68C37ED7B87332745AE48FACE2C4$EXT"
cp "_temp/SUPER MARIO 64#82868870#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/1/DAEF1E9DDFA8C43C1374C45CBB38E36D$EXT"
cp "_temp/SUPER MARIO 64#44789E8C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/2/92A0ABE98532B262D0017B813068FBDB$EXT"
cp "_temp/SUPER MARIO 64#6C889C54#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/3/77E896FA5ADBCBD47DDDFFEB1678975B$EXT"
cp "_temp/SUPER MARIO 64#527E926C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/4/7C11E41052BAE4DE160EEFF452F4A74E$EXT"
cp "_temp/SUPER MARIO 64#7A96785C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/5/BD4D361E770AF1B61EB9C0563443991A$EXT"
cp "_temp/SUPER MARIO 64#7A86845C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/6/017EEDC0C87B988E2ABB869305E6A1F9$EXT"
cp "_temp/SUPER MARIO 64#66729882#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/7/1CB0CBB61BBB3BD14B8FABEB44B361C1$EXT"
cp "_temp/SUPER MARIO 64#688C825C#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/8/EBABEA28DE289773212A13F0910AFF94$EXT"
cp "_temp/SUPER MARIO 64#72768866#3#1_all$EXT" "$PORT/Letters/8x8/Numerals/9/5E1ACF17956DE5132979DF26F24F670E$EXT"
cp "_temp/SUPER MARIO 64#86888984#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/Europe/C7ADCAE9FD26D95BDD0723801F3B20C7$EXT"
cp "_temp/SUPER MARIO 64#8A848688#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/Europe/3398456F29F7EEEE7A6E47D4B659A10A$EXT"
cp "_temp/SUPER MARIO 64#607A828A#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/D4CCB2BC50C4F86D96FDFB0D47715226$EXT"
cp "_temp/SUPER MARIO 64#86848A88#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/8513F4E3DA5B297D524AC38047B5EA94$EXT"
cp "_temp/SUPER MARIO 64#6EB46458#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/A374C3810D8AD735C23CE997AD53606A$EXT"
cp "_temp/SUPER MARIO 64#80788486#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/589FDE6A7F5CA51990E5AAC470F6183A$EXT"
cp "_temp/SUPER MARIO 64#82888684#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/7CBBE1F916D2733DDFC43131B8C75E65$EXT"
cp "_temp/SUPER MARIO 64#86868886#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/0E0DF7BD33ECF342260F1A1512383AC9$EXT"
cp "_temp/SUPER MARIO 64#88898880#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/9849282AE91AD0B07C561E08F8EEC9B4$EXT"
cp "_temp/SUPER MARIO 64#8C868486#3#1_all$EXT" "$PORT/Letters/8x8/Punctuation/E3876A72645989F4826F7667F7504F0E$EXT"
cp "_temp/SUPER MARIO 64#7A7E7984#3#1_all$EXT" "$PORT/Letters/8x8/Special/72C6F44EF6B76A02F92591C86C481FEB$EXT"
cp "_temp/SUPER MARIO 64#8C869674#3#1_all$EXT" "$PORT/Letters/8x8/Special/97C66396DA0B699C883214C2D2DD6F65$EXT"
cp "_temp/SUPER MARIO 64#4C8A74AC#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/0EF227240316198DE6325055E407E98F$EXT"
cp "_temp/SUPER MARIO 64#686C9480#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/26ACE10919F13A58997C4CBD780C9CE8$EXT"
cp "_temp/SUPER MARIO 64#76406E6E#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/5343909045865A0CFC58F72616C995DC$EXT"
cp "_temp/SUPER MARIO 64#7E87867A#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/49F90FE66FD5A8ABF9C26C3E9422D49B$EXT"
cp "_temp/SUPER MARIO 64#C4F693E5#3#1_all$EXT" "$PORT/Letters/8x8/Symbols/945666D414DA999ABE34FBD1E1505517$EXT"

cp "_temp/SUPER MARIO 64#02330CCD#0#2_all$EXT" "$PORT/Letters/Credits/09D272AF7C462C7184D2AA068CE149BA$EXT"
cp "_temp/SUPER MARIO 64#1CB6DC98#0#2_all$EXT" "$PORT/Letters/Credits/05AD44855BD079068FA19CA600475983$EXT"
cp "_temp/SUPER MARIO 64#2447B7F9#0#2_all$EXT" "$PORT/Letters/Credits/83A76C13FBAE56F825B1050ADF38163F$EXT"
cp "_temp/SUPER MARIO 64#24E61683#0#2_all$EXT" "$PORT/Letters/Credits/92D3D341005A71360B64FD9BD6E6B052$EXT"
cp "_temp/SUPER MARIO 64#276489C6#0#2_all$EXT" "$PORT/Letters/Credits/A9D58989B78AD5A0DB7EA50755BCE261$EXT"
cp "_temp/SUPER MARIO 64#2811C57F#0#2_all$EXT" "$PORT/Letters/Credits/827CB47B1BB87A23EA150734A0AD84FE$EXT"
cp "_temp/SUPER MARIO 64#2D898713#0#2_all$EXT" "$PORT/Letters/Credits/2A74548003863DCAA67A057911BCCF9A$EXT"
cp "_temp/SUPER MARIO 64#38AFCD8F#0#2_all$EXT" "$PORT/Letters/Credits/B16E5912F27FFE4EA22BE2D3EE64DC56$EXT"
cp "_temp/SUPER MARIO 64#39E90B67#0#2_all$EXT" "$PORT/Letters/Credits/BAB81EA21E375AAE37238259590FF796$EXT"
cp "_temp/SUPER MARIO 64#3CE9E494#0#2_all$EXT" "$PORT/Letters/Credits/86ECA150ECD0DB92C83BF9D0E774F6C5$EXT"
cp "_temp/SUPER MARIO 64#3DE0ED4E#0#2_all$EXT" "$PORT/Letters/Credits/6B5417AE48B8C55F6F7B1FE5F240E04B$EXT"
cp "_temp/SUPER MARIO 64#48A3E423#0#2_all$EXT" "$PORT/Letters/Credits/003BBF68FD20ADE3280A08478FB7FEDB$EXT"
cp "_temp/SUPER MARIO 64#4EE951E9#0#2_all$EXT" "$PORT/Letters/Credits/892D7C35B5357C5E53305B1F45F207B8$EXT"
cp "_temp/SUPER MARIO 64#75D9483A#0#2_all$EXT" "$PORT/Letters/Credits/59A216C6AD4724FBF48C81DEE7783B04$EXT"
cp "_temp/SUPER MARIO 64#784949CA#0#2_all$EXT" "$PORT/Letters/Credits/3BC1749B30B274583EAE481AAE74F595$EXT"
cp "_temp/SUPER MARIO 64#962278D5#0#2_all$EXT" "$PORT/Letters/Credits/A189E8CFC856C487E7FDA31CCF397598$EXT"
cp "_temp/SUPER MARIO 64#988F8D4A#0#2_all$EXT" "$PORT/Letters/Credits/796ABD1E799F8A573773AE57AC719F07$EXT"
cp "_temp/SUPER MARIO 64#9AE320D1#0#2_all$EXT" "$PORT/Letters/Credits/5DAEE2A062312857A64D3427D9EF83D5$EXT"
cp "_temp/SUPER MARIO 64#C91C9210#0#2_all$EXT" "$PORT/Letters/Credits/15D8E2CE92EBD7CE3651FADEE19DF993$EXT"
cp "_temp/SUPER MARIO 64#CE8E25FA#0#2_all$EXT" "$PORT/Letters/Credits/389EE1A691D727FFB5361E45B5391936$EXT"
cp "_temp/SUPER MARIO 64#D2E92870#0#2_all$EXT" "$PORT/Letters/Credits/D28EB5073EDA9FF32737FDE80FFC3BA3$EXT"
cp "_temp/SUPER MARIO 64#D6F1A677#0#2_all$EXT" "$PORT/Letters/Credits/71A495D5D1636757D86BBA5940BF9CFF$EXT"
cp "_temp/SUPER MARIO 64#D8502FF0#0#2_all$EXT" "$PORT/Letters/Credits/7A2B44471CFE4975C04062EF2BEC9382$EXT"
cp "_temp/SUPER MARIO 64#DA971B4E#0#2_all$EXT" "$PORT/Letters/Credits/1D196574F0C73E11A41BDE14BBB5FAF9$EXT"
cp "_temp/SUPER MARIO 64#E67C070B#0#2_all$EXT" "$PORT/Letters/Credits/59B4A92F483D3532B0686AC68A7BCE39$EXT"
cp "_temp/SUPER MARIO 64#ECD57CE8#0#2_all$EXT" "$PORT/Letters/Credits/DB1A132678507F816280B8D9F7875DBE$EXT"
cp "_temp/SUPER MARIO 64#F2979267#0#2_all$EXT" "$PORT/Letters/Credits/EDC1607C4D5B4F5519BE18469B4DB7DB$EXT"
cp "_temp/SUPER MARIO 64#FC58ED51#0#2_all$EXT" "$PORT/Letters/Credits/8C08CA239205F4ED2E91D73D1CCB8FC6$EXT"

cp "_temp/SUPER MARIO 64#A23342E2#0#2_all$EXT" "$PORT/Objects/1-UP/8DF5F92387419C6154841B47822970BD$EXT"

cp "_temp/SUPER MARIO 64#25EE1BA5#0#2_all$EXT" "$PORT/Objects/Blue Coin Switch/6DC2489D65FF443D1B51C41CB48DB08C$EXT"
cp "_temp/SUPER MARIO 64#875630D6#0#2_all$EXT" "$PORT/Objects/Blue Coin Switch/DFC68724809DF8F6A49AE407BD7A8378$EXT"

cp "_temp/SUPER MARIO 64#AE1D5DC1#0#2_all$EXT" "$PORT/Objects/Bomb/82DAB31A8386D5C25433C5A273312200$EXT"
cp "_temp/SUPER MARIO 64#C2050F68#0#2_all$EXT" "$PORT/Objects/Bomb/8F3A43E14DAED1F30B3BB3E3838BC40F$EXT"
cp "_temp/SUPER MARIO 64#C82A46F3#0#2_all$EXT" "$PORT/Objects/Bomb/F1177EF461393A0189EC193A452A2590$EXT"

cp "_temp/SUPER MARIO 64#1F04DAF4#0#2_all$EXT" "$PORT/Objects/Boxes/7D93EB6EA9EFF8E660CC3D5A7202295B$EXT"
cp "_temp/SUPER MARIO 64#23F84D6A#0#2_all$EXT" "$PORT/Objects/Boxes/DA1CD8D959D42A3958575136DA4E73FA$EXT"
cp "_temp/SUPER MARIO 64#428D4124#0#2_all$EXT" "$PORT/Objects/Boxes/E0BF71257EF7C96823EF56556817019C$EXT"
cp "_temp/SUPER MARIO 64#4838A16E#0#2_all$EXT" "$PORT/Objects/Boxes/DF5782E97F087907AE2AA5B6C8C15F45$EXT"
cp "_temp/SUPER MARIO 64#7E5C3A04#0#2_all$EXT" "$PORT/Objects/Boxes/2491C80C41E1CFBE5D21F3BA83EA5D45$EXT"
cp "_temp/SUPER MARIO 64#7EBE7D5E#0#2_all$EXT" "$PORT/Objects/Boxes/A8AAB1A3615DD148A215E2727802301B$EXT"
cp "_temp/SUPER MARIO 64#8413A8FA#0#2_all$EXT" "$PORT/Objects/Boxes/58BE1FE74E635B9BA669055C5D165FBB$EXT"
cp "_temp/SUPER MARIO 64#A765AAA8#0#2_all$EXT" "$PORT/Objects/Boxes/6F945046C0DC8551BA83547A7DC0DDD7$EXT"
cp "_temp/SUPER MARIO 64#B16EDFA9#0#2_all$EXT" "$PORT/Objects/Boxes/744CD5CA58BA7B120960D5C954D9D8F9$EXT"
cp "_temp/SUPER MARIO 64#D17F99C6#0#2_all$EXT" "$PORT/Objects/Boxes/829B22B982F0CF07B426E0D4A21C4488$EXT"

cp "_temp/SUPER MARIO 64#C9F30BAF#0#2_all$EXT" "$PORT/Objects/Breakable Box/05FE33B13DB9C49A98BA1775FCD23DA3$EXT"
cp "_temp/SUPER MARIO 64#FDDF5C31#0#2_all$EXT" "$PORT/Objects/Breakable Box/0A9FB54648DFDACB76855331096F272F$EXT"

cp "_temp/SUPER MARIO 64#0612269D#0#2_all$EXT" "$PORT/Objects/Cannon/C333163485B40E91E276E7306C8C6665$EXT"
cp "_temp/SUPER MARIO 64#94776F27#0#2_all$EXT" "$PORT/Objects/Cannon/CB2B9897333C710DB8E5C2C546B450E2$EXT"
cp "_temp/SUPER MARIO 64#E0BB9B61#0#2_all$EXT" "$PORT/Objects/Cannon/6F524B3919EA08ABC62EE6C02D68FE61$EXT"

cp "_temp/SUPER MARIO 64#1F71DA85#0#2_all$EXT" "$PORT/Objects/Cap Switch/3D60600798A7151588885655D08074D2$EXT"
cp "_temp/SUPER MARIO 64#D2A05119#3#2_all$EXT" "$PORT/Objects/Cap Switch/0EF1712F9E2E2D9252561D6462F7E596$EXT"

cp "_temp/SUPER MARIO 64#A6E1B26B#0#2_all$EXT" "$PORT/Objects/Chair/unused/45671AAA89D4E834C46D3AA90F67B8AA$EXT"
cp "_temp/SUPER MARIO 64#1195AECC#0#2_all$EXT" "$PORT/Objects/Chair/881AA32FD3718C9AD632A74EC898D62F$EXT"
cp "_temp/SUPER MARIO 64#1198C8AB#0#2_all$EXT" "$PORT/Objects/Chair/49534B4AFCC85B58514CEC09B37CBA83$EXT"
cp "_temp/SUPER MARIO 64#21BFEA1A#0#2_all$EXT" "$PORT/Objects/Chair/006894B838457ED98F6CDBD3C615C2B4$EXT"

cp "_temp/SUPER MARIO 64#3486BF66#0#2_all$EXT" "$PORT/Objects/Checkerboard Platform/E0E7BC1F49C6ACB8BC10AC16F6DD0034$EXT"
cp "_temp/SUPER MARIO 64#BC16978D#0#2_all$EXT" "$PORT/Objects/Checkerboard Platform/EE324B54BC2CE41651D6267F5C088C57$EXT"

cp "_temp/SUPER MARIO 64#176C2E93#3#2_all$EXT" "$PORT/Objects/Coin/F8E723399A8C2C80212594978DD58E88$EXT"
cp "_temp/SUPER MARIO 64#6906C074#3#2_all$EXT" "$PORT/Objects/Coin/61B21706925CA427346F8C70E1D26D96$EXT"
cp "_temp/SUPER MARIO 64#E5BCF46E#3#2_all$EXT" "$PORT/Objects/Coin/46E58160B6C0BD1DC30CCF774996C324$EXT"
cp "_temp/SUPER MARIO 64#FBE08CAB#3#2_all$EXT" "$PORT/Objects/Coin/52BE23B83A99B389B06950683491E752$EXT"

cp "_temp/SUPER MARIO 64#0DF6BDFF#0#2_all$EXT" "$PORT/Objects/Doors/57F845512BCAA0243C7EF4F04836F117$EXT"
cp "_temp/SUPER MARIO 64#12733B4F#0#2_all$EXT" "$PORT/Objects/Doors/D3A0A067187AC3AB498AC576942D2BFC$EXT"
cp "_temp/SUPER MARIO 64#1EBAE88A#0#2_all$EXT" "$PORT/Objects/Doors/4852EB28AD166821AFD6723C2FF7960A$EXT"
cp "_temp/SUPER MARIO 64#2AAB5196#0#2_all$EXT" "$PORT/Objects/Doors/AB1DF9FBB5F3A35D8C1C642E8E0E5039$EXT"
cp "_temp/SUPER MARIO 64#2F5F1297#0#2_all$EXT" "$PORT/Objects/Doors/1AB95F79F9B6FE9580ED285D8B7AD4A1$EXT"
cp "_temp/SUPER MARIO 64#401B923F#0#2_all$EXT" "$PORT/Objects/Doors/51D18FF200415EB583C1E3922BECCB65$EXT"
cp "_temp/SUPER MARIO 64#4EB8714C#0#2_all$EXT" "$PORT/Objects/Doors/4BEFB3DC373FF544A8FC38339BB60B28$EXT"
cp "_temp/SUPER MARIO 64#877137A9#0#2_all$EXT" "$PORT/Objects/Doors/26D1037CD619CE3A614F52DA546D6628$EXT"
cp "_temp/SUPER MARIO 64#93D4EE01#0#2_all$EXT" "$PORT/Objects/Doors/F64535781400D9B8385F28F9BC77E681$EXT"
cp "_temp/SUPER MARIO 64#9965C006#0#2_all$EXT" "$PORT/Objects/Doors/F19254816F64018651141532D2A5722C$EXT"
cp "_temp/SUPER MARIO 64#9A5A2FB3#0#2_all$EXT" "$PORT/Objects/Doors/35F3207A71C2E3F08D4F3BBC7BF91419$EXT"
cp "_temp/SUPER MARIO 64#9C977CFF#0#2_all$EXT" "$PORT/Objects/Doors/3A122D651A4E79FDB9A7A0A729DFD46F$EXT"
cp "_temp/SUPER MARIO 64#BBC6B061#0#2_all$EXT" "$PORT/Objects/Doors/4D11881B4865B492B6F0BE7BFF240A29$EXT"
cp "_temp/SUPER MARIO 64#C99B5909#0#2_all$EXT" "$PORT/Objects/Doors/8003BB6C36F827E8EC561C90B07C8657$EXT"
cp "_temp/SUPER MARIO 64#F2897E05#0#2_all$EXT" "$PORT/Objects/Doors/B7E08FC588D7E1C076A748FB8D8835C7$EXT"
cp "_temp/SUPER MARIO 64#FD820701#0#2_all$EXT" "$PORT/Objects/Doors/1F59BFD899AA25BEAA77059535E0A8BD$EXT"

cp "_temp/SUPER MARIO 64#CD5F7595#0#2_all$EXT" "$PORT/Objects/Heart/243A26F6D4999E2347CEFB528D124466$EXT"

cp "_temp/SUPER MARIO 64#3F817C21#0#2_all$EXT" "$PORT/Objects/Lava/35C949824B540BB12C1C04C702005EC7$EXT"

cp "_temp/SUPER MARIO 64#946F580C#0#2_all$EXT" "$PORT/Objects/Metal Box/5A2BFB984EF0792785674EA329FE014E$EXT"

cp "_temp/SUPER MARIO 64#67A98771#0#2_all$EXT" "$PORT/Objects/Pipe/A9BA740931C3C22989A6D8C0E8949268$EXT"
cp "_temp/SUPER MARIO 64#E9CABB44#0#2_all$EXT" "$PORT/Objects/Pipe/7302BD44F18D000970F626DBDFC9B1F0$EXT"

cp "_temp/SUPER MARIO 64#31B77240#0#2_all$EXT" "$PORT/Objects/Poundable Pole/D8BB601C68FB84B1C078C4DE47C7D812$EXT"
cp "_temp/SUPER MARIO 64#90027A49#0#2_all$EXT" "$PORT/Objects/Poundable Pole/859F5764577B5A2C81347D030CD7A092$EXT"

cp "_temp/SUPER MARIO 64#3AC6C19C#0#2_all$EXT" "$PORT/Objects/Purple Switch/A58E34E90A8EDB69372DBAEE34D1FC11$EXT"
cp "_temp/SUPER MARIO 64#CD381281#0#2_all$EXT" "$PORT/Objects/Purple Switch/B393371D6BD4D5B082AE0194B7367EEC$EXT"

cp "_temp/SUPER MARIO 64#125E068D#0#2_all$EXT" "$PORT/Objects/Sign/B9E517431CD1FE061768F4863ED5DE0F$EXT"
cp "_temp/SUPER MARIO 64#F09D711E#0#2_all$EXT" "$PORT/Objects/Sign/029A6E46BFF021D9958107218434F9EF$EXT"

cp "_temp/SUPER MARIO 64#10E998F8#0#2_all$EXT" "$PORT/Objects/Star/BD2ABF28562888B7BC79DDEF838768D3$EXT"
cp "_temp/SUPER MARIO 64#1D0F0A8E#0#2_all$EXT" "$PORT/Objects/Star/9A872735FEEC04A26B5EBB4C8072DF36$EXT"

cp "_temp/SUPER MARIO 64#192FA726#0#2_all$EXT" "$PORT/Objects/Trees/A3C26D3F6F257EABA92E2D6BC9DEFCE1$EXT"
cp "_temp/SUPER MARIO 64#3FB69C59#0#2_all$EXT" "$PORT/Objects/Trees/C483C979FF7C3A926F9ECD008FB4FC70$EXT"
cp "_temp/SUPER MARIO 64#7AF18328#0#2_all$EXT" "$PORT/Objects/Trees/DD5EC9CD7598099CC0FA8C00B10185CC$EXT"
cp "_temp/SUPER MARIO 64#B452CBBE#0#2_all$EXT" "$PORT/Objects/Trees/5F72A05297B56140949EF1A1317F62F1$EXT"
cp "_temp/SUPER MARIO 64#C2E48C81#0#2_all$EXT" "$PORT/Objects/Trees/9CB5B175A5C39AA5396E20D8E3A1E0D5$EXT"
cp "_temp/SUPER MARIO 64#C4D1C3CE#0#2_all$EXT" "$PORT/Objects/Trees/E7FAF9048F919B84484CC1B5AB0D049F$EXT"

cp "_temp/SUPER MARIO 64#5095921B#0#2_all$EXT" "$PORT/Objects/Water/B5C4FF94FE1BFE3B8DCE211E8EC5A481$EXT"
cp "_temp/SUPER MARIO 64#DFFBB688#0#2_all$EXT" "$PORT/Objects/Water/2B45E0FE3DF16C9891A158B41D18334E$EXT"
cp "_temp/SUPER MARIO 64#DFFBB688#3#2_all$EXT" "$PORT/Objects/Water/AAA7EF5783AD3D59F5A7EE572BA4E32C$EXT"

cp "_temp/SUPER MARIO 64#14C95BA0#0#2_all$EXT" "$PORT/Objects/Water Bubble/8624951CBAB84D9C34AE6C87EA1BA260$EXT"

cp "_temp/SUPER MARIO 64#8E41FFCD#0#2_all$EXT" "$PORT/Objects/Yellow Sphere/CE7D953E97E0ECBEB2760527962F0D20$EXT"

cp "_temp/SUPER MARIO 64#946E561B#0#2_all$EXT" "$PORT/Paintings/Bob-omb Battlefield/DF67EE6A174C7D2A1F302735165D6A17$EXT"
cp "_temp/SUPER MARIO 64#FC4B4762#0#2_all$EXT" "$PORT/Paintings/Bob-omb Battlefield/37531D73F2F40D13FDAA52FF4C415EFB$EXT"
cp "_temp/SUPER MARIO 64#1C786EE9#0#2_all$EXT" "$PORT/Paintings/Bowser/CA6056A012AB9985F0EA888676A38EF2$EXT"
cp "_temp/SUPER MARIO 64#8D030865#0#2_all$EXT" "$PORT/Paintings/Bowser/C57E5B585AA775A5BABEAC0B58AC5E35$EXT"
cp "_temp/SUPER MARIO 64#B1237167#0#2_all$EXT" "$PORT/Paintings/Bowser/4A8ECD0A200C7D98074CB210AF8037C4$EXT"
cp "_temp/SUPER MARIO 64#EB871023#0#2_all$EXT" "$PORT/Paintings/Bowser/9B003252FEEB5B45F20277653A2A5E8A$EXT"
cp "_temp/SUPER MARIO 64#95C4562E#0#2_all$EXT" "$PORT/Paintings/Cool Cool Mountain/92BEB206179E5EDD7D184F68C869550B$EXT"
cp "_temp/SUPER MARIO 64#B5AC8928#0#2_all$EXT" "$PORT/Paintings/Cool Cool Mountain/CAE7750946AE79397F3520278F072F5F$EXT"
cp "_temp/SUPER MARIO 64#27183C4F#0#2_all$EXT" "$PORT/Paintings/Dire Dire Docks/056A2134A6605D135DC65DF4C8BD29E0$EXT"
cp "_temp/SUPER MARIO 64#3BA43FA1#0#2_all$EXT" "$PORT/Paintings/Jolly Roger Bay/Japan/ECAA9EE9EF4E9F7DCC4E37073BE26778$EXT"
cp "_temp/SUPER MARIO 64#CACFAA39#0#2_all$EXT" "$PORT/Paintings/Jolly Roger Bay/Japan/E2BE1BE7E35CE84276EEC7E92DE92353$EXT"
cp "_temp/SUPER MARIO 64#08B8530E#0#2_all$EXT" "$PORT/Paintings/Jolly Roger Bay/C27286B59D4C42AE86382DE1C37864C6$EXT"
cp "_temp/SUPER MARIO 64#1A4BCC77#0#2_all$EXT" "$PORT/Paintings/Jolly Roger Bay/FC0673968D0C36B2AF148C6AD61261E6$EXT"
cp "_temp/SUPER MARIO 64#8300DD14#0#2_all$EXT" "$PORT/Paintings/Lethal Lava Land/DC0EEBA8852E5E20CD40D39BFD64E7E6$EXT"
cp "_temp/SUPER MARIO 64#A8FF4543#0#2_all$EXT" "$PORT/Paintings/Lethal Lava Land/265CC881275DD894990CE27C5C2C713A$EXT"
cp "_temp/SUPER MARIO 64#678BBBC1#0#2_all$EXT" "$PORT/Paintings/Peach/A5E01D2BD614011D35F8CD3C516F52F4$EXT"
cp "_temp/SUPER MARIO 64#73D7C121#0#2_all$EXT" "$PORT/Paintings/Peach/2F18565430C12D058E2EC186A389A0A9$EXT"
cp "_temp/SUPER MARIO 64#A08E284C#0#2_all$EXT" "$PORT/Paintings/Peach/26514EBA2FC3C34BB2587ADC7E2D13FD$EXT"
cp "_temp/SUPER MARIO 64#CB7B6E97#0#2_all$EXT" "$PORT/Paintings/Peach/090B96CA5CC3C90A56547610432C59E8$EXT"
cp "_temp/SUPER MARIO 64#CCA2987C#0#2_all$EXT" "$PORT/Paintings/Shifting Sand Land/B50374522598C93E10103AF353CC2339$EXT"
cp "_temp/SUPER MARIO 64#D2A1C338#0#2_all$EXT" "$PORT/Paintings/Shifting Sand Land/02478BB7B45AEC580AA132DB2E1C59D7$EXT"
cp "_temp/SUPER MARIO 64#33AE70AA#0#2_all$EXT" "$PORT/Paintings/Snowman's Land/8F873D35635530AECD5505C8EADB9913$EXT"
cp "_temp/SUPER MARIO 64#6FF2AAC5#0#2_all$EXT" "$PORT/Paintings/Snowman's Land/80ACCEC94F94D75FA5204C86D566AF8E$EXT"
cp "_temp/SUPER MARIO 64#603AB9FE#0#2_all$EXT" "$PORT/Paintings/Tall Tall Mountain/6D27576F0FC03C33DC0F47EF9D6A7313$EXT"
cp "_temp/SUPER MARIO 64#FE391DDB#0#2_all$EXT" "$PORT/Paintings/Tall Tall Mountain/0A85E2C0D6A3B6EB51938CDEF49E6EAA$EXT"
cp "_temp/SUPER MARIO 64#239F9E44#0#2_all$EXT" "$PORT/Paintings/Tick Tock Clock/FBBAB261D41713A6B6DEBE3144078612$EXT"
cp "_temp/SUPER MARIO 64#981FC4C1#0#2_all$EXT" "$PORT/Paintings/Tick Tock Clock/FCA9075B94DC1BB0B0C6ACBC566117F3$EXT"
cp "_temp/SUPER MARIO 64#8B6C6929#0#2_all$EXT" "$PORT/Paintings/Tiny-Huge Island/5EA4F14E8F079CC5A1EE4920BD1E96D3$EXT"
cp "_temp/SUPER MARIO 64#DEAE047B#0#2_all$EXT" "$PORT/Paintings/Tiny-Huge Island/F955C8785FBB82278089B5CB3EB832B4$EXT"
cp "_temp/SUPER MARIO 64#B6A89482#0#2_all$EXT" "$PORT/Paintings/Wet-Dry World/4FFB4B93825B5D6513F77EFF68EAE5CB$EXT"
cp "_temp/SUPER MARIO 64#E8FABCC5#0#2_all$EXT" "$PORT/Paintings/Wet-Dry World/C21B730BBAE87FB5B77D14D42E8C13F9$EXT"
cp "_temp/SUPER MARIO 64#88493238#0#2_all$EXT" "$PORT/Paintings/Whomp's Fortress/A59BB2C8CFA99397B9E4DB3FD7C00BA1$EXT"
cp "_temp/SUPER MARIO 64#90EF51BB#0#2_all$EXT" "$PORT/Paintings/Whomp's Fortress/C8EFB025B5E09F9A4518650B73875789$EXT"

cp "_temp/SUPER MARIO 64#02429854#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/CBF51469BA762CD301342AD38CF653D0$EXT"
cp "_temp/SUPER MARIO 64#0571FC7C#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/FDE315F51E8B50EAA2AAA553189E4A61$EXT"
cp "_temp/SUPER MARIO 64#0D6A8490#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/2CD16A8D3EAFB00DE00EBE5E2E8AB642$EXT"
cp "_temp/SUPER MARIO 64#165F940A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/0C417FE299D3C908CB7DE05C08481511$EXT"
cp "_temp/SUPER MARIO 64#339B3765#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/6422AC3C00DD55099609FA5095634D1D$EXT"
cp "_temp/SUPER MARIO 64#3556A0C8#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/604AB337DDB6FDBB2EEA1A18F3D6B4A4$EXT"
cp "_temp/SUPER MARIO 64#46BEFF45#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/2AA980D1E93F4DE21A5943CC9DD83B8F$EXT"
cp "_temp/SUPER MARIO 64#4ED18843#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/9E788189062915BADB79B788B68C01B9$EXT"
cp "_temp/SUPER MARIO 64#51B5CD93#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/50C4BC50E30D17C12ADC539D8EF55664$EXT"
cp "_temp/SUPER MARIO 64#543AE92E#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/3E5E94E1B2C066E37683447717503E9F$EXT"
cp "_temp/SUPER MARIO 64#5691C606#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/440DE0FB1149866B9AEEFFABCF6E50D4$EXT"
cp "_temp/SUPER MARIO 64#5DDD4BF0#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/A7A38F3C8CD16E53AC327856ACB12556$EXT"
cp "_temp/SUPER MARIO 64#5E819C11#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/04B08FD931DE3FD4D250C44F4D36CA23$EXT"
cp "_temp/SUPER MARIO 64#63820423#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/A6BBA14C9A57B5E0FFFA2C165C6656D1$EXT"
cp "_temp/SUPER MARIO 64#6E88F5E0#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/9D6D1FB010D4D3ACB07573AF6CBE9776$EXT"
cp "_temp/SUPER MARIO 64#72D28485#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/C1FA32039FE0E73738439526BE4E7F35$EXT"
cp "_temp/SUPER MARIO 64#73276400#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/F14F05489C26536B0ACC8737675A85CE$EXT"
cp "_temp/SUPER MARIO 64#7F0C0D1A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/4B0727C28376F5BCF3D65CA364E7E938$EXT"
cp "_temp/SUPER MARIO 64#869D1C9B#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/2115F55AF080C9F064245F2D20FF8682$EXT"
cp "_temp/SUPER MARIO 64#888F7075#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/DC9C51BF4817D5C44AEAE2AFE740B9F9$EXT"
cp "_temp/SUPER MARIO 64#8EDC5BE4#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/F25BB48ED21709672A4A034DB80096CA$EXT"
cp "_temp/SUPER MARIO 64#9663B6F7#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/AB737249A274A4FE5EE47E435C632BF1$EXT"
cp "_temp/SUPER MARIO 64#9C6FA38A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/1E75AD543DDDDECE14DD5673AAF46108$EXT"
cp "_temp/SUPER MARIO 64#9E520CB2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/586F6DEA8DD38921A32D1999B33D2C17$EXT"
cp "_temp/SUPER MARIO 64#AA5A7898#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/168677532E15C7E8781D43948DFEEF8F$EXT"
cp "_temp/SUPER MARIO 64#ACEC3F69#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/5AD061BAC8BD23D53D07088C9B3F8F49$EXT"
cp "_temp/SUPER MARIO 64#AF7B75C2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/3F105853F8E0D4349581A367A78BD31F$EXT"
cp "_temp/SUPER MARIO 64#B3F25163#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/E020B7E485E2E6B7580C20CBAA873A30$EXT"
cp "_temp/SUPER MARIO 64#B45578DC#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/7CD81C77CF80B03B5D6BBE157EE391B7$EXT"
cp "_temp/SUPER MARIO 64#B616A7C2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/74B1268842D6017752373A57CBBEEA8C$EXT"
cp "_temp/SUPER MARIO 64#BA8930C5#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/8F8A6CA97D29D25B27940D6C26ECF89A$EXT"
cp "_temp/SUPER MARIO 64#BD9C82DE#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/5C341490E32242E44DABC28CDFAD85AF$EXT"
cp "_temp/SUPER MARIO 64#BE721E4B#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/137A1EFFBB54E8A67E3569F8E26DABAC$EXT"
cp "_temp/SUPER MARIO 64#C55CA18E#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/581E5959D95156A4A886DC5629398E0F$EXT"
cp "_temp/SUPER MARIO 64#C99F67F2#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/DBE8901F4611A918B6C6682078904E4D$EXT"
cp "_temp/SUPER MARIO 64#D678C04F#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/ED95FC27B9DF3BC498D39849F91F016A$EXT"
cp "_temp/SUPER MARIO 64#D910F455#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/6AFE30548A35B376A946EA72769F7AC6$EXT"
cp "_temp/SUPER MARIO 64#E2FAD209#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/9B0DDC08A02189C01FECB17E8E6C4389$EXT"
cp "_temp/SUPER MARIO 64#EB0DFB0A#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/AF516FAA9CF08D0E7DA4AC9493B0ADE4$EXT"
cp "_temp/SUPER MARIO 64#F5E69D71#0#2_all$EXT" "$PORT/Skybox/Big Boo's Haunt/F3FD3041E2C74091ADF1D46B675A9E79$EXT"

cp "_temp/SUPER MARIO 64#00B11930#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/E8B12B253CC4B9BC6410EC1B69F18DA7$EXT"
cp "_temp/SUPER MARIO 64#05D86D02#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/2F24324871D27CD931E726007474D336$EXT"
cp "_temp/SUPER MARIO 64#0EE19C09#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/1F9E64D0896AF8AF57040C9E2DA3FF16$EXT"
cp "_temp/SUPER MARIO 64#18102121#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/627D354025BDB48C641FDFBFEC6C6BCB$EXT"
cp "_temp/SUPER MARIO 64#1EA893D2#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/2A79FE80E4DFE2DAAF57DA94F4B95ADD$EXT"
cp "_temp/SUPER MARIO 64#216A674D#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/A333E6F8CC8F12F28CA92AEB9259877F$EXT"
cp "_temp/SUPER MARIO 64#22253C7E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/59F2701901802E604078673E01802C0C$EXT"
cp "_temp/SUPER MARIO 64#27D9AF1F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/7E2DA068759BF41A5A0D14AF397B9E46$EXT"
cp "_temp/SUPER MARIO 64#2CFA4B7F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/1F7A1976C6973BA34B8E69AD1C0844ED$EXT"
cp "_temp/SUPER MARIO 64#2FC064C1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/B45A720ABED02ED59C3142285E7C594C$EXT"
cp "_temp/SUPER MARIO 64#2FE9009A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/344DE49DEB3A534B04FA04C0A1B427BF$EXT"
cp "_temp/SUPER MARIO 64#310F4C2C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/DA6F206F7E60C4557C5879F5EEF9C517$EXT"
cp "_temp/SUPER MARIO 64#3324B340#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/138155997DC910688D5F9D0D9FA85C58$EXT"
cp "_temp/SUPER MARIO 64#3CCF8886#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/8C344BDB0DEBD5C42924446C8DED5C50$EXT"
cp "_temp/SUPER MARIO 64#46649148#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C4D32328D32B33EBD9AD82F2EE52C3EE$EXT"
cp "_temp/SUPER MARIO 64#48E57582#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/90A50BC946544A44BB8DA8DCDA0D6C28$EXT"
cp "_temp/SUPER MARIO 64#4CDB236C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/8999562526EE9C1194646358C4C8B0D6$EXT"
cp "_temp/SUPER MARIO 64#4E80FA6F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/2FF34A3772AA4FF3E9BAA4A15D5E4464$EXT"
cp "_temp/SUPER MARIO 64#5050548F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/E56A2EDE5B58661C85B10EC432FEB988$EXT"
cp "_temp/SUPER MARIO 64#58C547BD#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C284156AEC0868A05D2A39761AA4BD31$EXT"
cp "_temp/SUPER MARIO 64#5B01FAF9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/08669B061879CF68377C3E8EFCF863AC$EXT"
cp "_temp/SUPER MARIO 64#6218470C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C00CEA8745F4361B3ECBD00F030A4017$EXT"
cp "_temp/SUPER MARIO 64#68C4A756#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/66148D5D60B6185C22C122EABE4C5EA4$EXT"
cp "_temp/SUPER MARIO 64#6EB6822E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/12A08C3B397999B78CA54BF8C4BAE779$EXT"
cp "_temp/SUPER MARIO 64#718C4694#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/967C643D208E9A661B512A2BF9B35E24$EXT"
cp "_temp/SUPER MARIO 64#75F39E26#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C02B580F4FBD25DBCB79ADE87F316A05$EXT"
cp "_temp/SUPER MARIO 64#7AF76431#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/6E00624FC1102870822916F5D5CA7C9A$EXT"
cp "_temp/SUPER MARIO 64#7F5468E5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/EEB57AA728BBFEA9CCDC861FA564CE87$EXT"
cp "_temp/SUPER MARIO 64#7FCB976C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/6B6FAB989F97B60D32FA3A2971622ECE$EXT"
cp "_temp/SUPER MARIO 64#8093D98D#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/15F55E791517E8583B487CE086F2B607$EXT"
cp "_temp/SUPER MARIO 64#908BB0A5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/174EDA383570FD8F9C7E5D9C17AC10EE$EXT"
cp "_temp/SUPER MARIO 64#9205F8FC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/328A90962B7CF8FECCBF3E9416BFCF8C$EXT"
cp "_temp/SUPER MARIO 64#92914C1C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/73DE8E2A9B1A00F2967B45B0E999AEE7$EXT"
cp "_temp/SUPER MARIO 64#93507E3B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/3C33F94DE5AAACB0F2E4FADC85A54CBD$EXT"
cp "_temp/SUPER MARIO 64#937650B4#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/D324421B90C07DA4FDBF4C9E9C939BA8$EXT"
cp "_temp/SUPER MARIO 64#9E94B9F1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/FD1C420B8E8840B85E66414A8947B116$EXT"
cp "_temp/SUPER MARIO 64#9F6DD214#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/6E923E71A108C851DD8CBE52ED750DAF$EXT"
cp "_temp/SUPER MARIO 64#A4316E88#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/70D9832AFE37445870F2D47134C0B1AC$EXT"
cp "_temp/SUPER MARIO 64#ADB81440#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/3ACEFBDF1CFD7839D484D7C1C9FC3DA7$EXT"
cp "_temp/SUPER MARIO 64#AE39BA68#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/AFEC2B5A1BB245EE6FA969D61735B3BA$EXT"
cp "_temp/SUPER MARIO 64#B2EFD400#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/86777C0615208693751FEA489A8C8803$EXT"
cp "_temp/SUPER MARIO 64#B76D42DD#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/6D92B4748A37F571D5AD69AD1503096A$EXT"
cp "_temp/SUPER MARIO 64#BE0750A6#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/56593E99881C9D2ADEB644B78E19BB20$EXT"
cp "_temp/SUPER MARIO 64#BE5AB2EE#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/7C55C441F9BA4FA38000A13AFBAD8FAC$EXT"
cp "_temp/SUPER MARIO 64#BE610D43#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/2C1FEAC501E7081C3C1D1F87762EEE4A$EXT"
cp "_temp/SUPER MARIO 64#BFA0DFE0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/0259D1F8ACC21C1BEF583DE7859B1F5F$EXT"
cp "_temp/SUPER MARIO 64#BFE56F11#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/265E0DBC8881BE27533D31B00A70F049$EXT"
cp "_temp/SUPER MARIO 64#C30B4FE2#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/D91835B782464ABE84BCD312BF3288EF$EXT"
cp "_temp/SUPER MARIO 64#C39651E5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/53E1F377D93B660B02D6B9A3F29783D3$EXT"
cp "_temp/SUPER MARIO 64#C4C331E8#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/22967CE0A76F1E05DF6E527BE2708AF1$EXT"
cp "_temp/SUPER MARIO 64#C4C356FA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/EE11B7A9FF911CAC95D6E8965795D6F2$EXT"
cp "_temp/SUPER MARIO 64#CB67DA9F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C57CDB8EB244882882CE581D3CD75FAB$EXT"
cp "_temp/SUPER MARIO 64#CC89FE99#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/E7AFF599F0412D616FB652191EC6F0E9$EXT"
cp "_temp/SUPER MARIO 64#D1B72B53#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/3A9F3B87CEFCF44F0F462D12B90CCD1A$EXT"
cp "_temp/SUPER MARIO 64#D4FECE2C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C8EE8525D44D9AAE32E1859BC003DF51$EXT"
cp "_temp/SUPER MARIO 64#D660A2AE#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/4F10830766ECA554ECC5869FD2321048$EXT"
cp "_temp/SUPER MARIO 64#D89FBCA9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/5AA2374225A2243746A9736AD57F8B0D$EXT"
cp "_temp/SUPER MARIO 64#D8A463DF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/60BD33F95A0241D3F2AF1D7269DD75F4$EXT"
cp "_temp/SUPER MARIO 64#D97FB4F5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/589B357A9D82844295ECD2C3BAABE94C$EXT"
cp "_temp/SUPER MARIO 64#DC08D520#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/6B6E80D30E3DE1906B72E2EBA0940712$EXT"
cp "_temp/SUPER MARIO 64#DE38650F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/FA699F93A6DD6E2463E6E4331A2D1CA5$EXT"
cp "_temp/SUPER MARIO 64#DF07ED35#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/212C884F3D27ABC3A4684845AAB384DE$EXT"
cp "_temp/SUPER MARIO 64#FAAFF848#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/C2C842EBECB797CCCB74DB7DC2279724$EXT"
cp "_temp/SUPER MARIO 64#FC6EF688#0#2_all$EXT" "$PORT/Skybox/Bowser in the Dark World/E197F653DF702A49C7C8E55B76B11DF6$EXT"

cp "_temp/SUPER MARIO 64#07155D85#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/9508CEBAEFBDE5DFC5E5AB5384003FE7$EXT"
cp "_temp/SUPER MARIO 64#07FF7CD2#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/4FD23B91E4380F85F288B57B63103286$EXT"
cp "_temp/SUPER MARIO 64#22348F8B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/A15054D02BB033540F7E1DD9481FF3CF$EXT"
cp "_temp/SUPER MARIO 64#27B1AA10#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/5C9369450B217EB50EEF86C03485D2A7$EXT"
cp "_temp/SUPER MARIO 64#2FA4B137#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/40C4FC8623B8B9B4931911FF664E3A57$EXT"
cp "_temp/SUPER MARIO 64#3342AE2E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/0AC6DBB3C3334EC602357CC8866C3F43$EXT"
cp "_temp/SUPER MARIO 64#3D7ADDE3#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/0DEF0A7F16AD63BDE622ABB01823F54B$EXT"
cp "_temp/SUPER MARIO 64#4783C2BF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/375CCE0E3D237F36C692C53ABB6E1088$EXT"
cp "_temp/SUPER MARIO 64#49D68918#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/18A99795003402ED8AA8ACD3085E07B8$EXT"
cp "_temp/SUPER MARIO 64#4F1CAC41#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/226FE57C68ADE0AD7BFD3A769B5E7A3E$EXT"
cp "_temp/SUPER MARIO 64#5FC183BA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/152BC5374E7574A62972F177B5DBEA78$EXT"
cp "_temp/SUPER MARIO 64#63860579#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/BDAFBAFFD52A2FE95C9458ADF369E58D$EXT"
cp "_temp/SUPER MARIO 64#6872E4FF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/A174A107577F85812258259BA8DF3D06$EXT"
cp "_temp/SUPER MARIO 64#6E969590#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/1072F30271A811C03118BD0CC6306A94$EXT"
cp "_temp/SUPER MARIO 64#81175ED5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/7A150B43FFBA59EB6F471039D416CA37$EXT"
cp "_temp/SUPER MARIO 64#812626F9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/6099B151FF086AC846E6C69632899780$EXT"
cp "_temp/SUPER MARIO 64#99302633#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/CA6F78E69A5EC3512F7E4B67AABF3364$EXT"
cp "_temp/SUPER MARIO 64#9E30AED1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/1F0DB03CA3B3CA39F6BE028C57C373F9$EXT"
cp "_temp/SUPER MARIO 64#9E4203FF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/C11865AAC34DEA3FEFCADF2CB691275B$EXT"
cp "_temp/SUPER MARIO 64#9EB76583#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/F8BC300C8C6EC0E02C60A47B2593B463$EXT"
cp "_temp/SUPER MARIO 64#A46217AB#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/BDFA6E5C89F39BAE5FA0301948289303$EXT"
cp "_temp/SUPER MARIO 64#A5063ADB#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/0E98E62896F18084E9F6CD42E3773280$EXT"
cp "_temp/SUPER MARIO 64#B453CC4A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/0E92D85E8C6FE73107784E0A546C0EB1$EXT"
cp "_temp/SUPER MARIO 64#B8AB2C4E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/4BE1370F5A18EE1A4C9E7C05A8268AE0$EXT"
cp "_temp/SUPER MARIO 64#BB5327E0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/722580741141C8AE9A9AAE7C46A05616$EXT"
cp "_temp/SUPER MARIO 64#BDE331E7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/ABD4102A760438C2C6FE00372214FF1F$EXT"
cp "_temp/SUPER MARIO 64#BFAFF600#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/B58D81C11FF068772E41594425B1C455$EXT"
cp "_temp/SUPER MARIO 64#CE142635#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/C238C8A1A7301345990D3E2B2BAD4672$EXT"
cp "_temp/SUPER MARIO 64#CEB6CAA7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/E4E81FFF3FE0FB4A4601CE627A83E1AC$EXT"
cp "_temp/SUPER MARIO 64#CF390916#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/ADDC9DC93DE8BE8251E44A4DB809499E$EXT"
cp "_temp/SUPER MARIO 64#DAA65AFC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/393DF0CE13E9C92063D8F57733AF469D$EXT"
cp "_temp/SUPER MARIO 64#DCDCA548#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/94FA5ECD7CE80EC2E494E016EE1B1FA7$EXT"
cp "_temp/SUPER MARIO 64#DDBE80A7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/1FFCDDF12E2D1FC28986B0C9E258F7F4$EXT"
cp "_temp/SUPER MARIO 64#DF0E0D87#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/8C859C004978BC2269FC3030EB9AF046$EXT"
cp "_temp/SUPER MARIO 64#E00D840E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/8F157C463EFF6D81C8668CC2C7CEBDD7$EXT"
cp "_temp/SUPER MARIO 64#E398C0E5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/1A8FC2486F952AF59DD498E018091314$EXT"
cp "_temp/SUPER MARIO 64#E6061D88#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/59CF4B5EA1112CFF80B58339F62441F2$EXT"
cp "_temp/SUPER MARIO 64#E6959DA0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/C74B50AD092B8977E0E53F763B5931D0$EXT"
cp "_temp/SUPER MARIO 64#E69D9617#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/222F0AC65434F65084067F16CA92523C$EXT"
cp "_temp/SUPER MARIO 64#E7161D98#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/16692B998466C76989884FF6F6659975$EXT"
cp "_temp/SUPER MARIO 64#EA566CB8#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/2E8A13E0430FF9399622BAC44E96123E$EXT"
cp "_temp/SUPER MARIO 64#EE949D98#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/F95781FC7E7E6260FB4A3020F78897B8$EXT"
cp "_temp/SUPER MARIO 64#EF161D97#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/E148EEB4161710DEDDBDF8521AD85864$EXT"
cp "_temp/SUPER MARIO 64#EF44FC69#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/A54598BB44BFC1BF95F00311A6910952$EXT"
cp "_temp/SUPER MARIO 64#F8CC42D7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/58263D5CF562CF72C0F89A0EB3BABFF5$EXT"
cp "_temp/SUPER MARIO 64#F9889333#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/81A1F300A50DDFBD8278973871670A88$EXT"
cp "_temp/SUPER MARIO 64#FF309AA3#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/F6567035D8B5282A48B7834DB2F15903$EXT"
cp "_temp/SUPER MARIO 64#FFDEBBC5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Fire Sea/ED02640DDADD16EDCA1425FD93F68F79$EXT"

cp "_temp/SUPER MARIO 64#069F68D5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/D2F8135746B3921C32DBF78D049E4FAB$EXT"
cp "_temp/SUPER MARIO 64#0771AB54#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/B9361840B5F021CDFB0294B8646F01C3$EXT"
cp "_temp/SUPER MARIO 64#0A18ADCA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/69CB2929BE25919000FA544AEA4FA8C2$EXT"
cp "_temp/SUPER MARIO 64#11543850#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/BEA2C73B5DA7DCEDA114DE2BFC77A239$EXT"
cp "_temp/SUPER MARIO 64#1450F56E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/3AAB93C63DEE9169A5C78DB754B167CF$EXT"
cp "_temp/SUPER MARIO 64#14C6A0DB#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/110237CB65AA2D175FAB3A005E2BA40F$EXT"
cp "_temp/SUPER MARIO 64#17F35F3C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/AA867F70B86D765049F4754D76EB1F3C$EXT"
cp "_temp/SUPER MARIO 64#18A7104C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/E9DCFC4031AD38D9C60C70AC1AFBCB50$EXT"
cp "_temp/SUPER MARIO 64#21854115#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/5C48F0245FB1244C1321A885D140BED3$EXT"
cp "_temp/SUPER MARIO 64#24AD7055#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/1AAE41BB54EAAC06CAFF7853473D17E6$EXT"
cp "_temp/SUPER MARIO 64#2A9F12C7#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/5EF6AF94AD55BD44F43B506EB1D4B289$EXT"
cp "_temp/SUPER MARIO 64#2B3F9B9C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/C574E1B19BD41A43ECF8B0F758FAD522$EXT"
cp "_temp/SUPER MARIO 64#2C246943#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/FF2705C70261BD69F17C97FE6E366E8F$EXT"
cp "_temp/SUPER MARIO 64#2C44217C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/E812302424E187E9CECA284D2CB48A33$EXT"
cp "_temp/SUPER MARIO 64#2CE5532E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/9860A197E165425D9C6F492DA54B0323$EXT"
cp "_temp/SUPER MARIO 64#2ECE83FA#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/15DC5473FE9CD6543E5089E92BDA4FB1$EXT"
cp "_temp/SUPER MARIO 64#308C95F5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/996AF6DB00AB6448AF2D4D1FA55E2C7D$EXT"
cp "_temp/SUPER MARIO 64#34E02944#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/CB602F0C6704D2BB5914AA0848F54F8A$EXT"
cp "_temp/SUPER MARIO 64#41D56401#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/802B5E3FA8C650ACBCF2E0924C7F267C$EXT"
cp "_temp/SUPER MARIO 64#42F2325A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/5866D206928CC1A75E5A17CBB9627EAE$EXT"
cp "_temp/SUPER MARIO 64#44D5AA4B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/507917B9541791A28ED0DD0D9FBCB39C$EXT"
cp "_temp/SUPER MARIO 64#452AAD60#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/1D513B694E12DE834661CBF7F52C33A1$EXT"
cp "_temp/SUPER MARIO 64#486F9BD1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/CE7BE0B63984B72ACF35AF4336A27A87$EXT"
cp "_temp/SUPER MARIO 64#4CEEF375#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/E26F75FA6024D06489A02B2A898C43DA$EXT"
cp "_temp/SUPER MARIO 64#4F503C6E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/D9554416C46E10A315BC43FCC081AFA1$EXT"
cp "_temp/SUPER MARIO 64#51256D7A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/AE9536D632FC55C44E29AFE14E908ED0$EXT"
cp "_temp/SUPER MARIO 64#58A11D1E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/06669F96F37D2B20BDF5CBB0B05A67F1$EXT"
cp "_temp/SUPER MARIO 64#5C153DAF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/C078CF937CBE8F436BD18AEA2CA145AF$EXT"
cp "_temp/SUPER MARIO 64#677A5E03#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/E84D2C1D8603B50850A8D31B3B72F9CA$EXT"
cp "_temp/SUPER MARIO 64#688DEFB4#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/781DEEBD8FB6763C1CDDBD2AA369624A$EXT"
cp "_temp/SUPER MARIO 64#68CBBCD3#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/2CC2DBCCA50C0DB106CAC0B327E163C5$EXT"
cp "_temp/SUPER MARIO 64#6DABF6C8#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/7A95DEA81CF73E6A32C76FF558B6A86F$EXT"
cp "_temp/SUPER MARIO 64#6F964986#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/BB8B79D7CA8A21D6DE1B1F470ABF8217$EXT"
cp "_temp/SUPER MARIO 64#747B1B07#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/4AC6DD97A7837FFF602D1F3E636343E6$EXT"
cp "_temp/SUPER MARIO 64#795FE3B9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/F1B287E0A453DD74D018AE5E03E65425$EXT"
cp "_temp/SUPER MARIO 64#7D398EF0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/11B1272C1D316C176C51E238D18181CF$EXT"
cp "_temp/SUPER MARIO 64#7DCC1AB5#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/32F0602F34963FC6721A1DFE1431D802$EXT"
cp "_temp/SUPER MARIO 64#8141BBBC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/9D0F0F07195D2ED6D15388E0CE401B0C$EXT"
cp "_temp/SUPER MARIO 64#84EB583E#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/5B4E82F602D3EDAB1433FF81D216FDE6$EXT"
cp "_temp/SUPER MARIO 64#930392D9#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/47B0463BAC114261C2014E53B97C85A8$EXT"
cp "_temp/SUPER MARIO 64#9791B947#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/FE2DD6801A3A6FAC540ADDF5D9AEFADA$EXT"
cp "_temp/SUPER MARIO 64#9AF43B47#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/76E2BAF80C7CC7F67FBEBA7EC9CB515A$EXT"
cp "_temp/SUPER MARIO 64#A349A078#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/1A4A85A27955C4513338AD5991D4C0F7$EXT"
cp "_temp/SUPER MARIO 64#A436E205#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/BAF623A326726DA9299556BDF74D0290$EXT"
cp "_temp/SUPER MARIO 64#A9F1685A#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/379DE5BA33A331D94A08621BB2ED9AA4$EXT"
cp "_temp/SUPER MARIO 64#AA0F24EC#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/BD79345DFE7A5DEBB6A34465237144A1$EXT"
cp "_temp/SUPER MARIO 64#B2444E60#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/3EAD61AA55259D606A0A1DBA3D6D1CAF$EXT"
cp "_temp/SUPER MARIO 64#B26D42C0#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/4C38AFBAA326CF7169AAE3256F9B599A$EXT"
cp "_temp/SUPER MARIO 64#B271DB5B#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/E20ECA04951C4F1B042B6C7737F4521D$EXT"
cp "_temp/SUPER MARIO 64#B5DA0B63#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/7047F3F2E21586417ED178049A12EFBB$EXT"
cp "_temp/SUPER MARIO 64#B602AB34#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/E2B832E50C5D35906B3C65A5E9BBE80F$EXT"
cp "_temp/SUPER MARIO 64#B92BF6C1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/5AE106C44AFF792E54D2ACC4CFA110B6$EXT"
cp "_temp/SUPER MARIO 64#C80078C1#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/9FAD84E2B4931D30DB920A70FA444FEF$EXT"
cp "_temp/SUPER MARIO 64#D6ACB89D#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/ACF1646DAFBB367D65423B70B6D764D7$EXT"
cp "_temp/SUPER MARIO 64#D97D5A21#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/83A6322F2D7786F885A848569167D158$EXT"
cp "_temp/SUPER MARIO 64#DB37FF1F#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/5DC75FA5784A34526220A119B1AE08D2$EXT"
cp "_temp/SUPER MARIO 64#DD5AE929#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/14F4813515B858CBD7E3A3FC85BA339C$EXT"
cp "_temp/SUPER MARIO 64#DE415A3C#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/0137FD7478948913065591EF8539C1C2$EXT"
cp "_temp/SUPER MARIO 64#E144C219#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/018170AE7E87850D8CFB003A5CCA5558$EXT"
cp "_temp/SUPER MARIO 64#EC004254#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/A47772257C1687982797CB556FC9ED9B$EXT"
cp "_temp/SUPER MARIO 64#F5D9E5BF#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/93FC87B2D55866FF3C5D188E05D1FE04$EXT"
cp "_temp/SUPER MARIO 64#F69986CE#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/2B3328BBC1A46DDE60CC116274293176$EXT"
cp "_temp/SUPER MARIO 64#FC0DD433#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/3D753755BF7762F00361B07079BB26B0$EXT"
cp "_temp/SUPER MARIO 64#FCFC8637#0#2_all$EXT" "$PORT/Skybox/Bowser in the Sky/2E01D0167EE1A933ADDBE5B4530AE009$EXT"

cp "_temp/SUPER MARIO 64#027C89DB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/8150D40030737553FF345C7695D2667E$EXT"
cp "_temp/SUPER MARIO 64#02AADDF6#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/BC7B496C033EA149EA518B6458F5A7DB$EXT"
cp "_temp/SUPER MARIO 64#031DC071#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/65773FC980EC6906D468A79554E147CC$EXT"
cp "_temp/SUPER MARIO 64#05EC9E16#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/243DD36088904631A39F4BDDACA0D889$EXT"
cp "_temp/SUPER MARIO 64#0F1C2159#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/04016632BA9C1F71CF919B53797F77E1$EXT"
cp "_temp/SUPER MARIO 64#212A4546#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/125B2C17785235576AF48B89AEEF9ADE$EXT"
cp "_temp/SUPER MARIO 64#24A049BD#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/BA41A967333D80998ABD4E0E18FC3369$EXT"
cp "_temp/SUPER MARIO 64#2D31F48B#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/F15DA74E281ED80DDE467B9A03ACA6D2$EXT"
cp "_temp/SUPER MARIO 64#2DDB1AB2#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/E3B272E7429066B5248F9FE0CAC2C500$EXT"
cp "_temp/SUPER MARIO 64#32DA5C54#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/A2FBD72858844C6ED1319CDFB5F82357$EXT"
cp "_temp/SUPER MARIO 64#408779A6#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/37E4A986FF9D16C9F0807EBE4CFD15B2$EXT"
cp "_temp/SUPER MARIO 64#40AD9DAB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/C23780824B744B86EDC59ABD105513AE$EXT"
cp "_temp/SUPER MARIO 64#48A5F126#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/E2164FD6C50380E1FE0BAEB982598E33$EXT"
cp "_temp/SUPER MARIO 64#49A828DB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/FCF6E139CA7ACBEF88D625D93DB54652$EXT"
cp "_temp/SUPER MARIO 64#54CA6DDC#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/904FED0E451A86A9EF00859108B232EA$EXT"
cp "_temp/SUPER MARIO 64#579B80B3#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/A6DC9B21FF379E6D22DBDEFA9070F355$EXT"
cp "_temp/SUPER MARIO 64#579D6C8A#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/E1B99860EDDCC36A8014965ECB4F8D8D$EXT"
cp "_temp/SUPER MARIO 64#57DD4DE0#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/24656E290984834A1A75D934ED538BBD$EXT"
cp "_temp/SUPER MARIO 64#5D58D20C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/AFE25DF5E1C6C261058919E21F6B6FB5$EXT"
cp "_temp/SUPER MARIO 64#613A2612#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/5FE5760DF14D8147C33CC4849B3FE7C6$EXT"
cp "_temp/SUPER MARIO 64#626B987C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/99AE7ECC64035F8CD4ECB831974F8DB3$EXT"
cp "_temp/SUPER MARIO 64#648DFFC2#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/971A473E6AFE5EE5E20677FED60246DB$EXT"
cp "_temp/SUPER MARIO 64#677CF935#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/F95843CE9BFF2CC8AD2236027DBFE078$EXT"
cp "_temp/SUPER MARIO 64#6D00C07C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/BA5ECFA78A7F263C5BF61D721BA6F48E$EXT"
cp "_temp/SUPER MARIO 64#71D8C330#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/F1B5706857A58B9D2B23700FC8D2D392$EXT"
cp "_temp/SUPER MARIO 64#71FFBF4D#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/F080EE173A09478333B06FB03FB238E0$EXT"
cp "_temp/SUPER MARIO 64#74C13ED4#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/AAF4C0F5DFC53649A5E8AA165EABA8E7$EXT"
cp "_temp/SUPER MARIO 64#76ABE6DB#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/A0C529880ED4DD1825BED27730687C41$EXT"
cp "_temp/SUPER MARIO 64#76F2963D#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/C3D2899BD13B20B6F76F5595AB745D8A$EXT"
cp "_temp/SUPER MARIO 64#7C98DFA7#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/BDF9E5A2E320F1506DE3DD67FEAC895B$EXT"
cp "_temp/SUPER MARIO 64#7E91D91E#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/A1AE5B252D6CB9E188723E77DE2BF8B3$EXT"
cp "_temp/SUPER MARIO 64#84651765#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/6639A7D5B03BC4E3E2BC4F2EA0F59A5B$EXT"
cp "_temp/SUPER MARIO 64#86B5C15F#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/54EE1EF2802478BDB184050E93D1B1C2$EXT"
cp "_temp/SUPER MARIO 64#880ED312#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/C5ACD195BDAE9E974FB04CE641FEBFBF$EXT"
cp "_temp/SUPER MARIO 64#889D2B5C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/6E30CECB69BBB9DFEE455864A649C251$EXT"
cp "_temp/SUPER MARIO 64#9FB76A34#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/EB8495637EDB31ECF145AFEE2F255B4B$EXT"
cp "_temp/SUPER MARIO 64#A356667C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/3C26C08376E088A0116BCF6CB5656D92$EXT"
cp "_temp/SUPER MARIO 64#A4908044#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/D795B22AB1F74BCD63BB6293207893EC$EXT"
cp "_temp/SUPER MARIO 64#A87F6678#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/7A151E81B47F2C12381E4E8273D56BB5$EXT"
cp "_temp/SUPER MARIO 64#B09F7FF5#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/3DFD52C29D7308D66BA1E08544FCE3A7$EXT"
cp "_temp/SUPER MARIO 64#B416574C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/F4C100B080CEB75B2B20C48B89726F31$EXT"
cp "_temp/SUPER MARIO 64#B484B601#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/98C8BD714F3E2C48B619427204B79E40$EXT"
cp "_temp/SUPER MARIO 64#BA25C107#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/8C30B79956DE1EB46EF7613E663B949C$EXT"
cp "_temp/SUPER MARIO 64#C70E2879#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/488551BCA5E82D2B58E846AB70E959E2$EXT"
cp "_temp/SUPER MARIO 64#D3D96165#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/64B85D89E88E94CA90A73605A04866AF$EXT"
cp "_temp/SUPER MARIO 64#D3F0D281#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/865A7A0466AEEBBCF65F0D5A91FCE2EA$EXT"
cp "_temp/SUPER MARIO 64#D404F7B3#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/209CF8F325ABDBAF9B6F1DF05B560F71$EXT"
cp "_temp/SUPER MARIO 64#D61DC576#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/11971371E238FA97B10FB6A8D611A5F9$EXT"
cp "_temp/SUPER MARIO 64#D8E02894#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/A0B3C51D9A5B09D8DBDC1F8132A712BB$EXT"
cp "_temp/SUPER MARIO 64#E0901C5A#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/14F3B5284580198A7AADFCCBB3E9012A$EXT"
cp "_temp/SUPER MARIO 64#E6640E91#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/47433FFDA725BDEE386F43B895C01147$EXT"
cp "_temp/SUPER MARIO 64#E747F9B9#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/E60C8080B2A608D223D0D0DA4581D167$EXT"
cp "_temp/SUPER MARIO 64#E7D08E45#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/409B30FD5172398F687ABC2BEDAC27B1$EXT"
cp "_temp/SUPER MARIO 64#EB5C820F#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/D82379A5BBA867544CE5F648C0465989$EXT"
cp "_temp/SUPER MARIO 64#EBA48BA7#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/107DD8FE9B5313754420FB5BE73838C1$EXT"
cp "_temp/SUPER MARIO 64#EBA8BFCA#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/E122FAED07FF7960617C4A51846C8C10$EXT"
cp "_temp/SUPER MARIO 64#EE5C9999#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/A10C15F7706E36B06B775EEAC8FF67DC$EXT"
cp "_temp/SUPER MARIO 64#F03AEF7D#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/919516DFF23941F84CB207C9C2747F24$EXT"
cp "_temp/SUPER MARIO 64#F05AADEE#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/B37F6BDA2EB42C9B729F557831C6D35D$EXT"
cp "_temp/SUPER MARIO 64#F0DD9D26#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/AA31442BF2BB447EC4CC9C106D9B93A6$EXT"
cp "_temp/SUPER MARIO 64#F6BB8446#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/B0195CFF7ED76584A780A1CF2CD9BD73$EXT"
cp "_temp/SUPER MARIO 64#FB04DE95#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/5C0137B4A192A98507EF53CA269C749D$EXT"
cp "_temp/SUPER MARIO 64#FB4E7D3C#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/7A65F046B2F3B7A1A49D11302B7F2595$EXT"
cp "_temp/SUPER MARIO 64#FC424ECC#0#2_all$EXT" "$PORT/Skybox/Cloud Floor/801979FC34D3CA1B64A06FD4D9CB0765$EXT"

cp "_temp/SUPER MARIO 64#019BFB97#0#2_all$EXT" "$PORT/Skybox/Clouds/B3DC84DF507E77CEB182A2F61CA2F850$EXT"
cp "_temp/SUPER MARIO 64#02C423F8#0#2_all$EXT" "$PORT/Skybox/Clouds/DDF9EABC2A83E8AB29361A84CA346C65$EXT"
cp "_temp/SUPER MARIO 64#0A10018C#0#2_all$EXT" "$PORT/Skybox/Clouds/8590FB5ABD65BBBC1CAB23587E1D11E7$EXT"
cp "_temp/SUPER MARIO 64#0D344FC8#0#2_all$EXT" "$PORT/Skybox/Clouds/2CFBAAEF9619BD1997F3ABD510486713$EXT"
cp "_temp/SUPER MARIO 64#214F09C8#0#2_all$EXT" "$PORT/Skybox/Clouds/933A50D9104DD5B6C95AC6F08D876489$EXT"
cp "_temp/SUPER MARIO 64#21676BDD#0#2_all$EXT" "$PORT/Skybox/Clouds/9D48C7B28C4C6B2DAD7329C3E71C22C8$EXT"
cp "_temp/SUPER MARIO 64#2F3FDBA3#0#2_all$EXT" "$PORT/Skybox/Clouds/A46C2946CB0801CDD84AC8413DAB1EE8$EXT"
cp "_temp/SUPER MARIO 64#40E6BBFB#0#2_all$EXT" "$PORT/Skybox/Clouds/16D08FF83463518E32D71AACB6CF336C$EXT"
cp "_temp/SUPER MARIO 64#4A043C67#0#2_all$EXT" "$PORT/Skybox/Clouds/AAD506E4D0CB0DB4440C6619A98571C8$EXT"
cp "_temp/SUPER MARIO 64#540F30FF#0#2_all$EXT" "$PORT/Skybox/Clouds/CC5BA04EA1C78EFCEC40176344A17E47$EXT"
cp "_temp/SUPER MARIO 64#5A838C70#0#2_all$EXT" "$PORT/Skybox/Clouds/AEAE77BBC2376A40CA2A85DB8DBB4FCE$EXT"
cp "_temp/SUPER MARIO 64#6C064A7F#0#2_all$EXT" "$PORT/Skybox/Clouds/E573B6C27BBE76E00DF480CF8955DAFA$EXT"
cp "_temp/SUPER MARIO 64#6C42DFF7#0#2_all$EXT" "$PORT/Skybox/Clouds/6E2ACB7596D20AF8255631370C26040C$EXT"
cp "_temp/SUPER MARIO 64#7F86B16B#0#2_all$EXT" "$PORT/Skybox/Clouds/BFADE00F397060BED46CC2733810727A$EXT"
cp "_temp/SUPER MARIO 64#7FCD908D#0#2_all$EXT" "$PORT/Skybox/Clouds/C29A8C054F20C474785E3C1F6A4F1ACF$EXT"
cp "_temp/SUPER MARIO 64#82C55DC1#0#2_all$EXT" "$PORT/Skybox/Clouds/4203DC82855900EFE38A51EFC01847AE$EXT"
cp "_temp/SUPER MARIO 64#89AC3C05#0#2_all$EXT" "$PORT/Skybox/Clouds/F72841418CB093DE18E3D11507EF909E$EXT"
cp "_temp/SUPER MARIO 64#89CFD188#0#2_all$EXT" "$PORT/Skybox/Clouds/1F25B41586DF87C9544615D5B92F1E76$EXT"
cp "_temp/SUPER MARIO 64#8CC10B27#0#2_all$EXT" "$PORT/Skybox/Clouds/8CB5CCD40C029860C262E73B74F5FA87$EXT"
cp "_temp/SUPER MARIO 64#98C45311#0#2_all$EXT" "$PORT/Skybox/Clouds/388EC2AE9709E064F9205528AB941722$EXT"
cp "_temp/SUPER MARIO 64#98C99A4D#0#2_all$EXT" "$PORT/Skybox/Clouds/5C66A35F84D021EDB7DE86275CA117A8$EXT"
cp "_temp/SUPER MARIO 64#A07BCDE0#0#2_all$EXT" "$PORT/Skybox/Clouds/17C6C0DD0549C3387987329519AAF352$EXT"
cp "_temp/SUPER MARIO 64#A1261BAA#0#2_all$EXT" "$PORT/Skybox/Clouds/769D4971F235EC4E773E4C7CB59364DC$EXT"
cp "_temp/SUPER MARIO 64#A5E5250E#0#2_all$EXT" "$PORT/Skybox/Clouds/922B9227E5A5349B2EE38DD614843782$EXT"
cp "_temp/SUPER MARIO 64#AACF41C9#0#2_all$EXT" "$PORT/Skybox/Clouds/218312F32AAD1D69A6C24C24971C7710$EXT"
cp "_temp/SUPER MARIO 64#AB7A67D1#0#2_all$EXT" "$PORT/Skybox/Clouds/E23B66576A81880520E36777B0CBACBC$EXT"
cp "_temp/SUPER MARIO 64#C0A7D217#0#2_all$EXT" "$PORT/Skybox/Clouds/5D4AB28D5A4A75B69EF4889781FE1F9F$EXT"
cp "_temp/SUPER MARIO 64#C3941398#0#2_all$EXT" "$PORT/Skybox/Clouds/9AC63D5945DFA6EBDE667A9F845D5D0E$EXT"
cp "_temp/SUPER MARIO 64#C63F7ABB#0#2_all$EXT" "$PORT/Skybox/Clouds/66A40B1B5872187679CEB9057E3FBD57$EXT"
cp "_temp/SUPER MARIO 64#C96FD4B4#0#2_all$EXT" "$PORT/Skybox/Clouds/579410197F9F20C732F79F9F59D681E3$EXT"
cp "_temp/SUPER MARIO 64#CABC445D#0#2_all$EXT" "$PORT/Skybox/Clouds/09540E9F2EAA7AF7DE522FE403E6091E$EXT"
cp "_temp/SUPER MARIO 64#D658AB33#0#2_all$EXT" "$PORT/Skybox/Clouds/F2D363951465A97ABA268D96E011F855$EXT"
cp "_temp/SUPER MARIO 64#D7B09499#0#2_all$EXT" "$PORT/Skybox/Clouds/1EA4EA088A73EC4328B3A6B39EBBEF7E$EXT"
cp "_temp/SUPER MARIO 64#DB5B2455#0#2_all$EXT" "$PORT/Skybox/Clouds/A60E3ADA206A67CD780D9C01D5268901$EXT"
cp "_temp/SUPER MARIO 64#DC28412D#0#2_all$EXT" "$PORT/Skybox/Clouds/E79D1C4807E22AFD65DF270C4F95BC82$EXT"
cp "_temp/SUPER MARIO 64#E20D5C69#0#2_all$EXT" "$PORT/Skybox/Clouds/82EB9869F5A1D4BF13A1D31A923CA0AD$EXT"
cp "_temp/SUPER MARIO 64#EEB51695#0#2_all$EXT" "$PORT/Skybox/Clouds/64E121F7BE151081714E9E0CD93D7202$EXT"
cp "_temp/SUPER MARIO 64#F0FD9FE8#0#2_all$EXT" "$PORT/Skybox/Clouds/AA8B151C81B0B2F8774C873555A4D0D5$EXT"
cp "_temp/SUPER MARIO 64#F19D33E5#0#2_all$EXT" "$PORT/Skybox/Clouds/E20517D095553EC8194633211D102C3D$EXT"
cp "_temp/SUPER MARIO 64#FDB6DE70#0#2_all$EXT" "$PORT/Skybox/Clouds/D819CCE8617AFBFD97404F9C777F28D1$EXT"

cp "_temp/SUPER MARIO 64#014C6E73#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/C4F4661D386489E585821768B910420D$EXT"
cp "_temp/SUPER MARIO 64#03EEAB38#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/70495DB8E729E7370579BEA769A7C5EB$EXT"
cp "_temp/SUPER MARIO 64#0BA8D96E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/91A69C90AC125FDE25085C6623F3609F$EXT"
cp "_temp/SUPER MARIO 64#11A852CB#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/9A49C994B9CBD02CDA0CE69E6934DD59$EXT"
cp "_temp/SUPER MARIO 64#221C9F08#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/E8E4240A9989E6D27FE7CE0726E17AA4$EXT"
cp "_temp/SUPER MARIO 64#22628916#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/1461DDA94E943DF2F50F7E4D9A6BD9E1$EXT"
cp "_temp/SUPER MARIO 64#24EC3198#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/8E8BFBBC7CA0C0718FD56E43DCB9700A$EXT"
cp "_temp/SUPER MARIO 64#26A34F80#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/69DBCECC1B5C5D9E8ECD16CB68B597F6$EXT"
cp "_temp/SUPER MARIO 64#32B61B3E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/3D7F1FF32D19537B6C20C64C761DFE19$EXT"
cp "_temp/SUPER MARIO 64#39C55C7F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/7BFA74F52D63FD6C6F732206ADF59F28$EXT"
cp "_temp/SUPER MARIO 64#3CC93124#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/E0CC824D1A2842C24DE4F683D5D64803$EXT"
cp "_temp/SUPER MARIO 64#3FFA0BE7#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/546EEEEC136FDD37CF8F663756A4CC79$EXT"
cp "_temp/SUPER MARIO 64#40226C48#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/046909232C86061555BDDCF02A52CC59$EXT"
cp "_temp/SUPER MARIO 64#46EE72E8#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/E9B0253C0D6641E9AAC0DA5822ABF973$EXT"
cp "_temp/SUPER MARIO 64#51D0A5D0#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/40E640BB35FB951BE75701D60BBB3C69$EXT"
cp "_temp/SUPER MARIO 64#58F28A81#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/76C10AD5CFB191E504289886D066F1C1$EXT"
cp "_temp/SUPER MARIO 64#5C293288#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/D8B3A90BB16724297ADE4E313582FFFB$EXT"
cp "_temp/SUPER MARIO 64#5CC5CAF7#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/E4AC789457BB0B24FA10227108691062$EXT"
cp "_temp/SUPER MARIO 64#64DF79E9#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/0C3243A4A5F0F2C58B9E1FE9C9CA7D24$EXT"
cp "_temp/SUPER MARIO 64#6905FBF2#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/EB0AA5A35D2658386EBC7349D3B22584$EXT"
cp "_temp/SUPER MARIO 64#6DB140AD#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/54EED8CBB59EB5AB967568612452CD18$EXT"
cp "_temp/SUPER MARIO 64#74535372#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/5B98A073FB0305B72BF199058719554A$EXT"
cp "_temp/SUPER MARIO 64#76F2D5AF#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/267F65E4CD3ACAADDBA06A4E8BB78279$EXT"
cp "_temp/SUPER MARIO 64#77EC8240#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/402DB2232482FF9FBC3E3C1CAFD8E5C2$EXT"
cp "_temp/SUPER MARIO 64#8076D349#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/8CDD35D08FFFD1824C9EF2DF44166EF4$EXT"
cp "_temp/SUPER MARIO 64#822B53ED#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/3F1FF1B6AFDB6F32F8B2D8F631A6257D$EXT"
cp "_temp/SUPER MARIO 64#82487DAB#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/8FDE7883829B9544B512ADCC7001BAEB$EXT"
cp "_temp/SUPER MARIO 64#8541D92C#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/2B63FAE767A25B67E1624C413227398D$EXT"
cp "_temp/SUPER MARIO 64#86A4D0DC#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/477D90C23529C333B4926532686311DA$EXT"
cp "_temp/SUPER MARIO 64#8726A741#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/203587D3434853D6C3C2A895E1242150$EXT"
cp "_temp/SUPER MARIO 64#889E61FF#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/666BD21DA588E77F941F33968E0F845C$EXT"
cp "_temp/SUPER MARIO 64#88E7E346#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/45AF1CA5B07310F90929756F8DDA4EB0$EXT"
cp "_temp/SUPER MARIO 64#8B462047#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/134796416B5CA9381628F5734E54B936$EXT"
cp "_temp/SUPER MARIO 64#912F6E5E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/62AAA4FEF6553D2A810D2111A38A495D$EXT"
cp "_temp/SUPER MARIO 64#92A6E121#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/18D3DA2CC8A53219D6E282C808C5FD68$EXT"
cp "_temp/SUPER MARIO 64#99A009D0#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/A347CB8228D648836931F8303481CEC9$EXT"
cp "_temp/SUPER MARIO 64#9DBB856E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/8762F0155A13CE331D97E652F1A9B3B9$EXT"
cp "_temp/SUPER MARIO 64#9F6BFF93#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/B1C99FCA270DBFE625DEBEC47901ADA5$EXT"
cp "_temp/SUPER MARIO 64#9F82C465#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/8586A2CA3B195A0568B586565527BA84$EXT"
cp "_temp/SUPER MARIO 64#A3067F0B#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/4D88C180E79CE91AE8D9DE1CC729D1A3$EXT"
cp "_temp/SUPER MARIO 64#B0FE2869#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/B357395ACA16268B8523D77546B09DC4$EXT"
cp "_temp/SUPER MARIO 64#B1330909#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/53E019AA34BEE1EBB86694A5080CF6C1$EXT"
cp "_temp/SUPER MARIO 64#B858A9A4#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/55944AF62DC9083166858FA1521243A8$EXT"
cp "_temp/SUPER MARIO 64#BB2FB09F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/E5B888B0EB4A8963B16C71F9FA5ABC7D$EXT"
cp "_temp/SUPER MARIO 64#BBED1DAD#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/D862A3D1C87525059291C3EA1FD5D19A$EXT"
cp "_temp/SUPER MARIO 64#BDD76307#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/DCEA4A05B9198EF4CFEF8485AF796EC3$EXT"
cp "_temp/SUPER MARIO 64#BF89DF6A#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/19FA24EE4D4CE8BDC58802F5F1F86127$EXT"
cp "_temp/SUPER MARIO 64#C9425D35#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/93F2D77224C886615945AB6F96F2B503$EXT"
cp "_temp/SUPER MARIO 64#CCAD2F1E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/C7DC2E86D6BF2BEB76CE33AB00CFD121$EXT"
cp "_temp/SUPER MARIO 64#CCFB8478#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/9AD642E158CC40A9BBFFE09343971422$EXT"
cp "_temp/SUPER MARIO 64#CD7A591F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/4EB48A9DB169029AC9D4E73F43FA84BE$EXT"
cp "_temp/SUPER MARIO 64#D2A5272B#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/82CF1881C26273517EF680B4E9E9241F$EXT"
cp "_temp/SUPER MARIO 64#D68E7D47#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/FA17CEF6FF87C8AA0BD3E9E1BBCB689F$EXT"
cp "_temp/SUPER MARIO 64#D742B346#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/7855E88C78E8EF37F9D2E22187FB9F88$EXT"
cp "_temp/SUPER MARIO 64#DA354D71#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/C5D8DFB7C7477C3ABC346F6313A290EE$EXT"
cp "_temp/SUPER MARIO 64#DC5422CC#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/8EE596ECC9D5C7CEA0DA438CF5E310C4$EXT"
cp "_temp/SUPER MARIO 64#DDCBD0BF#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/38749C7D52321C2F980938F1DCD6BEFE$EXT"
cp "_temp/SUPER MARIO 64#DEEF869F#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/AF7FB5B72439C7EE6EC9A1BC7E82DE51$EXT"
cp "_temp/SUPER MARIO 64#E348762E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/C5BBB003368BF1F8999C360CFF8CBE9C$EXT"
cp "_temp/SUPER MARIO 64#E47FB00E#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/A7942C59B9365111A404493BD58D206C$EXT"
cp "_temp/SUPER MARIO 64#E702818C#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/B523AA079280C7C526805987755639C7$EXT"
cp "_temp/SUPER MARIO 64#EB70D69C#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/0B0B52C13C8248FB586C75E80D7AEB07$EXT"
cp "_temp/SUPER MARIO 64#EF1D1E70#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/65156705122FA5F047B053450C891ACC$EXT"
cp "_temp/SUPER MARIO 64#F1301217#0#2_all$EXT" "$PORT/Skybox/Cool Cool Mountain/0983629A863EE49F9649749A08A378BA$EXT"

cp "_temp/SUPER MARIO 64#06AB9733#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/736CF3F4F83E9B4879A2007B5642186E$EXT"
cp "_temp/SUPER MARIO 64#074933DA#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/CE8024A5E80B504E7C57C4509BAC4524$EXT"
cp "_temp/SUPER MARIO 64#082CD478#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/080F91D7AE608D9D0B45456EA86B82EB$EXT"
cp "_temp/SUPER MARIO 64#101CA508#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/454989B99481325AFAF16CC67D8C06CD$EXT"
cp "_temp/SUPER MARIO 64#11F1B791#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/452A3BA2ECA309CBB89C91434C40C573$EXT"
cp "_temp/SUPER MARIO 64#1411177B#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/20EFCC3B28B4E0CF38CA2028A605E266$EXT"
cp "_temp/SUPER MARIO 64#15B65397#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/505F6172D7380729E1DC1C54DA60774C$EXT"
cp "_temp/SUPER MARIO 64#19CF329B#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/30AEDF55B0A8111326FC622858E9A2EF$EXT"
cp "_temp/SUPER MARIO 64#1ADECD70#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/4B8618D310D60A10F174BA4A14BC88D9$EXT"
cp "_temp/SUPER MARIO 64#213EBD50#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/47184B86B0259E95EF2CB66D084F885E$EXT"
cp "_temp/SUPER MARIO 64#2193CD76#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/C42BCE712E886F699C6FD6F17A619921$EXT"
cp "_temp/SUPER MARIO 64#2D6492F4#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/23D8D0125C30BE2FABD5AA30F3954D8D$EXT"
cp "_temp/SUPER MARIO 64#32BEB053#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/A01E557DBD78DC59F971DD8D40A2E680$EXT"
cp "_temp/SUPER MARIO 64#38EC1B66#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/A9A48DBDA57E39C57251F8D9B7AEA26C$EXT"
cp "_temp/SUPER MARIO 64#393BA6AE#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/C030AB9D6CD4636183B5DF7BCE49F5FC$EXT"
cp "_temp/SUPER MARIO 64#3C183177#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/9EDD303CAE9DE30E4D92DDF7BBBF45FC$EXT"
cp "_temp/SUPER MARIO 64#52749E6E#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/131D1C37E348323CCF6E49A1586C07FF$EXT"
cp "_temp/SUPER MARIO 64#52D5A8B9#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/EB37413E25C22191BF558B257342BFC2$EXT"
cp "_temp/SUPER MARIO 64#55EB7A33#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/3B4BF99C2371A66B8C45D95FE184F4EC$EXT"
cp "_temp/SUPER MARIO 64#5F5E3DF7#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/5210D009A9400B7F9F734DED67E2541C$EXT"
cp "_temp/SUPER MARIO 64#62AEFDE2#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/B0E1642CF62F09C337B2827950C2F54B$EXT"
cp "_temp/SUPER MARIO 64#6505FAC3#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/8B56F3CA2EE575CA0D27514754FEA25C$EXT"
cp "_temp/SUPER MARIO 64#67B3CF11#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/F16DC1D7E0A83C813D2F365971DF5AC4$EXT"
cp "_temp/SUPER MARIO 64#6899F91F#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/213CF1B75BD1209C21EA203729EDF216$EXT"
cp "_temp/SUPER MARIO 64#6A17A436#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/428A9A3D468286F25256D1F3055F3F8E$EXT"
cp "_temp/SUPER MARIO 64#6D0C18AA#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/F9422D5DDB9D304175111BB0F532B7DC$EXT"
cp "_temp/SUPER MARIO 64#75EF9A90#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/96DCEE09461CEF9FBF6A4D19C036B2E4$EXT"
cp "_temp/SUPER MARIO 64#79C8997D#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/70A2D59B52AC57B29279446143DBE468$EXT"
cp "_temp/SUPER MARIO 64#7E1D47DB#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/9EB6A8101A3A698DD32589412344E4ED$EXT"
cp "_temp/SUPER MARIO 64#7E27E43F#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/D88C81F976A66292942A029BAC050A84$EXT"
cp "_temp/SUPER MARIO 64#85A91338#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/1D4A3F1D430BED3BC37536ADD1B9B516$EXT"
cp "_temp/SUPER MARIO 64#914AFA93#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/81722B99CA041CFEBD51EB3F47564697$EXT"
cp "_temp/SUPER MARIO 64#91787803#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/99C9794494CB98DD8660A1EF1EF6EDF1$EXT"
cp "_temp/SUPER MARIO 64#96FAD568#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/5151CBBA79B83B253EECD25E0A92AFA6$EXT"
cp "_temp/SUPER MARIO 64#9BF7992D#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/0A76C4191CDD3B361F8D0561B9D9D2EE$EXT"
cp "_temp/SUPER MARIO 64#A0A0A907#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/C9C4974907D8DBDC21AADB6FBFEB7246$EXT"
cp "_temp/SUPER MARIO 64#A34577B4#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/01416D0CFDB1EE77A25E87C38C224088$EXT"
cp "_temp/SUPER MARIO 64#A4B86DC8#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/9F81ADAD5568153177116F67ECDD2A75$EXT"
cp "_temp/SUPER MARIO 64#A4C2448B#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/5233AE8BC967A910D4B54A44B4838E95$EXT"
cp "_temp/SUPER MARIO 64#A6D0D0CC#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/D5B79C844A23F590A17EA9A7E5211507$EXT"
cp "_temp/SUPER MARIO 64#AFCC9DE7#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/B29E15EEEC768BBF0DE2E212FAAFC2BD$EXT"
cp "_temp/SUPER MARIO 64#B0A791EE#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/7CB627D1A6651D1541315536FD7B64B0$EXT"
cp "_temp/SUPER MARIO 64#B1E98F62#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/4646283B605455B6FFAE19FA7D25A670$EXT"
cp "_temp/SUPER MARIO 64#B3C88877#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/CCA46E0B75386FC133ADB0AD20E6B764$EXT"
cp "_temp/SUPER MARIO 64#B44A7CEF#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/1E883503852D9EEA1F11FD6D0B5933CE$EXT"
cp "_temp/SUPER MARIO 64#B48BB452#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/A53E5519EB897AC02A564F532DD7C225$EXT"
cp "_temp/SUPER MARIO 64#B55E9B94#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/BEB8DB54D8479300853C91BFC39FCC7D$EXT"
cp "_temp/SUPER MARIO 64#B7C222A8#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/7073246105E00ACE76B2521E3DF78CCE$EXT"
cp "_temp/SUPER MARIO 64#B8378CD9#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/E16763D3122F9506FC1EC8AED3B28298$EXT"
cp "_temp/SUPER MARIO 64#BD8C842F#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/BF3B260424DB7C7D664766EBC274D2AE$EXT"
cp "_temp/SUPER MARIO 64#BDC75108#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/E7B20CD71C617C8C23AA35D11FB69E3F$EXT"
cp "_temp/SUPER MARIO 64#C6D80BAF#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/67E34DA42BA0D60B3BA07ADB3F52CF69$EXT"
cp "_temp/SUPER MARIO 64#C8922002#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/B77536E824E02F46CC459E97F656D664$EXT"
cp "_temp/SUPER MARIO 64#CB3C5D47#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/D67680D3497D0F25D41AA3A6EDC5B407$EXT"
cp "_temp/SUPER MARIO 64#CEA7425D#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/E4ADB0BAA874C9F6C07AA8380941A11D$EXT"
cp "_temp/SUPER MARIO 64#D26EE300#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/0D696D065C3049CE8A88FC507EA7D507$EXT"
cp "_temp/SUPER MARIO 64#DBA34B25#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/CAE8E51A52F9B3AC1DF1E7BB6033D7E5$EXT"
cp "_temp/SUPER MARIO 64#DDD906E3#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/70B7F61F79B21B2CD00FB393254E4D91$EXT"
cp "_temp/SUPER MARIO 64#DF68E5A6#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/FF0570CE40796A2AB3CC1ACC97FC7E14$EXT"
cp "_temp/SUPER MARIO 64#F16F1966#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/B6E62CE776C2B45095D63C233184AA33$EXT"
cp "_temp/SUPER MARIO 64#F4472DB5#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/6A84675F67B20C1A742F17345BE9C9A7$EXT"
cp "_temp/SUPER MARIO 64#F765D232#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/33CE178015CFF6F6CDBFD14D4EF38CE6$EXT"
cp "_temp/SUPER MARIO 64#FDC48AEB#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/5B83D642B9E3A64035103FF4541426D9$EXT"
cp "_temp/SUPER MARIO 64#FF6C67F0#0#2_all$EXT" "$PORT/Skybox/Shifting Sand Land/7C480AB7468EEC042A090618593F4974$EXT"

cp "_temp/SUPER MARIO 64#011C8C77#0#2_all$EXT" "$PORT/Skybox/Water/3378C2EE8FE3FEFFA843908EFDE9166D$EXT"
cp "_temp/SUPER MARIO 64#08170B98#0#2_all$EXT" "$PORT/Skybox/Water/E4629D85EC9E811286F2215FB1138982$EXT"
cp "_temp/SUPER MARIO 64#0DDC6F87#0#2_all$EXT" "$PORT/Skybox/Water/2BD9FD9BCE0A91A3E9E4826FD6A1BA29$EXT"
cp "_temp/SUPER MARIO 64#1096C02E#0#2_all$EXT" "$PORT/Skybox/Water/788902AAA6DA281B3C17DB7DDD6F84EC$EXT"
cp "_temp/SUPER MARIO 64#112C8257#0#2_all$EXT" "$PORT/Skybox/Water/EC345083AB3690241102132834766D3E$EXT"
cp "_temp/SUPER MARIO 64#1465E49F#0#2_all$EXT" "$PORT/Skybox/Water/940DB3F0574D598236B5A610553E37A0$EXT"
cp "_temp/SUPER MARIO 64#19132BCC#0#2_all$EXT" "$PORT/Skybox/Water/FFEB55C099251024A0D6A39A210B9317$EXT"
cp "_temp/SUPER MARIO 64#1A66C67F#0#2_all$EXT" "$PORT/Skybox/Water/D1B6B507E87E19B73E4709FB744830A2$EXT"
cp "_temp/SUPER MARIO 64#1CA18F8F#0#2_all$EXT" "$PORT/Skybox/Water/4F117BAC60BB5A4FFD591991C041C92E$EXT"
cp "_temp/SUPER MARIO 64#1E940DB1#0#2_all$EXT" "$PORT/Skybox/Water/292014C92CC1675B62A841D6B5D8CBD1$EXT"
cp "_temp/SUPER MARIO 64#1EED9296#0#2_all$EXT" "$PORT/Skybox/Water/9284EF46E41D9C40CC378ED5193693D4$EXT"
cp "_temp/SUPER MARIO 64#208F2137#0#2_all$EXT" "$PORT/Skybox/Water/B196247DB3C7A3C39C25F6E0DF0307A6$EXT"
cp "_temp/SUPER MARIO 64#21DD7803#0#2_all$EXT" "$PORT/Skybox/Water/DB13A3606F97D843A3850D680D18A3C0$EXT"
cp "_temp/SUPER MARIO 64#2499CE37#0#2_all$EXT" "$PORT/Skybox/Water/C1AB0FE1A35B4A2EFBDB022421DD03A9$EXT"
cp "_temp/SUPER MARIO 64#24D27245#0#2_all$EXT" "$PORT/Skybox/Water/A3588781C2D47FF17CE1EBBC9791CCCD$EXT"
cp "_temp/SUPER MARIO 64#258A8627#0#2_all$EXT" "$PORT/Skybox/Water/A5B293B6127DC6F84ECC60053CCE859A$EXT"
cp "_temp/SUPER MARIO 64#29904548#0#2_all$EXT" "$PORT/Skybox/Water/B8704AF79C85A6F72DAD1D9CEB72860F$EXT"
cp "_temp/SUPER MARIO 64#2E5DD16D#0#2_all$EXT" "$PORT/Skybox/Water/67F782EA2B12923BED2CC09858B814A6$EXT"
cp "_temp/SUPER MARIO 64#3AADB102#0#2_all$EXT" "$PORT/Skybox/Water/B9DB9FC9A50BBB5F77883F3C1C21440B$EXT"
cp "_temp/SUPER MARIO 64#3AE6BEC9#0#2_all$EXT" "$PORT/Skybox/Water/132DDF5E761C6AA2765F75D4DDB81745$EXT"
cp "_temp/SUPER MARIO 64#3D21394E#0#2_all$EXT" "$PORT/Skybox/Water/BEC4200040DE41BB090980E45E6B9EAC$EXT"
cp "_temp/SUPER MARIO 64#3D244F64#0#2_all$EXT" "$PORT/Skybox/Water/3DC7AE7129AEAF960D82B25A56FE361E$EXT"
cp "_temp/SUPER MARIO 64#3D354167#0#2_all$EXT" "$PORT/Skybox/Water/5C45CE70B3DF44C90EE28F607E62CB99$EXT"
cp "_temp/SUPER MARIO 64#4089D798#0#2_all$EXT" "$PORT/Skybox/Water/45C48CA1369381EDAF6B1F863B85A5CA$EXT"
cp "_temp/SUPER MARIO 64#45F63AE1#0#2_all$EXT" "$PORT/Skybox/Water/D7299A6A0EB64608E80ACF5B9868DBE4$EXT"
cp "_temp/SUPER MARIO 64#48BC2FC8#0#2_all$EXT" "$PORT/Skybox/Water/C5C0F369E0F3507142FD76B25D8AEFBF$EXT"
cp "_temp/SUPER MARIO 64#4BCAE8D6#0#2_all$EXT" "$PORT/Skybox/Water/64403FF4CFA98D9A511944D44D7CF18D$EXT"
cp "_temp/SUPER MARIO 64#4D606A9B#0#2_all$EXT" "$PORT/Skybox/Water/F75F4CF294286AA94D2D86A81C3B28AC$EXT"
cp "_temp/SUPER MARIO 64#53CBF3E0#0#2_all$EXT" "$PORT/Skybox/Water/2E019CA7414110944130F7894EFE3D49$EXT"
cp "_temp/SUPER MARIO 64#5643908B#0#2_all$EXT" "$PORT/Skybox/Water/9D1F2F5CC018CC3439748A3A22E38A3E$EXT"
cp "_temp/SUPER MARIO 64#5730FAAA#0#2_all$EXT" "$PORT/Skybox/Water/7D462A8A340679F5C123EE746D5B6F90$EXT"
cp "_temp/SUPER MARIO 64#599DA7CB#0#2_all$EXT" "$PORT/Skybox/Water/F10DE8706384D7E51295050BBAB23A3C$EXT"
cp "_temp/SUPER MARIO 64#5A2FA13A#0#2_all$EXT" "$PORT/Skybox/Water/69F5A25A42B69642E64465DB3E065D1E$EXT"
cp "_temp/SUPER MARIO 64#60DD861C#0#2_all$EXT" "$PORT/Skybox/Water/563413381986C79767E6E6074C8AF97B$EXT"
cp "_temp/SUPER MARIO 64#65ABBFE9#0#2_all$EXT" "$PORT/Skybox/Water/E40A9F4F354ABDF576532920D0383E68$EXT"
cp "_temp/SUPER MARIO 64#6ACA7D17#0#2_all$EXT" "$PORT/Skybox/Water/691F86300EB8EBCF0FA7D668A9E39382$EXT"
cp "_temp/SUPER MARIO 64#6F146752#0#2_all$EXT" "$PORT/Skybox/Water/7EE75E8FA8F7E1AE90F521131C869983$EXT"
cp "_temp/SUPER MARIO 64#7CB09E26#0#2_all$EXT" "$PORT/Skybox/Water/FA33641D6823ABA6D01A8E46F1985020$EXT"
cp "_temp/SUPER MARIO 64#7D23E625#0#2_all$EXT" "$PORT/Skybox/Water/97169E5F1EF80B03F7155EF59EA146A7$EXT"
cp "_temp/SUPER MARIO 64#87C25FE2#0#2_all$EXT" "$PORT/Skybox/Water/E2B0AFAF696A5B124C0F14CD35642355$EXT"
cp "_temp/SUPER MARIO 64#8AF0E7BE#0#2_all$EXT" "$PORT/Skybox/Water/A49CAB8B134CA2FF528FEAE52239A478$EXT"
cp "_temp/SUPER MARIO 64#8E58D68A#0#2_all$EXT" "$PORT/Skybox/Water/10949A1F578AB0B62F0F3FEFB8E22E4D$EXT"
cp "_temp/SUPER MARIO 64#8F92529C#0#2_all$EXT" "$PORT/Skybox/Water/229987A55CF8EC27D6730147307F7B4D$EXT"
cp "_temp/SUPER MARIO 64#933976B9#0#2_all$EXT" "$PORT/Skybox/Water/DD0ECEB016154C99743717F8309E5D52$EXT"
cp "_temp/SUPER MARIO 64#942949F4#0#2_all$EXT" "$PORT/Skybox/Water/F52A3205820546B1A652FEE211CD6083$EXT"
cp "_temp/SUPER MARIO 64#96A88F3B#0#2_all$EXT" "$PORT/Skybox/Water/86BC25CEC525D90B2ED26F8D8EE97DDB$EXT"
cp "_temp/SUPER MARIO 64#9D13156E#0#2_all$EXT" "$PORT/Skybox/Water/2F29A65E3030F166901FD52ABD7322AA$EXT"
cp "_temp/SUPER MARIO 64#A608942F#0#2_all$EXT" "$PORT/Skybox/Water/975C1D1599C6973EC937311F30192716$EXT"
cp "_temp/SUPER MARIO 64#A9DE87A8#0#2_all$EXT" "$PORT/Skybox/Water/1F1FCA99872CC7D0BA1119AFDCC03F26$EXT"
cp "_temp/SUPER MARIO 64#B6CEC061#0#2_all$EXT" "$PORT/Skybox/Water/BC063129809A5E0977D4D8FCB8837125$EXT"
cp "_temp/SUPER MARIO 64#B8755755#0#2_all$EXT" "$PORT/Skybox/Water/24F2D561559F0E6509D41FD991DF69FC$EXT"
cp "_temp/SUPER MARIO 64#B8E3120B#0#2_all$EXT" "$PORT/Skybox/Water/3D65C434DCF469BEEF8F564D17D9D6AF$EXT"
cp "_temp/SUPER MARIO 64#C3EB2FC6#0#2_all$EXT" "$PORT/Skybox/Water/569EB8283DFF9344AD8F06C68116CE6C$EXT"
cp "_temp/SUPER MARIO 64#DB3EDFED#0#2_all$EXT" "$PORT/Skybox/Water/EE1E1B4E6D3DF00C9EC941DA6D94CBB0$EXT"
cp "_temp/SUPER MARIO 64#DBC08093#0#2_all$EXT" "$PORT/Skybox/Water/7243D706D9EFF09F58614AE1ADFD0709$EXT"
cp "_temp/SUPER MARIO 64#DDE2C14F#0#2_all$EXT" "$PORT/Skybox/Water/3B976760F5BC99D9B6BF931E8FC30312$EXT"
cp "_temp/SUPER MARIO 64#E04EF9FC#0#2_all$EXT" "$PORT/Skybox/Water/3EE7D0D7FEBEE27793F63B11BBB6CB12$EXT"
cp "_temp/SUPER MARIO 64#E169C3BF#0#2_all$EXT" "$PORT/Skybox/Water/A42B37F4781A8A180FCC48B728825C5F$EXT"
cp "_temp/SUPER MARIO 64#E447E6B0#0#2_all$EXT" "$PORT/Skybox/Water/46D514AD930E330D7AB0E1CA8A9EC3BC$EXT"
cp "_temp/SUPER MARIO 64#E8F6FFF7#0#2_all$EXT" "$PORT/Skybox/Water/6BC69D9DF6942B623FEAB1FE6C24FD22$EXT"
cp "_temp/SUPER MARIO 64#EDFF0BD2#0#2_all$EXT" "$PORT/Skybox/Water/F75FC33F9776A18B8F54F0BE94A45AD0$EXT"
cp "_temp/SUPER MARIO 64#EF35DA31#0#2_all$EXT" "$PORT/Skybox/Water/C9AEED95AE2B9DBA6675BBAD6917D36C$EXT"
cp "_temp/SUPER MARIO 64#F10816C6#0#2_all$EXT" "$PORT/Skybox/Water/5B6D4C737AFD3EED933FAF1DC162D99A$EXT"
cp "_temp/SUPER MARIO 64#FC489936#0#2_all$EXT" "$PORT/Skybox/Water/276362EF3D3A73D736DF4540B8080C66$EXT"

cp "_temp/SUPER MARIO 64#006A1516#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/1095443DE550B9D92B91341919608B34$EXT"
cp "_temp/SUPER MARIO 64#0374425D#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/00A7A3B544E6E2365E4323447637FB10$EXT"
cp "_temp/SUPER MARIO 64#0391EE74#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/D6EB46C7D2907910F89239269EE551E4$EXT"
cp "_temp/SUPER MARIO 64#07059F23#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/83A8756A9DF125682D5AC0E739E481F4$EXT"
cp "_temp/SUPER MARIO 64#0731BEEA#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/8B58DC6BFB0D86D0E83514F3F5D46438$EXT"
cp "_temp/SUPER MARIO 64#0A45EF5B#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/3A98AA210D75C244D881963DB4056AC0$EXT"
cp "_temp/SUPER MARIO 64#0BE35913#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/82D759009595E51C0143D6C37EEA8EAB$EXT"
cp "_temp/SUPER MARIO 64#0E1E7EB2#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/09DEED15547221A5236D3C2ABFBFBE2E$EXT"
cp "_temp/SUPER MARIO 64#0FF0D650#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/AD5743DC184276A563F75A83161B5A5D$EXT"
cp "_temp/SUPER MARIO 64#12C0F052#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/611772F5AD7E77B0BCF62BD3AEAD4FD6$EXT"
cp "_temp/SUPER MARIO 64#158AA64C#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/7C49A8E305599C5F14B2EDE653B69E00$EXT"
cp "_temp/SUPER MARIO 64#16733B9A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/B8908D6B35D74404D1D17254FC3068BC$EXT"
cp "_temp/SUPER MARIO 64#19D0A651#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/91E8DB7D078CC2E3ED07DA583C239C50$EXT"
cp "_temp/SUPER MARIO 64#1B1FA1C6#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/2449526B9229714A295E5F0DA70DCC1D$EXT"
cp "_temp/SUPER MARIO 64#2B8359BB#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/5271B6716B6B3AF3B71E4653FD8472A3$EXT"
cp "_temp/SUPER MARIO 64#385055F4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/9BC23820101426A54018354C5A25B4BE$EXT"
cp "_temp/SUPER MARIO 64#397F1DA4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/7C7FEB6CFD91B33084051AD676140695$EXT"
cp "_temp/SUPER MARIO 64#3CFBA273#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/50A09FA229068C1077CA3E0BD2DC2DAC$EXT"
cp "_temp/SUPER MARIO 64#3EC818DE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/65C184C2EAFF3E0C7593D3003B67CD5F$EXT"
cp "_temp/SUPER MARIO 64#41590B79#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/F461D039EFAB88FEB59DAC33E599BD66$EXT"
cp "_temp/SUPER MARIO 64#465F9B72#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/0EE79616602A27CDD9F616D5977FEA2B$EXT"
cp "_temp/SUPER MARIO 64#4F3ECE62#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/81132F10A9B889E06620ED66552A47E6$EXT"
cp "_temp/SUPER MARIO 64#56450E91#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E327F4E3A2D6C321805C880F0CC77028$EXT"
cp "_temp/SUPER MARIO 64#5A1A4FBF#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/9E1FA76AE6A3ED9C6FAF7E59E7E80FF9$EXT"
cp "_temp/SUPER MARIO 64#5E2B9C03#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/39C32804A7ECD0C023F175E31A96643D$EXT"
cp "_temp/SUPER MARIO 64#6A8BF6A8#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/376EA07C7B0B7F731218070C80420829$EXT"
cp "_temp/SUPER MARIO 64#6D1039D9#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E1F57C70AABB65106B8F44D2A1CC551F$EXT"
cp "_temp/SUPER MARIO 64#6DF82BBE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E001C11BDDEB5DE5D6CAC298C3086322$EXT"
cp "_temp/SUPER MARIO 64#7889781A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E6F79C9E1C012236A840FFF77853EC1F$EXT"
cp "_temp/SUPER MARIO 64#8675F075#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/5499F943BFB81A23F8944B36A015C916$EXT"
cp "_temp/SUPER MARIO 64#8853B016#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/0B46D87365B5419454F4325AF423BF99$EXT"
cp "_temp/SUPER MARIO 64#92E17E06#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/8CD237DFDCF9D28D0B7E0FD3C069B422$EXT"
cp "_temp/SUPER MARIO 64#940954AC#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/21C7AFAFFBCE4219A8FB1FBB6F9E7B5C$EXT"
cp "_temp/SUPER MARIO 64#98DAF219#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E19C16FBA95A7F76AF87F7ECE537DAAE$EXT"
cp "_temp/SUPER MARIO 64#A3936EE4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/7548A2A04399D9C9BF010694148F9E9B$EXT"
cp "_temp/SUPER MARIO 64#A554538A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E8474FB869ED92B06859FD3EFF6EE29D$EXT"
cp "_temp/SUPER MARIO 64#A6592F52#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/08DB27F1430E657EB31897AC5D6464CA$EXT"
cp "_temp/SUPER MARIO 64#A6C56AA3#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/ADA3485B48BFAA6FDBE77523148370A8$EXT"
cp "_temp/SUPER MARIO 64#A72C7C50#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/2AAF1668AE1370A5288526E0BAF824F3$EXT"
cp "_temp/SUPER MARIO 64#A742C5E3#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/0D23ED201FC374F88D1D68CC95B91F1F$EXT"
cp "_temp/SUPER MARIO 64#A84756AE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/74AA5E4DEDBA242113E0F25078CC1A90$EXT"
cp "_temp/SUPER MARIO 64#B3B76BCE#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/F0EF19D84210327D72373540BF531768$EXT"
cp "_temp/SUPER MARIO 64#BFC9A9DD#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/067C29C6772C1923884C6F5F0C38A7E7$EXT"
cp "_temp/SUPER MARIO 64#CBAB007A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/F03BD4DF412129930703586BC1CA5EB8$EXT"
cp "_temp/SUPER MARIO 64#CD56C1F2#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/92CD8A9F3777AA9B7035CF8F564E9F48$EXT"
cp "_temp/SUPER MARIO 64#CFB45CAF#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/3A921D1617D5A77C2BC6FAC06E540BAE$EXT"
cp "_temp/SUPER MARIO 64#D13A97C9#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/F20458DA96238A37316CE064012FE60D$EXT"
cp "_temp/SUPER MARIO 64#D3EA4D38#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/AAE9771B1C047187D4D21171D46C7F53$EXT"
cp "_temp/SUPER MARIO 64#D4C2DC38#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/A382A1E4C6EE230DBD3CE9ECED2E50AB$EXT"
cp "_temp/SUPER MARIO 64#D8F79383#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/528E5B176F6950ADCD27426DC639949D$EXT"
cp "_temp/SUPER MARIO 64#DA83E7AB#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/E6091D54301F564139AA9A2588709B18$EXT"
cp "_temp/SUPER MARIO 64#DB4B54D5#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/1059ED9691CEF43DB77D1026DA9305E9$EXT"
cp "_temp/SUPER MARIO 64#DDE6049E#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/570BAD97B4287A045C42226E5ECBF239$EXT"
cp "_temp/SUPER MARIO 64#DE5450B9#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/51BFC908CC4C59E781AC2A7148738D2F$EXT"
cp "_temp/SUPER MARIO 64#E01B30F4#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/9F933CB2B3185CE3AB53C73A9227AFCC$EXT"
cp "_temp/SUPER MARIO 64#E075472A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/107233C09CBCC6787DC18BB3EA7D892E$EXT"
cp "_temp/SUPER MARIO 64#F0EDEA43#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/DD66D48FD5DE1E9925971219D6EE3D47$EXT"
cp "_temp/SUPER MARIO 64#F2EDE87D#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/2BA1B77ACAAFF9F17AB3EC5B60D772C0$EXT"
cp "_temp/SUPER MARIO 64#F37A7379#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/4F1730287442D21E991ABEE2B0549A99$EXT"
cp "_temp/SUPER MARIO 64#F5013C4A#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/3EFE290E757C37ADB09866F3C0970E2D$EXT"
cp "_temp/SUPER MARIO 64#F566B5FA#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/4D81280474A17BA21F7D657F195848AE$EXT"
cp "_temp/SUPER MARIO 64#F861446C#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/747DDFCB2FAED1998C8F0DB9E0DFEFAF$EXT"
cp "_temp/SUPER MARIO 64#F8CAB46C#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/0002366D03A50E646840E65B911B7CC6$EXT"
cp "_temp/SUPER MARIO 64#FEB13915#0#2_all$EXT" "$PORT/Skybox/Wet-Dry World/6A2311E530DE16BE26133349EDC49A0B$EXT"

cp "_temp/SUPER MARIO 64#45667AED#0#2_all$EXT" "$PORT/Skybox/D6431C591D65092BA7FF1FC8213EB62C$EXT"
cp "_temp/SUPER MARIO 64#211EDF33#0#2_all$EXT" "$PORT/Skybox/F2438E4267BD3FEA4352D02732624EEC$EXT"
